package software.amazon.awscdk.services.events;

/**
 * An event pattern matcher.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Rule rule = Rule.Builder.create(this, "rule")
 *         .eventPattern(EventPattern.builder()
 *                 .detail(Map.of(
 *                         "object", Map.of(
 *                                 // Matchers may appear at any level
 *                                 "size", Match.greaterThan(1024)),
 *                         // 'OR' condition
 *                         "source-storage-class", Match.anyOf(Match.prefix("GLACIER"), Match.exactString("DEEP_ARCHIVE"))))
 *                 // If you prefer, you can use a low level array of strings, as directly consumed by EventBridge
 *                 .source(List.of("aws.s3"))
 *                 .region(Match.anythingButPrefix("us-gov"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.222Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.Match")
public class Match extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IResolvable {

    protected Match(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Match(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Matches an event if any of the provided matchers do.
     * <p>
     * Only numeric matchers are accepted.
     * <p>
     * @param matchers This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> allOf(final @org.jetbrains.annotations.NotNull java.lang.Object... matchers) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "allOf", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), java.util.Arrays.<Object>stream(matchers).toArray(Object[]::new)));
    }

    /**
     * Matches an event if any of the provided matchers does.
     * <p>
     * @param matchers This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> anyOf(final @org.jetbrains.annotations.NotNull java.lang.Object... matchers) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "anyOf", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), java.util.Arrays.<Object>stream(matchers).toArray(Object[]::new)));
    }

    /**
     * Matches anything except what's provided in the rule.
     * <p>
     * The list of provided values must contain
     * only strings or only numbers.
     * <p>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> anythingBut(final @org.jetbrains.annotations.NotNull java.lang.Object... values) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "anythingBut", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), java.util.Arrays.<Object>stream(values).toArray(Object[]::new)));
    }

    /**
     * Matches any string that doesn't match with the given value regardless of character casing.
     * <p>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> anythingButEqualsIgnoreCase(final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "anythingButEqualsIgnoreCase", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), java.util.Arrays.<Object>stream(values).toArray(Object[]::new)));
    }

    /**
     * Matches any string that doesn't start with the given prefix.
     * <p>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> anythingButPrefix(final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "anythingButPrefix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), java.util.Arrays.<Object>stream(values).toArray(Object[]::new)));
    }

    /**
     * Matches any string that doesn't end with the given suffix.
     * <p>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> anythingButSuffix(final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "anythingButSuffix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), java.util.Arrays.<Object>stream(values).toArray(Object[]::new)));
    }

    /**
     * Matches any string that doesn't match with the given wildcard pattern.
     * <p>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> anythingButWildcard(final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "anythingButWildcard", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), java.util.Arrays.<Object>stream(values).toArray(Object[]::new)));
    }

    /**
     * Matches IPv4 and IPv6 network addresses using the Classless Inter-Domain Routing (CIDR) format.
     * <p>
     * @param range This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> cidr(final @org.jetbrains.annotations.NotNull java.lang.String range) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "cidr", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(range, "range is required") }));
    }

    /**
     * Matches when the field is absent from the JSON of the event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> doesNotExist() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "doesNotExist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Matches numbers equal to the provided value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> equal(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "equal", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches a string, regardless of case, in the JSON of the event.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> equalsIgnoreCase(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "equalsIgnoreCase", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches a string, exactly, in the JSON of the event.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> exactString(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "exactString", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches when the field is present in the JSON of the event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> exists() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "exists", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Matches numbers greater than the provided value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> greaterThan(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "greaterThan", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches numbers greater than, or equal to, the provided value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> greaterThanOrEqual(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "greaterThanOrEqual", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches numbers inside a closed numeric interval. Equivalent to:.
     * <p>
     * Match.allOf(Match.greaterThanOrEqual(lower), Match.lessThanOrEqual(upper))
     * <p>
     * @param lower Lower bound (inclusive). This parameter is required.
     * @param upper Upper bound (inclusive). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> interval(final @org.jetbrains.annotations.NotNull java.lang.Number lower, final @org.jetbrains.annotations.NotNull java.lang.Number upper) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "interval", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(lower, "lower is required"), java.util.Objects.requireNonNull(upper, "upper is required") }));
    }

    /**
     * Matches IPv4 and IPv6 network addresses using the Classless Inter-Domain Routing (CIDR) format.
     * <p>
     * Alias of <code>cidr()</code>.
     * <p>
     * @param range This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> ipAddressRange(final @org.jetbrains.annotations.NotNull java.lang.String range) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "ipAddressRange", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(range, "range is required") }));
    }

    /**
     * Matches numbers less than the provided value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> lessThan(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "lessThan", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches numbers less than, or equal to, the provided value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> lessThanOrEqual(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "lessThanOrEqual", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches a null value in the JSON of the event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> nullValue() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "nullValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Matches strings with the given prefix in the JSON of the event.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> prefix(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "prefix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches strings with the given prefix in the JSON of the event regardless of the casing.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> prefixEqualsIgnoreCase(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "prefixEqualsIgnoreCase", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches strings with the given suffix in the JSON of the event.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> suffix(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "suffix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches strings with the given suffix in the JSON of the event regardless of the casing.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> suffixEqualsIgnoreCase(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "suffixEqualsIgnoreCase", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * Matches strings with the given wildcard pattern in the JSON of the event.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> wildcard(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Match.class, "wildcard", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(value, "value is required") }));
    }

    /**
     * A representation of this matcher as a list of strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> asList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "asList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Produce the Token's value at resolution time.
     * <p>
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * Return a string representation of this resolvable object.
     * <p>
     * Returns a reversible string representation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     * <p>
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }
}
