package software.amazon.awscdk.services.finspace;

/**
 * Properties for defining a <code>CfnEnvironment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.finspace.*;
 * CfnEnvironmentProps cfnEnvironmentProps = CfnEnvironmentProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .dataBundles(List.of("dataBundles"))
 *         .description("description")
 *         .federationMode("federationMode")
 *         .federationParameters(FederationParametersProperty.builder()
 *                 .applicationCallBackUrl("applicationCallBackUrl")
 *                 .attributeMap(List.of(AttributeMapItemsProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .federationProviderName("federationProviderName")
 *                 .federationUrn("federationUrn")
 *                 .samlMetadataDocument("samlMetadataDocument")
 *                 .samlMetadataUrl("samlMetadataUrl")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .superuserParameters(SuperuserParametersProperty.builder()
 *                 .emailAddress("emailAddress")
 *                 .firstName("firstName")
 *                 .lastName("lastName")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.366Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_finspace.CfnEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the FinSpace environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * (deprecated) ARNs of FinSpace Data Bundles to install.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-databundles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-databundles</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataBundles() {
        return null;
    }

    /**
     * The description of the FinSpace environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The authentication mode for the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFederationMode() {
        return null;
    }

    /**
     * Configuration information when authentication mode is FEDERATED.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.finspace.CfnEnvironment.FederationParametersProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-federationparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFederationParameters() {
        return null;
    }

    /**
     * The KMS key id used to encrypt in the FinSpace environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Configuration information for the superuser.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.finspace.CfnEnvironment.SuperuserParametersProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-superuserparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-superuserparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSuperuserParameters() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-finspace-environment.html#cfn-finspace-environment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentProps> {
        java.lang.String name;
        java.util.List<java.lang.String> dataBundles;
        java.lang.String description;
        java.lang.String federationMode;
        java.lang.Object federationParameters;
        java.lang.String kmsKeyId;
        java.lang.Object superuserParameters;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEnvironmentProps#getName}
         * @param name The name of the FinSpace environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDataBundles}
         * @param dataBundles ARNs of FinSpace Data Bundles to install.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder dataBundles(java.util.List<java.lang.String> dataBundles) {
            this.dataBundles = dataBundles;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDescription}
         * @param description The description of the FinSpace environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getFederationMode}
         * @param federationMode The authentication mode for the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationMode(java.lang.String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getFederationParameters}
         * @param federationParameters Configuration information when authentication mode is FEDERATED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationParameters(software.amazon.awscdk.IResolvable federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getFederationParameters}
         * @param federationParameters Configuration information when authentication mode is FEDERATED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationParameters(software.amazon.awscdk.services.finspace.CfnEnvironment.FederationParametersProperty federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getKmsKeyId}
         * @param kmsKeyId The KMS key id used to encrypt in the FinSpace environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSuperuserParameters}
         * @param superuserParameters Configuration information for the superuser.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder superuserParameters(software.amazon.awscdk.IResolvable superuserParameters) {
            this.superuserParameters = superuserParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSuperuserParameters}
         * @param superuserParameters Configuration information for the superuser.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder superuserParameters(software.amazon.awscdk.services.finspace.CfnEnvironment.SuperuserParametersProperty superuserParameters) {
            this.superuserParameters = superuserParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProps {
        private final java.lang.String name;
        private final java.util.List<java.lang.String> dataBundles;
        private final java.lang.String description;
        private final java.lang.String federationMode;
        private final java.lang.Object federationParameters;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object superuserParameters;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataBundles = software.amazon.jsii.Kernel.get(this, "dataBundles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.federationMode = software.amazon.jsii.Kernel.get(this, "federationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.federationParameters = software.amazon.jsii.Kernel.get(this, "federationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.superuserParameters = software.amazon.jsii.Kernel.get(this, "superuserParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.dataBundles = builder.dataBundles;
            this.description = builder.description;
            this.federationMode = builder.federationMode;
            this.federationParameters = builder.federationParameters;
            this.kmsKeyId = builder.kmsKeyId;
            this.superuserParameters = builder.superuserParameters;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getDataBundles() {
            return this.dataBundles;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFederationMode() {
            return this.federationMode;
        }

        @Override
        public final java.lang.Object getFederationParameters() {
            return this.federationParameters;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getSuperuserParameters() {
            return this.superuserParameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDataBundles() != null) {
                data.set("dataBundles", om.valueToTree(this.getDataBundles()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFederationMode() != null) {
                data.set("federationMode", om.valueToTree(this.getFederationMode()));
            }
            if (this.getFederationParameters() != null) {
                data.set("federationParameters", om.valueToTree(this.getFederationParameters()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getSuperuserParameters() != null) {
                data.set("superuserParameters", om.valueToTree(this.getSuperuserParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_finspace.CfnEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProps.Jsii$Proxy that = (CfnEnvironmentProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.dataBundles != null ? !this.dataBundles.equals(that.dataBundles) : that.dataBundles != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.federationMode != null ? !this.federationMode.equals(that.federationMode) : that.federationMode != null) return false;
            if (this.federationParameters != null ? !this.federationParameters.equals(that.federationParameters) : that.federationParameters != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.superuserParameters != null ? !this.superuserParameters.equals(that.superuserParameters) : that.superuserParameters != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.dataBundles != null ? this.dataBundles.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.federationMode != null ? this.federationMode.hashCode() : 0);
            result = 31 * result + (this.federationParameters != null ? this.federationParameters.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.superuserParameters != null ? this.superuserParameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
