package software.amazon.awscdk.services.fis;

/**
 * Specifies an experiment template.
 * <p>
 * An experiment template includes the following components:
 * <p>
 * <ul>
 * <li><em>Targets</em> : A target can be a specific resource in your AWS environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.</li>
 * <li><em>Actions</em> : The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.</li>
 * <li><em>Stop conditions</em> : If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the <em>AWS Fault Injection Service User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fis.*;
 * Object cloudWatchLogsConfiguration;
 * Object s3Configuration;
 * CfnExperimentTemplate cfnExperimentTemplate = CfnExperimentTemplate.Builder.create(this, "MyCfnExperimentTemplate")
 *         .description("description")
 *         .roleArn("roleArn")
 *         .stopConditions(List.of(ExperimentTemplateStopConditionProperty.builder()
 *                 .source("source")
 *                 // the properties below are optional
 *                 .value("value")
 *                 .build()))
 *         .targets(Map.of(
 *                 "targetsKey", ExperimentTemplateTargetProperty.builder()
 *                         .resourceType("resourceType")
 *                         .selectionMode("selectionMode")
 *                         // the properties below are optional
 *                         .filters(List.of(ExperimentTemplateTargetFilterProperty.builder()
 *                                 .path("path")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .resourceArns(List.of("resourceArns"))
 *                         .resourceTags(Map.of(
 *                                 "resourceTagsKey", "resourceTags"))
 *                         .build()))
 *         // the properties below are optional
 *         .actions(Map.of(
 *                 "actionsKey", ExperimentTemplateActionProperty.builder()
 *                         .actionId("actionId")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .startAfter(List.of("startAfter"))
 *                         .targets(Map.of(
 *                                 "targetsKey", "targets"))
 *                         .build()))
 *         .experimentOptions(ExperimentTemplateExperimentOptionsProperty.builder()
 *                 .accountTargeting("accountTargeting")
 *                 .emptyTargetResolutionMode("emptyTargetResolutionMode")
 *                 .build())
 *         .experimentReportConfiguration(ExperimentTemplateExperimentReportConfigurationProperty.builder()
 *                 .outputs(OutputsProperty.builder()
 *                         .experimentReportS3Configuration(ExperimentReportS3ConfigurationProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 // the properties below are optional
 *                                 .prefix("prefix")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .dataSources(DataSourcesProperty.builder()
 *                         .cloudWatchDashboards(List.of(CloudWatchDashboardProperty.builder()
 *                                 .dashboardIdentifier("dashboardIdentifier")
 *                                 .build()))
 *                         .build())
 *                 .postExperimentDuration("postExperimentDuration")
 *                 .preExperimentDuration("preExperimentDuration")
 *                 .build())
 *         .logConfiguration(ExperimentTemplateLogConfigurationProperty.builder()
 *                 .logSchemaVersion(123)
 *                 // the properties below are optional
 *                 .cloudWatchLogsConfiguration(cloudWatchLogsConfiguration)
 *                 .s3Configuration(s3Configuration)
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.367Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate")
public class CfnExperimentTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.fis.IExperimentTemplateRef, software.amazon.awscdk.ITaggable {

    protected CfnExperimentTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnExperimentTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fis.CfnExperimentTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::FIS::ExperimentTemplate</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnExperimentTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fis.CfnExperimentTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForExperimentTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.fis.IExperimentTemplateRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.fis.CfnExperimentTemplate.class, "arnForExperimentTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnExperimentTemplate.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnExperimentTemplate(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.fis.CfnExperimentTemplate.class, "isCfnExperimentTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ExperimentTemplate resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.fis.ExperimentTemplateReference getExperimentTemplateRef() {
        return software.amazon.jsii.Kernel.get(this, "experimentTemplateRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.fis.ExperimentTemplateReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The description for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The stop conditions for the experiment.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStopConditions() {
        return software.amazon.jsii.Kernel.get(this, "stopConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The stop conditions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStopConditions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stopConditions", java.util.Objects.requireNonNull(value, "stopConditions is required"));
    }

    /**
     * The stop conditions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStopConditions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "stopConditions", java.util.Objects.requireNonNull(value, "stopConditions is required"));
    }

    /**
     * The targets for the experiment.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The targets for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * The targets for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * The actions for the experiment.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateActionProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The actions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", value);
    }

    /**
     * The actions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateActionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateActionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actions", value);
    }

    /**
     * The experiment options for an experiment template.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateExperimentOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExperimentOptions() {
        return software.amazon.jsii.Kernel.get(this, "experimentOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The experiment options for an experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExperimentOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "experimentOptions", value);
    }

    /**
     * The experiment options for an experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExperimentOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateExperimentOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "experimentOptions", value);
    }

    /**
     * Describes the report configuration for the experiment template.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateExperimentReportConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExperimentReportConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "experimentReportConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the report configuration for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExperimentReportConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "experimentReportConfiguration", value);
    }

    /**
     * Describes the report configuration for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExperimentReportConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateExperimentReportConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "experimentReportConfiguration", value);
    }

    /**
     * The configuration for experiment logging.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for experiment logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }

    /**
     * The configuration for experiment logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }

    /**
     * The tags for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The CloudWatch dashboards to include as data sources in the experiment report.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * CloudWatchDashboardProperty cloudWatchDashboardProperty = CloudWatchDashboardProperty.builder()
     *         .dashboardIdentifier("dashboardIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchdashboard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchdashboard.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.CloudWatchDashboardProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchDashboardProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchDashboardProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the CloudWatch dashboard to include in the experiment report.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchdashboard.html#cfn-fis-experimenttemplate-cloudwatchdashboard-dashboardidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchdashboard.html#cfn-fis-experimenttemplate-cloudwatchdashboard-dashboardidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDashboardIdentifier();

        /**
         * @return a {@link Builder} of {@link CloudWatchDashboardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchDashboardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchDashboardProperty> {
            java.lang.String dashboardIdentifier;

            /**
             * Sets the value of {@link CloudWatchDashboardProperty#getDashboardIdentifier}
             * @param dashboardIdentifier The Amazon Resource Name (ARN) of the CloudWatch dashboard to include in the experiment report. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashboardIdentifier(java.lang.String dashboardIdentifier) {
                this.dashboardIdentifier = dashboardIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchDashboardProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchDashboardProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchDashboardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchDashboardProperty {
            private final java.lang.String dashboardIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dashboardIdentifier = software.amazon.jsii.Kernel.get(this, "dashboardIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dashboardIdentifier = java.util.Objects.requireNonNull(builder.dashboardIdentifier, "dashboardIdentifier is required");
            }

            @Override
            public final java.lang.String getDashboardIdentifier() {
                return this.dashboardIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dashboardIdentifier", om.valueToTree(this.getDashboardIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.CloudWatchDashboardProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchDashboardProperty.Jsii$Proxy that = (CloudWatchDashboardProperty.Jsii$Proxy) o;

                return this.dashboardIdentifier.equals(that.dashboardIdentifier);
            }

            @Override
            public final int hashCode() {
                int result = this.dashboardIdentifier.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for experiment logging to CloudWatch Logs .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * CloudWatchLogsConfigurationProperty cloudWatchLogsConfigurationProperty = CloudWatchLogsConfigurationProperty.builder()
     *         .logGroupArn("logGroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchlogsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchlogsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.CloudWatchLogsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchlogsconfiguration.html#cfn-fis-experimenttemplate-cloudwatchlogsconfiguration-loggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-cloudwatchlogsconfiguration.html#cfn-fis-experimenttemplate-cloudwatchlogsconfiguration-loggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsConfigurationProperty> {
            java.lang.String logGroupArn;

            /**
             * Sets the value of {@link CloudWatchLogsConfigurationProperty#getLogGroupArn}
             * @param logGroupArn The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsConfigurationProperty {
            private final java.lang.String logGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupArn = java.util.Objects.requireNonNull(builder.logGroupArn, "logGroupArn is required");
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.CloudWatchLogsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsConfigurationProperty.Jsii$Proxy that = (CloudWatchLogsConfigurationProperty.Jsii$Proxy) o;

                return this.logGroupArn.equals(that.logGroupArn);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the data sources for the experiment report.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * DataSourcesProperty dataSourcesProperty = DataSourcesProperty.builder()
     *         .cloudWatchDashboards(List.of(CloudWatchDashboardProperty.builder()
     *                 .dashboardIdentifier("dashboardIdentifier")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-datasources.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-datasources.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.DataSourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CloudWatch dashboards to include as data sources in the experiment report.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.CloudWatchDashboardProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-datasources.html#cfn-fis-experimenttemplate-datasources-cloudwatchdashboards">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-datasources.html#cfn-fis-experimenttemplate-datasources-cloudwatchdashboards</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchDashboards() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourcesProperty> {
            java.lang.Object cloudWatchDashboards;

            /**
             * Sets the value of {@link DataSourcesProperty#getCloudWatchDashboards}
             * @param cloudWatchDashboards The CloudWatch dashboards to include as data sources in the experiment report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchDashboards(software.amazon.awscdk.IResolvable cloudWatchDashboards) {
                this.cloudWatchDashboards = cloudWatchDashboards;
                return this;
            }

            /**
             * Sets the value of {@link DataSourcesProperty#getCloudWatchDashboards}
             * @param cloudWatchDashboards The CloudWatch dashboards to include as data sources in the experiment report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchDashboards(java.util.List<? extends java.lang.Object> cloudWatchDashboards) {
                this.cloudWatchDashboards = cloudWatchDashboards;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourcesProperty {
            private final java.lang.Object cloudWatchDashboards;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchDashboards = software.amazon.jsii.Kernel.get(this, "cloudWatchDashboards", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchDashboards = builder.cloudWatchDashboards;
            }

            @Override
            public final java.lang.Object getCloudWatchDashboards() {
                return this.cloudWatchDashboards;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchDashboards() != null) {
                    data.set("cloudWatchDashboards", om.valueToTree(this.getCloudWatchDashboards()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.DataSourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourcesProperty.Jsii$Proxy that = (DataSourcesProperty.Jsii$Proxy) o;

                return this.cloudWatchDashboards != null ? this.cloudWatchDashboards.equals(that.cloudWatchDashboards) : that.cloudWatchDashboards == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchDashboards != null ? this.cloudWatchDashboards.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The S3 destination for the experiment report.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentReportS3ConfigurationProperty experimentReportS3ConfigurationProperty = ExperimentReportS3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimentreports3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimentreports3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentReportS3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentReportS3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentReportS3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket where the experiment report will be stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimentreports3configuration.html#cfn-fis-experimenttemplate-experimentreports3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimentreports3configuration.html#cfn-fis-experimenttemplate-experimentreports3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The prefix of the S3 bucket where the experiment report will be stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimentreports3configuration.html#cfn-fis-experimenttemplate-experimentreports3configuration-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimentreports3configuration.html#cfn-fis-experimenttemplate-experimentreports3configuration-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentReportS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentReportS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentReportS3ConfigurationProperty> {
            java.lang.String bucketName;
            java.lang.String prefix;

            /**
             * Sets the value of {@link ExperimentReportS3ConfigurationProperty#getBucketName}
             * @param bucketName The name of the S3 bucket where the experiment report will be stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentReportS3ConfigurationProperty#getPrefix}
             * @param prefix The prefix of the S3 bucket where the experiment report will be stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentReportS3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentReportS3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentReportS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentReportS3ConfigurationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentReportS3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentReportS3ConfigurationProperty.Jsii$Proxy that = (ExperimentReportS3ConfigurationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an action for an experiment template.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/actions.html">Actions</a> in the <em>AWS Fault Injection Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateActionProperty experimentTemplateActionProperty = ExperimentTemplateActionProperty.builder()
     *         .actionId("actionId")
     *         // the properties below are optional
     *         .description("description")
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .startAfter(List.of("startAfter"))
     *         .targets(Map.of(
     *                 "targetsKey", "targets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-actionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-actionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionId();

        /**
         * A description for the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The parameters for the action.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The name of the action that must be completed before the current action starts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-startafter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-startafter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStartAfter() {
            return null;
        }

        /**
         * The targets for the action.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateaction.html#cfn-fis-experimenttemplate-experimenttemplateaction-targets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateActionProperty> {
            java.lang.String actionId;
            java.lang.String description;
            java.lang.Object parameters;
            java.util.List<java.lang.String> startAfter;
            java.lang.Object targets;

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getActionId}
             * @param actionId The ID of the action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionId(java.lang.String actionId) {
                this.actionId = actionId;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getDescription}
             * @param description A description for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getParameters}
             * @param parameters The parameters for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getParameters}
             * @param parameters The parameters for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getStartAfter}
             * @param startAfter The name of the action that must be completed before the current action starts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startAfter(java.util.List<java.lang.String> startAfter) {
                this.startAfter = startAfter;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getTargets}
             * @param targets The targets for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(java.util.Map<java.lang.String, java.lang.String> targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateActionProperty#getTargets}
             * @param targets The targets for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(software.amazon.awscdk.IResolvable targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateActionProperty {
            private final java.lang.String actionId;
            private final java.lang.String description;
            private final java.lang.Object parameters;
            private final java.util.List<java.lang.String> startAfter;
            private final java.lang.Object targets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionId = software.amazon.jsii.Kernel.get(this, "actionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startAfter = software.amazon.jsii.Kernel.get(this, "startAfter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionId = java.util.Objects.requireNonNull(builder.actionId, "actionId is required");
                this.description = builder.description;
                this.parameters = builder.parameters;
                this.startAfter = builder.startAfter;
                this.targets = builder.targets;
            }

            @Override
            public final java.lang.String getActionId() {
                return this.actionId;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.util.List<java.lang.String> getStartAfter() {
                return this.startAfter;
            }

            @Override
            public final java.lang.Object getTargets() {
                return this.targets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionId", om.valueToTree(this.getActionId()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getStartAfter() != null) {
                    data.set("startAfter", om.valueToTree(this.getStartAfter()));
                }
                if (this.getTargets() != null) {
                    data.set("targets", om.valueToTree(this.getTargets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateActionProperty.Jsii$Proxy that = (ExperimentTemplateActionProperty.Jsii$Proxy) o;

                if (!actionId.equals(that.actionId)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.startAfter != null ? !this.startAfter.equals(that.startAfter) : that.startAfter != null) return false;
                return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionId.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.startAfter != null ? this.startAfter.hashCode() : 0);
                result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the experiment options for an experiment template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateExperimentOptionsProperty experimentTemplateExperimentOptionsProperty = ExperimentTemplateExperimentOptionsProperty.builder()
     *         .accountTargeting("accountTargeting")
     *         .emptyTargetResolutionMode("emptyTargetResolutionMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateExperimentOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateExperimentOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateExperimentOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The account targeting setting for an experiment template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentoptions.html#cfn-fis-experimenttemplate-experimenttemplateexperimentoptions-accounttargeting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentoptions.html#cfn-fis-experimenttemplate-experimenttemplateexperimentoptions-accounttargeting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountTargeting() {
            return null;
        }

        /**
         * The empty target resolution mode for an experiment template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentoptions.html#cfn-fis-experimenttemplate-experimenttemplateexperimentoptions-emptytargetresolutionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentoptions.html#cfn-fis-experimenttemplate-experimenttemplateexperimentoptions-emptytargetresolutionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmptyTargetResolutionMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateExperimentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateExperimentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateExperimentOptionsProperty> {
            java.lang.String accountTargeting;
            java.lang.String emptyTargetResolutionMode;

            /**
             * Sets the value of {@link ExperimentTemplateExperimentOptionsProperty#getAccountTargeting}
             * @param accountTargeting The account targeting setting for an experiment template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountTargeting(java.lang.String accountTargeting) {
                this.accountTargeting = accountTargeting;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateExperimentOptionsProperty#getEmptyTargetResolutionMode}
             * @param emptyTargetResolutionMode The empty target resolution mode for an experiment template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyTargetResolutionMode(java.lang.String emptyTargetResolutionMode) {
                this.emptyTargetResolutionMode = emptyTargetResolutionMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateExperimentOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateExperimentOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateExperimentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateExperimentOptionsProperty {
            private final java.lang.String accountTargeting;
            private final java.lang.String emptyTargetResolutionMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountTargeting = software.amazon.jsii.Kernel.get(this, "accountTargeting", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emptyTargetResolutionMode = software.amazon.jsii.Kernel.get(this, "emptyTargetResolutionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountTargeting = builder.accountTargeting;
                this.emptyTargetResolutionMode = builder.emptyTargetResolutionMode;
            }

            @Override
            public final java.lang.String getAccountTargeting() {
                return this.accountTargeting;
            }

            @Override
            public final java.lang.String getEmptyTargetResolutionMode() {
                return this.emptyTargetResolutionMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccountTargeting() != null) {
                    data.set("accountTargeting", om.valueToTree(this.getAccountTargeting()));
                }
                if (this.getEmptyTargetResolutionMode() != null) {
                    data.set("emptyTargetResolutionMode", om.valueToTree(this.getEmptyTargetResolutionMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateExperimentOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateExperimentOptionsProperty.Jsii$Proxy that = (ExperimentTemplateExperimentOptionsProperty.Jsii$Proxy) o;

                if (this.accountTargeting != null ? !this.accountTargeting.equals(that.accountTargeting) : that.accountTargeting != null) return false;
                return this.emptyTargetResolutionMode != null ? this.emptyTargetResolutionMode.equals(that.emptyTargetResolutionMode) : that.emptyTargetResolutionMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountTargeting != null ? this.accountTargeting.hashCode() : 0;
                result = 31 * result + (this.emptyTargetResolutionMode != null ? this.emptyTargetResolutionMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the report configuration for the experiment template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateExperimentReportConfigurationProperty experimentTemplateExperimentReportConfigurationProperty = ExperimentTemplateExperimentReportConfigurationProperty.builder()
     *         .outputs(OutputsProperty.builder()
     *                 .experimentReportS3Configuration(ExperimentReportS3ConfigurationProperty.builder()
     *                         .bucketName("bucketName")
     *                         // the properties below are optional
     *                         .prefix("prefix")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .dataSources(DataSourcesProperty.builder()
     *                 .cloudWatchDashboards(List.of(CloudWatchDashboardProperty.builder()
     *                         .dashboardIdentifier("dashboardIdentifier")
     *                         .build()))
     *                 .build())
     *         .postExperimentDuration("postExperimentDuration")
     *         .preExperimentDuration("preExperimentDuration")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateExperimentReportConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateExperimentReportConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateExperimentReportConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The output destinations of the experiment report.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.OutputsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-outputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutputs();

        /**
         * The data sources for the experiment report.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.DataSourcesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-datasources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-datasources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataSources() {
            return null;
        }

        /**
         * The duration after the experiment end time for the data sources to include in the report.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-postexperimentduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-postexperimentduration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostExperimentDuration() {
            return null;
        }

        /**
         * The duration before the experiment start time for the data sources to include in the report.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-preexperimentduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration.html#cfn-fis-experimenttemplate-experimenttemplateexperimentreportconfiguration-preexperimentduration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreExperimentDuration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateExperimentReportConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateExperimentReportConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateExperimentReportConfigurationProperty> {
            java.lang.Object outputs;
            java.lang.Object dataSources;
            java.lang.String postExperimentDuration;
            java.lang.String preExperimentDuration;

            /**
             * Sets the value of {@link ExperimentTemplateExperimentReportConfigurationProperty#getOutputs}
             * @param outputs The output destinations of the experiment report. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(software.amazon.awscdk.IResolvable outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateExperimentReportConfigurationProperty#getOutputs}
             * @param outputs The output destinations of the experiment report. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(software.amazon.awscdk.services.fis.CfnExperimentTemplate.OutputsProperty outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateExperimentReportConfigurationProperty#getDataSources}
             * @param dataSources The data sources for the experiment report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSources(software.amazon.awscdk.IResolvable dataSources) {
                this.dataSources = dataSources;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateExperimentReportConfigurationProperty#getDataSources}
             * @param dataSources The data sources for the experiment report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSources(software.amazon.awscdk.services.fis.CfnExperimentTemplate.DataSourcesProperty dataSources) {
                this.dataSources = dataSources;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateExperimentReportConfigurationProperty#getPostExperimentDuration}
             * @param postExperimentDuration The duration after the experiment end time for the data sources to include in the report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postExperimentDuration(java.lang.String postExperimentDuration) {
                this.postExperimentDuration = postExperimentDuration;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateExperimentReportConfigurationProperty#getPreExperimentDuration}
             * @param preExperimentDuration The duration before the experiment start time for the data sources to include in the report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preExperimentDuration(java.lang.String preExperimentDuration) {
                this.preExperimentDuration = preExperimentDuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateExperimentReportConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateExperimentReportConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateExperimentReportConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateExperimentReportConfigurationProperty {
            private final java.lang.Object outputs;
            private final java.lang.Object dataSources;
            private final java.lang.String postExperimentDuration;
            private final java.lang.String preExperimentDuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataSources = software.amazon.jsii.Kernel.get(this, "dataSources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postExperimentDuration = software.amazon.jsii.Kernel.get(this, "postExperimentDuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preExperimentDuration = software.amazon.jsii.Kernel.get(this, "preExperimentDuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputs = java.util.Objects.requireNonNull(builder.outputs, "outputs is required");
                this.dataSources = builder.dataSources;
                this.postExperimentDuration = builder.postExperimentDuration;
                this.preExperimentDuration = builder.preExperimentDuration;
            }

            @Override
            public final java.lang.Object getOutputs() {
                return this.outputs;
            }

            @Override
            public final java.lang.Object getDataSources() {
                return this.dataSources;
            }

            @Override
            public final java.lang.String getPostExperimentDuration() {
                return this.postExperimentDuration;
            }

            @Override
            public final java.lang.String getPreExperimentDuration() {
                return this.preExperimentDuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputs", om.valueToTree(this.getOutputs()));
                if (this.getDataSources() != null) {
                    data.set("dataSources", om.valueToTree(this.getDataSources()));
                }
                if (this.getPostExperimentDuration() != null) {
                    data.set("postExperimentDuration", om.valueToTree(this.getPostExperimentDuration()));
                }
                if (this.getPreExperimentDuration() != null) {
                    data.set("preExperimentDuration", om.valueToTree(this.getPreExperimentDuration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateExperimentReportConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateExperimentReportConfigurationProperty.Jsii$Proxy that = (ExperimentTemplateExperimentReportConfigurationProperty.Jsii$Proxy) o;

                if (!outputs.equals(that.outputs)) return false;
                if (this.dataSources != null ? !this.dataSources.equals(that.dataSources) : that.dataSources != null) return false;
                if (this.postExperimentDuration != null ? !this.postExperimentDuration.equals(that.postExperimentDuration) : that.postExperimentDuration != null) return false;
                return this.preExperimentDuration != null ? this.preExperimentDuration.equals(that.preExperimentDuration) : that.preExperimentDuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputs.hashCode();
                result = 31 * result + (this.dataSources != null ? this.dataSources.hashCode() : 0);
                result = 31 * result + (this.postExperimentDuration != null ? this.postExperimentDuration.hashCode() : 0);
                result = 31 * result + (this.preExperimentDuration != null ? this.preExperimentDuration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for experiment logging.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/monitoring-logging.html">Experiment logging</a> in the <em>AWS Fault Injection Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * Object cloudWatchLogsConfiguration;
     * Object s3Configuration;
     * ExperimentTemplateLogConfigurationProperty experimentTemplateLogConfigurationProperty = ExperimentTemplateLogConfigurationProperty.builder()
     *         .logSchemaVersion(123)
     *         // the properties below are optional
     *         .cloudWatchLogsConfiguration(cloudWatchLogsConfiguration)
     *         .s3Configuration(s3Configuration)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateLogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateLogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The schema version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html#cfn-fis-experimenttemplate-experimenttemplatelogconfiguration-logschemaversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html#cfn-fis-experimenttemplate-experimenttemplatelogconfiguration-logschemaversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLogSchemaVersion();

        /**
         * The configuration for experiment logging to CloudWatch Logs .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html#cfn-fis-experimenttemplate-experimenttemplatelogconfiguration-cloudwatchlogsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html#cfn-fis-experimenttemplate-experimenttemplatelogconfiguration-cloudwatchlogsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogsConfiguration() {
            return null;
        }

        /**
         * The configuration for experiment logging to Amazon S3 .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html#cfn-fis-experimenttemplate-experimenttemplatelogconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatelogconfiguration.html#cfn-fis-experimenttemplate-experimenttemplatelogconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Configuration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateLogConfigurationProperty> {
            java.lang.Number logSchemaVersion;
            java.lang.Object cloudWatchLogsConfiguration;
            java.lang.Object s3Configuration;

            /**
             * Sets the value of {@link ExperimentTemplateLogConfigurationProperty#getLogSchemaVersion}
             * @param logSchemaVersion The schema version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logSchemaVersion(java.lang.Number logSchemaVersion) {
                this.logSchemaVersion = logSchemaVersion;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateLogConfigurationProperty#getCloudWatchLogsConfiguration}
             * @param cloudWatchLogsConfiguration The configuration for experiment logging to CloudWatch Logs .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsConfiguration(java.lang.Object cloudWatchLogsConfiguration) {
                this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateLogConfigurationProperty#getS3Configuration}
             * @param s3Configuration The configuration for experiment logging to Amazon S3 .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(java.lang.Object s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateLogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateLogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateLogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateLogConfigurationProperty {
            private final java.lang.Number logSchemaVersion;
            private final java.lang.Object cloudWatchLogsConfiguration;
            private final java.lang.Object s3Configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logSchemaVersion = software.amazon.jsii.Kernel.get(this, "logSchemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cloudWatchLogsConfiguration = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logSchemaVersion = java.util.Objects.requireNonNull(builder.logSchemaVersion, "logSchemaVersion is required");
                this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
                this.s3Configuration = builder.s3Configuration;
            }

            @Override
            public final java.lang.Number getLogSchemaVersion() {
                return this.logSchemaVersion;
            }

            @Override
            public final java.lang.Object getCloudWatchLogsConfiguration() {
                return this.cloudWatchLogsConfiguration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logSchemaVersion", om.valueToTree(this.getLogSchemaVersion()));
                if (this.getCloudWatchLogsConfiguration() != null) {
                    data.set("cloudWatchLogsConfiguration", om.valueToTree(this.getCloudWatchLogsConfiguration()));
                }
                if (this.getS3Configuration() != null) {
                    data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateLogConfigurationProperty.Jsii$Proxy that = (ExperimentTemplateLogConfigurationProperty.Jsii$Proxy) o;

                if (!logSchemaVersion.equals(that.logSchemaVersion)) return false;
                if (this.cloudWatchLogsConfiguration != null ? !this.cloudWatchLogsConfiguration.equals(that.cloudWatchLogsConfiguration) : that.cloudWatchLogsConfiguration != null) return false;
                return this.s3Configuration != null ? this.s3Configuration.equals(that.s3Configuration) : that.s3Configuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logSchemaVersion.hashCode();
                result = 31 * result + (this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3Configuration != null ? this.s3Configuration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a stop condition for an experiment template.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/stop-conditions.html">Stop conditions</a> in the <em>AWS Fault Injection Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateStopConditionProperty experimentTemplateStopConditionProperty = ExperimentTemplateStopConditionProperty.builder()
     *         .source("source")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatestopcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatestopcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateStopConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateStopConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source for the stop condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatestopcondition.html#cfn-fis-experimenttemplate-experimenttemplatestopcondition-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatestopcondition.html#cfn-fis-experimenttemplate-experimenttemplatestopcondition-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatestopcondition.html#cfn-fis-experimenttemplate-experimenttemplatestopcondition-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatestopcondition.html#cfn-fis-experimenttemplate-experimenttemplatestopcondition-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateStopConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateStopConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateStopConditionProperty> {
            java.lang.String source;
            java.lang.String value;

            /**
             * Sets the value of {@link ExperimentTemplateStopConditionProperty#getSource}
             * @param source The source for the stop condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateStopConditionProperty#getValue}
             * @param value The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateStopConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateStopConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateStopConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateStopConditionProperty {
            private final java.lang.String source;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("source", om.valueToTree(this.getSource()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateStopConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateStopConditionProperty.Jsii$Proxy that = (ExperimentTemplateStopConditionProperty.Jsii$Proxy) o;

                if (!source.equals(that.source)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a filter used for the target resource input in an experiment template.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters">Resource filters</a> in the <em>AWS Fault Injection Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateTargetFilterProperty experimentTemplateTargetFilterProperty = ExperimentTemplateTargetFilterProperty.builder()
     *         .path("path")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetargetfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetargetfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateTargetFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateTargetFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The attribute path for the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetargetfilter.html#cfn-fis-experimenttemplate-experimenttemplatetargetfilter-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetargetfilter.html#cfn-fis-experimenttemplate-experimenttemplatetargetfilter-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * The attribute values for the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetargetfilter.html#cfn-fis-experimenttemplate-experimenttemplatetargetfilter-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetargetfilter.html#cfn-fis-experimenttemplate-experimenttemplatetargetfilter-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateTargetFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateTargetFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateTargetFilterProperty> {
            java.lang.String path;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link ExperimentTemplateTargetFilterProperty#getPath}
             * @param path The attribute path for the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetFilterProperty#getValues}
             * @param values The attribute values for the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateTargetFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateTargetFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateTargetFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateTargetFilterProperty {
            private final java.lang.String path;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("path", om.valueToTree(this.getPath()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateTargetFilterProperty.Jsii$Proxy that = (ExperimentTemplateTargetFilterProperty.Jsii$Proxy) o;

                if (!path.equals(that.path)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.path.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a target for an experiment.
     * <p>
     * You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both ARNs and tags.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html">Targets</a> in the <em>AWS Fault Injection Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * ExperimentTemplateTargetProperty experimentTemplateTargetProperty = ExperimentTemplateTargetProperty.builder()
     *         .resourceType("resourceType")
     *         .selectionMode("selectionMode")
     *         // the properties below are optional
     *         .filters(List.of(ExperimentTemplateTargetFilterProperty.builder()
     *                 .path("path")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .resourceArns(List.of("resourceArns"))
     *         .resourceTags(Map.of(
     *                 "resourceTagsKey", "resourceTags"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentTemplateTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentTemplateTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * Scopes the identified resources to a specific count or percentage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-selectionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-selectionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSelectionMode();

        /**
         * The filters to apply to identify target resources using specific attributes.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateTargetFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-filters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilters() {
            return null;
        }

        /**
         * The parameters for the resource type.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The Amazon Resource Names (ARNs) of the targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-resourcearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-resourcearns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceArns() {
            return null;
        }

        /**
         * The tags for the target resources.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-experimenttemplatetarget.html#cfn-fis-experimenttemplate-experimenttemplatetarget-resourcetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentTemplateTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentTemplateTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateTargetProperty> {
            java.lang.String resourceType;
            java.lang.String selectionMode;
            java.lang.Object filters;
            java.lang.Object parameters;
            java.util.List<java.lang.String> resourceArns;
            java.lang.Object resourceTags;

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceType}
             * @param resourceType The resource type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getSelectionMode}
             * @param selectionMode Scopes the identified resources to a specific count or percentage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionMode(java.lang.String selectionMode) {
                this.selectionMode = selectionMode;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getFilters}
             * @param filters The filters to apply to identify target resources using specific attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getFilters}
             * @param filters The filters to apply to identify target resources using specific attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(java.util.List<? extends java.lang.Object> filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getParameters}
             * @param parameters The parameters for the resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getParameters}
             * @param parameters The parameters for the resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceArns}
             * @param resourceArns The Amazon Resource Names (ARNs) of the targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
                this.resourceArns = resourceArns;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceTags}
             * @param resourceTags The tags for the target resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(java.util.Map<java.lang.String, java.lang.String> resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentTemplateTargetProperty#getResourceTags}
             * @param resourceTags The tags for the target resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentTemplateTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentTemplateTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentTemplateTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateTargetProperty {
            private final java.lang.String resourceType;
            private final java.lang.String selectionMode;
            private final java.lang.Object filters;
            private final java.lang.Object parameters;
            private final java.util.List<java.lang.String> resourceArns;
            private final java.lang.Object resourceTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectionMode = software.amazon.jsii.Kernel.get(this, "selectionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceArns = software.amazon.jsii.Kernel.get(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
                this.selectionMode = java.util.Objects.requireNonNull(builder.selectionMode, "selectionMode is required");
                this.filters = builder.filters;
                this.parameters = builder.parameters;
                this.resourceArns = builder.resourceArns;
                this.resourceTags = builder.resourceTags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.String getSelectionMode() {
                return this.selectionMode;
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceArns() {
                return this.resourceArns;
            }

            @Override
            public final java.lang.Object getResourceTags() {
                return this.resourceTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceType", om.valueToTree(this.getResourceType()));
                data.set("selectionMode", om.valueToTree(this.getSelectionMode()));
                if (this.getFilters() != null) {
                    data.set("filters", om.valueToTree(this.getFilters()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getResourceArns() != null) {
                    data.set("resourceArns", om.valueToTree(this.getResourceArns()));
                }
                if (this.getResourceTags() != null) {
                    data.set("resourceTags", om.valueToTree(this.getResourceTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.ExperimentTemplateTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentTemplateTargetProperty.Jsii$Proxy that = (ExperimentTemplateTargetProperty.Jsii$Proxy) o;

                if (!resourceType.equals(that.resourceType)) return false;
                if (!selectionMode.equals(that.selectionMode)) return false;
                if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.resourceArns != null ? !this.resourceArns.equals(that.resourceArns) : that.resourceArns != null) return false;
                return this.resourceTags != null ? this.resourceTags.equals(that.resourceTags) : that.resourceTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType.hashCode();
                result = 31 * result + (this.selectionMode.hashCode());
                result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.resourceArns != null ? this.resourceArns.hashCode() : 0);
                result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the output destinations of the experiment report.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * OutputsProperty outputsProperty = OutputsProperty.builder()
     *         .experimentReportS3Configuration(ExperimentReportS3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 // the properties below are optional
     *                 .prefix("prefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-outputs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-outputs.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.OutputsProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 destination for the experiment report.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentReportS3ConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-outputs.html#cfn-fis-experimenttemplate-outputs-experimentreports3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-outputs.html#cfn-fis-experimenttemplate-outputs-experimentreports3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExperimentReportS3Configuration();

        /**
         * @return a {@link Builder} of {@link OutputsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputsProperty> {
            java.lang.Object experimentReportS3Configuration;

            /**
             * Sets the value of {@link OutputsProperty#getExperimentReportS3Configuration}
             * @param experimentReportS3Configuration The S3 destination for the experiment report. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder experimentReportS3Configuration(software.amazon.awscdk.IResolvable experimentReportS3Configuration) {
                this.experimentReportS3Configuration = experimentReportS3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link OutputsProperty#getExperimentReportS3Configuration}
             * @param experimentReportS3Configuration The S3 destination for the experiment report. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder experimentReportS3Configuration(software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentReportS3ConfigurationProperty experimentReportS3Configuration) {
                this.experimentReportS3Configuration = experimentReportS3Configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputsProperty {
            private final java.lang.Object experimentReportS3Configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.experimentReportS3Configuration = software.amazon.jsii.Kernel.get(this, "experimentReportS3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.experimentReportS3Configuration = java.util.Objects.requireNonNull(builder.experimentReportS3Configuration, "experimentReportS3Configuration is required");
            }

            @Override
            public final java.lang.Object getExperimentReportS3Configuration() {
                return this.experimentReportS3Configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("experimentReportS3Configuration", om.valueToTree(this.getExperimentReportS3Configuration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.OutputsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputsProperty.Jsii$Proxy that = (OutputsProperty.Jsii$Proxy) o;

                return this.experimentReportS3Configuration.equals(that.experimentReportS3Configuration);
            }

            @Override
            public final int hashCode() {
                int result = this.experimentReportS3Configuration.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for experiment logging to Amazon S3 .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fis.*;
     * S3ConfigurationProperty s3ConfigurationProperty = S3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-s3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-s3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplate.S3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the destination bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-s3configuration.html#cfn-fis-experimenttemplate-s3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-s3configuration.html#cfn-fis-experimenttemplate-s3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The bucket prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-s3configuration.html#cfn-fis-experimenttemplate-s3configuration-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fis-experimenttemplate-s3configuration.html#cfn-fis-experimenttemplate-s3configuration-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigurationProperty> {
            java.lang.String bucketName;
            java.lang.String prefix;

            /**
             * Sets the value of {@link S3ConfigurationProperty#getBucketName}
             * @param bucketName The name of the destination bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getPrefix}
             * @param prefix The bucket prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigurationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplate.S3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigurationProperty.Jsii$Proxy that = (S3ConfigurationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fis.CfnExperimentTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fis.CfnExperimentTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fis.CfnExperimentTemplateProps.Builder();
        }

        /**
         * The description for the experiment template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-description</a>
         * @param description The description for the experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }
        /**
         * The Amazon Resource Name (ARN) of an IAM role.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final software.amazon.awscdk.interfaces.iam.IRoleRef roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The stop conditions for the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-stopconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-stopconditions</a>
         * @param stopConditions The stop conditions for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopConditions(final software.amazon.awscdk.IResolvable stopConditions) {
            this.props.stopConditions(stopConditions);
            return this;
        }
        /**
         * The stop conditions for the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-stopconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-stopconditions</a>
         * @param stopConditions The stop conditions for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopConditions(final java.util.List<? extends java.lang.Object> stopConditions) {
            this.props.stopConditions(stopConditions);
            return this;
        }

        /**
         * The targets for the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-targets</a>
         * @param targets The targets for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.IResolvable targets) {
            this.props.targets(targets);
            return this;
        }
        /**
         * The targets for the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-targets</a>
         * @param targets The targets for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.Map<java.lang.String, ? extends java.lang.Object> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * The actions for the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-actions</a>
         * @param actions The actions for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * The actions for the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-actions</a>
         * @param actions The actions for the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.Map<java.lang.String, ? extends java.lang.Object> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * The experiment options for an experiment template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentoptions</a>
         * @param experimentOptions The experiment options for an experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentOptions(final software.amazon.awscdk.IResolvable experimentOptions) {
            this.props.experimentOptions(experimentOptions);
            return this;
        }
        /**
         * The experiment options for an experiment template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentoptions</a>
         * @param experimentOptions The experiment options for an experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentOptions(final software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateExperimentOptionsProperty experimentOptions) {
            this.props.experimentOptions(experimentOptions);
            return this;
        }

        /**
         * Describes the report configuration for the experiment template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentreportconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentreportconfiguration</a>
         * @param experimentReportConfiguration Describes the report configuration for the experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentReportConfiguration(final software.amazon.awscdk.IResolvable experimentReportConfiguration) {
            this.props.experimentReportConfiguration(experimentReportConfiguration);
            return this;
        }
        /**
         * Describes the report configuration for the experiment template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentreportconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-experimentreportconfiguration</a>
         * @param experimentReportConfiguration Describes the report configuration for the experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentReportConfiguration(final software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateExperimentReportConfigurationProperty experimentReportConfiguration) {
            this.props.experimentReportConfiguration(experimentReportConfiguration);
            return this;
        }

        /**
         * The configuration for experiment logging.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-logconfiguration</a>
         * @param logConfiguration The configuration for experiment logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.IResolvable logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }
        /**
         * The configuration for experiment logging.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-logconfiguration</a>
         * @param logConfiguration The configuration for experiment logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }

        /**
         * The tags for the experiment template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fis-experimenttemplate.html#cfn-fis-experimenttemplate-tags</a>
         * @param tags The tags for the experiment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.fis.CfnExperimentTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fis.CfnExperimentTemplate build() {
            return new software.amazon.awscdk.services.fis.CfnExperimentTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
