package software.amazon.awscdk.services.globalaccelerator;

/**
 * Construct properties for Listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.globalaccelerator.*;
 * Accelerator accelerator;
 * ListenerProps listenerProps = ListenerProps.builder()
 *         .accelerator(accelerator)
 *         .portRanges(List.of(PortRange.builder()
 *                 .fromPort(123)
 *                 // the properties below are optional
 *                 .toPort(123)
 *                 .build()))
 *         // the properties below are optional
 *         .clientAffinity(ClientAffinity.NONE)
 *         .listenerName("listenerName")
 *         .protocol(ConnectionProtocol.TCP)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.700Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.ListenerProps")
@software.amazon.jsii.Jsii.Proxy(ListenerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ListenerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.globalaccelerator.ListenerOptions {

    /**
     * The accelerator for this listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.IAccelerator getAccelerator();

    /**
     * @return a {@link Builder} of {@link ListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ListenerProps> {
        software.amazon.awscdk.services.globalaccelerator.IAccelerator accelerator;
        java.util.List<software.amazon.awscdk.services.globalaccelerator.PortRange> portRanges;
        software.amazon.awscdk.services.globalaccelerator.ClientAffinity clientAffinity;
        java.lang.String listenerName;
        software.amazon.awscdk.services.globalaccelerator.ConnectionProtocol protocol;

        /**
         * Sets the value of {@link ListenerProps#getAccelerator}
         * @param accelerator The accelerator for this listener. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerator(software.amazon.awscdk.services.globalaccelerator.IAccelerator accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        /**
         * Sets the value of {@link ListenerProps#getPortRanges}
         * @param portRanges The list of port ranges for the connections from clients to the accelerator. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder portRanges(java.util.List<? extends software.amazon.awscdk.services.globalaccelerator.PortRange> portRanges) {
            this.portRanges = (java.util.List<software.amazon.awscdk.services.globalaccelerator.PortRange>)portRanges;
            return this;
        }

        /**
         * Sets the value of {@link ListenerProps#getClientAffinity}
         * @param clientAffinity Client affinity to direct all requests from a user to the same endpoint.
         *                       If you have stateful applications, client affinity lets you direct all
         *                       requests from a user to the same endpoint.
         *                       <p>
         *                       By default, each connection from each client is routed to separate
         *                       endpoints. Set client affinity to SOURCE_IP to route all connections from
         *                       a single client to the same endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAffinity(software.amazon.awscdk.services.globalaccelerator.ClientAffinity clientAffinity) {
            this.clientAffinity = clientAffinity;
            return this;
        }

        /**
         * Sets the value of {@link ListenerProps#getListenerName}
         * @param listenerName Name of the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerName(java.lang.String listenerName) {
            this.listenerName = listenerName;
            return this;
        }

        /**
         * Sets the value of {@link ListenerProps#getProtocol}
         * @param protocol The protocol for the connections from clients to the accelerator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.globalaccelerator.ConnectionProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ListenerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerProps {
        private final software.amazon.awscdk.services.globalaccelerator.IAccelerator accelerator;
        private final java.util.List<software.amazon.awscdk.services.globalaccelerator.PortRange> portRanges;
        private final software.amazon.awscdk.services.globalaccelerator.ClientAffinity clientAffinity;
        private final java.lang.String listenerName;
        private final software.amazon.awscdk.services.globalaccelerator.ConnectionProtocol protocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accelerator = software.amazon.jsii.Kernel.get(this, "accelerator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.IAccelerator.class));
            this.portRanges = software.amazon.jsii.Kernel.get(this, "portRanges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.PortRange.class)));
            this.clientAffinity = software.amazon.jsii.Kernel.get(this, "clientAffinity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.ClientAffinity.class));
            this.listenerName = software.amazon.jsii.Kernel.get(this, "listenerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.ConnectionProtocol.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accelerator = java.util.Objects.requireNonNull(builder.accelerator, "accelerator is required");
            this.portRanges = (java.util.List<software.amazon.awscdk.services.globalaccelerator.PortRange>)java.util.Objects.requireNonNull(builder.portRanges, "portRanges is required");
            this.clientAffinity = builder.clientAffinity;
            this.listenerName = builder.listenerName;
            this.protocol = builder.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.globalaccelerator.IAccelerator getAccelerator() {
            return this.accelerator;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.globalaccelerator.PortRange> getPortRanges() {
            return this.portRanges;
        }

        @Override
        public final software.amazon.awscdk.services.globalaccelerator.ClientAffinity getClientAffinity() {
            return this.clientAffinity;
        }

        @Override
        public final java.lang.String getListenerName() {
            return this.listenerName;
        }

        @Override
        public final software.amazon.awscdk.services.globalaccelerator.ConnectionProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accelerator", om.valueToTree(this.getAccelerator()));
            data.set("portRanges", om.valueToTree(this.getPortRanges()));
            if (this.getClientAffinity() != null) {
                data.set("clientAffinity", om.valueToTree(this.getClientAffinity()));
            }
            if (this.getListenerName() != null) {
                data.set("listenerName", om.valueToTree(this.getListenerName()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_globalaccelerator.ListenerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ListenerProps.Jsii$Proxy that = (ListenerProps.Jsii$Proxy) o;

            if (!accelerator.equals(that.accelerator)) return false;
            if (!portRanges.equals(that.portRanges)) return false;
            if (this.clientAffinity != null ? !this.clientAffinity.equals(that.clientAffinity) : that.clientAffinity != null) return false;
            if (this.listenerName != null ? !this.listenerName.equals(that.listenerName) : that.listenerName != null) return false;
            return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accelerator.hashCode();
            result = 31 * result + (this.portRanges.hashCode());
            result = 31 * result + (this.clientAffinity != null ? this.clientAffinity.hashCode() : 0);
            result = 31 * result + (this.listenerName != null ? this.listenerName.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            return result;
        }
    }
}
