package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnConnection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object athenaProperties;
 * Object connectionProperties;
 * Object customAuthenticationCredentials;
 * Object pythonProperties;
 * Object sparkProperties;
 * Object tokenUrlParametersMap;
 * CfnConnectionProps cfnConnectionProps = CfnConnectionProps.builder()
 *         .catalogId("catalogId")
 *         .connectionInput(ConnectionInputProperty.builder()
 *                 .connectionType("connectionType")
 *                 // the properties below are optional
 *                 .athenaProperties(athenaProperties)
 *                 .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
 *                         .authenticationType("authenticationType")
 *                         // the properties below are optional
 *                         .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .customAuthenticationCredentials(customAuthenticationCredentials)
 *                         .kmsKeyArn("kmsKeyArn")
 *                         .oAuth2Properties(OAuth2PropertiesInputProperty.builder()
 *                                 .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
 *                                         .authorizationCode("authorizationCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
 *                                         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
 *                                         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
 *                                         .build())
 *                                 .oAuth2Credentials(OAuth2CredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .jwtToken("jwtToken")
 *                                         .refreshToken("refreshToken")
 *                                         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
 *                                         .build())
 *                                 .oAuth2GrantType("oAuth2GrantType")
 *                                 .tokenUrl("tokenUrl")
 *                                 .tokenUrlParametersMap(tokenUrlParametersMap)
 *                                 .build())
 *                         .secretArn("secretArn")
 *                         .build())
 *                 .connectionProperties(connectionProperties)
 *                 .description("description")
 *                 .matchCriteria(List.of("matchCriteria"))
 *                 .name("name")
 *                 .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .securityGroupIdList(List.of("securityGroupIdList"))
 *                         .subnetId("subnetId")
 *                         .build())
 *                 .pythonProperties(pythonProperties)
 *                 .sparkProperties(sparkProperties)
 *                 .validateCredentials(false)
 *                 .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.719Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the data catalog to create the catalog object in.
     * <p>
     * Currently, this should be the AWS account ID.
     * <p>
     * <blockquote>
     * <p>
     * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

    /**
     * The connection that you want to create.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnConnection.ConnectionInputProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectionInput();

    /**
     * @return a {@link Builder} of {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectionProps> {
        java.lang.String catalogId;
        java.lang.Object connectionInput;

        /**
         * Sets the value of {@link CfnConnectionProps#getCatalogId}
         * @param catalogId The ID of the data catalog to create the catalog object in. This parameter is required.
         *                  Currently, this should be the AWS account ID.
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code> .
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(java.lang.String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getConnectionInput}
         * @param connectionInput The connection that you want to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionInput(software.amazon.awscdk.IResolvable connectionInput) {
            this.connectionInput = connectionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getConnectionInput}
         * @param connectionInput The connection that you want to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionInput(software.amazon.awscdk.services.glue.CfnConnection.ConnectionInputProperty connectionInput) {
            this.connectionInput = connectionInput;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectionProps {
        private final java.lang.String catalogId;
        private final java.lang.Object connectionInput;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionInput = software.amazon.jsii.Kernel.get(this, "connectionInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
            this.connectionInput = java.util.Objects.requireNonNull(builder.connectionInput, "connectionInput is required");
        }

        @Override
        public final java.lang.String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final java.lang.Object getConnectionInput() {
            return this.connectionInput;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("catalogId", om.valueToTree(this.getCatalogId()));
            data.set("connectionInput", om.valueToTree(this.getConnectionInput()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectionProps.Jsii$Proxy that = (CfnConnectionProps.Jsii$Proxy) o;

            if (!catalogId.equals(that.catalogId)) return false;
            return this.connectionInput.equals(that.connectionInput);
        }

        @Override
        public final int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + (this.connectionInput.hashCode());
            return result;
        }
    }
}
