package software.amazon.awscdk.services.glue;

/**
 * The <code>AWS::Glue::Database</code> resource specifies a logical grouping of tables in AWS Glue .
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/define-database.html">Defining a Database in Your Data Catalog</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-Database">Database Structure</a> in the <em>AWS Glue Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object parameters;
 * CfnDatabase cfnDatabase = CfnDatabase.Builder.create(this, "MyCfnDatabase")
 *         .catalogId("catalogId")
 *         .databaseInput(DatabaseInputProperty.builder()
 *                 .createTableDefaultPermissions(List.of(PrincipalPrivilegesProperty.builder()
 *                         .permissions(List.of("permissions"))
 *                         .principal(DataLakePrincipalProperty.builder()
 *                                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
 *                                 .build())
 *                         .build()))
 *                 .description("description")
 *                 .federatedDatabase(FederatedDatabaseProperty.builder()
 *                         .connectionName("connectionName")
 *                         .identifier("identifier")
 *                         .build())
 *                 .locationUri("locationUri")
 *                 .name("name")
 *                 .parameters(parameters)
 *                 .targetDatabase(DatabaseIdentifierProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .region("region")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .databaseName("databaseName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.753Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDatabase")
public class CfnDatabase extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.glue.IDatabaseRef {

    protected CfnDatabase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDatabase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnDatabase.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Glue::Database</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDatabase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnDatabaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForDatabase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.glue.IDatabaseRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.CfnDatabase.class, "arnForDatabase", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new IDatabaseRef from a databaseName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param databaseName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.glue.IDatabaseRef fromDatabaseName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String databaseName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.CfnDatabase.class, "fromDatabaseName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.glue.IDatabaseRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(databaseName, "databaseName is required") });
    }

    /**
     * Checks whether the given object is a CfnDatabase.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnDatabase(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.CfnDatabase.class, "isCfnDatabase", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Database resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.glue.DatabaseReference getDatabaseRef() {
        return software.amazon.jsii.Kernel.get(this, "databaseRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.glue.DatabaseReference.class));
    }

    /**
     * The AWS account ID for the account in which to create the catalog object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCatalogId() {
        return software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID for the account in which to create the catalog object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCatalogId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "catalogId", java.util.Objects.requireNonNull(value, "catalogId is required"));
    }

    /**
     * The metadata for the database.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnDatabase.DatabaseInputProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDatabaseInput() {
        return software.amazon.jsii.Kernel.get(this, "databaseInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The metadata for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "databaseInput", java.util.Objects.requireNonNull(value, "databaseInput is required"));
    }

    /**
     * The metadata for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnDatabase.DatabaseInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "databaseInput", java.util.Objects.requireNonNull(value, "databaseInput is required"));
    }

    /**
     * The name of the catalog database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the catalog database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }
    /**
     * The AWS Lake Formation principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * DataLakePrincipalProperty dataLakePrincipalProperty = DataLakePrincipalProperty.builder()
     *         .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-datalakeprincipal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-datalakeprincipal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDatabase.DataLakePrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(DataLakePrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataLakePrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the AWS Lake Formation principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-datalakeprincipal.html#cfn-glue-database-datalakeprincipal-datalakeprincipalidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-datalakeprincipal.html#cfn-glue-database-datalakeprincipal-datalakeprincipalidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataLakePrincipalIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataLakePrincipalProperty> {
            java.lang.String dataLakePrincipalIdentifier;

            /**
             * Sets the value of {@link DataLakePrincipalProperty#getDataLakePrincipalIdentifier}
             * @param dataLakePrincipalIdentifier An identifier for the AWS Lake Formation principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLakePrincipalIdentifier(java.lang.String dataLakePrincipalIdentifier) {
                this.dataLakePrincipalIdentifier = dataLakePrincipalIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataLakePrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataLakePrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataLakePrincipalProperty {
            private final java.lang.String dataLakePrincipalIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataLakePrincipalIdentifier = software.amazon.jsii.Kernel.get(this, "dataLakePrincipalIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataLakePrincipalIdentifier = builder.dataLakePrincipalIdentifier;
            }

            @Override
            public final java.lang.String getDataLakePrincipalIdentifier() {
                return this.dataLakePrincipalIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataLakePrincipalIdentifier() != null) {
                    data.set("dataLakePrincipalIdentifier", om.valueToTree(this.getDataLakePrincipalIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDatabase.DataLakePrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataLakePrincipalProperty.Jsii$Proxy that = (DataLakePrincipalProperty.Jsii$Proxy) o;

                return this.dataLakePrincipalIdentifier != null ? this.dataLakePrincipalIdentifier.equals(that.dataLakePrincipalIdentifier) : that.dataLakePrincipalIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataLakePrincipalIdentifier != null ? this.dataLakePrincipalIdentifier.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A structure that describes a target database for resource linking.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * DatabaseIdentifierProperty databaseIdentifierProperty = DatabaseIdentifierProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDatabase.DatabaseIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the Data Catalog in which the database resides.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * The name of the catalog database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * The Region of the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseIdentifierProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String region;

            /**
             * Sets the value of {@link DatabaseIdentifierProperty#getCatalogId}
             * @param catalogId The ID of the Data Catalog in which the database resides.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseIdentifierProperty#getDatabaseName}
             * @param databaseName The name of the catalog database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseIdentifierProperty#getRegion}
             * @param region The Region of the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseIdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseIdentifierProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = builder.catalogId;
                this.databaseName = builder.databaseName;
                this.region = builder.region;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDatabase.DatabaseIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseIdentifierProperty.Jsii$Proxy that = (DatabaseIdentifierProperty.Jsii$Proxy) o;

                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                return this.region != null ? this.region.equals(that.region) : that.region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId != null ? this.catalogId.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The structure used to create or update a database.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object parameters;
     * DatabaseInputProperty databaseInputProperty = DatabaseInputProperty.builder()
     *         .createTableDefaultPermissions(List.of(PrincipalPrivilegesProperty.builder()
     *                 .permissions(List.of("permissions"))
     *                 .principal(DataLakePrincipalProperty.builder()
     *                         .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
     *                         .build())
     *                 .build()))
     *         .description("description")
     *         .federatedDatabase(FederatedDatabaseProperty.builder()
     *                 .connectionName("connectionName")
     *                 .identifier("identifier")
     *                 .build())
     *         .locationUri("locationUri")
     *         .name("name")
     *         .parameters(parameters)
     *         .targetDatabase(DatabaseIdentifierProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 .region("region")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDatabase.DatabaseInputProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Creates a set of default permissions on the table for principals.
         * <p>
         * Used by AWS Lake Formation . Not used in the normal course of AWS Glue operations.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnDatabase.PrincipalPrivilegesProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-createtabledefaultpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-createtabledefaultpermissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateTableDefaultPermissions() {
            return null;
        }

        /**
         * A description of the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A <code>FederatedDatabase</code> structure that references an entity outside the AWS Glue Data Catalog .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnDatabase.FederatedDatabaseProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-federateddatabase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-federateddatabase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFederatedDatabase() {
            return null;
        }

        /**
         * The location of the database (for example, an HDFS path).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-locationuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-locationuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocationUri() {
            return null;
        }

        /**
         * The name of the database.
         * <p>
         * For Hive compatibility, this is folded to lowercase when it is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * These key-value pairs define parameters and properties of the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnDatabase.DatabaseIdentifierProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-targetdatabase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-targetdatabase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetDatabase() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseInputProperty> {
            java.lang.Object createTableDefaultPermissions;
            java.lang.String description;
            java.lang.Object federatedDatabase;
            java.lang.String locationUri;
            java.lang.String name;
            java.lang.Object parameters;
            java.lang.Object targetDatabase;

            /**
             * Sets the value of {@link DatabaseInputProperty#getCreateTableDefaultPermissions}
             * @param createTableDefaultPermissions Creates a set of default permissions on the table for principals.
             *                                      Used by AWS Lake Formation . Not used in the normal course of AWS Glue operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createTableDefaultPermissions(software.amazon.awscdk.IResolvable createTableDefaultPermissions) {
                this.createTableDefaultPermissions = createTableDefaultPermissions;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getCreateTableDefaultPermissions}
             * @param createTableDefaultPermissions Creates a set of default permissions on the table for principals.
             *                                      Used by AWS Lake Formation . Not used in the normal course of AWS Glue operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createTableDefaultPermissions(java.util.List<? extends java.lang.Object> createTableDefaultPermissions) {
                this.createTableDefaultPermissions = createTableDefaultPermissions;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getDescription}
             * @param description A description of the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getFederatedDatabase}
             * @param federatedDatabase A <code>FederatedDatabase</code> structure that references an entity outside the AWS Glue Data Catalog .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder federatedDatabase(software.amazon.awscdk.IResolvable federatedDatabase) {
                this.federatedDatabase = federatedDatabase;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getFederatedDatabase}
             * @param federatedDatabase A <code>FederatedDatabase</code> structure that references an entity outside the AWS Glue Data Catalog .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder federatedDatabase(software.amazon.awscdk.services.glue.CfnDatabase.FederatedDatabaseProperty federatedDatabase) {
                this.federatedDatabase = federatedDatabase;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getLocationUri}
             * @param locationUri The location of the database (for example, an HDFS path).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locationUri(java.lang.String locationUri) {
                this.locationUri = locationUri;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getName}
             * @param name The name of the database.
             *             For Hive compatibility, this is folded to lowercase when it is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getParameters}
             * @param parameters These key-value pairs define parameters and properties of the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.Object parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getTargetDatabase}
             * @param targetDatabase A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDatabase(software.amazon.awscdk.IResolvable targetDatabase) {
                this.targetDatabase = targetDatabase;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseInputProperty#getTargetDatabase}
             * @param targetDatabase A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDatabase(software.amazon.awscdk.services.glue.CfnDatabase.DatabaseIdentifierProperty targetDatabase) {
                this.targetDatabase = targetDatabase;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInputProperty {
            private final java.lang.Object createTableDefaultPermissions;
            private final java.lang.String description;
            private final java.lang.Object federatedDatabase;
            private final java.lang.String locationUri;
            private final java.lang.String name;
            private final java.lang.Object parameters;
            private final java.lang.Object targetDatabase;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.createTableDefaultPermissions = software.amazon.jsii.Kernel.get(this, "createTableDefaultPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.federatedDatabase = software.amazon.jsii.Kernel.get(this, "federatedDatabase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.locationUri = software.amazon.jsii.Kernel.get(this, "locationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetDatabase = software.amazon.jsii.Kernel.get(this, "targetDatabase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
                this.description = builder.description;
                this.federatedDatabase = builder.federatedDatabase;
                this.locationUri = builder.locationUri;
                this.name = builder.name;
                this.parameters = builder.parameters;
                this.targetDatabase = builder.targetDatabase;
            }

            @Override
            public final java.lang.Object getCreateTableDefaultPermissions() {
                return this.createTableDefaultPermissions;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getFederatedDatabase() {
                return this.federatedDatabase;
            }

            @Override
            public final java.lang.String getLocationUri() {
                return this.locationUri;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.Object getTargetDatabase() {
                return this.targetDatabase;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCreateTableDefaultPermissions() != null) {
                    data.set("createTableDefaultPermissions", om.valueToTree(this.getCreateTableDefaultPermissions()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getFederatedDatabase() != null) {
                    data.set("federatedDatabase", om.valueToTree(this.getFederatedDatabase()));
                }
                if (this.getLocationUri() != null) {
                    data.set("locationUri", om.valueToTree(this.getLocationUri()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getTargetDatabase() != null) {
                    data.set("targetDatabase", om.valueToTree(this.getTargetDatabase()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDatabase.DatabaseInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseInputProperty.Jsii$Proxy that = (DatabaseInputProperty.Jsii$Proxy) o;

                if (this.createTableDefaultPermissions != null ? !this.createTableDefaultPermissions.equals(that.createTableDefaultPermissions) : that.createTableDefaultPermissions != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.federatedDatabase != null ? !this.federatedDatabase.equals(that.federatedDatabase) : that.federatedDatabase != null) return false;
                if (this.locationUri != null ? !this.locationUri.equals(that.locationUri) : that.locationUri != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                return this.targetDatabase != null ? this.targetDatabase.equals(that.targetDatabase) : that.targetDatabase == null;
            }

            @Override
            public final int hashCode() {
                int result = this.createTableDefaultPermissions != null ? this.createTableDefaultPermissions.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.federatedDatabase != null ? this.federatedDatabase.hashCode() : 0);
                result = 31 * result + (this.locationUri != null ? this.locationUri.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.targetDatabase != null ? this.targetDatabase.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A <code>FederatedDatabase</code> structure that references an entity outside the AWS Glue Data Catalog .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * FederatedDatabaseProperty federatedDatabaseProperty = FederatedDatabaseProperty.builder()
     *         .connectionName("connectionName")
     *         .identifier("identifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-federateddatabase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-federateddatabase.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDatabase.FederatedDatabaseProperty")
    @software.amazon.jsii.Jsii.Proxy(FederatedDatabaseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FederatedDatabaseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection to the external metastore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-federateddatabase.html#cfn-glue-database-federateddatabase-connectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-federateddatabase.html#cfn-glue-database-federateddatabase-connectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * A unique identifier for the federated database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-federateddatabase.html#cfn-glue-database-federateddatabase-identifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-federateddatabase.html#cfn-glue-database-federateddatabase-identifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FederatedDatabaseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FederatedDatabaseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FederatedDatabaseProperty> {
            java.lang.String connectionName;
            java.lang.String identifier;

            /**
             * Sets the value of {@link FederatedDatabaseProperty#getConnectionName}
             * @param connectionName The name of the connection to the external metastore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link FederatedDatabaseProperty#getIdentifier}
             * @param identifier A unique identifier for the federated database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifier(java.lang.String identifier) {
                this.identifier = identifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FederatedDatabaseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FederatedDatabaseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FederatedDatabaseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FederatedDatabaseProperty {
            private final java.lang.String connectionName;
            private final java.lang.String identifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.identifier = builder.identifier;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.lang.String getIdentifier() {
                return this.identifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getIdentifier() != null) {
                    data.set("identifier", om.valueToTree(this.getIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDatabase.FederatedDatabaseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FederatedDatabaseProperty.Jsii$Proxy that = (FederatedDatabaseProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * the permissions granted to a principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * PrincipalPrivilegesProperty principalPrivilegesProperty = PrincipalPrivilegesProperty.builder()
     *         .permissions(List.of("permissions"))
     *         .principal(DataLakePrincipalProperty.builder()
     *                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-principalprivileges.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-principalprivileges.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDatabase.PrincipalPrivilegesProperty")
    @software.amazon.jsii.Jsii.Proxy(PrincipalPrivilegesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrincipalPrivilegesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The permissions that are granted to the principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-principalprivileges.html#cfn-glue-database-principalprivileges-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-principalprivileges.html#cfn-glue-database-principalprivileges-permissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
            return null;
        }

        /**
         * The principal who is granted permissions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnDatabase.DataLakePrincipalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-principalprivileges.html#cfn-glue-database-principalprivileges-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-principalprivileges.html#cfn-glue-database-principalprivileges-principal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrincipal() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrincipalPrivilegesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrincipalPrivilegesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrincipalPrivilegesProperty> {
            java.util.List<java.lang.String> permissions;
            java.lang.Object principal;

            /**
             * Sets the value of {@link PrincipalPrivilegesProperty#getPermissions}
             * @param permissions The permissions that are granted to the principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissions(java.util.List<java.lang.String> permissions) {
                this.permissions = permissions;
                return this;
            }

            /**
             * Sets the value of {@link PrincipalPrivilegesProperty#getPrincipal}
             * @param principal The principal who is granted permissions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(software.amazon.awscdk.IResolvable principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Sets the value of {@link PrincipalPrivilegesProperty#getPrincipal}
             * @param principal The principal who is granted permissions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(software.amazon.awscdk.services.glue.CfnDatabase.DataLakePrincipalProperty principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrincipalPrivilegesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrincipalPrivilegesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrincipalPrivilegesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrincipalPrivilegesProperty {
            private final java.util.List<java.lang.String> permissions;
            private final java.lang.Object principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.permissions = builder.permissions;
                this.principal = builder.principal;
            }

            @Override
            public final java.util.List<java.lang.String> getPermissions() {
                return this.permissions;
            }

            @Override
            public final java.lang.Object getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPermissions() != null) {
                    data.set("permissions", om.valueToTree(this.getPermissions()));
                }
                if (this.getPrincipal() != null) {
                    data.set("principal", om.valueToTree(this.getPrincipal()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDatabase.PrincipalPrivilegesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrincipalPrivilegesProperty.Jsii$Proxy that = (PrincipalPrivilegesProperty.Jsii$Proxy) o;

                if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
                return this.principal != null ? this.principal.equals(that.principal) : that.principal == null;
            }

            @Override
            public final int hashCode() {
                int result = this.permissions != null ? this.permissions.hashCode() : 0;
                result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnDatabase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnDatabase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnDatabaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnDatabaseProps.Builder();
        }

        /**
         * The AWS account ID for the account in which to create the catalog object.
         * <p>
         * <blockquote>
         * <p>
         * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid</a>
         * @param catalogId The AWS account ID for the account in which to create the catalog object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(final java.lang.String catalogId) {
            this.props.catalogId(catalogId);
            return this;
        }

        /**
         * The metadata for the database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput</a>
         * @param databaseInput The metadata for the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInput(final software.amazon.awscdk.IResolvable databaseInput) {
            this.props.databaseInput(databaseInput);
            return this;
        }
        /**
         * The metadata for the database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput</a>
         * @param databaseInput The metadata for the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInput(final software.amazon.awscdk.services.glue.CfnDatabase.DatabaseInputProperty databaseInput) {
            this.props.databaseInput(databaseInput);
            return this;
        }

        /**
         * The name of the catalog database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databasename</a>
         * @param databaseName The name of the catalog database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnDatabase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnDatabase build() {
            return new software.amazon.awscdk.services.glue.CfnDatabase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
