package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnIdentityCenterConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnIdentityCenterConfigurationProps cfnIdentityCenterConfigurationProps = CfnIdentityCenterConfigurationProps.builder()
 *         .instanceArn("instanceArn")
 *         // the properties below are optional
 *         .scopes(List.of("scopes"))
 *         .userBackgroundSessionsEnabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.762Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnIdentityCenterConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentityCenterConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentityCenterConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IAM identity center instance arn.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html#cfn-glue-identitycenterconfiguration-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html#cfn-glue-identitycenterconfiguration-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * The downstream scopes that Glue identity center configuration can access.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html#cfn-glue-identitycenterconfiguration-scopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html#cfn-glue-identitycenterconfiguration-scopes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getScopes() {
        return null;
    }

    /**
     * Enable or disable user background sessions for Glue Identity Center.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html#cfn-glue-identitycenterconfiguration-userbackgroundsessionsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-identitycenterconfiguration.html#cfn-glue-identitycenterconfiguration-userbackgroundsessionsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserBackgroundSessionsEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentityCenterConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentityCenterConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentityCenterConfigurationProps> {
        java.lang.String instanceArn;
        java.util.List<java.lang.String> scopes;
        java.lang.Object userBackgroundSessionsEnabled;

        /**
         * Sets the value of {@link CfnIdentityCenterConfigurationProps#getInstanceArn}
         * @param instanceArn The IAM identity center instance arn. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityCenterConfigurationProps#getScopes}
         * @param scopes The downstream scopes that Glue identity center configuration can access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(java.util.List<java.lang.String> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityCenterConfigurationProps#getUserBackgroundSessionsEnabled}
         * @param userBackgroundSessionsEnabled Enable or disable user background sessions for Glue Identity Center.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userBackgroundSessionsEnabled(java.lang.Boolean userBackgroundSessionsEnabled) {
            this.userBackgroundSessionsEnabled = userBackgroundSessionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityCenterConfigurationProps#getUserBackgroundSessionsEnabled}
         * @param userBackgroundSessionsEnabled Enable or disable user background sessions for Glue Identity Center.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userBackgroundSessionsEnabled(software.amazon.awscdk.IResolvable userBackgroundSessionsEnabled) {
            this.userBackgroundSessionsEnabled = userBackgroundSessionsEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentityCenterConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentityCenterConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdentityCenterConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentityCenterConfigurationProps {
        private final java.lang.String instanceArn;
        private final java.util.List<java.lang.String> scopes;
        private final java.lang.Object userBackgroundSessionsEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userBackgroundSessionsEnabled = software.amazon.jsii.Kernel.get(this, "userBackgroundSessionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.scopes = builder.scopes;
            this.userBackgroundSessionsEnabled = builder.userBackgroundSessionsEnabled;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.util.List<java.lang.String> getScopes() {
            return this.scopes;
        }

        @Override
        public final java.lang.Object getUserBackgroundSessionsEnabled() {
            return this.userBackgroundSessionsEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }
            if (this.getUserBackgroundSessionsEnabled() != null) {
                data.set("userBackgroundSessionsEnabled", om.valueToTree(this.getUserBackgroundSessionsEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnIdentityCenterConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentityCenterConfigurationProps.Jsii$Proxy that = (CfnIdentityCenterConfigurationProps.Jsii$Proxy) o;

            if (!instanceArn.equals(that.instanceArn)) return false;
            if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
            return this.userBackgroundSessionsEnabled != null ? this.userBackgroundSessionsEnabled.equals(that.userBackgroundSessionsEnabled) : that.userBackgroundSessionsEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceArn.hashCode();
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            result = 31 * result + (this.userBackgroundSessionsEnabled != null ? this.userBackgroundSessionsEnabled.hashCode() : 0);
            return result;
        }
    }
}
