package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnIntegrationResourceProperty</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnIntegrationResourcePropertyProps cfnIntegrationResourcePropertyProps = CfnIntegrationResourcePropertyProps.builder()
 *         .resourceArn("resourceArn")
 *         // the properties below are optional
 *         .sourceProcessingProperties(SourceProcessingPropertiesProperty.builder()
 *                 .roleArn("roleArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetProcessingProperties(TargetProcessingPropertiesProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .connectionName("connectionName")
 *                 .eventBusArn("eventBusArn")
 *                 .kmsArn("kmsArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.767Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnIntegrationResourcePropertyProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntegrationResourcePropertyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntegrationResourcePropertyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The connection ARN of the source, or the database ARN of the target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-resourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

    /**
     * The resource properties associated with the integration source.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnIntegrationResourceProperty.SourceProcessingPropertiesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-sourceprocessingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-sourceprocessingproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceProcessingProperties() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The structure used to define the resource properties associated with the integration target.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnIntegrationResourceProperty.TargetProcessingPropertiesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-targetprocessingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-integrationresourceproperty.html#cfn-glue-integrationresourceproperty-targetprocessingproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetProcessingProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIntegrationResourcePropertyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntegrationResourcePropertyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntegrationResourcePropertyProps> {
        java.lang.String resourceArn;
        java.lang.Object sourceProcessingProperties;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object targetProcessingProperties;

        /**
         * Sets the value of {@link CfnIntegrationResourcePropertyProps#getResourceArn}
         * @param resourceArn The connection ARN of the source, or the database ARN of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(java.lang.String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResourcePropertyProps#getSourceProcessingProperties}
         * @param sourceProcessingProperties The resource properties associated with the integration source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceProcessingProperties(software.amazon.awscdk.IResolvable sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResourcePropertyProps#getSourceProcessingProperties}
         * @param sourceProcessingProperties The resource properties associated with the integration source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceProcessingProperties(software.amazon.awscdk.services.glue.CfnIntegrationResourceProperty.SourceProcessingPropertiesProperty sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResourcePropertyProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResourcePropertyProps#getTargetProcessingProperties}
         * @param targetProcessingProperties The structure used to define the resource properties associated with the integration target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetProcessingProperties(software.amazon.awscdk.IResolvable targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResourcePropertyProps#getTargetProcessingProperties}
         * @param targetProcessingProperties The structure used to define the resource properties associated with the integration target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetProcessingProperties(software.amazon.awscdk.services.glue.CfnIntegrationResourceProperty.TargetProcessingPropertiesProperty targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationResourcePropertyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntegrationResourcePropertyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntegrationResourcePropertyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntegrationResourcePropertyProps {
        private final java.lang.String resourceArn;
        private final java.lang.Object sourceProcessingProperties;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object targetProcessingProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceProcessingProperties = software.amazon.jsii.Kernel.get(this, "sourceProcessingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.targetProcessingProperties = software.amazon.jsii.Kernel.get(this, "targetProcessingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            this.sourceProcessingProperties = builder.sourceProcessingProperties;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.targetProcessingProperties = builder.targetProcessingProperties;
        }

        @Override
        public final java.lang.String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final java.lang.Object getSourceProcessingProperties() {
            return this.sourceProcessingProperties;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTargetProcessingProperties() {
            return this.targetProcessingProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceArn", om.valueToTree(this.getResourceArn()));
            if (this.getSourceProcessingProperties() != null) {
                data.set("sourceProcessingProperties", om.valueToTree(this.getSourceProcessingProperties()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetProcessingProperties() != null) {
                data.set("targetProcessingProperties", om.valueToTree(this.getTargetProcessingProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnIntegrationResourcePropertyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntegrationResourcePropertyProps.Jsii$Proxy that = (CfnIntegrationResourcePropertyProps.Jsii$Proxy) o;

            if (!resourceArn.equals(that.resourceArn)) return false;
            if (this.sourceProcessingProperties != null ? !this.sourceProcessingProperties.equals(that.sourceProcessingProperties) : that.sourceProcessingProperties != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.targetProcessingProperties != null ? this.targetProcessingProperties.equals(that.targetProcessingProperties) : that.targetProcessingProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceArn.hashCode();
            result = 31 * result + (this.sourceProcessingProperties != null ? this.sourceProcessingProperties.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetProcessingProperties != null ? this.targetProcessingProperties.hashCode() : 0);
            return result;
        }
    }
}
