package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnPartition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object parameters;
 * Object skewedColumnValueLocationMaps;
 * CfnPartitionProps cfnPartitionProps = CfnPartitionProps.builder()
 *         .catalogId("catalogId")
 *         .databaseName("databaseName")
 *         .partitionInput(PartitionInputProperty.builder()
 *                 .values(List.of("values"))
 *                 // the properties below are optional
 *                 .parameters(parameters)
 *                 .storageDescriptor(StorageDescriptorProperty.builder()
 *                         .bucketColumns(List.of("bucketColumns"))
 *                         .columns(List.of(ColumnProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .comment("comment")
 *                                 .type("type")
 *                                 .build()))
 *                         .compressed(false)
 *                         .inputFormat("inputFormat")
 *                         .location("location")
 *                         .numberOfBuckets(123)
 *                         .outputFormat("outputFormat")
 *                         .parameters(parameters)
 *                         .schemaReference(SchemaReferenceProperty.builder()
 *                                 .schemaId(SchemaIdProperty.builder()
 *                                         .registryName("registryName")
 *                                         .schemaArn("schemaArn")
 *                                         .schemaName("schemaName")
 *                                         .build())
 *                                 .schemaVersionId("schemaVersionId")
 *                                 .schemaVersionNumber(123)
 *                                 .build())
 *                         .serdeInfo(SerdeInfoProperty.builder()
 *                                 .name("name")
 *                                 .parameters(parameters)
 *                                 .serializationLibrary("serializationLibrary")
 *                                 .build())
 *                         .skewedInfo(SkewedInfoProperty.builder()
 *                                 .skewedColumnNames(List.of("skewedColumnNames"))
 *                                 .skewedColumnValueLocationMaps(skewedColumnValueLocationMaps)
 *                                 .skewedColumnValues(List.of("skewedColumnValues"))
 *                                 .build())
 *                         .sortColumns(List.of(OrderProperty.builder()
 *                                 .column("column")
 *                                 // the properties below are optional
 *                                 .sortOrder(123)
 *                                 .build()))
 *                         .storedAsSubDirectories(false)
 *                         .build())
 *                 .build())
 *         .tableName("tableName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.805Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnPartitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnPartitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPartitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS account ID of the catalog in which the partion is to be created.
     * <p>
     * <blockquote>
     * <p>
     * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-catalogid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

    /**
     * The name of the catalog database in which to create the partition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-databasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * The structure used to create and update a partition.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnPartition.PartitionInputProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-partitioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-partitioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPartitionInput();

    /**
     * The name of the metadata table in which the partition is to be created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-tablename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * @return a {@link Builder} of {@link CfnPartitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPartitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPartitionProps> {
        java.lang.String catalogId;
        java.lang.String databaseName;
        java.lang.Object partitionInput;
        java.lang.String tableName;

        /**
         * Sets the value of {@link CfnPartitionProps#getCatalogId}
         * @param catalogId The AWS account ID of the catalog in which the partion is to be created. This parameter is required.
         *                  <blockquote>
         *                  <p>
         *                  To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code>
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(java.lang.String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartitionProps#getDatabaseName}
         * @param databaseName The name of the catalog database in which to create the partition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartitionProps#getPartitionInput}
         * @param partitionInput The structure used to create and update a partition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionInput(software.amazon.awscdk.IResolvable partitionInput) {
            this.partitionInput = partitionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartitionProps#getPartitionInput}
         * @param partitionInput The structure used to create and update a partition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionInput(software.amazon.awscdk.services.glue.CfnPartition.PartitionInputProperty partitionInput) {
            this.partitionInput = partitionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartitionProps#getTableName}
         * @param tableName The name of the metadata table in which the partition is to be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPartitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPartitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPartitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPartitionProps {
        private final java.lang.String catalogId;
        private final java.lang.String databaseName;
        private final java.lang.Object partitionInput;
        private final java.lang.String tableName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.partitionInput = software.amazon.jsii.Kernel.get(this, "partitionInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.partitionInput = java.util.Objects.requireNonNull(builder.partitionInput, "partitionInput is required");
            this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
        }

        @Override
        public final java.lang.String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.Object getPartitionInput() {
            return this.partitionInput;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("catalogId", om.valueToTree(this.getCatalogId()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            data.set("partitionInput", om.valueToTree(this.getPartitionInput()));
            data.set("tableName", om.valueToTree(this.getTableName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnPartitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPartitionProps.Jsii$Proxy that = (CfnPartitionProps.Jsii$Proxy) o;

            if (!catalogId.equals(that.catalogId)) return false;
            if (!databaseName.equals(that.databaseName)) return false;
            if (!partitionInput.equals(that.partitionInput)) return false;
            return this.tableName.equals(that.tableName);
        }

        @Override
        public final int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + (this.databaseName.hashCode());
            result = 31 * result + (this.partitionInput.hashCode());
            result = 31 * result + (this.tableName.hashCode());
            return result;
        }
    }
}
