package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a <code>CfnConnectorDefinitionVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object parameters;
 * CfnConnectorDefinitionVersionProps cfnConnectorDefinitionVersionProps = CfnConnectorDefinitionVersionProps.builder()
 *         .connectorDefinitionId("connectorDefinitionId")
 *         .connectors(List.of(ConnectorProperty.builder()
 *                 .connectorArn("connectorArn")
 *                 .id("id")
 *                 // the properties below are optional
 *                 .parameters(parameters)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnConnectorDefinitionVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectorDefinitionVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectorDefinitionVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the connector definition associated with this version.
     * <p>
     * This value is a GUID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectordefinitionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectordefinitionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorDefinitionId();

    /**
     * The connectors in this version.
     * <p>
     * Only one instance of a given connector can be added to the connector definition version at a time.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.greengrass.CfnConnectorDefinitionVersion.ConnectorProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectors();

    /**
     * @return a {@link Builder} of {@link CfnConnectorDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectorDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectorDefinitionVersionProps> {
        java.lang.String connectorDefinitionId;
        java.lang.Object connectors;

        /**
         * Sets the value of {@link CfnConnectorDefinitionVersionProps#getConnectorDefinitionId}
         * @param connectorDefinitionId The ID of the connector definition associated with this version. This parameter is required.
         *                              This value is a GUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorDefinitionId(java.lang.String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorDefinitionVersionProps#getConnectors}
         * @param connectors The connectors in this version. This parameter is required.
         *                   Only one instance of a given connector can be added to the connector definition version at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectors(software.amazon.awscdk.IResolvable connectors) {
            this.connectors = connectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorDefinitionVersionProps#getConnectors}
         * @param connectors The connectors in this version. This parameter is required.
         *                   Only one instance of a given connector can be added to the connector definition version at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectors(java.util.List<? extends java.lang.Object> connectors) {
            this.connectors = connectors;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectorDefinitionVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectorDefinitionVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectorDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectorDefinitionVersionProps {
        private final java.lang.String connectorDefinitionId;
        private final java.lang.Object connectors;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectorDefinitionId = software.amazon.jsii.Kernel.get(this, "connectorDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectors = software.amazon.jsii.Kernel.get(this, "connectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectorDefinitionId = java.util.Objects.requireNonNull(builder.connectorDefinitionId, "connectorDefinitionId is required");
            this.connectors = java.util.Objects.requireNonNull(builder.connectors, "connectors is required");
        }

        @Override
        public final java.lang.String getConnectorDefinitionId() {
            return this.connectorDefinitionId;
        }

        @Override
        public final java.lang.Object getConnectors() {
            return this.connectors;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectorDefinitionId", om.valueToTree(this.getConnectorDefinitionId()));
            data.set("connectors", om.valueToTree(this.getConnectors()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnConnectorDefinitionVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectorDefinitionVersionProps.Jsii$Proxy that = (CfnConnectorDefinitionVersionProps.Jsii$Proxy) o;

            if (!connectorDefinitionId.equals(that.connectorDefinitionId)) return false;
            return this.connectors.equals(that.connectors);
        }

        @Override
        public final int hashCode() {
            int result = this.connectorDefinitionId.hashCode();
            result = 31 * result + (this.connectors.hashCode());
            return result;
        }
    }
}
