package software.amazon.awscdk.services.groundstation;

/**
 * Properties for defining a <code>CfnMissionProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.groundstation.*;
 * CfnMissionProfileProps cfnMissionProfileProps = CfnMissionProfileProps.builder()
 *         .dataflowEdges(List.of(DataflowEdgeProperty.builder()
 *                 .destination("destination")
 *                 .source("source")
 *                 .build()))
 *         .minimumViableContactDurationSeconds(123)
 *         .name("name")
 *         .trackingConfigArn("trackingConfigArn")
 *         // the properties below are optional
 *         .contactPostPassDurationSeconds(123)
 *         .contactPrePassDurationSeconds(123)
 *         .streamsKmsKey(StreamsKmsKeyProperty.builder()
 *                 .kmsAliasArn("kmsAliasArn")
 *                 .kmsAliasName("kmsAliasName")
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .streamsKmsRole("streamsKmsRole")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.023Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_groundstation.CfnMissionProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnMissionProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMissionProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list containing lists of config ARNs.
     * <p>
     * Each list of config ARNs is an edge, with a "from" config and a "to" config.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.groundstation.CfnMissionProfile.DataflowEdgeProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-dataflowedges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-dataflowedges</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataflowEdges();

    /**
     * Minimum length of a contact in seconds that Ground Station will return when listing contacts.
     * <p>
     * Ground Station will not return contacts shorter than this duration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-minimumviablecontactdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-minimumviablecontactdurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinimumViableContactDurationSeconds();

    /**
     * The name of the mission profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.groundstation.IConfigRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-trackingconfigarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-trackingconfigarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTrackingConfigArn();

    /**
     * Amount of time in seconds after a contact ends that you’d like to receive a Ground Station Contact State Change indicating the pass has finished.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactpostpassdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactpostpassdurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getContactPostPassDurationSeconds() {
        return null;
    }

    /**
     * Amount of time in seconds prior to contact start that you'd like to receive a Ground Station Contact State Change Event indicating an upcoming pass.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactprepassdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactprepassdurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getContactPrePassDurationSeconds() {
        return null;
    }

    /**
     * KMS key to use for encrypting streams.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.groundstation.CfnMissionProfile.StreamsKmsKeyProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-streamskmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-streamskmskey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStreamsKmsKey() {
        return null;
    }

    /**
     * Role to use for encrypting streams with KMS key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-streamskmsrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-streamskmsrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStreamsKmsRole() {
        return null;
    }

    /**
     * Tags assigned to the mission profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMissionProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMissionProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMissionProfileProps> {
        java.lang.Object dataflowEdges;
        java.lang.Number minimumViableContactDurationSeconds;
        java.lang.String name;
        java.lang.Object trackingConfigArn;
        java.lang.Number contactPostPassDurationSeconds;
        java.lang.Number contactPrePassDurationSeconds;
        java.lang.Object streamsKmsKey;
        java.lang.String streamsKmsRole;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMissionProfileProps#getDataflowEdges}
         * @param dataflowEdges A list containing lists of config ARNs. This parameter is required.
         *                      Each list of config ARNs is an edge, with a "from" config and a "to" config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataflowEdges(software.amazon.awscdk.IResolvable dataflowEdges) {
            this.dataflowEdges = dataflowEdges;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getDataflowEdges}
         * @param dataflowEdges A list containing lists of config ARNs. This parameter is required.
         *                      Each list of config ARNs is an edge, with a "from" config and a "to" config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataflowEdges(java.util.List<? extends java.lang.Object> dataflowEdges) {
            this.dataflowEdges = dataflowEdges;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getMinimumViableContactDurationSeconds}
         * @param minimumViableContactDurationSeconds Minimum length of a contact in seconds that Ground Station will return when listing contacts. This parameter is required.
         *                                            Ground Station will not return contacts shorter than this duration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumViableContactDurationSeconds(java.lang.Number minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getName}
         * @param name The name of the mission profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getTrackingConfigArn}
         * @param trackingConfigArn The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingConfigArn(java.lang.String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getTrackingConfigArn}
         * @param trackingConfigArn The ARN of a tracking config objects that defines how to track the satellite through the sky during a contact. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingConfigArn(software.amazon.awscdk.interfaces.groundstation.IConfigRef trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getContactPostPassDurationSeconds}
         * @param contactPostPassDurationSeconds Amount of time in seconds after a contact ends that you’d like to receive a Ground Station Contact State Change indicating the pass has finished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactPostPassDurationSeconds(java.lang.Number contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getContactPrePassDurationSeconds}
         * @param contactPrePassDurationSeconds Amount of time in seconds prior to contact start that you'd like to receive a Ground Station Contact State Change Event indicating an upcoming pass.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactPrePassDurationSeconds(java.lang.Number contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getStreamsKmsKey}
         * @param streamsKmsKey KMS key to use for encrypting streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamsKmsKey(software.amazon.awscdk.IResolvable streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getStreamsKmsKey}
         * @param streamsKmsKey KMS key to use for encrypting streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamsKmsKey(software.amazon.awscdk.services.groundstation.CfnMissionProfile.StreamsKmsKeyProperty streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getStreamsKmsRole}
         * @param streamsKmsRole Role to use for encrypting streams with KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamsKmsRole(java.lang.String streamsKmsRole) {
            this.streamsKmsRole = streamsKmsRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnMissionProfileProps#getTags}
         * @param tags Tags assigned to the mission profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMissionProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMissionProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMissionProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMissionProfileProps {
        private final java.lang.Object dataflowEdges;
        private final java.lang.Number minimumViableContactDurationSeconds;
        private final java.lang.String name;
        private final java.lang.Object trackingConfigArn;
        private final java.lang.Number contactPostPassDurationSeconds;
        private final java.lang.Number contactPrePassDurationSeconds;
        private final java.lang.Object streamsKmsKey;
        private final java.lang.String streamsKmsRole;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataflowEdges = software.amazon.jsii.Kernel.get(this, "dataflowEdges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.minimumViableContactDurationSeconds = software.amazon.jsii.Kernel.get(this, "minimumViableContactDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trackingConfigArn = software.amazon.jsii.Kernel.get(this, "trackingConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.contactPostPassDurationSeconds = software.amazon.jsii.Kernel.get(this, "contactPostPassDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.contactPrePassDurationSeconds = software.amazon.jsii.Kernel.get(this, "contactPrePassDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.streamsKmsKey = software.amazon.jsii.Kernel.get(this, "streamsKmsKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.streamsKmsRole = software.amazon.jsii.Kernel.get(this, "streamsKmsRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataflowEdges = java.util.Objects.requireNonNull(builder.dataflowEdges, "dataflowEdges is required");
            this.minimumViableContactDurationSeconds = java.util.Objects.requireNonNull(builder.minimumViableContactDurationSeconds, "minimumViableContactDurationSeconds is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.trackingConfigArn = java.util.Objects.requireNonNull(builder.trackingConfigArn, "trackingConfigArn is required");
            this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
            this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
            this.streamsKmsKey = builder.streamsKmsKey;
            this.streamsKmsRole = builder.streamsKmsRole;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDataflowEdges() {
            return this.dataflowEdges;
        }

        @Override
        public final java.lang.Number getMinimumViableContactDurationSeconds() {
            return this.minimumViableContactDurationSeconds;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getTrackingConfigArn() {
            return this.trackingConfigArn;
        }

        @Override
        public final java.lang.Number getContactPostPassDurationSeconds() {
            return this.contactPostPassDurationSeconds;
        }

        @Override
        public final java.lang.Number getContactPrePassDurationSeconds() {
            return this.contactPrePassDurationSeconds;
        }

        @Override
        public final java.lang.Object getStreamsKmsKey() {
            return this.streamsKmsKey;
        }

        @Override
        public final java.lang.String getStreamsKmsRole() {
            return this.streamsKmsRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataflowEdges", om.valueToTree(this.getDataflowEdges()));
            data.set("minimumViableContactDurationSeconds", om.valueToTree(this.getMinimumViableContactDurationSeconds()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("trackingConfigArn", om.valueToTree(this.getTrackingConfigArn()));
            if (this.getContactPostPassDurationSeconds() != null) {
                data.set("contactPostPassDurationSeconds", om.valueToTree(this.getContactPostPassDurationSeconds()));
            }
            if (this.getContactPrePassDurationSeconds() != null) {
                data.set("contactPrePassDurationSeconds", om.valueToTree(this.getContactPrePassDurationSeconds()));
            }
            if (this.getStreamsKmsKey() != null) {
                data.set("streamsKmsKey", om.valueToTree(this.getStreamsKmsKey()));
            }
            if (this.getStreamsKmsRole() != null) {
                data.set("streamsKmsRole", om.valueToTree(this.getStreamsKmsRole()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_groundstation.CfnMissionProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMissionProfileProps.Jsii$Proxy that = (CfnMissionProfileProps.Jsii$Proxy) o;

            if (!dataflowEdges.equals(that.dataflowEdges)) return false;
            if (!minimumViableContactDurationSeconds.equals(that.minimumViableContactDurationSeconds)) return false;
            if (!name.equals(that.name)) return false;
            if (!trackingConfigArn.equals(that.trackingConfigArn)) return false;
            if (this.contactPostPassDurationSeconds != null ? !this.contactPostPassDurationSeconds.equals(that.contactPostPassDurationSeconds) : that.contactPostPassDurationSeconds != null) return false;
            if (this.contactPrePassDurationSeconds != null ? !this.contactPrePassDurationSeconds.equals(that.contactPrePassDurationSeconds) : that.contactPrePassDurationSeconds != null) return false;
            if (this.streamsKmsKey != null ? !this.streamsKmsKey.equals(that.streamsKmsKey) : that.streamsKmsKey != null) return false;
            if (this.streamsKmsRole != null ? !this.streamsKmsRole.equals(that.streamsKmsRole) : that.streamsKmsRole != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataflowEdges.hashCode();
            result = 31 * result + (this.minimumViableContactDurationSeconds.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.trackingConfigArn.hashCode());
            result = 31 * result + (this.contactPostPassDurationSeconds != null ? this.contactPostPassDurationSeconds.hashCode() : 0);
            result = 31 * result + (this.contactPrePassDurationSeconds != null ? this.contactPrePassDurationSeconds.hashCode() : 0);
            result = 31 * result + (this.streamsKmsKey != null ? this.streamsKmsKey.hashCode() : 0);
            result = 31 * result + (this.streamsKmsRole != null ? this.streamsKmsRole.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
