package software.amazon.awscdk.services.iam;

/**
 * Result of a call to grantOnKey().
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * Grant grant;
 * GrantOnKeyResult grantOnKeyResult = GrantOnKeyResult.builder()
 *         .grant(grant)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.180Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.GrantOnKeyResult")
@software.amazon.jsii.Jsii.Proxy(GrantOnKeyResult.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrantOnKeyResult extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Grant object, if a grant was created.
     * <p>
     * Default: No grant
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.Grant getGrant() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrantOnKeyResult}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrantOnKeyResult}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrantOnKeyResult> {
        software.amazon.awscdk.services.iam.Grant grant;

        /**
         * Sets the value of {@link GrantOnKeyResult#getGrant}
         * @param grant The Grant object, if a grant was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grant(software.amazon.awscdk.services.iam.Grant grant) {
            this.grant = grant;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantOnKeyResult}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrantOnKeyResult build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrantOnKeyResult}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantOnKeyResult {
        private final software.amazon.awscdk.services.iam.Grant grant;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.grant = software.amazon.jsii.Kernel.get(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.grant = builder.grant;
        }

        @Override
        public final software.amazon.awscdk.services.iam.Grant getGrant() {
            return this.grant;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGrant() != null) {
                data.set("grant", om.valueToTree(this.getGrant()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.GrantOnKeyResult"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantOnKeyResult.Jsii$Proxy that = (GrantOnKeyResult.Jsii$Proxy) o;

            return this.grant != null ? this.grant.equals(that.grant) : that.grant == null;
        }

        @Override
        public final int hashCode() {
            int result = this.grant != null ? this.grant.hashCode() : 0;
            return result;
        }
    }
}
