package software.amazon.awscdk.services.iam;

/**
 * Collection of grant methods for a IRoleRef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.interfaces.iam.*;
 * IRoleRef roleRef;
 * RoleGrants roleGrants = RoleGrants.fromRole(roleRef);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.RoleGrants")
public class RoleGrants extends software.amazon.jsii.JsiiObject {

    protected RoleGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RoleGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates grants for IRoleRef.
     * <p>
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.RoleGrants fromRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iam.IRoleRef role) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.RoleGrants.class, "fromRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.RoleGrants.class), new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Grant permissions to the given principal to assume this role.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant assumeRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity) {
        return software.amazon.jsii.Kernel.call(this, "assumeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant permissions to the given principal to pass this role.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant passRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity) {
        return software.amazon.jsii.Kernel.call(this, "passRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }
}
