package software.amazon.awscdk.services.inspectorv2;

/**
 * Creates a code security integration with a source code repository provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspectorv2.*;
 * CfnCodeSecurityIntegration cfnCodeSecurityIntegration = CfnCodeSecurityIntegration.Builder.create(this, "MyCfnCodeSecurityIntegration")
 *         .createIntegrationDetails(CreateDetailsProperty.builder()
 *                 .gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetailProperty.builder()
 *                         .accessToken("accessToken")
 *                         .instanceUrl("instanceUrl")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .type("type")
 *         .updateIntegrationDetails(UpdateDetailsProperty.builder()
 *                 .github(UpdateGitHubIntegrationDetailProperty.builder()
 *                         .code("code")
 *                         .installationId("installationId")
 *                         .build())
 *                 .gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetailProperty.builder()
 *                         .authCode("authCode")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.371Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration")
public class CfnCodeSecurityIntegration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.inspectorv2.ICodeSecurityIntegrationRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnCodeSecurityIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCodeSecurityIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::InspectorV2::CodeSecurityIntegration</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCodeSecurityIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::InspectorV2::CodeSecurityIntegration</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCodeSecurityIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForCodeSecurityIntegration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.inspectorv2.ICodeSecurityIntegrationRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.class, "arnForCodeSecurityIntegration", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnCodeSecurityIntegration.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnCodeSecurityIntegration(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.class, "isCfnCodeSecurityIntegration", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the code security integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL used to authorize the integration with the repository provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAuthorizationUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrAuthorizationUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the code security integration was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the code security integration was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The reason for the current status of the code security integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusReason() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a CodeSecurityIntegration resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.inspectorv2.CodeSecurityIntegrationReference getCodeSecurityIntegrationRef() {
        return software.amazon.jsii.Kernel.get(this, "codeSecurityIntegrationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.inspectorv2.CodeSecurityIntegrationReference.class));
    }

    /**
     * Contains details required to create a code security integration with a specific repository provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.CreateDetailsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCreateIntegrationDetails() {
        return software.amazon.jsii.Kernel.get(this, "createIntegrationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details required to create a code security integration with a specific repository provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreateIntegrationDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "createIntegrationDetails", value);
    }

    /**
     * Contains details required to create a code security integration with a specific repository provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreateIntegrationDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.CreateDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "createIntegrationDetails", value);
    }

    /**
     * The name of the code security integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the code security integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The tags to apply to the code security integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags to apply to the code security integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The type of repository provider for the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of repository provider for the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }

    /**
     * The updated integration details specific to the repository provider type.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateDetailsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUpdateIntegrationDetails() {
        return software.amazon.jsii.Kernel.get(this, "updateIntegrationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The updated integration details specific to the repository provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUpdateIntegrationDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "updateIntegrationDetails", value);
    }

    /**
     * The updated integration details specific to the repository provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUpdateIntegrationDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "updateIntegrationDetails", value);
    }
    /**
     * Contains details required to create a code security integration with a specific repository provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * CreateDetailsProperty createDetailsProperty = CreateDetailsProperty.builder()
     *         .gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetailProperty.builder()
     *                 .accessToken("accessToken")
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-createdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-createdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.CreateDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details specific to creating an integration with a self-managed GitLab instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.CreateGitLabSelfManagedIntegrationDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-createdetails.html#cfn-inspectorv2-codesecurityintegration-createdetails-gitlabselfmanaged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-createdetails.html#cfn-inspectorv2-codesecurityintegration-createdetails-gitlabselfmanaged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGitlabSelfManaged();

        /**
         * @return a {@link Builder} of {@link CreateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateDetailsProperty> {
            java.lang.Object gitlabSelfManaged;

            /**
             * Sets the value of {@link CreateDetailsProperty#getGitlabSelfManaged}
             * @param gitlabSelfManaged Details specific to creating an integration with a self-managed GitLab instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitlabSelfManaged(software.amazon.awscdk.IResolvable gitlabSelfManaged) {
                this.gitlabSelfManaged = gitlabSelfManaged;
                return this;
            }

            /**
             * Sets the value of {@link CreateDetailsProperty#getGitlabSelfManaged}
             * @param gitlabSelfManaged Details specific to creating an integration with a self-managed GitLab instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitlabSelfManaged(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.CreateGitLabSelfManagedIntegrationDetailProperty gitlabSelfManaged) {
                this.gitlabSelfManaged = gitlabSelfManaged;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateDetailsProperty {
            private final java.lang.Object gitlabSelfManaged;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gitlabSelfManaged = software.amazon.jsii.Kernel.get(this, "gitlabSelfManaged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gitlabSelfManaged = java.util.Objects.requireNonNull(builder.gitlabSelfManaged, "gitlabSelfManaged is required");
            }

            @Override
            public final java.lang.Object getGitlabSelfManaged() {
                return this.gitlabSelfManaged;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("gitlabSelfManaged", om.valueToTree(this.getGitlabSelfManaged()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.CreateDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateDetailsProperty.Jsii$Proxy that = (CreateDetailsProperty.Jsii$Proxy) o;

                return this.gitlabSelfManaged.equals(that.gitlabSelfManaged);
            }

            @Override
            public final int hashCode() {
                int result = this.gitlabSelfManaged.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains details required to create an integration with a self-managed GitLab instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * CreateGitLabSelfManagedIntegrationDetailProperty createGitLabSelfManagedIntegrationDetailProperty = CreateGitLabSelfManagedIntegrationDetailProperty.builder()
     *         .accessToken("accessToken")
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.CreateGitLabSelfManagedIntegrationDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateGitLabSelfManagedIntegrationDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateGitLabSelfManagedIntegrationDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The personal access token used to authenticate with the self-managed GitLab instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccessToken();

        /**
         * The URL of the self-managed GitLab instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-creategitlabselfmanagedintegrationdetail-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link CreateGitLabSelfManagedIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateGitLabSelfManagedIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateGitLabSelfManagedIntegrationDetailProperty> {
            java.lang.String accessToken;
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link CreateGitLabSelfManagedIntegrationDetailProperty#getAccessToken}
             * @param accessToken The personal access token used to authenticate with the self-managed GitLab instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link CreateGitLabSelfManagedIntegrationDetailProperty#getInstanceUrl}
             * @param instanceUrl The URL of the self-managed GitLab instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateGitLabSelfManagedIntegrationDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateGitLabSelfManagedIntegrationDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateGitLabSelfManagedIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateGitLabSelfManagedIntegrationDetailProperty {
            private final java.lang.String accessToken;
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = java.util.Objects.requireNonNull(builder.accessToken, "accessToken is required");
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessToken", om.valueToTree(this.getAccessToken()));
                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.CreateGitLabSelfManagedIntegrationDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateGitLabSelfManagedIntegrationDetailProperty.Jsii$Proxy that = (CreateGitLabSelfManagedIntegrationDetailProperty.Jsii$Proxy) o;

                if (!accessToken.equals(that.accessToken)) return false;
                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken.hashCode();
                result = 31 * result + (this.instanceUrl.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details required to update a code security integration with a specific repository provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * UpdateDetailsProperty updateDetailsProperty = UpdateDetailsProperty.builder()
     *         .github(UpdateGitHubIntegrationDetailProperty.builder()
     *                 .code("code")
     *                 .installationId("installationId")
     *                 .build())
     *         .gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetailProperty.builder()
     *                 .authCode("authCode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updatedetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updatedetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.UpdateDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(UpdateDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpdateDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details specific to updating an integration with GitHub.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateGitHubIntegrationDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updatedetails.html#cfn-inspectorv2-codesecurityintegration-updatedetails-github">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updatedetails.html#cfn-inspectorv2-codesecurityintegration-updatedetails-github</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGithub() {
            return null;
        }

        /**
         * Details specific to updating an integration with a self-managed GitLab instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateGitLabSelfManagedIntegrationDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updatedetails.html#cfn-inspectorv2-codesecurityintegration-updatedetails-gitlabselfmanaged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updatedetails.html#cfn-inspectorv2-codesecurityintegration-updatedetails-gitlabselfmanaged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGitlabSelfManaged() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UpdateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpdateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpdateDetailsProperty> {
            java.lang.Object github;
            java.lang.Object gitlabSelfManaged;

            /**
             * Sets the value of {@link UpdateDetailsProperty#getGithub}
             * @param github Details specific to updating an integration with GitHub.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder github(software.amazon.awscdk.IResolvable github) {
                this.github = github;
                return this;
            }

            /**
             * Sets the value of {@link UpdateDetailsProperty#getGithub}
             * @param github Details specific to updating an integration with GitHub.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder github(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateGitHubIntegrationDetailProperty github) {
                this.github = github;
                return this;
            }

            /**
             * Sets the value of {@link UpdateDetailsProperty#getGitlabSelfManaged}
             * @param gitlabSelfManaged Details specific to updating an integration with a self-managed GitLab instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitlabSelfManaged(software.amazon.awscdk.IResolvable gitlabSelfManaged) {
                this.gitlabSelfManaged = gitlabSelfManaged;
                return this;
            }

            /**
             * Sets the value of {@link UpdateDetailsProperty#getGitlabSelfManaged}
             * @param gitlabSelfManaged Details specific to updating an integration with a self-managed GitLab instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitlabSelfManaged(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateGitLabSelfManagedIntegrationDetailProperty gitlabSelfManaged) {
                this.gitlabSelfManaged = gitlabSelfManaged;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpdateDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpdateDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpdateDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpdateDetailsProperty {
            private final java.lang.Object github;
            private final java.lang.Object gitlabSelfManaged;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.github = software.amazon.jsii.Kernel.get(this, "github", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.gitlabSelfManaged = software.amazon.jsii.Kernel.get(this, "gitlabSelfManaged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.github = builder.github;
                this.gitlabSelfManaged = builder.gitlabSelfManaged;
            }

            @Override
            public final java.lang.Object getGithub() {
                return this.github;
            }

            @Override
            public final java.lang.Object getGitlabSelfManaged() {
                return this.gitlabSelfManaged;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGithub() != null) {
                    data.set("github", om.valueToTree(this.getGithub()));
                }
                if (this.getGitlabSelfManaged() != null) {
                    data.set("gitlabSelfManaged", om.valueToTree(this.getGitlabSelfManaged()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.UpdateDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpdateDetailsProperty.Jsii$Proxy that = (UpdateDetailsProperty.Jsii$Proxy) o;

                if (this.github != null ? !this.github.equals(that.github) : that.github != null) return false;
                return this.gitlabSelfManaged != null ? this.gitlabSelfManaged.equals(that.gitlabSelfManaged) : that.gitlabSelfManaged == null;
            }

            @Override
            public final int hashCode() {
                int result = this.github != null ? this.github.hashCode() : 0;
                result = 31 * result + (this.gitlabSelfManaged != null ? this.gitlabSelfManaged.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details required to update an integration with GitHub.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * UpdateGitHubIntegrationDetailProperty updateGitHubIntegrationDetailProperty = UpdateGitHubIntegrationDetailProperty.builder()
     *         .code("code")
     *         .installationId("installationId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategithubintegrationdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategithubintegrationdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.UpdateGitHubIntegrationDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(UpdateGitHubIntegrationDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpdateGitHubIntegrationDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization code received from GitHub to update the integration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategithubintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-updategithubintegrationdetail-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategithubintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-updategithubintegrationdetail-code</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCode();

        /**
         * The installation ID of the GitHub App associated with the integration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategithubintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-updategithubintegrationdetail-installationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategithubintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-updategithubintegrationdetail-installationid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstallationId();

        /**
         * @return a {@link Builder} of {@link UpdateGitHubIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpdateGitHubIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpdateGitHubIntegrationDetailProperty> {
            java.lang.String code;
            java.lang.String installationId;

            /**
             * Sets the value of {@link UpdateGitHubIntegrationDetailProperty#getCode}
             * @param code The authorization code received from GitHub to update the integration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder code(java.lang.String code) {
                this.code = code;
                return this;
            }

            /**
             * Sets the value of {@link UpdateGitHubIntegrationDetailProperty#getInstallationId}
             * @param installationId The installation ID of the GitHub App associated with the integration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder installationId(java.lang.String installationId) {
                this.installationId = installationId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpdateGitHubIntegrationDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpdateGitHubIntegrationDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpdateGitHubIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpdateGitHubIntegrationDetailProperty {
            private final java.lang.String code;
            private final java.lang.String installationId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.installationId = software.amazon.jsii.Kernel.get(this, "installationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.code = java.util.Objects.requireNonNull(builder.code, "code is required");
                this.installationId = java.util.Objects.requireNonNull(builder.installationId, "installationId is required");
            }

            @Override
            public final java.lang.String getCode() {
                return this.code;
            }

            @Override
            public final java.lang.String getInstallationId() {
                return this.installationId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("code", om.valueToTree(this.getCode()));
                data.set("installationId", om.valueToTree(this.getInstallationId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.UpdateGitHubIntegrationDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpdateGitHubIntegrationDetailProperty.Jsii$Proxy that = (UpdateGitHubIntegrationDetailProperty.Jsii$Proxy) o;

                if (!code.equals(that.code)) return false;
                return this.installationId.equals(that.installationId);
            }

            @Override
            public final int hashCode() {
                int result = this.code.hashCode();
                result = 31 * result + (this.installationId.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details required to update an integration with a self-managed GitLab instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * UpdateGitLabSelfManagedIntegrationDetailProperty updateGitLabSelfManagedIntegrationDetailProperty = UpdateGitLabSelfManagedIntegrationDetailProperty.builder()
     *         .authCode("authCode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategitlabselfmanagedintegrationdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategitlabselfmanagedintegrationdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.UpdateGitLabSelfManagedIntegrationDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(UpdateGitLabSelfManagedIntegrationDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpdateGitLabSelfManagedIntegrationDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization code received from the self-managed GitLab instance to update the integration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategitlabselfmanagedintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-updategitlabselfmanagedintegrationdetail-authcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityintegration-updategitlabselfmanagedintegrationdetail.html#cfn-inspectorv2-codesecurityintegration-updategitlabselfmanagedintegrationdetail-authcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthCode();

        /**
         * @return a {@link Builder} of {@link UpdateGitLabSelfManagedIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpdateGitLabSelfManagedIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpdateGitLabSelfManagedIntegrationDetailProperty> {
            java.lang.String authCode;

            /**
             * Sets the value of {@link UpdateGitLabSelfManagedIntegrationDetailProperty#getAuthCode}
             * @param authCode The authorization code received from the self-managed GitLab instance to update the integration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authCode(java.lang.String authCode) {
                this.authCode = authCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpdateGitLabSelfManagedIntegrationDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpdateGitLabSelfManagedIntegrationDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpdateGitLabSelfManagedIntegrationDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpdateGitLabSelfManagedIntegrationDetailProperty {
            private final java.lang.String authCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authCode = software.amazon.jsii.Kernel.get(this, "authCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authCode = java.util.Objects.requireNonNull(builder.authCode, "authCode is required");
            }

            @Override
            public final java.lang.String getAuthCode() {
                return this.authCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authCode", om.valueToTree(this.getAuthCode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegration.UpdateGitLabSelfManagedIntegrationDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpdateGitLabSelfManagedIntegrationDetailProperty.Jsii$Proxy that = (UpdateGitLabSelfManagedIntegrationDetailProperty.Jsii$Proxy) o;

                return this.authCode.equals(that.authCode);
            }

            @Override
            public final int hashCode() {
                int result = this.authCode.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Contains details required to create a code security integration with a specific repository provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-createintegrationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-createintegrationdetails</a>
         * @param createIntegrationDetails Contains details required to create a code security integration with a specific repository provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createIntegrationDetails(final software.amazon.awscdk.IResolvable createIntegrationDetails) {
            this.props().createIntegrationDetails(createIntegrationDetails);
            return this;
        }
        /**
         * Contains details required to create a code security integration with a specific repository provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-createintegrationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-createintegrationdetails</a>
         * @param createIntegrationDetails Contains details required to create a code security integration with a specific repository provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createIntegrationDetails(final software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.CreateDetailsProperty createIntegrationDetails) {
            this.props().createIntegrationDetails(createIntegrationDetails);
            return this;
        }

        /**
         * The name of the code security integration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-name</a>
         * @param name The name of the code security integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The tags to apply to the code security integration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-tags</a>
         * @param tags The tags to apply to the code security integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The type of repository provider for the integration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-type</a>
         * @param type The type of repository provider for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * The updated integration details specific to the repository provider type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-updateintegrationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-updateintegrationdetails</a>
         * @param updateIntegrationDetails The updated integration details specific to the repository provider type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateIntegrationDetails(final software.amazon.awscdk.IResolvable updateIntegrationDetails) {
            this.props().updateIntegrationDetails(updateIntegrationDetails);
            return this;
        }
        /**
         * The updated integration details specific to the repository provider type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-updateintegrationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-updateintegrationdetails</a>
         * @param updateIntegrationDetails The updated integration details specific to the repository provider type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateIntegrationDetails(final software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateDetailsProperty updateIntegrationDetails) {
            this.props().updateIntegrationDetails(updateIntegrationDetails);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration build() {
            return new software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}
