package software.amazon.awscdk.services.inspectorv2;

/**
 * Properties for defining a <code>CfnCodeSecurityIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspectorv2.*;
 * CfnCodeSecurityIntegrationProps cfnCodeSecurityIntegrationProps = CfnCodeSecurityIntegrationProps.builder()
 *         .createIntegrationDetails(CreateDetailsProperty.builder()
 *                 .gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetailProperty.builder()
 *                         .accessToken("accessToken")
 *                         .instanceUrl("instanceUrl")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .type("type")
 *         .updateIntegrationDetails(UpdateDetailsProperty.builder()
 *                 .github(UpdateGitHubIntegrationDetailProperty.builder()
 *                         .code("code")
 *                         .installationId("installationId")
 *                         .build())
 *                 .gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetailProperty.builder()
 *                         .authCode("authCode")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.374Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnCodeSecurityIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeSecurityIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains details required to create a code security integration with a specific repository provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.CreateDetailsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-createintegrationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-createintegrationdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreateIntegrationDetails() {
        return null;
    }

    /**
     * The name of the code security integration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags to apply to the code security integration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The type of repository provider for the integration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * The updated integration details specific to the repository provider type.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateDetailsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-updateintegrationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityintegration.html#cfn-inspectorv2-codesecurityintegration-updateintegrationdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateIntegrationDetails() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCodeSecurityIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeSecurityIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCodeSecurityIntegrationProps> {
        java.lang.Object createIntegrationDetails;
        java.lang.String name;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.String type;
        java.lang.Object updateIntegrationDetails;

        /**
         * Sets the value of {@link CfnCodeSecurityIntegrationProps#getCreateIntegrationDetails}
         * @param createIntegrationDetails Contains details required to create a code security integration with a specific repository provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createIntegrationDetails(software.amazon.awscdk.IResolvable createIntegrationDetails) {
            this.createIntegrationDetails = createIntegrationDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSecurityIntegrationProps#getCreateIntegrationDetails}
         * @param createIntegrationDetails Contains details required to create a code security integration with a specific repository provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createIntegrationDetails(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.CreateDetailsProperty createIntegrationDetails) {
            this.createIntegrationDetails = createIntegrationDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSecurityIntegrationProps#getName}
         * @param name The name of the code security integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSecurityIntegrationProps#getTags}
         * @param tags The tags to apply to the code security integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSecurityIntegrationProps#getType}
         * @param type The type of repository provider for the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSecurityIntegrationProps#getUpdateIntegrationDetails}
         * @param updateIntegrationDetails The updated integration details specific to the repository provider type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateIntegrationDetails(software.amazon.awscdk.IResolvable updateIntegrationDetails) {
            this.updateIntegrationDetails = updateIntegrationDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSecurityIntegrationProps#getUpdateIntegrationDetails}
         * @param updateIntegrationDetails The updated integration details specific to the repository provider type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateIntegrationDetails(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityIntegration.UpdateDetailsProperty updateIntegrationDetails) {
            this.updateIntegrationDetails = updateIntegrationDetails;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeSecurityIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCodeSecurityIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCodeSecurityIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeSecurityIntegrationProps {
        private final java.lang.Object createIntegrationDetails;
        private final java.lang.String name;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String type;
        private final java.lang.Object updateIntegrationDetails;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.createIntegrationDetails = software.amazon.jsii.Kernel.get(this, "createIntegrationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.updateIntegrationDetails = software.amazon.jsii.Kernel.get(this, "updateIntegrationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.createIntegrationDetails = builder.createIntegrationDetails;
            this.name = builder.name;
            this.tags = builder.tags;
            this.type = builder.type;
            this.updateIntegrationDetails = builder.updateIntegrationDetails;
        }

        @Override
        public final java.lang.Object getCreateIntegrationDetails() {
            return this.createIntegrationDetails;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getUpdateIntegrationDetails() {
            return this.updateIntegrationDetails;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCreateIntegrationDetails() != null) {
                data.set("createIntegrationDetails", om.valueToTree(this.getCreateIntegrationDetails()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getUpdateIntegrationDetails() != null) {
                data.set("updateIntegrationDetails", om.valueToTree(this.getUpdateIntegrationDetails()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeSecurityIntegrationProps.Jsii$Proxy that = (CfnCodeSecurityIntegrationProps.Jsii$Proxy) o;

            if (this.createIntegrationDetails != null ? !this.createIntegrationDetails.equals(that.createIntegrationDetails) : that.createIntegrationDetails != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.updateIntegrationDetails != null ? this.updateIntegrationDetails.equals(that.updateIntegrationDetails) : that.updateIntegrationDetails == null;
        }

        @Override
        public final int hashCode() {
            int result = this.createIntegrationDetails != null ? this.createIntegrationDetails.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.updateIntegrationDetails != null ? this.updateIntegrationDetails.hashCode() : 0);
            return result;
        }
    }
}
