package software.amazon.awscdk.services.inspectorv2;

/**
 * Creates a scan configuration for code security scanning.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspectorv2.*;
 * CfnCodeSecurityScanConfiguration cfnCodeSecurityScanConfiguration = CfnCodeSecurityScanConfiguration.Builder.create(this, "MyCfnCodeSecurityScanConfiguration")
 *         .configuration(CodeSecurityScanConfigurationProperty.builder()
 *                 .ruleSetCategories(List.of("ruleSetCategories"))
 *                 // the properties below are optional
 *                 .continuousIntegrationScanConfiguration(ContinuousIntegrationScanConfigurationProperty.builder()
 *                         .supportedEvents(List.of("supportedEvents"))
 *                         .build())
 *                 .periodicScanConfiguration(PeriodicScanConfigurationProperty.builder()
 *                         .frequency("frequency")
 *                         .frequencyExpression("frequencyExpression")
 *                         .build())
 *                 .build())
 *         .level("level")
 *         .name("name")
 *         .scopeSettings(ScopeSettingsProperty.builder()
 *                 .projectSelectionScope("projectSelectionScope")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.375Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration")
public class CfnCodeSecurityScanConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.inspectorv2.ICodeSecurityScanConfigurationRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnCodeSecurityScanConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCodeSecurityScanConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::InspectorV2::CodeSecurityScanConfiguration</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCodeSecurityScanConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::InspectorV2::CodeSecurityScanConfiguration</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCodeSecurityScanConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForCodeSecurityScanConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.inspectorv2.ICodeSecurityScanConfigurationRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.class, "arnForCodeSecurityScanConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnCodeSecurityScanConfiguration.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnCodeSecurityScanConfiguration(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.class, "isCfnCodeSecurityScanConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a CodeSecurityScanConfiguration resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.inspectorv2.CodeSecurityScanConfigurationReference getCodeSecurityScanConfigurationRef() {
        return software.amazon.jsii.Kernel.get(this, "codeSecurityScanConfigurationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.inspectorv2.CodeSecurityScanConfigurationReference.class));
    }

    /**
     * The configuration settings for the code security scan.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.CodeSecurityScanConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration settings for the code security scan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The configuration settings for the code security scan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.CodeSecurityScanConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The security level for the scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLevel() {
        return software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The security level for the scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLevel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "level", value);
    }

    /**
     * The name of the scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The scope settings that define which repositories will be scanned.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.ScopeSettingsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScopeSettings() {
        return software.amazon.jsii.Kernel.get(this, "scopeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scope settings that define which repositories will be scanned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScopeSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scopeSettings", value);
    }

    /**
     * The scope settings that define which repositories will be scanned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScopeSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.ScopeSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "scopeSettings", value);
    }

    /**
     * The tags to apply to the scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags to apply to the scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains the configuration settings for code security scans.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * CodeSecurityScanConfigurationProperty codeSecurityScanConfigurationProperty = CodeSecurityScanConfigurationProperty.builder()
     *         .ruleSetCategories(List.of("ruleSetCategories"))
     *         // the properties below are optional
     *         .continuousIntegrationScanConfiguration(ContinuousIntegrationScanConfigurationProperty.builder()
     *                 .supportedEvents(List.of("supportedEvents"))
     *                 .build())
     *         .periodicScanConfiguration(PeriodicScanConfigurationProperty.builder()
     *                 .frequency("frequency")
     *                 .frequencyExpression("frequencyExpression")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.CodeSecurityScanConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeSecurityScanConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeSecurityScanConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The categories of security rules to be applied during the scan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration-rulesetcategories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration-rulesetcategories</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRuleSetCategories();

        /**
         * Configuration settings for continuous integration scans that run automatically when code changes are made.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.ContinuousIntegrationScanConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration-continuousintegrationscanconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration-continuousintegrationscanconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContinuousIntegrationScanConfiguration() {
            return null;
        }

        /**
         * Configuration settings for periodic scans that run on a scheduled basis.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.PeriodicScanConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration-periodicscanconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-codesecurityscanconfiguration-periodicscanconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPeriodicScanConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeSecurityScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeSecurityScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeSecurityScanConfigurationProperty> {
            java.util.List<java.lang.String> ruleSetCategories;
            java.lang.Object continuousIntegrationScanConfiguration;
            java.lang.Object periodicScanConfiguration;

            /**
             * Sets the value of {@link CodeSecurityScanConfigurationProperty#getRuleSetCategories}
             * @param ruleSetCategories The categories of security rules to be applied during the scan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleSetCategories(java.util.List<java.lang.String> ruleSetCategories) {
                this.ruleSetCategories = ruleSetCategories;
                return this;
            }

            /**
             * Sets the value of {@link CodeSecurityScanConfigurationProperty#getContinuousIntegrationScanConfiguration}
             * @param continuousIntegrationScanConfiguration Configuration settings for continuous integration scans that run automatically when code changes are made.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continuousIntegrationScanConfiguration(software.amazon.awscdk.IResolvable continuousIntegrationScanConfiguration) {
                this.continuousIntegrationScanConfiguration = continuousIntegrationScanConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CodeSecurityScanConfigurationProperty#getContinuousIntegrationScanConfiguration}
             * @param continuousIntegrationScanConfiguration Configuration settings for continuous integration scans that run automatically when code changes are made.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continuousIntegrationScanConfiguration(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.ContinuousIntegrationScanConfigurationProperty continuousIntegrationScanConfiguration) {
                this.continuousIntegrationScanConfiguration = continuousIntegrationScanConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CodeSecurityScanConfigurationProperty#getPeriodicScanConfiguration}
             * @param periodicScanConfiguration Configuration settings for periodic scans that run on a scheduled basis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodicScanConfiguration(software.amazon.awscdk.IResolvable periodicScanConfiguration) {
                this.periodicScanConfiguration = periodicScanConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CodeSecurityScanConfigurationProperty#getPeriodicScanConfiguration}
             * @param periodicScanConfiguration Configuration settings for periodic scans that run on a scheduled basis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodicScanConfiguration(software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.PeriodicScanConfigurationProperty periodicScanConfiguration) {
                this.periodicScanConfiguration = periodicScanConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeSecurityScanConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeSecurityScanConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeSecurityScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeSecurityScanConfigurationProperty {
            private final java.util.List<java.lang.String> ruleSetCategories;
            private final java.lang.Object continuousIntegrationScanConfiguration;
            private final java.lang.Object periodicScanConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleSetCategories = software.amazon.jsii.Kernel.get(this, "ruleSetCategories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.continuousIntegrationScanConfiguration = software.amazon.jsii.Kernel.get(this, "continuousIntegrationScanConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.periodicScanConfiguration = software.amazon.jsii.Kernel.get(this, "periodicScanConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleSetCategories = java.util.Objects.requireNonNull(builder.ruleSetCategories, "ruleSetCategories is required");
                this.continuousIntegrationScanConfiguration = builder.continuousIntegrationScanConfiguration;
                this.periodicScanConfiguration = builder.periodicScanConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getRuleSetCategories() {
                return this.ruleSetCategories;
            }

            @Override
            public final java.lang.Object getContinuousIntegrationScanConfiguration() {
                return this.continuousIntegrationScanConfiguration;
            }

            @Override
            public final java.lang.Object getPeriodicScanConfiguration() {
                return this.periodicScanConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleSetCategories", om.valueToTree(this.getRuleSetCategories()));
                if (this.getContinuousIntegrationScanConfiguration() != null) {
                    data.set("continuousIntegrationScanConfiguration", om.valueToTree(this.getContinuousIntegrationScanConfiguration()));
                }
                if (this.getPeriodicScanConfiguration() != null) {
                    data.set("periodicScanConfiguration", om.valueToTree(this.getPeriodicScanConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.CodeSecurityScanConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeSecurityScanConfigurationProperty.Jsii$Proxy that = (CodeSecurityScanConfigurationProperty.Jsii$Proxy) o;

                if (!ruleSetCategories.equals(that.ruleSetCategories)) return false;
                if (this.continuousIntegrationScanConfiguration != null ? !this.continuousIntegrationScanConfiguration.equals(that.continuousIntegrationScanConfiguration) : that.continuousIntegrationScanConfiguration != null) return false;
                return this.periodicScanConfiguration != null ? this.periodicScanConfiguration.equals(that.periodicScanConfiguration) : that.periodicScanConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ruleSetCategories.hashCode();
                result = 31 * result + (this.continuousIntegrationScanConfiguration != null ? this.continuousIntegrationScanConfiguration.hashCode() : 0);
                result = 31 * result + (this.periodicScanConfiguration != null ? this.periodicScanConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for continuous integration scans that run automatically when code changes are made.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * ContinuousIntegrationScanConfigurationProperty continuousIntegrationScanConfigurationProperty = ContinuousIntegrationScanConfigurationProperty.builder()
     *         .supportedEvents(List.of("supportedEvents"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-continuousintegrationscanconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-continuousintegrationscanconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.ContinuousIntegrationScanConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ContinuousIntegrationScanConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContinuousIntegrationScanConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The repository events that trigger continuous integration scans, such as pull requests or commits.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-continuousintegrationscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-continuousintegrationscanconfiguration-supportedevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-continuousintegrationscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-continuousintegrationscanconfiguration-supportedevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSupportedEvents();

        /**
         * @return a {@link Builder} of {@link ContinuousIntegrationScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContinuousIntegrationScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContinuousIntegrationScanConfigurationProperty> {
            java.util.List<java.lang.String> supportedEvents;

            /**
             * Sets the value of {@link ContinuousIntegrationScanConfigurationProperty#getSupportedEvents}
             * @param supportedEvents The repository events that trigger continuous integration scans, such as pull requests or commits. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportedEvents(java.util.List<java.lang.String> supportedEvents) {
                this.supportedEvents = supportedEvents;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContinuousIntegrationScanConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContinuousIntegrationScanConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContinuousIntegrationScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContinuousIntegrationScanConfigurationProperty {
            private final java.util.List<java.lang.String> supportedEvents;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.supportedEvents = software.amazon.jsii.Kernel.get(this, "supportedEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.supportedEvents = java.util.Objects.requireNonNull(builder.supportedEvents, "supportedEvents is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSupportedEvents() {
                return this.supportedEvents;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("supportedEvents", om.valueToTree(this.getSupportedEvents()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.ContinuousIntegrationScanConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContinuousIntegrationScanConfigurationProperty.Jsii$Proxy that = (ContinuousIntegrationScanConfigurationProperty.Jsii$Proxy) o;

                return this.supportedEvents.equals(that.supportedEvents);
            }

            @Override
            public final int hashCode() {
                int result = this.supportedEvents.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration settings for periodic scans that run on a scheduled basis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * PeriodicScanConfigurationProperty periodicScanConfigurationProperty = PeriodicScanConfigurationProperty.builder()
     *         .frequency("frequency")
     *         .frequencyExpression("frequencyExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.PeriodicScanConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PeriodicScanConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PeriodicScanConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency at which periodic scans are performed (such as weekly or monthly).
         * <p>
         * If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to run. If you provide the <code>frequencyExpression</code> , the schedule must match the specified <code>frequency</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration-frequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration-frequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFrequency() {
            return null;
        }

        /**
         * The schedule expression for periodic scans, in cron format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration-frequencyexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-periodicscanconfiguration-frequencyexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFrequencyExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PeriodicScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PeriodicScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PeriodicScanConfigurationProperty> {
            java.lang.String frequency;
            java.lang.String frequencyExpression;

            /**
             * Sets the value of {@link PeriodicScanConfigurationProperty#getFrequency}
             * @param frequency The frequency at which periodic scans are performed (such as weekly or monthly).
             *                  If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to run. If you provide the <code>frequencyExpression</code> , the schedule must match the specified <code>frequency</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequency(java.lang.String frequency) {
                this.frequency = frequency;
                return this;
            }

            /**
             * Sets the value of {@link PeriodicScanConfigurationProperty#getFrequencyExpression}
             * @param frequencyExpression The schedule expression for periodic scans, in cron format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequencyExpression(java.lang.String frequencyExpression) {
                this.frequencyExpression = frequencyExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PeriodicScanConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PeriodicScanConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PeriodicScanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PeriodicScanConfigurationProperty {
            private final java.lang.String frequency;
            private final java.lang.String frequencyExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.frequencyExpression = software.amazon.jsii.Kernel.get(this, "frequencyExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequency = builder.frequency;
                this.frequencyExpression = builder.frequencyExpression;
            }

            @Override
            public final java.lang.String getFrequency() {
                return this.frequency;
            }

            @Override
            public final java.lang.String getFrequencyExpression() {
                return this.frequencyExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFrequency() != null) {
                    data.set("frequency", om.valueToTree(this.getFrequency()));
                }
                if (this.getFrequencyExpression() != null) {
                    data.set("frequencyExpression", om.valueToTree(this.getFrequencyExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.PeriodicScanConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PeriodicScanConfigurationProperty.Jsii$Proxy that = (PeriodicScanConfigurationProperty.Jsii$Proxy) o;

                if (this.frequency != null ? !this.frequency.equals(that.frequency) : that.frequency != null) return false;
                return this.frequencyExpression != null ? this.frequencyExpression.equals(that.frequencyExpression) : that.frequencyExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.frequency != null ? this.frequency.hashCode() : 0;
                result = 31 * result + (this.frequencyExpression != null ? this.frequencyExpression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The scope settings that define which repositories will be scanned.
     * <p>
     * If the <code>ScopeSetting</code> parameter is <code>ALL</code> the scan configuration applies to all existing and future projects imported into Amazon Inspector .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * ScopeSettingsProperty scopeSettingsProperty = ScopeSettingsProperty.builder()
     *         .projectSelectionScope("projectSelectionScope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-scopesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-scopesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.ScopeSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ScopeSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScopeSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scope of projects to be selected for scanning within the integrated repositories.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-scopesettings.html#cfn-inspectorv2-codesecurityscanconfiguration-scopesettings-projectselectionscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-codesecurityscanconfiguration-scopesettings.html#cfn-inspectorv2-codesecurityscanconfiguration-scopesettings-projectselectionscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProjectSelectionScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScopeSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScopeSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScopeSettingsProperty> {
            java.lang.String projectSelectionScope;

            /**
             * Sets the value of {@link ScopeSettingsProperty#getProjectSelectionScope}
             * @param projectSelectionScope The scope of projects to be selected for scanning within the integrated repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectSelectionScope(java.lang.String projectSelectionScope) {
                this.projectSelectionScope = projectSelectionScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScopeSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScopeSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScopeSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScopeSettingsProperty {
            private final java.lang.String projectSelectionScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.projectSelectionScope = software.amazon.jsii.Kernel.get(this, "projectSelectionScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.projectSelectionScope = builder.projectSelectionScope;
            }

            @Override
            public final java.lang.String getProjectSelectionScope() {
                return this.projectSelectionScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProjectSelectionScope() != null) {
                    data.set("projectSelectionScope", om.valueToTree(this.getProjectSelectionScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCodeSecurityScanConfiguration.ScopeSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScopeSettingsProperty.Jsii$Proxy that = (ScopeSettingsProperty.Jsii$Proxy) o;

                return this.projectSelectionScope != null ? this.projectSelectionScope.equals(that.projectSelectionScope) : that.projectSelectionScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.projectSelectionScope != null ? this.projectSelectionScope.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The configuration settings for the code security scan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-configuration</a>
         * @param configuration The configuration settings for the code security scan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props().configuration(configuration);
            return this;
        }
        /**
         * The configuration settings for the code security scan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-configuration</a>
         * @param configuration The configuration settings for the code security scan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.CodeSecurityScanConfigurationProperty configuration) {
            this.props().configuration(configuration);
            return this;
        }

        /**
         * The security level for the scan configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-level">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-level</a>
         * @param level The security level for the scan configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder level(final java.lang.String level) {
            this.props().level(level);
            return this;
        }

        /**
         * The name of the scan configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-name</a>
         * @param name The name of the scan configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The scope settings that define which repositories will be scanned.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-scopesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-scopesettings</a>
         * @param scopeSettings The scope settings that define which repositories will be scanned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopeSettings(final software.amazon.awscdk.IResolvable scopeSettings) {
            this.props().scopeSettings(scopeSettings);
            return this;
        }
        /**
         * The scope settings that define which repositories will be scanned.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-scopesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-scopesettings</a>
         * @param scopeSettings The scope settings that define which repositories will be scanned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopeSettings(final software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration.ScopeSettingsProperty scopeSettings) {
            this.props().scopeSettings(scopeSettings);
            return this;
        }

        /**
         * The tags to apply to the scan configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-codesecurityscanconfiguration.html#cfn-inspectorv2-codesecurityscanconfiguration-tags</a>
         * @param tags The tags to apply to the scan configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration build() {
            return new software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfiguration(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfigurationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.inspectorv2.CfnCodeSecurityScanConfigurationProps.Builder();
            }
            return this.props;
        }
    }
}
