package software.amazon.awscdk.services.iot;

/**
 * Use the <code>AWS::IoT::SecurityProfile</code> resource to create a Device Defender security profile.
 * <p>
 * For API reference, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_CreateSecurityProfile.html">CreateSecurityProfile</a> and for general information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Detect</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnSecurityProfile cfnSecurityProfile = CfnSecurityProfile.Builder.create(this, "MyCfnSecurityProfile")
 *         .additionalMetricsToRetainV2(List.of(MetricToRetainProperty.builder()
 *                 .metric("metric")
 *                 // the properties below are optional
 *                 .exportMetric(false)
 *                 .metricDimension(MetricDimensionProperty.builder()
 *                         .dimensionName("dimensionName")
 *                         // the properties below are optional
 *                         .operator("operator")
 *                         .build())
 *                 .build()))
 *         .alertTargets(Map.of(
 *                 "alertTargetsKey", AlertTargetProperty.builder()
 *                         .alertTargetArn("alertTargetArn")
 *                         .roleArn("roleArn")
 *                         .build()))
 *         .behaviors(List.of(BehaviorProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .criteria(BehaviorCriteriaProperty.builder()
 *                         .comparisonOperator("comparisonOperator")
 *                         .consecutiveDatapointsToAlarm(123)
 *                         .consecutiveDatapointsToClear(123)
 *                         .durationSeconds(123)
 *                         .mlDetectionConfig(MachineLearningDetectionConfigProperty.builder()
 *                                 .confidenceLevel("confidenceLevel")
 *                                 .build())
 *                         .statisticalThreshold(StatisticalThresholdProperty.builder()
 *                                 .statistic("statistic")
 *                                 .build())
 *                         .value(MetricValueProperty.builder()
 *                                 .cidrs(List.of("cidrs"))
 *                                 .count("count")
 *                                 .number(123)
 *                                 .numbers(List.of(123))
 *                                 .ports(List.of(123))
 *                                 .strings(List.of("strings"))
 *                                 .build())
 *                         .build())
 *                 .exportMetric(false)
 *                 .metric("metric")
 *                 .metricDimension(MetricDimensionProperty.builder()
 *                         .dimensionName("dimensionName")
 *                         // the properties below are optional
 *                         .operator("operator")
 *                         .build())
 *                 .suppressAlerts(false)
 *                 .build()))
 *         .metricsExportConfig(MetricsExportConfigProperty.builder()
 *                 .mqttTopic("mqttTopic")
 *                 .roleArn("roleArn")
 *                 .build())
 *         .securityProfileDescription("securityProfileDescription")
 *         .securityProfileName("securityProfileName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetArns(List.of("targetArns"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.498Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile")
public class CfnSecurityProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.iot.ISecurityProfileRef, software.amazon.awscdk.ITaggable {

    protected CfnSecurityProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnSecurityProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::IoT::SecurityProfile</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecurityProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnSecurityProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::IoT::SecurityProfile</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecurityProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForSecurityProfile(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iot.ISecurityProfileRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.CfnSecurityProfile.class, "arnForSecurityProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new ISecurityProfileRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iot.ISecurityProfileRef fromSecurityProfileArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.CfnSecurityProfile.class, "fromSecurityProfileArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iot.ISecurityProfileRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new ISecurityProfileRef from a securityProfileName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param securityProfileName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iot.ISecurityProfileRef fromSecurityProfileName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String securityProfileName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.CfnSecurityProfile.class, "fromSecurityProfileName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iot.ISecurityProfileRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityProfileName, "securityProfileName is required") });
    }

    /**
     * Checks whether the given object is a CfnSecurityProfile.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnSecurityProfile(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.CfnSecurityProfile.class, "isCfnSecurityProfile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSecurityProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSecurityProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a SecurityProfile resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iot.SecurityProfileReference getSecurityProfileRef() {
        return software.amazon.jsii.Kernel.get(this, "securityProfileRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iot.SecurityProfileReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of metrics whose data is retained (stored).
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricToRetainProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalMetricsToRetainV2() {
        return software.amazon.jsii.Kernel.get(this, "additionalMetricsToRetainV2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of metrics whose data is retained (stored).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalMetricsToRetainV2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalMetricsToRetainV2", value);
    }

    /**
     * A list of metrics whose data is retained (stored).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalMetricsToRetainV2(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricToRetainProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricToRetainProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "additionalMetricsToRetainV2", value);
    }

    /**
     * Specifies the destinations to which alerts are sent.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.AlertTargetProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAlertTargets() {
        return software.amazon.jsii.Kernel.get(this, "alertTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the destinations to which alerts are sent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlertTargets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "alertTargets", value);
    }

    /**
     * Specifies the destinations to which alerts are sent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlertTargets(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iot.CfnSecurityProfile.AlertTargetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iot.CfnSecurityProfile.AlertTargetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "alertTargets", value);
    }

    /**
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.BehaviorProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBehaviors() {
        return software.amazon.jsii.Kernel.get(this, "behaviors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBehaviors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "behaviors", value);
    }

    /**
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBehaviors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iot.CfnSecurityProfile.BehaviorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iot.CfnSecurityProfile.BehaviorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "behaviors", value);
    }

    /**
     * Specifies the MQTT topic and role ARN required for metric export.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricsExportConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetricsExportConfig() {
        return software.amazon.jsii.Kernel.get(this, "metricsExportConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the MQTT topic and role ARN required for metric export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsExportConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricsExportConfig", value);
    }

    /**
     * Specifies the MQTT topic and role ARN required for metric export.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsExportConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricsExportConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "metricsExportConfig", value);
    }

    /**
     * A description of the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityProfileDescription() {
        return software.amazon.jsii.Kernel.get(this, "securityProfileDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityProfileDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityProfileDescription", value);
    }

    /**
     * The name you gave to the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityProfileName() {
        return software.amazon.jsii.Kernel.get(this, "securityProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name you gave to the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityProfileName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityProfileName", value);
    }

    /**
     * Metadata that can be used to manage the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that can be used to manage the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The ARN of the target (thing group) to which the security profile is attached.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "targetArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The ARN of the target (thing group) to which the security profile is attached.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "targetArns", value);
    }
    /**
     * A structure containing the alert target ARN and the role ARN.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AlertTargetProperty alertTargetProperty = AlertTargetProperty.builder()
     *         .alertTargetArn("alertTargetArn")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.AlertTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(AlertTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlertTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the notification target to which alerts are sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html#cfn-iot-securityprofile-alerttarget-alerttargetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html#cfn-iot-securityprofile-alerttarget-alerttargetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlertTargetArn();

        /**
         * The ARN of the role that grants permission to send alerts to the notification target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html#cfn-iot-securityprofile-alerttarget-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html#cfn-iot-securityprofile-alerttarget-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link AlertTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlertTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlertTargetProperty> {
            java.lang.String alertTargetArn;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link AlertTargetProperty#getAlertTargetArn}
             * @param alertTargetArn The Amazon Resource Name (ARN) of the notification target to which alerts are sent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alertTargetArn(java.lang.String alertTargetArn) {
                this.alertTargetArn = alertTargetArn;
                return this;
            }

            /**
             * Sets the value of {@link AlertTargetProperty#getRoleArn}
             * @param roleArn The ARN of the role that grants permission to send alerts to the notification target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlertTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlertTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlertTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlertTargetProperty {
            private final java.lang.String alertTargetArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alertTargetArn = software.amazon.jsii.Kernel.get(this, "alertTargetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alertTargetArn = java.util.Objects.requireNonNull(builder.alertTargetArn, "alertTargetArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getAlertTargetArn() {
                return this.alertTargetArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alertTargetArn", om.valueToTree(this.getAlertTargetArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.AlertTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlertTargetProperty.Jsii$Proxy that = (AlertTargetProperty.Jsii$Proxy) o;

                if (!alertTargetArn.equals(that.alertTargetArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.alertTargetArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * The criteria by which the behavior is determined to be normal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * BehaviorCriteriaProperty behaviorCriteriaProperty = BehaviorCriteriaProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .consecutiveDatapointsToAlarm(123)
     *         .consecutiveDatapointsToClear(123)
     *         .durationSeconds(123)
     *         .mlDetectionConfig(MachineLearningDetectionConfigProperty.builder()
     *                 .confidenceLevel("confidenceLevel")
     *                 .build())
     *         .statisticalThreshold(StatisticalThresholdProperty.builder()
     *                 .statistic("statistic")
     *                 .build())
     *         .value(MetricValueProperty.builder()
     *                 .cidrs(List.of("cidrs"))
     *                 .count("count")
     *                 .number(123)
     *                 .numbers(List.of(123))
     *                 .ports(List.of(123))
     *                 .strings(List.of("strings"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.BehaviorCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(BehaviorCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BehaviorCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operator that relates the thing measured ( <code>metric</code> ) to the criteria (containing a <code>value</code> or <code>statisticalThreshold</code> ).
         * <p>
         * Valid operators include:
         * <p>
         * <ul>
         * <li><code>string-list</code> : <code>in-set</code> and <code>not-in-set</code></li>
         * <li><code>number-list</code> : <code>in-set</code> and <code>not-in-set</code></li>
         * <li><code>ip-address-list</code> : <code>in-cidr-set</code> and <code>not-in-cidr-set</code></li>
         * <li><code>number</code> : <code>less-than</code> , <code>less-than-equals</code> , <code>greater-than</code> , and <code>greater-than-equals</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComparisonOperator() {
            return null;
        }

        /**
         * If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm occurs.
         * <p>
         * If not specified, the default is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-consecutivedatapointstoalarm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-consecutivedatapointstoalarm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConsecutiveDatapointsToAlarm() {
            return null;
        }

        /**
         * If an alarm has occurred and the offending device is no longer in violation of the behavior for the specified number of consecutive datapoints, the alarm is cleared.
         * <p>
         * If not specified, the default is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-consecutivedatapointstoclear">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-consecutivedatapointstoclear</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConsecutiveDatapointsToClear() {
            return null;
        }

        /**
         * Use this to specify the time duration over which the behavior is evaluated, for those criteria that have a time dimension (for example, <code>NUM_MESSAGES_SENT</code> ).
         * <p>
         * For a <code>statisticalThreshhold</code> metric comparison, measurements from all devices are accumulated over this time duration before being used to calculate percentiles, and later, measurements from an individual device are also accumulated over this time duration before being given a percentile rank. Cannot be used with list-based metric datatypes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-durationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-durationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationSeconds() {
            return null;
        }

        /**
         * The confidence level of the detection model.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.MachineLearningDetectionConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-mldetectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-mldetectionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMlDetectionConfig() {
            return null;
        }

        /**
         * A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.StatisticalThresholdProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-statisticalthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-statisticalthreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatisticalThreshold() {
            return null;
        }

        /**
         * The value to be compared with the <code>metric</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BehaviorCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BehaviorCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BehaviorCriteriaProperty> {
            java.lang.String comparisonOperator;
            java.lang.Number consecutiveDatapointsToAlarm;
            java.lang.Number consecutiveDatapointsToClear;
            java.lang.Number durationSeconds;
            java.lang.Object mlDetectionConfig;
            java.lang.Object statisticalThreshold;
            java.lang.Object value;

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getComparisonOperator}
             * @param comparisonOperator The operator that relates the thing measured ( <code>metric</code> ) to the criteria (containing a <code>value</code> or <code>statisticalThreshold</code> ).
             *                           Valid operators include:
             *                           <p>
             *                           <ul>
             *                           <li><code>string-list</code> : <code>in-set</code> and <code>not-in-set</code></li>
             *                           <li><code>number-list</code> : <code>in-set</code> and <code>not-in-set</code></li>
             *                           <li><code>ip-address-list</code> : <code>in-cidr-set</code> and <code>not-in-cidr-set</code></li>
             *                           <li><code>number</code> : <code>less-than</code> , <code>less-than-equals</code> , <code>greater-than</code> , and <code>greater-than-equals</code></li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getConsecutiveDatapointsToAlarm}
             * @param consecutiveDatapointsToAlarm If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm occurs.
             *                                     If not specified, the default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consecutiveDatapointsToAlarm(java.lang.Number consecutiveDatapointsToAlarm) {
                this.consecutiveDatapointsToAlarm = consecutiveDatapointsToAlarm;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getConsecutiveDatapointsToClear}
             * @param consecutiveDatapointsToClear If an alarm has occurred and the offending device is no longer in violation of the behavior for the specified number of consecutive datapoints, the alarm is cleared.
             *                                     If not specified, the default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consecutiveDatapointsToClear(java.lang.Number consecutiveDatapointsToClear) {
                this.consecutiveDatapointsToClear = consecutiveDatapointsToClear;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getDurationSeconds}
             * @param durationSeconds Use this to specify the time duration over which the behavior is evaluated, for those criteria that have a time dimension (for example, <code>NUM_MESSAGES_SENT</code> ).
             *                        For a <code>statisticalThreshhold</code> metric comparison, measurements from all devices are accumulated over this time duration before being used to calculate percentiles, and later, measurements from an individual device are also accumulated over this time duration before being given a percentile rank. Cannot be used with list-based metric datatypes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationSeconds(java.lang.Number durationSeconds) {
                this.durationSeconds = durationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getMlDetectionConfig}
             * @param mlDetectionConfig The confidence level of the detection model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlDetectionConfig(software.amazon.awscdk.IResolvable mlDetectionConfig) {
                this.mlDetectionConfig = mlDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getMlDetectionConfig}
             * @param mlDetectionConfig The confidence level of the detection model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlDetectionConfig(software.amazon.awscdk.services.iot.CfnSecurityProfile.MachineLearningDetectionConfigProperty mlDetectionConfig) {
                this.mlDetectionConfig = mlDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getStatisticalThreshold}
             * @param statisticalThreshold A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statisticalThreshold(software.amazon.awscdk.IResolvable statisticalThreshold) {
                this.statisticalThreshold = statisticalThreshold;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getStatisticalThreshold}
             * @param statisticalThreshold A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statisticalThreshold(software.amazon.awscdk.services.iot.CfnSecurityProfile.StatisticalThresholdProperty statisticalThreshold) {
                this.statisticalThreshold = statisticalThreshold;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getValue}
             * @param value The value to be compared with the <code>metric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorCriteriaProperty#getValue}
             * @param value The value to be compared with the <code>metric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BehaviorCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BehaviorCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BehaviorCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BehaviorCriteriaProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.Number consecutiveDatapointsToAlarm;
            private final java.lang.Number consecutiveDatapointsToClear;
            private final java.lang.Number durationSeconds;
            private final java.lang.Object mlDetectionConfig;
            private final java.lang.Object statisticalThreshold;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.consecutiveDatapointsToAlarm = software.amazon.jsii.Kernel.get(this, "consecutiveDatapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.consecutiveDatapointsToClear = software.amazon.jsii.Kernel.get(this, "consecutiveDatapointsToClear", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.durationSeconds = software.amazon.jsii.Kernel.get(this, "durationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mlDetectionConfig = software.amazon.jsii.Kernel.get(this, "mlDetectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statisticalThreshold = software.amazon.jsii.Kernel.get(this, "statisticalThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = builder.comparisonOperator;
                this.consecutiveDatapointsToAlarm = builder.consecutiveDatapointsToAlarm;
                this.consecutiveDatapointsToClear = builder.consecutiveDatapointsToClear;
                this.durationSeconds = builder.durationSeconds;
                this.mlDetectionConfig = builder.mlDetectionConfig;
                this.statisticalThreshold = builder.statisticalThreshold;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.Number getConsecutiveDatapointsToAlarm() {
                return this.consecutiveDatapointsToAlarm;
            }

            @Override
            public final java.lang.Number getConsecutiveDatapointsToClear() {
                return this.consecutiveDatapointsToClear;
            }

            @Override
            public final java.lang.Number getDurationSeconds() {
                return this.durationSeconds;
            }

            @Override
            public final java.lang.Object getMlDetectionConfig() {
                return this.mlDetectionConfig;
            }

            @Override
            public final java.lang.Object getStatisticalThreshold() {
                return this.statisticalThreshold;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComparisonOperator() != null) {
                    data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                }
                if (this.getConsecutiveDatapointsToAlarm() != null) {
                    data.set("consecutiveDatapointsToAlarm", om.valueToTree(this.getConsecutiveDatapointsToAlarm()));
                }
                if (this.getConsecutiveDatapointsToClear() != null) {
                    data.set("consecutiveDatapointsToClear", om.valueToTree(this.getConsecutiveDatapointsToClear()));
                }
                if (this.getDurationSeconds() != null) {
                    data.set("durationSeconds", om.valueToTree(this.getDurationSeconds()));
                }
                if (this.getMlDetectionConfig() != null) {
                    data.set("mlDetectionConfig", om.valueToTree(this.getMlDetectionConfig()));
                }
                if (this.getStatisticalThreshold() != null) {
                    data.set("statisticalThreshold", om.valueToTree(this.getStatisticalThreshold()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.BehaviorCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BehaviorCriteriaProperty.Jsii$Proxy that = (BehaviorCriteriaProperty.Jsii$Proxy) o;

                if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
                if (this.consecutiveDatapointsToAlarm != null ? !this.consecutiveDatapointsToAlarm.equals(that.consecutiveDatapointsToAlarm) : that.consecutiveDatapointsToAlarm != null) return false;
                if (this.consecutiveDatapointsToClear != null ? !this.consecutiveDatapointsToClear.equals(that.consecutiveDatapointsToClear) : that.consecutiveDatapointsToClear != null) return false;
                if (this.durationSeconds != null ? !this.durationSeconds.equals(that.durationSeconds) : that.durationSeconds != null) return false;
                if (this.mlDetectionConfig != null ? !this.mlDetectionConfig.equals(that.mlDetectionConfig) : that.mlDetectionConfig != null) return false;
                if (this.statisticalThreshold != null ? !this.statisticalThreshold.equals(that.statisticalThreshold) : that.statisticalThreshold != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0;
                result = 31 * result + (this.consecutiveDatapointsToAlarm != null ? this.consecutiveDatapointsToAlarm.hashCode() : 0);
                result = 31 * result + (this.consecutiveDatapointsToClear != null ? this.consecutiveDatapointsToClear.hashCode() : 0);
                result = 31 * result + (this.durationSeconds != null ? this.durationSeconds.hashCode() : 0);
                result = 31 * result + (this.mlDetectionConfig != null ? this.mlDetectionConfig.hashCode() : 0);
                result = 31 * result + (this.statisticalThreshold != null ? this.statisticalThreshold.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A Device Defender security profile behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * BehaviorProperty behaviorProperty = BehaviorProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .criteria(BehaviorCriteriaProperty.builder()
     *                 .comparisonOperator("comparisonOperator")
     *                 .consecutiveDatapointsToAlarm(123)
     *                 .consecutiveDatapointsToClear(123)
     *                 .durationSeconds(123)
     *                 .mlDetectionConfig(MachineLearningDetectionConfigProperty.builder()
     *                         .confidenceLevel("confidenceLevel")
     *                         .build())
     *                 .statisticalThreshold(StatisticalThresholdProperty.builder()
     *                         .statistic("statistic")
     *                         .build())
     *                 .value(MetricValueProperty.builder()
     *                         .cidrs(List.of("cidrs"))
     *                         .count("count")
     *                         .number(123)
     *                         .numbers(List.of(123))
     *                         .ports(List.of(123))
     *                         .strings(List.of("strings"))
     *                         .build())
     *                 .build())
     *         .exportMetric(false)
     *         .metric("metric")
     *         .metricDimension(MetricDimensionProperty.builder()
     *                 .dimensionName("dimensionName")
     *                 // the properties below are optional
     *                 .operator("operator")
     *                 .build())
     *         .suppressAlerts(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.BehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(BehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name you've given to the behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The criteria that determine if a device is behaving normally in regard to the <code>metric</code> .
         * <p>
         * <blockquote>
         * <p>
         * In the AWS IoT console, you can choose to be sent an alert through Amazon SNS when AWS IoT Device Defender detects that a device is behaving anomalously.
         * <p>
         * </blockquote>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.BehaviorCriteriaProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-criteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCriteria() {
            return null;
        }

        /**
         * Value indicates exporting metrics related to the behavior when it is true.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-exportmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-exportmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportMetric() {
            return null;
        }

        /**
         * What is measured by the behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-metric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-metric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetric() {
            return null;
        }

        /**
         * The dimension of the metric.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricDimensionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-metricdimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-metricdimension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricDimension() {
            return null;
        }

        /**
         * The alert status.
         * <p>
         * If you set the value to <code>true</code> , alerts will be suppressed.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-suppressalerts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-suppressalerts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuppressAlerts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BehaviorProperty> {
            java.lang.String name;
            java.lang.Object criteria;
            java.lang.Object exportMetric;
            java.lang.String metric;
            java.lang.Object metricDimension;
            java.lang.Object suppressAlerts;

            /**
             * Sets the value of {@link BehaviorProperty#getName}
             * @param name The name you've given to the behavior. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getCriteria}
             * @param criteria The criteria that determine if a device is behaving normally in regard to the <code>metric</code> .
             *                 <blockquote>
             *                 <p>
             *                 In the AWS IoT console, you can choose to be sent an alert through Amazon SNS when AWS IoT Device Defender detects that a device is behaving anomalously.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criteria(software.amazon.awscdk.IResolvable criteria) {
                this.criteria = criteria;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getCriteria}
             * @param criteria The criteria that determine if a device is behaving normally in regard to the <code>metric</code> .
             *                 <blockquote>
             *                 <p>
             *                 In the AWS IoT console, you can choose to be sent an alert through Amazon SNS when AWS IoT Device Defender detects that a device is behaving anomalously.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criteria(software.amazon.awscdk.services.iot.CfnSecurityProfile.BehaviorCriteriaProperty criteria) {
                this.criteria = criteria;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getExportMetric}
             * @param exportMetric Value indicates exporting metrics related to the behavior when it is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportMetric(java.lang.Boolean exportMetric) {
                this.exportMetric = exportMetric;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getExportMetric}
             * @param exportMetric Value indicates exporting metrics related to the behavior when it is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportMetric(software.amazon.awscdk.IResolvable exportMetric) {
                this.exportMetric = exportMetric;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getMetric}
             * @param metric What is measured by the behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(java.lang.String metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getMetricDimension}
             * @param metricDimension The dimension of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDimension(software.amazon.awscdk.IResolvable metricDimension) {
                this.metricDimension = metricDimension;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getMetricDimension}
             * @param metricDimension The dimension of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDimension(software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricDimensionProperty metricDimension) {
                this.metricDimension = metricDimension;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getSuppressAlerts}
             * @param suppressAlerts The alert status.
             *                       If you set the value to <code>true</code> , alerts will be suppressed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suppressAlerts(java.lang.Boolean suppressAlerts) {
                this.suppressAlerts = suppressAlerts;
                return this;
            }

            /**
             * Sets the value of {@link BehaviorProperty#getSuppressAlerts}
             * @param suppressAlerts The alert status.
             *                       If you set the value to <code>true</code> , alerts will be suppressed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suppressAlerts(software.amazon.awscdk.IResolvable suppressAlerts) {
                this.suppressAlerts = suppressAlerts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BehaviorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BehaviorProperty {
            private final java.lang.String name;
            private final java.lang.Object criteria;
            private final java.lang.Object exportMetric;
            private final java.lang.String metric;
            private final java.lang.Object metricDimension;
            private final java.lang.Object suppressAlerts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.criteria = software.amazon.jsii.Kernel.get(this, "criteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exportMetric = software.amazon.jsii.Kernel.get(this, "exportMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricDimension = software.amazon.jsii.Kernel.get(this, "metricDimension", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.suppressAlerts = software.amazon.jsii.Kernel.get(this, "suppressAlerts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.criteria = builder.criteria;
                this.exportMetric = builder.exportMetric;
                this.metric = builder.metric;
                this.metricDimension = builder.metricDimension;
                this.suppressAlerts = builder.suppressAlerts;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getCriteria() {
                return this.criteria;
            }

            @Override
            public final java.lang.Object getExportMetric() {
                return this.exportMetric;
            }

            @Override
            public final java.lang.String getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.Object getMetricDimension() {
                return this.metricDimension;
            }

            @Override
            public final java.lang.Object getSuppressAlerts() {
                return this.suppressAlerts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getCriteria() != null) {
                    data.set("criteria", om.valueToTree(this.getCriteria()));
                }
                if (this.getExportMetric() != null) {
                    data.set("exportMetric", om.valueToTree(this.getExportMetric()));
                }
                if (this.getMetric() != null) {
                    data.set("metric", om.valueToTree(this.getMetric()));
                }
                if (this.getMetricDimension() != null) {
                    data.set("metricDimension", om.valueToTree(this.getMetricDimension()));
                }
                if (this.getSuppressAlerts() != null) {
                    data.set("suppressAlerts", om.valueToTree(this.getSuppressAlerts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.BehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BehaviorProperty.Jsii$Proxy that = (BehaviorProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.criteria != null ? !this.criteria.equals(that.criteria) : that.criteria != null) return false;
                if (this.exportMetric != null ? !this.exportMetric.equals(that.exportMetric) : that.exportMetric != null) return false;
                if (this.metric != null ? !this.metric.equals(that.metric) : that.metric != null) return false;
                if (this.metricDimension != null ? !this.metricDimension.equals(that.metricDimension) : that.metricDimension != null) return false;
                return this.suppressAlerts != null ? this.suppressAlerts.equals(that.suppressAlerts) : that.suppressAlerts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.criteria != null ? this.criteria.hashCode() : 0);
                result = 31 * result + (this.exportMetric != null ? this.exportMetric.hashCode() : 0);
                result = 31 * result + (this.metric != null ? this.metric.hashCode() : 0);
                result = 31 * result + (this.metricDimension != null ? this.metricDimension.hashCode() : 0);
                result = 31 * result + (this.suppressAlerts != null ? this.suppressAlerts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>MachineLearningDetectionConfig</code> property type controls confidence of the machine learning model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * MachineLearningDetectionConfigProperty machineLearningDetectionConfigProperty = MachineLearningDetectionConfigProperty.builder()
     *         .confidenceLevel("confidenceLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-machinelearningdetectionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-machinelearningdetectionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.MachineLearningDetectionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MachineLearningDetectionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MachineLearningDetectionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The model confidence level.
         * <p>
         * There are three levels of confidence, <code>"high"</code> , <code>"medium"</code> , and <code>"low"</code> .
         * <p>
         * The higher the confidence level, the lower the sensitivity, and the lower the alarm frequency will be.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-machinelearningdetectionconfig.html#cfn-iot-securityprofile-machinelearningdetectionconfig-confidencelevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-machinelearningdetectionconfig.html#cfn-iot-securityprofile-machinelearningdetectionconfig-confidencelevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConfidenceLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MachineLearningDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MachineLearningDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MachineLearningDetectionConfigProperty> {
            java.lang.String confidenceLevel;

            /**
             * Sets the value of {@link MachineLearningDetectionConfigProperty#getConfidenceLevel}
             * @param confidenceLevel The model confidence level.
             *                        There are three levels of confidence, <code>"high"</code> , <code>"medium"</code> , and <code>"low"</code> .
             *                        <p>
             *                        The higher the confidence level, the lower the sensitivity, and the lower the alarm frequency will be.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidenceLevel(java.lang.String confidenceLevel) {
                this.confidenceLevel = confidenceLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MachineLearningDetectionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MachineLearningDetectionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MachineLearningDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MachineLearningDetectionConfigProperty {
            private final java.lang.String confidenceLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.confidenceLevel = software.amazon.jsii.Kernel.get(this, "confidenceLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.confidenceLevel = builder.confidenceLevel;
            }

            @Override
            public final java.lang.String getConfidenceLevel() {
                return this.confidenceLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfidenceLevel() != null) {
                    data.set("confidenceLevel", om.valueToTree(this.getConfidenceLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.MachineLearningDetectionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MachineLearningDetectionConfigProperty.Jsii$Proxy that = (MachineLearningDetectionConfigProperty.Jsii$Proxy) o;

                return this.confidenceLevel != null ? this.confidenceLevel.equals(that.confidenceLevel) : that.confidenceLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.confidenceLevel != null ? this.confidenceLevel.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The dimension of the metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .dimensionName("dimensionName")
     *         // the properties below are optional
     *         .operator("operator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html#cfn-iot-securityprofile-metricdimension-dimensionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html#cfn-iot-securityprofile-metricdimension-dimensionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionName();

        /**
         * Operators are constructs that perform logical operations.
         * <p>
         * Valid values are <code>IN</code> and <code>NOT_IN</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html#cfn-iot-securityprofile-metricdimension-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html#cfn-iot-securityprofile-metricdimension-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperator() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String dimensionName;
            java.lang.String operator;

            /**
             * Sets the value of {@link MetricDimensionProperty#getDimensionName}
             * @param dimensionName The name of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionName(java.lang.String dimensionName) {
                this.dimensionName = dimensionName;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getOperator}
             * @param operator Operators are constructs that perform logical operations.
             *                 Valid values are <code>IN</code> and <code>NOT_IN</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String dimensionName;
            private final java.lang.String operator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionName = software.amazon.jsii.Kernel.get(this, "dimensionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionName = java.util.Objects.requireNonNull(builder.dimensionName, "dimensionName is required");
                this.operator = builder.operator;
            }

            @Override
            public final java.lang.String getDimensionName() {
                return this.dimensionName;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensionName", om.valueToTree(this.getDimensionName()));
                if (this.getOperator() != null) {
                    data.set("operator", om.valueToTree(this.getOperator()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!dimensionName.equals(that.dimensionName)) return false;
                return this.operator != null ? this.operator.equals(that.operator) : that.operator == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionName.hashCode();
                result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The metric you want to retain.
     * <p>
     * Dimensions are optional.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * MetricToRetainProperty metricToRetainProperty = MetricToRetainProperty.builder()
     *         .metric("metric")
     *         // the properties below are optional
     *         .exportMetric(false)
     *         .metricDimension(MetricDimensionProperty.builder()
     *                 .dimensionName("dimensionName")
     *                 // the properties below are optional
     *                 .operator("operator")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricToRetainProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricToRetainProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricToRetainProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A standard of measurement.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-metric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-metric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetric();

        /**
         * The value indicates exporting metrics related to the <code>MetricToRetain</code> when it's true.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-exportmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-exportmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExportMetric() {
            return null;
        }

        /**
         * The dimension of the metric.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricDimensionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-metricdimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-metricdimension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricDimension() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricToRetainProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricToRetainProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricToRetainProperty> {
            java.lang.String metric;
            java.lang.Object exportMetric;
            java.lang.Object metricDimension;

            /**
             * Sets the value of {@link MetricToRetainProperty#getMetric}
             * @param metric A standard of measurement. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(java.lang.String metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link MetricToRetainProperty#getExportMetric}
             * @param exportMetric The value indicates exporting metrics related to the <code>MetricToRetain</code> when it's true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportMetric(java.lang.Boolean exportMetric) {
                this.exportMetric = exportMetric;
                return this;
            }

            /**
             * Sets the value of {@link MetricToRetainProperty#getExportMetric}
             * @param exportMetric The value indicates exporting metrics related to the <code>MetricToRetain</code> when it's true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportMetric(software.amazon.awscdk.IResolvable exportMetric) {
                this.exportMetric = exportMetric;
                return this;
            }

            /**
             * Sets the value of {@link MetricToRetainProperty#getMetricDimension}
             * @param metricDimension The dimension of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDimension(software.amazon.awscdk.IResolvable metricDimension) {
                this.metricDimension = metricDimension;
                return this;
            }

            /**
             * Sets the value of {@link MetricToRetainProperty#getMetricDimension}
             * @param metricDimension The dimension of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDimension(software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricDimensionProperty metricDimension) {
                this.metricDimension = metricDimension;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricToRetainProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricToRetainProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricToRetainProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricToRetainProperty {
            private final java.lang.String metric;
            private final java.lang.Object exportMetric;
            private final java.lang.Object metricDimension;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportMetric = software.amazon.jsii.Kernel.get(this, "exportMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricDimension = software.amazon.jsii.Kernel.get(this, "metricDimension", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
                this.exportMetric = builder.exportMetric;
                this.metricDimension = builder.metricDimension;
            }

            @Override
            public final java.lang.String getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.Object getExportMetric() {
                return this.exportMetric;
            }

            @Override
            public final java.lang.Object getMetricDimension() {
                return this.metricDimension;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metric", om.valueToTree(this.getMetric()));
                if (this.getExportMetric() != null) {
                    data.set("exportMetric", om.valueToTree(this.getExportMetric()));
                }
                if (this.getMetricDimension() != null) {
                    data.set("metricDimension", om.valueToTree(this.getMetricDimension()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricToRetainProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricToRetainProperty.Jsii$Proxy that = (MetricToRetainProperty.Jsii$Proxy) o;

                if (!metric.equals(that.metric)) return false;
                if (this.exportMetric != null ? !this.exportMetric.equals(that.exportMetric) : that.exportMetric != null) return false;
                return this.metricDimension != null ? this.metricDimension.equals(that.metricDimension) : that.metricDimension == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metric.hashCode();
                result = 31 * result + (this.exportMetric != null ? this.exportMetric.hashCode() : 0);
                result = 31 * result + (this.metricDimension != null ? this.metricDimension.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The value to be compared with the <code>metric</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * MetricValueProperty metricValueProperty = MetricValueProperty.builder()
     *         .cidrs(List.of("cidrs"))
     *         .count("count")
     *         .number(123)
     *         .numbers(List.of(123))
     *         .ports(List.of(123))
     *         .strings(List.of("strings"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricValueProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be compared with the <code>metric</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-cidrs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-cidrs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCidrs() {
            return null;
        }

        /**
         * If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric value to be compared with the <code>metric</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCount() {
            return null;
        }

        /**
         * The numeric values of a metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-number">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-number</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumber() {
            return null;
        }

        /**
         * The numeric value of a metric.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-numbers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-numbers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumbers() {
            return null;
        }

        /**
         * If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared with the <code>metric</code> .
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-ports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-ports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPorts() {
            return null;
        }

        /**
         * The string values of a metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-strings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-strings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStrings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricValueProperty> {
            java.util.List<java.lang.String> cidrs;
            java.lang.String count;
            java.lang.Number number;
            java.lang.Object numbers;
            java.lang.Object ports;
            java.util.List<java.lang.String> strings;

            /**
             * Sets the value of {@link MetricValueProperty#getCidrs}
             * @param cidrs If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be compared with the <code>metric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrs(java.util.List<java.lang.String> cidrs) {
                this.cidrs = cidrs;
                return this;
            }

            /**
             * Sets the value of {@link MetricValueProperty#getCount}
             * @param count If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric value to be compared with the <code>metric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.String count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link MetricValueProperty#getNumber}
             * @param number The numeric values of a metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder number(java.lang.Number number) {
                this.number = number;
                return this;
            }

            /**
             * Sets the value of {@link MetricValueProperty#getNumbers}
             * @param numbers The numeric value of a metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numbers(java.util.List<? extends java.lang.Number> numbers) {
                this.numbers = numbers;
                return this;
            }

            /**
             * Sets the value of {@link MetricValueProperty#getNumbers}
             * @param numbers The numeric value of a metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numbers(software.amazon.awscdk.IResolvable numbers) {
                this.numbers = numbers;
                return this;
            }

            /**
             * Sets the value of {@link MetricValueProperty#getPorts}
             * @param ports If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared with the <code>metric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(java.util.List<? extends java.lang.Number> ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Sets the value of {@link MetricValueProperty#getPorts}
             * @param ports If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared with the <code>metric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(software.amazon.awscdk.IResolvable ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Sets the value of {@link MetricValueProperty#getStrings}
             * @param strings The string values of a metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strings(java.util.List<java.lang.String> strings) {
                this.strings = strings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricValueProperty {
            private final java.util.List<java.lang.String> cidrs;
            private final java.lang.String count;
            private final java.lang.Number number;
            private final java.lang.Object numbers;
            private final java.lang.Object ports;
            private final java.util.List<java.lang.String> strings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidrs = software.amazon.jsii.Kernel.get(this, "cidrs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.number = software.amazon.jsii.Kernel.get(this, "number", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.numbers = software.amazon.jsii.Kernel.get(this, "numbers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.strings = software.amazon.jsii.Kernel.get(this, "strings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidrs = builder.cidrs;
                this.count = builder.count;
                this.number = builder.number;
                this.numbers = builder.numbers;
                this.ports = builder.ports;
                this.strings = builder.strings;
            }

            @Override
            public final java.util.List<java.lang.String> getCidrs() {
                return this.cidrs;
            }

            @Override
            public final java.lang.String getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getNumber() {
                return this.number;
            }

            @Override
            public final java.lang.Object getNumbers() {
                return this.numbers;
            }

            @Override
            public final java.lang.Object getPorts() {
                return this.ports;
            }

            @Override
            public final java.util.List<java.lang.String> getStrings() {
                return this.strings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCidrs() != null) {
                    data.set("cidrs", om.valueToTree(this.getCidrs()));
                }
                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getNumber() != null) {
                    data.set("number", om.valueToTree(this.getNumber()));
                }
                if (this.getNumbers() != null) {
                    data.set("numbers", om.valueToTree(this.getNumbers()));
                }
                if (this.getPorts() != null) {
                    data.set("ports", om.valueToTree(this.getPorts()));
                }
                if (this.getStrings() != null) {
                    data.set("strings", om.valueToTree(this.getStrings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricValueProperty.Jsii$Proxy that = (MetricValueProperty.Jsii$Proxy) o;

                if (this.cidrs != null ? !this.cidrs.equals(that.cidrs) : that.cidrs != null) return false;
                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.number != null ? !this.number.equals(that.number) : that.number != null) return false;
                if (this.numbers != null ? !this.numbers.equals(that.numbers) : that.numbers != null) return false;
                if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) return false;
                return this.strings != null ? this.strings.equals(that.strings) : that.strings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cidrs != null ? this.cidrs.hashCode() : 0;
                result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
                result = 31 * result + (this.number != null ? this.number.hashCode() : 0);
                result = 31 * result + (this.numbers != null ? this.numbers.hashCode() : 0);
                result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
                result = 31 * result + (this.strings != null ? this.strings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the MQTT topic and role ARN required for metric export.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * MetricsExportConfigProperty metricsExportConfigProperty = MetricsExportConfigProperty.builder()
     *         .mqttTopic("mqttTopic")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricsexportconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricsexportconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricsExportConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricsExportConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricsExportConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The MQTT topic that Device Defender Detect should publish messages to for metrics export.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricsexportconfig.html#cfn-iot-securityprofile-metricsexportconfig-mqtttopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricsexportconfig.html#cfn-iot-securityprofile-metricsexportconfig-mqtttopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMqttTopic();

        /**
         * This role ARN has permission to publish MQTT messages, after which Device Defender Detect can assume the role and publish messages on your behalf.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricsexportconfig.html#cfn-iot-securityprofile-metricsexportconfig-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricsexportconfig.html#cfn-iot-securityprofile-metricsexportconfig-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link MetricsExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricsExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricsExportConfigProperty> {
            java.lang.String mqttTopic;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link MetricsExportConfigProperty#getMqttTopic}
             * @param mqttTopic The MQTT topic that Device Defender Detect should publish messages to for metrics export. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mqttTopic(java.lang.String mqttTopic) {
                this.mqttTopic = mqttTopic;
                return this;
            }

            /**
             * Sets the value of {@link MetricsExportConfigProperty#getRoleArn}
             * @param roleArn This role ARN has permission to publish MQTT messages, after which Device Defender Detect can assume the role and publish messages on your behalf. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsExportConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricsExportConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricsExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsExportConfigProperty {
            private final java.lang.String mqttTopic;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mqttTopic = software.amazon.jsii.Kernel.get(this, "mqttTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mqttTopic = java.util.Objects.requireNonNull(builder.mqttTopic, "mqttTopic is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getMqttTopic() {
                return this.mqttTopic;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mqttTopic", om.valueToTree(this.getMqttTopic()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.MetricsExportConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricsExportConfigProperty.Jsii$Proxy that = (MetricsExportConfigProperty.Jsii$Proxy) o;

                if (!mqttTopic.equals(that.mqttTopic)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.mqttTopic.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * A statistical ranking (percentile) that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * StatisticalThresholdProperty statisticalThresholdProperty = StatisticalThresholdProperty.builder()
     *         .statistic("statistic")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-statisticalthreshold.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-statisticalthreshold.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfile.StatisticalThresholdProperty")
    @software.amazon.jsii.Jsii.Proxy(StatisticalThresholdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatisticalThresholdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The percentile that resolves to a threshold value by which compliance with a behavior is determined.
         * <p>
         * Metrics are collected over the specified period ( <code>durationSeconds</code> ) from all reporting devices in your account and statistical ranks are calculated. Then, the measurements from a device are collected over the same period. If the accumulated measurements from the device fall above or below ( <code>comparisonOperator</code> ) the value associated with the percentile specified, then the device is considered to be in compliance with the behavior, otherwise a violation occurs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-statisticalthreshold.html#cfn-iot-securityprofile-statisticalthreshold-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-statisticalthreshold.html#cfn-iot-securityprofile-statisticalthreshold-statistic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatisticalThresholdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatisticalThresholdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatisticalThresholdProperty> {
            java.lang.String statistic;

            /**
             * Sets the value of {@link StatisticalThresholdProperty#getStatistic}
             * @param statistic The percentile that resolves to a threshold value by which compliance with a behavior is determined.
             *                  Metrics are collected over the specified period ( <code>durationSeconds</code> ) from all reporting devices in your account and statistical ranks are calculated. Then, the measurements from a device are collected over the same period. If the accumulated measurements from the device fall above or below ( <code>comparisonOperator</code> ) the value associated with the percentile specified, then the device is considered to be in compliance with the behavior, otherwise a violation occurs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatisticalThresholdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatisticalThresholdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatisticalThresholdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatisticalThresholdProperty {
            private final java.lang.String statistic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statistic = builder.statistic;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStatistic() != null) {
                    data.set("statistic", om.valueToTree(this.getStatistic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfile.StatisticalThresholdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatisticalThresholdProperty.Jsii$Proxy that = (StatisticalThresholdProperty.Jsii$Proxy) o;

                return this.statistic != null ? this.statistic.equals(that.statistic) : that.statistic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statistic != null ? this.statistic.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnSecurityProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnSecurityProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iot.CfnSecurityProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A list of metrics whose data is retained (stored).
         * <p>
         * By default, data is retained for any metric used in the profile's <code>behaviors</code> , but it's also retained for any metric specified here. Can be used with custom metrics; can't be used with dimensions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2</a>
         * @param additionalMetricsToRetainV2 A list of metrics whose data is retained (stored). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalMetricsToRetainV2(final software.amazon.awscdk.IResolvable additionalMetricsToRetainV2) {
            this.props().additionalMetricsToRetainV2(additionalMetricsToRetainV2);
            return this;
        }
        /**
         * A list of metrics whose data is retained (stored).
         * <p>
         * By default, data is retained for any metric used in the profile's <code>behaviors</code> , but it's also retained for any metric specified here. Can be used with custom metrics; can't be used with dimensions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2</a>
         * @param additionalMetricsToRetainV2 A list of metrics whose data is retained (stored). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalMetricsToRetainV2(final java.util.List<? extends java.lang.Object> additionalMetricsToRetainV2) {
            this.props().additionalMetricsToRetainV2(additionalMetricsToRetainV2);
            return this;
        }

        /**
         * Specifies the destinations to which alerts are sent.
         * <p>
         * (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets</a>
         * @param alertTargets Specifies the destinations to which alerts are sent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alertTargets(final software.amazon.awscdk.IResolvable alertTargets) {
            this.props().alertTargets(alertTargets);
            return this;
        }
        /**
         * Specifies the destinations to which alerts are sent.
         * <p>
         * (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets</a>
         * @param alertTargets Specifies the destinations to which alerts are sent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alertTargets(final java.util.Map<java.lang.String, ? extends java.lang.Object> alertTargets) {
            this.props().alertTargets(alertTargets);
            return this;
        }

        /**
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors</a>
         * @param behaviors Specifies the behaviors that, when violated by a device (thing), cause an alert. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder behaviors(final software.amazon.awscdk.IResolvable behaviors) {
            this.props().behaviors(behaviors);
            return this;
        }
        /**
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors</a>
         * @param behaviors Specifies the behaviors that, when violated by a device (thing), cause an alert. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder behaviors(final java.util.List<? extends java.lang.Object> behaviors) {
            this.props().behaviors(behaviors);
            return this;
        }

        /**
         * Specifies the MQTT topic and role ARN required for metric export.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-metricsexportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-metricsexportconfig</a>
         * @param metricsExportConfig Specifies the MQTT topic and role ARN required for metric export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsExportConfig(final software.amazon.awscdk.IResolvable metricsExportConfig) {
            this.props().metricsExportConfig(metricsExportConfig);
            return this;
        }
        /**
         * Specifies the MQTT topic and role ARN required for metric export.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-metricsexportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-metricsexportconfig</a>
         * @param metricsExportConfig Specifies the MQTT topic and role ARN required for metric export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsExportConfig(final software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricsExportConfigProperty metricsExportConfig) {
            this.props().metricsExportConfig(metricsExportConfig);
            return this;
        }

        /**
         * A description of the security profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofiledescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofiledescription</a>
         * @param securityProfileDescription A description of the security profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileDescription(final java.lang.String securityProfileDescription) {
            this.props().securityProfileDescription(securityProfileDescription);
            return this;
        }

        /**
         * The name you gave to the security profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofilename</a>
         * @param securityProfileName The name you gave to the security profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileName(final java.lang.String securityProfileName) {
            this.props().securityProfileName(securityProfileName);
            return this;
        }

        /**
         * Metadata that can be used to manage the security profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-tags</a>
         * @param tags Metadata that can be used to manage the security profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The ARN of the target (thing group) to which the security profile is attached.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-targetarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-targetarns</a>
         * @param targetArns The ARN of the target (thing group) to which the security profile is attached. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArns(final java.util.List<java.lang.String> targetArns) {
            this.props().targetArns(targetArns);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnSecurityProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnSecurityProfile build() {
            return new software.amazon.awscdk.services.iot.CfnSecurityProfile(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.CfnSecurityProfileProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.CfnSecurityProfileProps.Builder();
            }
            return this.props;
        }
    }
}
