package software.amazon.awscdk.services.iotfleetwise;

/**
 * Creates a vehicle, which is an instance of a vehicle model (model manifest).
 * <p>
 * Vehicles created from the same vehicle model consist of the same signals inherited from the vehicle model.
 * <p>
 * <blockquote>
 * <p>
 * If you have an existing AWS IoT thing, you can use AWS IoT FleetWise to create a vehicle and collect data from your thing.
 * <p>
 * </blockquote>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicles.html">Vehicles</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * Object onChange;
 * CfnVehicle cfnVehicle = CfnVehicle.Builder.create(this, "MyCfnVehicle")
 *         .decoderManifestArn("decoderManifestArn")
 *         .modelManifestArn("modelManifestArn")
 *         .name("name")
 *         // the properties below are optional
 *         .associationBehavior("associationBehavior")
 *         .attributes(Map.of(
 *                 "attributesKey", "attributes"))
 *         .stateTemplates(List.of(StateTemplateAssociationProperty.builder()
 *                 .identifier("identifier")
 *                 .stateTemplateUpdateStrategy(StateTemplateUpdateStrategyProperty.builder()
 *                         .onChange(onChange)
 *                         .periodic(PeriodicStateTemplateUpdateStrategyProperty.builder()
 *                                 .stateTemplateUpdateRate(TimePeriodProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.754Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnVehicle")
public class CfnVehicle extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.iotfleetwise.IVehicleRef, software.amazon.awscdk.ITaggable {

    protected CfnVehicle(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVehicle(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotfleetwise.CfnVehicle.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::IoTFleetWise::Vehicle</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVehicle(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnVehicleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForVehicle(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotfleetwise.IVehicleRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotfleetwise.CfnVehicle.class, "arnForVehicle", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnVehicle.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnVehicle(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotfleetwise.CfnVehicle.class, "isCfnVehicle", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the vehicle was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the vehicle was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A reference to a Vehicle resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotfleetwise.VehicleReference getVehicleRef() {
        return software.amazon.jsii.Kernel.get(this, "vehicleRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iotfleetwise.VehicleReference.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a decoder manifest associated with the vehicle to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDecoderManifestArn() {
        return software.amazon.jsii.Kernel.get(this, "decoderManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a decoder manifest associated with the vehicle to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDecoderManifestArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "decoderManifestArn", java.util.Objects.requireNonNull(value, "decoderManifestArn is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the vehicle model (model manifest) to create the vehicle from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelManifestArn() {
        return software.amazon.jsii.Kernel.get(this, "modelManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the vehicle model (model manifest) to create the vehicle from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelManifestArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelManifestArn", java.util.Objects.requireNonNull(value, "modelManifestArn is required"));
    }

    /**
     * The unique ID of the vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * An option to create a new AWS IoT thing when creating a vehicle, or to validate an existing thing as a vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssociationBehavior() {
        return software.amazon.jsii.Kernel.get(this, "associationBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An option to create a new AWS IoT thing when creating a vehicle, or to validate an existing thing as a vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociationBehavior(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "associationBehavior", value);
    }

    /**
     * Static information about a vehicle in a key-value pair.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Static information about a vehicle in a key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * Static information about a vehicle in a key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * Associate state templates to track the state of the vehicle.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotfleetwise.CfnVehicle.StateTemplateAssociationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStateTemplates() {
        return software.amazon.jsii.Kernel.get(this, "stateTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Associate state templates to track the state of the vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStateTemplates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stateTemplates", value);
    }

    /**
     * Associate state templates to track the state of the vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStateTemplates(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnVehicle.StateTemplateAssociationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotfleetwise.CfnVehicle.StateTemplateAssociationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "stateTemplates", value);
    }

    /**
     * Metadata which can be used to manage the vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata which can be used to manage the vehicle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Vehicles associated with the state template will stream telemetry data during a specified time period.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * PeriodicStateTemplateUpdateStrategyProperty periodicStateTemplateUpdateStrategyProperty = PeriodicStateTemplateUpdateStrategyProperty.builder()
     *         .stateTemplateUpdateRate(TimePeriodProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-periodicstatetemplateupdatestrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-periodicstatetemplateupdatestrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnVehicle.PeriodicStateTemplateUpdateStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(PeriodicStateTemplateUpdateStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PeriodicStateTemplateUpdateStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotfleetwise.CfnVehicle.TimePeriodProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-periodicstatetemplateupdatestrategy.html#cfn-iotfleetwise-vehicle-periodicstatetemplateupdatestrategy-statetemplateupdaterate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-periodicstatetemplateupdatestrategy.html#cfn-iotfleetwise-vehicle-periodicstatetemplateupdatestrategy-statetemplateupdaterate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStateTemplateUpdateRate();

        /**
         * @return a {@link Builder} of {@link PeriodicStateTemplateUpdateStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PeriodicStateTemplateUpdateStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PeriodicStateTemplateUpdateStrategyProperty> {
            java.lang.Object stateTemplateUpdateRate;

            /**
             * Sets the value of {@link PeriodicStateTemplateUpdateStrategyProperty#getStateTemplateUpdateRate}
             * @param stateTemplateUpdateRate the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateTemplateUpdateRate(software.amazon.awscdk.IResolvable stateTemplateUpdateRate) {
                this.stateTemplateUpdateRate = stateTemplateUpdateRate;
                return this;
            }

            /**
             * Sets the value of {@link PeriodicStateTemplateUpdateStrategyProperty#getStateTemplateUpdateRate}
             * @param stateTemplateUpdateRate the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateTemplateUpdateRate(software.amazon.awscdk.services.iotfleetwise.CfnVehicle.TimePeriodProperty stateTemplateUpdateRate) {
                this.stateTemplateUpdateRate = stateTemplateUpdateRate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PeriodicStateTemplateUpdateStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PeriodicStateTemplateUpdateStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PeriodicStateTemplateUpdateStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PeriodicStateTemplateUpdateStrategyProperty {
            private final java.lang.Object stateTemplateUpdateRate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stateTemplateUpdateRate = software.amazon.jsii.Kernel.get(this, "stateTemplateUpdateRate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateTemplateUpdateRate = java.util.Objects.requireNonNull(builder.stateTemplateUpdateRate, "stateTemplateUpdateRate is required");
            }

            @Override
            public final java.lang.Object getStateTemplateUpdateRate() {
                return this.stateTemplateUpdateRate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stateTemplateUpdateRate", om.valueToTree(this.getStateTemplateUpdateRate()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnVehicle.PeriodicStateTemplateUpdateStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PeriodicStateTemplateUpdateStrategyProperty.Jsii$Proxy that = (PeriodicStateTemplateUpdateStrategyProperty.Jsii$Proxy) o;

                return this.stateTemplateUpdateRate.equals(that.stateTemplateUpdateRate);
            }

            @Override
            public final int hashCode() {
                int result = this.stateTemplateUpdateRate.hashCode();
                return result;
            }
        }
    }
    /**
     * The state template associated with a vehicle.
     * <p>
     * State templates contain state properties, which are signals that belong to a signal catalog that is synchronized between the AWS IoT FleetWise Edge and the AWS Cloud .
     * <p>
     * <blockquote>
     * <p>
     * Access to certain AWS IoT FleetWise features is currently gated. For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">AWS Region and feature availability</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object onChange;
     * StateTemplateAssociationProperty stateTemplateAssociationProperty = StateTemplateAssociationProperty.builder()
     *         .identifier("identifier")
     *         .stateTemplateUpdateStrategy(StateTemplateUpdateStrategyProperty.builder()
     *                 .onChange(onChange)
     *                 .periodic(PeriodicStateTemplateUpdateStrategyProperty.builder()
     *                         .stateTemplateUpdateRate(TimePeriodProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateassociation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnVehicle.StateTemplateAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(StateTemplateAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StateTemplateAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique ID of the state template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateassociation.html#cfn-iotfleetwise-vehicle-statetemplateassociation-identifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateassociation.html#cfn-iotfleetwise-vehicle-statetemplateassociation-identifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotfleetwise.CfnVehicle.StateTemplateUpdateStrategyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateassociation.html#cfn-iotfleetwise-vehicle-statetemplateassociation-statetemplateupdatestrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateassociation.html#cfn-iotfleetwise-vehicle-statetemplateassociation-statetemplateupdatestrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStateTemplateUpdateStrategy();

        /**
         * @return a {@link Builder} of {@link StateTemplateAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateTemplateAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StateTemplateAssociationProperty> {
            java.lang.String identifier;
            java.lang.Object stateTemplateUpdateStrategy;

            /**
             * Sets the value of {@link StateTemplateAssociationProperty#getIdentifier}
             * @param identifier The unique ID of the state template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifier(java.lang.String identifier) {
                this.identifier = identifier;
                return this;
            }

            /**
             * Sets the value of {@link StateTemplateAssociationProperty#getStateTemplateUpdateStrategy}
             * @param stateTemplateUpdateStrategy the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateTemplateUpdateStrategy(software.amazon.awscdk.IResolvable stateTemplateUpdateStrategy) {
                this.stateTemplateUpdateStrategy = stateTemplateUpdateStrategy;
                return this;
            }

            /**
             * Sets the value of {@link StateTemplateAssociationProperty#getStateTemplateUpdateStrategy}
             * @param stateTemplateUpdateStrategy the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateTemplateUpdateStrategy(software.amazon.awscdk.services.iotfleetwise.CfnVehicle.StateTemplateUpdateStrategyProperty stateTemplateUpdateStrategy) {
                this.stateTemplateUpdateStrategy = stateTemplateUpdateStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateTemplateAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StateTemplateAssociationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StateTemplateAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateTemplateAssociationProperty {
            private final java.lang.String identifier;
            private final java.lang.Object stateTemplateUpdateStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stateTemplateUpdateStrategy = software.amazon.jsii.Kernel.get(this, "stateTemplateUpdateStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
                this.stateTemplateUpdateStrategy = java.util.Objects.requireNonNull(builder.stateTemplateUpdateStrategy, "stateTemplateUpdateStrategy is required");
            }

            @Override
            public final java.lang.String getIdentifier() {
                return this.identifier;
            }

            @Override
            public final java.lang.Object getStateTemplateUpdateStrategy() {
                return this.stateTemplateUpdateStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identifier", om.valueToTree(this.getIdentifier()));
                data.set("stateTemplateUpdateStrategy", om.valueToTree(this.getStateTemplateUpdateStrategy()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnVehicle.StateTemplateAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateTemplateAssociationProperty.Jsii$Proxy that = (StateTemplateAssociationProperty.Jsii$Proxy) o;

                if (!identifier.equals(that.identifier)) return false;
                return this.stateTemplateUpdateStrategy.equals(that.stateTemplateUpdateStrategy);
            }

            @Override
            public final int hashCode() {
                int result = this.identifier.hashCode();
                result = 31 * result + (this.stateTemplateUpdateStrategy.hashCode());
                return result;
            }
        }
    }
    /**
     * The update strategy for the state template.
     * <p>
     * Vehicles associated with the state template can stream telemetry data with either an <code>onChange</code> or <code>periodic</code> update strategy.
     * <p>
     * <blockquote>
     * <p>
     * Access to certain AWS IoT FleetWise features is currently gated. For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">AWS Region and feature availability</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * Object onChange;
     * StateTemplateUpdateStrategyProperty stateTemplateUpdateStrategyProperty = StateTemplateUpdateStrategyProperty.builder()
     *         .onChange(onChange)
     *         .periodic(PeriodicStateTemplateUpdateStrategyProperty.builder()
     *                 .stateTemplateUpdateRate(TimePeriodProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateupdatestrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateupdatestrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnVehicle.StateTemplateUpdateStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(StateTemplateUpdateStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StateTemplateUpdateStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateupdatestrategy.html#cfn-iotfleetwise-vehicle-statetemplateupdatestrategy-onchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateupdatestrategy.html#cfn-iotfleetwise-vehicle-statetemplateupdatestrategy-onchange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnChange() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotfleetwise.CfnVehicle.PeriodicStateTemplateUpdateStrategyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateupdatestrategy.html#cfn-iotfleetwise-vehicle-statetemplateupdatestrategy-periodic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-statetemplateupdatestrategy.html#cfn-iotfleetwise-vehicle-statetemplateupdatestrategy-periodic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPeriodic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StateTemplateUpdateStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateTemplateUpdateStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StateTemplateUpdateStrategyProperty> {
            java.lang.Object onChange;
            java.lang.Object periodic;

            /**
             * Sets the value of {@link StateTemplateUpdateStrategyProperty#getOnChange}
             * @param onChange the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onChange(java.lang.Object onChange) {
                this.onChange = onChange;
                return this;
            }

            /**
             * Sets the value of {@link StateTemplateUpdateStrategyProperty#getPeriodic}
             * @param periodic the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodic(software.amazon.awscdk.IResolvable periodic) {
                this.periodic = periodic;
                return this;
            }

            /**
             * Sets the value of {@link StateTemplateUpdateStrategyProperty#getPeriodic}
             * @param periodic the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodic(software.amazon.awscdk.services.iotfleetwise.CfnVehicle.PeriodicStateTemplateUpdateStrategyProperty periodic) {
                this.periodic = periodic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateTemplateUpdateStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StateTemplateUpdateStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StateTemplateUpdateStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateTemplateUpdateStrategyProperty {
            private final java.lang.Object onChange;
            private final java.lang.Object periodic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onChange = software.amazon.jsii.Kernel.get(this, "onChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.periodic = software.amazon.jsii.Kernel.get(this, "periodic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onChange = builder.onChange;
                this.periodic = builder.periodic;
            }

            @Override
            public final java.lang.Object getOnChange() {
                return this.onChange;
            }

            @Override
            public final java.lang.Object getPeriodic() {
                return this.periodic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOnChange() != null) {
                    data.set("onChange", om.valueToTree(this.getOnChange()));
                }
                if (this.getPeriodic() != null) {
                    data.set("periodic", om.valueToTree(this.getPeriodic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnVehicle.StateTemplateUpdateStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateTemplateUpdateStrategyProperty.Jsii$Proxy that = (StateTemplateUpdateStrategyProperty.Jsii$Proxy) o;

                if (this.onChange != null ? !this.onChange.equals(that.onChange) : that.onChange != null) return false;
                return this.periodic != null ? this.periodic.equals(that.periodic) : that.periodic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.onChange != null ? this.onChange.hashCode() : 0;
                result = 31 * result + (this.periodic != null ? this.periodic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The length of time between state template updates.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * TimePeriodProperty timePeriodProperty = TimePeriodProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-timeperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-timeperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnVehicle.TimePeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(TimePeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimePeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unit of time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-timeperiod.html#cfn-iotfleetwise-vehicle-timeperiod-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-timeperiod.html#cfn-iotfleetwise-vehicle-timeperiod-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * A number of time units.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-timeperiod.html#cfn-iotfleetwise-vehicle-timeperiod-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-vehicle-timeperiod.html#cfn-iotfleetwise-vehicle-timeperiod-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link TimePeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimePeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimePeriodProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link TimePeriodProperty#getUnit}
             * @param unit A unit of time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link TimePeriodProperty#getValue}
             * @param value A number of time units. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimePeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimePeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimePeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimePeriodProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnVehicle.TimePeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimePeriodProperty.Jsii$Proxy that = (TimePeriodProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotfleetwise.CfnVehicle}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotfleetwise.CfnVehicle> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotfleetwise.CfnVehicleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotfleetwise.CfnVehicleProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of a decoder manifest associated with the vehicle to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-decodermanifestarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-decodermanifestarn</a>
         * @param decoderManifestArn The Amazon Resource Name (ARN) of a decoder manifest associated with the vehicle to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder decoderManifestArn(final java.lang.String decoderManifestArn) {
            this.props.decoderManifestArn(decoderManifestArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the vehicle model (model manifest) to create the vehicle from.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-modelmanifestarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-modelmanifestarn</a>
         * @param modelManifestArn The Amazon Resource Name (ARN) of the vehicle model (model manifest) to create the vehicle from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestArn(final java.lang.String modelManifestArn) {
            this.props.modelManifestArn(modelManifestArn);
            return this;
        }

        /**
         * The unique ID of the vehicle.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-name</a>
         * @param name The unique ID of the vehicle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An option to create a new AWS IoT thing when creating a vehicle, or to validate an existing thing as a vehicle.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-associationbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-associationbehavior</a>
         * @param associationBehavior An option to create a new AWS IoT thing when creating a vehicle, or to validate an existing thing as a vehicle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationBehavior(final java.lang.String associationBehavior) {
            this.props.associationBehavior(associationBehavior);
            return this;
        }

        /**
         * Static information about a vehicle in a key-value pair.
         * <p>
         * For example: <code>"engine Type"</code> : <code>"v6"</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes</a>
         * @param attributes Static information about a vehicle in a key-value pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.props.attributes(attributes);
            return this;
        }
        /**
         * Static information about a vehicle in a key-value pair.
         * <p>
         * For example: <code>"engine Type"</code> : <code>"v6"</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes</a>
         * @param attributes Static information about a vehicle in a key-value pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.IResolvable attributes) {
            this.props.attributes(attributes);
            return this;
        }

        /**
         * Associate state templates to track the state of the vehicle.
         * <p>
         * State templates determine which signal updates the vehicle sends to the cloud.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-statetemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-statetemplates</a>
         * @param stateTemplates Associate state templates to track the state of the vehicle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateTemplates(final software.amazon.awscdk.IResolvable stateTemplates) {
            this.props.stateTemplates(stateTemplates);
            return this;
        }
        /**
         * Associate state templates to track the state of the vehicle.
         * <p>
         * State templates determine which signal updates the vehicle sends to the cloud.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-statetemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-statetemplates</a>
         * @param stateTemplates Associate state templates to track the state of the vehicle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateTemplates(final java.util.List<? extends java.lang.Object> stateTemplates) {
            this.props.stateTemplates(stateTemplates);
            return this;
        }

        /**
         * Metadata which can be used to manage the vehicle.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-tags</a>
         * @param tags Metadata which can be used to manage the vehicle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotfleetwise.CfnVehicle}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotfleetwise.CfnVehicle build() {
            return new software.amazon.awscdk.services.iotfleetwise.CfnVehicle(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
