package software.amazon.awscdk.services.iotsitewise;

/**
 * Create a computation model with a configuration and data binding.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * ComputationModelDataBindingValueProperty computationModelDataBindingValueProperty_;
 * CfnComputationModel cfnComputationModel = CfnComputationModel.Builder.create(this, "MyCfnComputationModel")
 *         .computationModelConfiguration(ComputationModelConfigurationProperty.builder()
 *                 .anomalyDetection(AnomalyDetectionComputationModelConfigurationProperty.builder()
 *                         .inputProperties("inputProperties")
 *                         .resultProperty("resultProperty")
 *                         .build())
 *                 .build())
 *         .computationModelDataBinding(Map.of(
 *                 "computationModelDataBindingKey", ComputationModelDataBindingValueProperty.builder()
 *                         .assetModelProperty(AssetModelPropertyBindingValueProperty.builder()
 *                                 .assetModelId("assetModelId")
 *                                 .propertyId("propertyId")
 *                                 .build())
 *                         .assetProperty(AssetPropertyBindingValueProperty.builder()
 *                                 .assetId("assetId")
 *                                 .propertyId("propertyId")
 *                                 .build())
 *                         .list(List.of(computationModelDataBindingValueProperty_))
 *                         .build()))
 *         .computationModelName("computationModelName")
 *         // the properties below are optional
 *         .computationModelDescription("computationModelDescription")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.799Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnComputationModel")
public class CfnComputationModel extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.iotsitewise.IComputationModelRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnComputationModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComputationModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::IoTSiteWise::ComputationModel</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComputationModel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnComputationModelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForComputationModel(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotsitewise.IComputationModelRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.class, "arnForComputationModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new IComputationModelRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotsitewise.IComputationModelRef fromComputationModelArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.class, "fromComputationModelArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iotsitewise.IComputationModelRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new IComputationModelRef from a computationModelId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param computationModelId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotsitewise.IComputationModelRef fromComputationModelId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String computationModelId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.class, "fromComputationModelId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iotsitewise.IComputationModelRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(computationModelId, "computationModelId is required") });
    }

    /**
     * Checks whether the given object is a CfnComputationModel.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnComputationModel(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.class, "isCfnComputationModel", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the computation model, which has the following format.
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComputationModelArn() {
        return software.amazon.jsii.Kernel.get(this, "attrComputationModelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComputationModelId() {
        return software.amazon.jsii.Kernel.get(this, "attrComputationModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ComputationModel resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotsitewise.ComputationModelReference getComputationModelRef() {
        return software.amazon.jsii.Kernel.get(this, "computationModelRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iotsitewise.ComputationModelReference.class));
    }

    /**
     * The configuration for the computation model.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getComputationModelConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "computationModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputationModelConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "computationModelConfiguration", java.util.Objects.requireNonNull(value, "computationModelConfiguration is required"));
    }

    /**
     * The configuration for the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputationModelConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "computationModelConfiguration", java.util.Objects.requireNonNull(value, "computationModelConfiguration is required"));
    }

    /**
     * The data binding for the computation model.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelDataBindingValueProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getComputationModelDataBinding() {
        return software.amazon.jsii.Kernel.get(this, "computationModelDataBinding", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The data binding for the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputationModelDataBinding(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "computationModelDataBinding", java.util.Objects.requireNonNull(value, "computationModelDataBinding is required"));
    }

    /**
     * The data binding for the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputationModelDataBinding(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelDataBindingValueProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelDataBindingValueProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "computationModelDataBinding", java.util.Objects.requireNonNull(value, "computationModelDataBinding is required"));
    }

    /**
     * The name of the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputationModelName() {
        return software.amazon.jsii.Kernel.get(this, "computationModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputationModelName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "computationModelName", java.util.Objects.requireNonNull(value, "computationModelName is required"));
    }

    /**
     * The description of the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComputationModelDescription() {
        return software.amazon.jsii.Kernel.get(this, "computationModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the computation model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputationModelDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "computationModelDescription", value);
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains the configuration for anomaly detection computation models.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AnomalyDetectionComputationModelConfigurationProperty anomalyDetectionComputationModelConfigurationProperty = AnomalyDetectionComputationModelConfigurationProperty.builder()
     *         .inputProperties("inputProperties")
     *         .resultProperty("resultProperty")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnComputationModel.AnomalyDetectionComputationModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnomalyDetectionComputationModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnomalyDetectionComputationModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of input properties for the anomaly detection model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration.html#cfn-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration-inputproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration.html#cfn-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration-inputproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputProperties();

        /**
         * The property where the anomaly detection results will be stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration.html#cfn-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration-resultproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration.html#cfn-iotsitewise-computationmodel-anomalydetectioncomputationmodelconfiguration-resultproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResultProperty();

        /**
         * @return a {@link Builder} of {@link AnomalyDetectionComputationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnomalyDetectionComputationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnomalyDetectionComputationModelConfigurationProperty> {
            java.lang.String inputProperties;
            java.lang.String resultProperty;

            /**
             * Sets the value of {@link AnomalyDetectionComputationModelConfigurationProperty#getInputProperties}
             * @param inputProperties The list of input properties for the anomaly detection model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputProperties(java.lang.String inputProperties) {
                this.inputProperties = inputProperties;
                return this;
            }

            /**
             * Sets the value of {@link AnomalyDetectionComputationModelConfigurationProperty#getResultProperty}
             * @param resultProperty The property where the anomaly detection results will be stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultProperty(java.lang.String resultProperty) {
                this.resultProperty = resultProperty;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnomalyDetectionComputationModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnomalyDetectionComputationModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnomalyDetectionComputationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnomalyDetectionComputationModelConfigurationProperty {
            private final java.lang.String inputProperties;
            private final java.lang.String resultProperty;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputProperties = software.amazon.jsii.Kernel.get(this, "inputProperties", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resultProperty = software.amazon.jsii.Kernel.get(this, "resultProperty", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputProperties = java.util.Objects.requireNonNull(builder.inputProperties, "inputProperties is required");
                this.resultProperty = java.util.Objects.requireNonNull(builder.resultProperty, "resultProperty is required");
            }

            @Override
            public final java.lang.String getInputProperties() {
                return this.inputProperties;
            }

            @Override
            public final java.lang.String getResultProperty() {
                return this.resultProperty;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputProperties", om.valueToTree(this.getInputProperties()));
                data.set("resultProperty", om.valueToTree(this.getResultProperty()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnComputationModel.AnomalyDetectionComputationModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnomalyDetectionComputationModelConfigurationProperty.Jsii$Proxy that = (AnomalyDetectionComputationModelConfigurationProperty.Jsii$Proxy) o;

                if (!inputProperties.equals(that.inputProperties)) return false;
                return this.resultProperty.equals(that.resultProperty);
            }

            @Override
            public final int hashCode() {
                int result = this.inputProperties.hashCode();
                result = 31 * result + (this.resultProperty.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about an <code>assetModelProperty</code> binding value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetModelPropertyBindingValueProperty assetModelPropertyBindingValueProperty = AssetModelPropertyBindingValueProperty.builder()
     *         .assetModelId("assetModelId")
     *         .propertyId("propertyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetmodelpropertybindingvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetmodelpropertybindingvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnComputationModel.AssetModelPropertyBindingValueProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetModelPropertyBindingValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetModelPropertyBindingValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the asset model, in UUID format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetmodelpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetmodelpropertybindingvalue-assetmodelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetmodelpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetmodelpropertybindingvalue-assetmodelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAssetModelId();

        /**
         * The ID of the asset model property used in data binding value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetmodelpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetmodelpropertybindingvalue-propertyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetmodelpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetmodelpropertybindingvalue-propertyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPropertyId();

        /**
         * @return a {@link Builder} of {@link AssetModelPropertyBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetModelPropertyBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetModelPropertyBindingValueProperty> {
            java.lang.String assetModelId;
            java.lang.String propertyId;

            /**
             * Sets the value of {@link AssetModelPropertyBindingValueProperty#getAssetModelId}
             * @param assetModelId The ID of the asset model, in UUID format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetModelId(java.lang.String assetModelId) {
                this.assetModelId = assetModelId;
                return this;
            }

            /**
             * Sets the value of {@link AssetModelPropertyBindingValueProperty#getPropertyId}
             * @param propertyId The ID of the asset model property used in data binding value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyId(java.lang.String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetModelPropertyBindingValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetModelPropertyBindingValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetModelPropertyBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetModelPropertyBindingValueProperty {
            private final java.lang.String assetModelId;
            private final java.lang.String propertyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assetModelId = software.amazon.jsii.Kernel.get(this, "assetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyId = software.amazon.jsii.Kernel.get(this, "propertyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assetModelId = java.util.Objects.requireNonNull(builder.assetModelId, "assetModelId is required");
                this.propertyId = java.util.Objects.requireNonNull(builder.propertyId, "propertyId is required");
            }

            @Override
            public final java.lang.String getAssetModelId() {
                return this.assetModelId;
            }

            @Override
            public final java.lang.String getPropertyId() {
                return this.propertyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("assetModelId", om.valueToTree(this.getAssetModelId()));
                data.set("propertyId", om.valueToTree(this.getPropertyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnComputationModel.AssetModelPropertyBindingValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetModelPropertyBindingValueProperty.Jsii$Proxy that = (AssetModelPropertyBindingValueProperty.Jsii$Proxy) o;

                if (!assetModelId.equals(that.assetModelId)) return false;
                return this.propertyId.equals(that.propertyId);
            }

            @Override
            public final int hashCode() {
                int result = this.assetModelId.hashCode();
                result = 31 * result + (this.propertyId.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents a data binding value referencing a specific asset property.
     * <p>
     * It's used to bind computation model variables to actual asset property values for processing.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AssetPropertyBindingValueProperty assetPropertyBindingValueProperty = AssetPropertyBindingValueProperty.builder()
     *         .assetId("assetId")
     *         .propertyId("propertyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetpropertybindingvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetpropertybindingvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnComputationModel.AssetPropertyBindingValueProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyBindingValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyBindingValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the asset containing the property.
         * <p>
         * This identifies the specific asset instance's property value used in the computation model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetpropertybindingvalue-assetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetpropertybindingvalue-assetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAssetId();

        /**
         * The ID of the property within the asset.
         * <p>
         * This identifies the specific property's value used in the computation model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetpropertybindingvalue-propertyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-assetpropertybindingvalue.html#cfn-iotsitewise-computationmodel-assetpropertybindingvalue-propertyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPropertyId();

        /**
         * @return a {@link Builder} of {@link AssetPropertyBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyBindingValueProperty> {
            java.lang.String assetId;
            java.lang.String propertyId;

            /**
             * Sets the value of {@link AssetPropertyBindingValueProperty#getAssetId}
             * @param assetId The ID of the asset containing the property. This parameter is required.
             *                This identifies the specific asset instance's property value used in the computation model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetId(java.lang.String assetId) {
                this.assetId = assetId;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyBindingValueProperty#getPropertyId}
             * @param propertyId The ID of the property within the asset. This parameter is required.
             *                   This identifies the specific property's value used in the computation model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyId(java.lang.String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyBindingValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyBindingValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyBindingValueProperty {
            private final java.lang.String assetId;
            private final java.lang.String propertyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assetId = software.amazon.jsii.Kernel.get(this, "assetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyId = software.amazon.jsii.Kernel.get(this, "propertyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assetId = java.util.Objects.requireNonNull(builder.assetId, "assetId is required");
                this.propertyId = java.util.Objects.requireNonNull(builder.propertyId, "propertyId is required");
            }

            @Override
            public final java.lang.String getAssetId() {
                return this.assetId;
            }

            @Override
            public final java.lang.String getPropertyId() {
                return this.propertyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("assetId", om.valueToTree(this.getAssetId()));
                data.set("propertyId", om.valueToTree(this.getPropertyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnComputationModel.AssetPropertyBindingValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyBindingValueProperty.Jsii$Proxy that = (AssetPropertyBindingValueProperty.Jsii$Proxy) o;

                if (!assetId.equals(that.assetId)) return false;
                return this.propertyId.equals(that.propertyId);
            }

            @Override
            public final int hashCode() {
                int result = this.assetId.hashCode();
                result = 31 * result + (this.propertyId.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration for the computation model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * ComputationModelConfigurationProperty computationModelConfigurationProperty = ComputationModelConfigurationProperty.builder()
     *         .anomalyDetection(AnomalyDetectionComputationModelConfigurationProperty.builder()
     *                 .inputProperties("inputProperties")
     *                 .resultProperty("resultProperty")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnComputationModel.ComputationModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComputationModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComputationModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the anomaly detection type of computation model.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel.AnomalyDetectionComputationModelConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodelconfiguration.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration-anomalydetection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodelconfiguration.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration-anomalydetection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnomalyDetection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComputationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComputationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComputationModelConfigurationProperty> {
            java.lang.Object anomalyDetection;

            /**
             * Sets the value of {@link ComputationModelConfigurationProperty#getAnomalyDetection}
             * @param anomalyDetection The configuration for the anomaly detection type of computation model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anomalyDetection(software.amazon.awscdk.IResolvable anomalyDetection) {
                this.anomalyDetection = anomalyDetection;
                return this;
            }

            /**
             * Sets the value of {@link ComputationModelConfigurationProperty#getAnomalyDetection}
             * @param anomalyDetection The configuration for the anomaly detection type of computation model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anomalyDetection(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.AnomalyDetectionComputationModelConfigurationProperty anomalyDetection) {
                this.anomalyDetection = anomalyDetection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComputationModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComputationModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComputationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputationModelConfigurationProperty {
            private final java.lang.Object anomalyDetection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.anomalyDetection = software.amazon.jsii.Kernel.get(this, "anomalyDetection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.anomalyDetection = builder.anomalyDetection;
            }

            @Override
            public final java.lang.Object getAnomalyDetection() {
                return this.anomalyDetection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnomalyDetection() != null) {
                    data.set("anomalyDetection", om.valueToTree(this.getAnomalyDetection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnComputationModel.ComputationModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComputationModelConfigurationProperty.Jsii$Proxy that = (ComputationModelConfigurationProperty.Jsii$Proxy) o;

                return this.anomalyDetection != null ? this.anomalyDetection.equals(that.anomalyDetection) : that.anomalyDetection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.anomalyDetection != null ? this.anomalyDetection.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains computation model data binding value information, which can be one of <code>assetModelProperty</code> , <code>list</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * ComputationModelDataBindingValueProperty computationModelDataBindingValueProperty_;
     * ComputationModelDataBindingValueProperty computationModelDataBindingValueProperty = ComputationModelDataBindingValueProperty.builder()
     *         .assetModelProperty(AssetModelPropertyBindingValueProperty.builder()
     *                 .assetModelId("assetModelId")
     *                 .propertyId("propertyId")
     *                 .build())
     *         .assetProperty(AssetPropertyBindingValueProperty.builder()
     *                 .assetId("assetId")
     *                 .propertyId("propertyId")
     *                 .build())
     *         .list(List.of(computationModelDataBindingValueProperty_))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnComputationModel.ComputationModelDataBindingValueProperty")
    @software.amazon.jsii.Jsii.Proxy(ComputationModelDataBindingValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComputationModelDataBindingValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies an asset model property data binding value.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel.AssetModelPropertyBindingValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html#cfn-iotsitewise-computationmodel-computationmodeldatabindingvalue-assetmodelproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html#cfn-iotsitewise-computationmodel-computationmodeldatabindingvalue-assetmodelproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssetModelProperty() {
            return null;
        }

        /**
         * The asset property value used for computation model data binding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel.AssetPropertyBindingValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html#cfn-iotsitewise-computationmodel-computationmodeldatabindingvalue-assetproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html#cfn-iotsitewise-computationmodel-computationmodeldatabindingvalue-assetproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssetProperty() {
            return null;
        }

        /**
         * Specifies a list of data binding value.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelDataBindingValueProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html#cfn-iotsitewise-computationmodel-computationmodeldatabindingvalue-list">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-computationmodel-computationmodeldatabindingvalue.html#cfn-iotsitewise-computationmodel-computationmodeldatabindingvalue-list</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComputationModelDataBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComputationModelDataBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComputationModelDataBindingValueProperty> {
            java.lang.Object assetModelProperty;
            java.lang.Object assetProperty;
            java.lang.Object list;

            /**
             * Sets the value of {@link ComputationModelDataBindingValueProperty#getAssetModelProperty}
             * @param assetModelProperty Specifies an asset model property data binding value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetModelProperty(software.amazon.awscdk.IResolvable assetModelProperty) {
                this.assetModelProperty = assetModelProperty;
                return this;
            }

            /**
             * Sets the value of {@link ComputationModelDataBindingValueProperty#getAssetModelProperty}
             * @param assetModelProperty Specifies an asset model property data binding value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetModelProperty(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.AssetModelPropertyBindingValueProperty assetModelProperty) {
                this.assetModelProperty = assetModelProperty;
                return this;
            }

            /**
             * Sets the value of {@link ComputationModelDataBindingValueProperty#getAssetProperty}
             * @param assetProperty The asset property value used for computation model data binding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetProperty(software.amazon.awscdk.IResolvable assetProperty) {
                this.assetProperty = assetProperty;
                return this;
            }

            /**
             * Sets the value of {@link ComputationModelDataBindingValueProperty#getAssetProperty}
             * @param assetProperty The asset property value used for computation model data binding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetProperty(software.amazon.awscdk.services.iotsitewise.CfnComputationModel.AssetPropertyBindingValueProperty assetProperty) {
                this.assetProperty = assetProperty;
                return this;
            }

            /**
             * Sets the value of {@link ComputationModelDataBindingValueProperty#getList}
             * @param list Specifies a list of data binding value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder list(software.amazon.awscdk.IResolvable list) {
                this.list = list;
                return this;
            }

            /**
             * Sets the value of {@link ComputationModelDataBindingValueProperty#getList}
             * @param list Specifies a list of data binding value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder list(java.util.List<? extends java.lang.Object> list) {
                this.list = list;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComputationModelDataBindingValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComputationModelDataBindingValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComputationModelDataBindingValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputationModelDataBindingValueProperty {
            private final java.lang.Object assetModelProperty;
            private final java.lang.Object assetProperty;
            private final java.lang.Object list;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assetModelProperty = software.amazon.jsii.Kernel.get(this, "assetModelProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.assetProperty = software.amazon.jsii.Kernel.get(this, "assetProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.list = software.amazon.jsii.Kernel.get(this, "list", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assetModelProperty = builder.assetModelProperty;
                this.assetProperty = builder.assetProperty;
                this.list = builder.list;
            }

            @Override
            public final java.lang.Object getAssetModelProperty() {
                return this.assetModelProperty;
            }

            @Override
            public final java.lang.Object getAssetProperty() {
                return this.assetProperty;
            }

            @Override
            public final java.lang.Object getList() {
                return this.list;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssetModelProperty() != null) {
                    data.set("assetModelProperty", om.valueToTree(this.getAssetModelProperty()));
                }
                if (this.getAssetProperty() != null) {
                    data.set("assetProperty", om.valueToTree(this.getAssetProperty()));
                }
                if (this.getList() != null) {
                    data.set("list", om.valueToTree(this.getList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnComputationModel.ComputationModelDataBindingValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComputationModelDataBindingValueProperty.Jsii$Proxy that = (ComputationModelDataBindingValueProperty.Jsii$Proxy) o;

                if (this.assetModelProperty != null ? !this.assetModelProperty.equals(that.assetModelProperty) : that.assetModelProperty != null) return false;
                if (this.assetProperty != null ? !this.assetProperty.equals(that.assetProperty) : that.assetProperty != null) return false;
                return this.list != null ? this.list.equals(that.list) : that.list == null;
            }

            @Override
            public final int hashCode() {
                int result = this.assetModelProperty != null ? this.assetModelProperty.hashCode() : 0;
                result = 31 * result + (this.assetProperty != null ? this.assetProperty.hashCode() : 0);
                result = 31 * result + (this.list != null ? this.list.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotsitewise.CfnComputationModel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotsitewise.CfnComputationModelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotsitewise.CfnComputationModelProps.Builder();
        }

        /**
         * The configuration for the computation model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration</a>
         * @param computationModelConfiguration The configuration for the computation model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelConfiguration(final software.amazon.awscdk.IResolvable computationModelConfiguration) {
            this.props.computationModelConfiguration(computationModelConfiguration);
            return this;
        }
        /**
         * The configuration for the computation model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelconfiguration</a>
         * @param computationModelConfiguration The configuration for the computation model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelConfiguration(final software.amazon.awscdk.services.iotsitewise.CfnComputationModel.ComputationModelConfigurationProperty computationModelConfiguration) {
            this.props.computationModelConfiguration(computationModelConfiguration);
            return this;
        }

        /**
         * The data binding for the computation model.
         * <p>
         * Key is a variable name defined in configuration. Value is a <code>ComputationModelDataBindingValue</code> referenced by the variable.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldatabinding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldatabinding</a>
         * @param computationModelDataBinding The data binding for the computation model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelDataBinding(final software.amazon.awscdk.IResolvable computationModelDataBinding) {
            this.props.computationModelDataBinding(computationModelDataBinding);
            return this;
        }
        /**
         * The data binding for the computation model.
         * <p>
         * Key is a variable name defined in configuration. Value is a <code>ComputationModelDataBindingValue</code> referenced by the variable.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldatabinding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldatabinding</a>
         * @param computationModelDataBinding The data binding for the computation model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelDataBinding(final java.util.Map<java.lang.String, ? extends java.lang.Object> computationModelDataBinding) {
            this.props.computationModelDataBinding(computationModelDataBinding);
            return this;
        }

        /**
         * The name of the computation model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodelname</a>
         * @param computationModelName The name of the computation model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelName(final java.lang.String computationModelName) {
            this.props.computationModelName(computationModelName);
            return this;
        }

        /**
         * The description of the computation model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-computationmodeldescription</a>
         * @param computationModelDescription The description of the computation model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationModelDescription(final java.lang.String computationModelDescription) {
            this.props.computationModelDescription(computationModelDescription);
            return this;
        }

        /**
         * A list of key-value pairs that contain metadata for the asset.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-computationmodel.html#cfn-iotsitewise-computationmodel-tags</a>
         * @param tags A list of key-value pairs that contain metadata for the asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotsitewise.CfnComputationModel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotsitewise.CfnComputationModel build() {
            return new software.amazon.awscdk.services.iotsitewise.CfnComputationModel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
