package software.amazon.awscdk.services.iotwireless;

/**
 * Creates a new device profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnDeviceProfile cfnDeviceProfile = CfnDeviceProfile.Builder.create(this, "MyCfnDeviceProfile")
 *         .loRaWan(LoRaWANDeviceProfileProperty.builder()
 *                 .classBTimeout(123)
 *                 .classCTimeout(123)
 *                 .factoryPresetFreqsList(List.of(123))
 *                 .macVersion("macVersion")
 *                 .maxDutyCycle(123)
 *                 .maxEirp(123)
 *                 .pingSlotDr(123)
 *                 .pingSlotFreq(123)
 *                 .pingSlotPeriod(123)
 *                 .regParamsRevision("regParamsRevision")
 *                 .rfRegion("rfRegion")
 *                 .rxDataRate2(123)
 *                 .rxDelay1(123)
 *                 .rxDrOffset1(123)
 *                 .rxFreq2(123)
 *                 .supports32BitFCnt(false)
 *                 .supportsClassB(false)
 *                 .supportsClassC(false)
 *                 .supportsJoin(false)
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:22.860Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnDeviceProfile")
public class CfnDeviceProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.iotwireless.IDeviceProfileRef, software.amazon.awscdk.ITaggable {

    protected CfnDeviceProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeviceProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::IoTWireless::DeviceProfile</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeviceProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnDeviceProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::IoTWireless::DeviceProfile</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeviceProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForDeviceProfile(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotwireless.IDeviceProfileRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.class, "arnForDeviceProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new IDeviceProfileRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotwireless.IDeviceProfileRef fromDeviceProfileArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.class, "fromDeviceProfileArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iotwireless.IDeviceProfileRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new IDeviceProfileRef from a deviceProfileId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param deviceProfileId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotwireless.IDeviceProfileRef fromDeviceProfileId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String deviceProfileId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.class, "fromDeviceProfileId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iotwireless.IDeviceProfileRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(deviceProfileId, "deviceProfileId is required") });
    }

    /**
     * Checks whether the given object is a CfnDeviceProfile.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnDeviceProfile(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.class, "isCfnDeviceProfile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the device profile created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the device profile created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a DeviceProfile resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iotwireless.DeviceProfileReference getDeviceProfileRef() {
        return software.amazon.jsii.Kernel.get(this, "deviceProfileRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iotwireless.DeviceProfileReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * LoRaWAN device profile object.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.LoRaWANDeviceProfileProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoRaWan() {
        return software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * LoRaWAN device profile object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWan(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loRaWan", value);
    }

    /**
     * LoRaWAN device profile object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWan(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.LoRaWANDeviceProfileProperty value) {
        software.amazon.jsii.Kernel.set(this, "loRaWan", value);
    }

    /**
     * The name of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * LoRaWAN device profile object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * LoRaWANDeviceProfileProperty loRaWANDeviceProfileProperty = LoRaWANDeviceProfileProperty.builder()
     *         .classBTimeout(123)
     *         .classCTimeout(123)
     *         .factoryPresetFreqsList(List.of(123))
     *         .macVersion("macVersion")
     *         .maxDutyCycle(123)
     *         .maxEirp(123)
     *         .pingSlotDr(123)
     *         .pingSlotFreq(123)
     *         .pingSlotPeriod(123)
     *         .regParamsRevision("regParamsRevision")
     *         .rfRegion("rfRegion")
     *         .rxDataRate2(123)
     *         .rxDelay1(123)
     *         .rxDrOffset1(123)
     *         .rxFreq2(123)
     *         .supports32BitFCnt(false)
     *         .supportsClassB(false)
     *         .supportsClassC(false)
     *         .supportsJoin(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnDeviceProfile.LoRaWANDeviceProfileProperty")
    @software.amazon.jsii.Jsii.Proxy(LoRaWANDeviceProfileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoRaWANDeviceProfileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ClassBTimeout value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classbtimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classbtimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getClassBTimeout() {
            return null;
        }

        /**
         * The ClassCTimeout value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classctimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classctimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getClassCTimeout() {
            return null;
        }

        /**
         * The list of values that make up the FactoryPresetFreqs value.
         * <p>
         * Valid range of values include a minimum value of 1000000 and a maximum value of 16700000.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-factorypresetfreqslist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-factorypresetfreqslist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFactoryPresetFreqsList() {
            return null;
        }

        /**
         * The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-macversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-macversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMacVersion() {
            return null;
        }

        /**
         * The MaxDutyCycle value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxdutycycle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxdutycycle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDutyCycle() {
            return null;
        }

        /**
         * The MaxEIRP value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxeirp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxeirp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxEirp() {
            return null;
        }

        /**
         * The PingSlotDR value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotdr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotdr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPingSlotDr() {
            return null;
        }

        /**
         * The PingSlotFreq value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotfreq">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotfreq</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPingSlotFreq() {
            return null;
        }

        /**
         * The PingSlotPeriod value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPingSlotPeriod() {
            return null;
        }

        /**
         * The version of regional parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-regparamsrevision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-regparamsrevision</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegParamsRevision() {
            return null;
        }

        /**
         * The frequency band (RFRegion) value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rfregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rfregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRfRegion() {
            return null;
        }

        /**
         * The RXDataRate2 value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxdatarate2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxdatarate2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRxDataRate2() {
            return null;
        }

        /**
         * The RXDelay1 value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxdelay1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxdelay1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRxDelay1() {
            return null;
        }

        /**
         * The RXDROffset1 value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxdroffset1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxdroffset1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRxDrOffset1() {
            return null;
        }

        /**
         * The RXFreq2 value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxfreq2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rxfreq2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRxFreq2() {
            return null;
        }

        /**
         * The Supports32BitFCnt value.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supports32bitfcnt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supports32bitfcnt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSupports32BitFCnt() {
            return null;
        }

        /**
         * The SupportsClassB value.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSupportsClassB() {
            return null;
        }

        /**
         * The SupportsClassC value.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSupportsClassC() {
            return null;
        }

        /**
         * The SupportsJoin value.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsjoin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsjoin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSupportsJoin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoRaWANDeviceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoRaWANDeviceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoRaWANDeviceProfileProperty> {
            java.lang.Number classBTimeout;
            java.lang.Number classCTimeout;
            java.lang.Object factoryPresetFreqsList;
            java.lang.String macVersion;
            java.lang.Number maxDutyCycle;
            java.lang.Number maxEirp;
            java.lang.Number pingSlotDr;
            java.lang.Number pingSlotFreq;
            java.lang.Number pingSlotPeriod;
            java.lang.String regParamsRevision;
            java.lang.String rfRegion;
            java.lang.Number rxDataRate2;
            java.lang.Number rxDelay1;
            java.lang.Number rxDrOffset1;
            java.lang.Number rxFreq2;
            java.lang.Object supports32BitFCnt;
            java.lang.Object supportsClassB;
            java.lang.Object supportsClassC;
            java.lang.Object supportsJoin;

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getClassBTimeout}
             * @param classBTimeout The ClassBTimeout value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classBTimeout(java.lang.Number classBTimeout) {
                this.classBTimeout = classBTimeout;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getClassCTimeout}
             * @param classCTimeout The ClassCTimeout value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classCTimeout(java.lang.Number classCTimeout) {
                this.classCTimeout = classCTimeout;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getFactoryPresetFreqsList}
             * @param factoryPresetFreqsList The list of values that make up the FactoryPresetFreqs value.
             *                               Valid range of values include a minimum value of 1000000 and a maximum value of 16700000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder factoryPresetFreqsList(java.util.List<? extends java.lang.Number> factoryPresetFreqsList) {
                this.factoryPresetFreqsList = factoryPresetFreqsList;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getFactoryPresetFreqsList}
             * @param factoryPresetFreqsList The list of values that make up the FactoryPresetFreqs value.
             *                               Valid range of values include a minimum value of 1000000 and a maximum value of 16700000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder factoryPresetFreqsList(software.amazon.awscdk.IResolvable factoryPresetFreqsList) {
                this.factoryPresetFreqsList = factoryPresetFreqsList;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getMacVersion}
             * @param macVersion The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder macVersion(java.lang.String macVersion) {
                this.macVersion = macVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getMaxDutyCycle}
             * @param maxDutyCycle The MaxDutyCycle value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxDutyCycle(java.lang.Number maxDutyCycle) {
                this.maxDutyCycle = maxDutyCycle;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getMaxEirp}
             * @param maxEirp The MaxEIRP value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxEirp(java.lang.Number maxEirp) {
                this.maxEirp = maxEirp;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getPingSlotDr}
             * @param pingSlotDr The PingSlotDR value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pingSlotDr(java.lang.Number pingSlotDr) {
                this.pingSlotDr = pingSlotDr;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getPingSlotFreq}
             * @param pingSlotFreq The PingSlotFreq value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pingSlotFreq(java.lang.Number pingSlotFreq) {
                this.pingSlotFreq = pingSlotFreq;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getPingSlotPeriod}
             * @param pingSlotPeriod The PingSlotPeriod value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pingSlotPeriod(java.lang.Number pingSlotPeriod) {
                this.pingSlotPeriod = pingSlotPeriod;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getRegParamsRevision}
             * @param regParamsRevision The version of regional parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regParamsRevision(java.lang.String regParamsRevision) {
                this.regParamsRevision = regParamsRevision;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getRfRegion}
             * @param rfRegion The frequency band (RFRegion) value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rfRegion(java.lang.String rfRegion) {
                this.rfRegion = rfRegion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getRxDataRate2}
             * @param rxDataRate2 The RXDataRate2 value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rxDataRate2(java.lang.Number rxDataRate2) {
                this.rxDataRate2 = rxDataRate2;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getRxDelay1}
             * @param rxDelay1 The RXDelay1 value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rxDelay1(java.lang.Number rxDelay1) {
                this.rxDelay1 = rxDelay1;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getRxDrOffset1}
             * @param rxDrOffset1 The RXDROffset1 value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rxDrOffset1(java.lang.Number rxDrOffset1) {
                this.rxDrOffset1 = rxDrOffset1;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getRxFreq2}
             * @param rxFreq2 The RXFreq2 value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rxFreq2(java.lang.Number rxFreq2) {
                this.rxFreq2 = rxFreq2;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupports32BitFCnt}
             * @param supports32BitFCnt The Supports32BitFCnt value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supports32BitFCnt(java.lang.Boolean supports32BitFCnt) {
                this.supports32BitFCnt = supports32BitFCnt;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupports32BitFCnt}
             * @param supports32BitFCnt The Supports32BitFCnt value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supports32BitFCnt(software.amazon.awscdk.IResolvable supports32BitFCnt) {
                this.supports32BitFCnt = supports32BitFCnt;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupportsClassB}
             * @param supportsClassB The SupportsClassB value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportsClassB(java.lang.Boolean supportsClassB) {
                this.supportsClassB = supportsClassB;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupportsClassB}
             * @param supportsClassB The SupportsClassB value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportsClassB(software.amazon.awscdk.IResolvable supportsClassB) {
                this.supportsClassB = supportsClassB;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupportsClassC}
             * @param supportsClassC The SupportsClassC value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportsClassC(java.lang.Boolean supportsClassC) {
                this.supportsClassC = supportsClassC;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupportsClassC}
             * @param supportsClassC The SupportsClassC value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportsClassC(software.amazon.awscdk.IResolvable supportsClassC) {
                this.supportsClassC = supportsClassC;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupportsJoin}
             * @param supportsJoin The SupportsJoin value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportsJoin(java.lang.Boolean supportsJoin) {
                this.supportsJoin = supportsJoin;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANDeviceProfileProperty#getSupportsJoin}
             * @param supportsJoin The SupportsJoin value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportsJoin(software.amazon.awscdk.IResolvable supportsJoin) {
                this.supportsJoin = supportsJoin;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoRaWANDeviceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoRaWANDeviceProfileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoRaWANDeviceProfileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoRaWANDeviceProfileProperty {
            private final java.lang.Number classBTimeout;
            private final java.lang.Number classCTimeout;
            private final java.lang.Object factoryPresetFreqsList;
            private final java.lang.String macVersion;
            private final java.lang.Number maxDutyCycle;
            private final java.lang.Number maxEirp;
            private final java.lang.Number pingSlotDr;
            private final java.lang.Number pingSlotFreq;
            private final java.lang.Number pingSlotPeriod;
            private final java.lang.String regParamsRevision;
            private final java.lang.String rfRegion;
            private final java.lang.Number rxDataRate2;
            private final java.lang.Number rxDelay1;
            private final java.lang.Number rxDrOffset1;
            private final java.lang.Number rxFreq2;
            private final java.lang.Object supports32BitFCnt;
            private final java.lang.Object supportsClassB;
            private final java.lang.Object supportsClassC;
            private final java.lang.Object supportsJoin;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classBTimeout = software.amazon.jsii.Kernel.get(this, "classBTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.classCTimeout = software.amazon.jsii.Kernel.get(this, "classCTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.factoryPresetFreqsList = software.amazon.jsii.Kernel.get(this, "factoryPresetFreqsList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.macVersion = software.amazon.jsii.Kernel.get(this, "macVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxDutyCycle = software.amazon.jsii.Kernel.get(this, "maxDutyCycle", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxEirp = software.amazon.jsii.Kernel.get(this, "maxEirp", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pingSlotDr = software.amazon.jsii.Kernel.get(this, "pingSlotDr", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pingSlotFreq = software.amazon.jsii.Kernel.get(this, "pingSlotFreq", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pingSlotPeriod = software.amazon.jsii.Kernel.get(this, "pingSlotPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.regParamsRevision = software.amazon.jsii.Kernel.get(this, "regParamsRevision", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rfRegion = software.amazon.jsii.Kernel.get(this, "rfRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rxDataRate2 = software.amazon.jsii.Kernel.get(this, "rxDataRate2", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rxDelay1 = software.amazon.jsii.Kernel.get(this, "rxDelay1", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rxDrOffset1 = software.amazon.jsii.Kernel.get(this, "rxDrOffset1", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rxFreq2 = software.amazon.jsii.Kernel.get(this, "rxFreq2", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.supports32BitFCnt = software.amazon.jsii.Kernel.get(this, "supports32BitFCnt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.supportsClassB = software.amazon.jsii.Kernel.get(this, "supportsClassB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.supportsClassC = software.amazon.jsii.Kernel.get(this, "supportsClassC", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.supportsJoin = software.amazon.jsii.Kernel.get(this, "supportsJoin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classBTimeout = builder.classBTimeout;
                this.classCTimeout = builder.classCTimeout;
                this.factoryPresetFreqsList = builder.factoryPresetFreqsList;
                this.macVersion = builder.macVersion;
                this.maxDutyCycle = builder.maxDutyCycle;
                this.maxEirp = builder.maxEirp;
                this.pingSlotDr = builder.pingSlotDr;
                this.pingSlotFreq = builder.pingSlotFreq;
                this.pingSlotPeriod = builder.pingSlotPeriod;
                this.regParamsRevision = builder.regParamsRevision;
                this.rfRegion = builder.rfRegion;
                this.rxDataRate2 = builder.rxDataRate2;
                this.rxDelay1 = builder.rxDelay1;
                this.rxDrOffset1 = builder.rxDrOffset1;
                this.rxFreq2 = builder.rxFreq2;
                this.supports32BitFCnt = builder.supports32BitFCnt;
                this.supportsClassB = builder.supportsClassB;
                this.supportsClassC = builder.supportsClassC;
                this.supportsJoin = builder.supportsJoin;
            }

            @Override
            public final java.lang.Number getClassBTimeout() {
                return this.classBTimeout;
            }

            @Override
            public final java.lang.Number getClassCTimeout() {
                return this.classCTimeout;
            }

            @Override
            public final java.lang.Object getFactoryPresetFreqsList() {
                return this.factoryPresetFreqsList;
            }

            @Override
            public final java.lang.String getMacVersion() {
                return this.macVersion;
            }

            @Override
            public final java.lang.Number getMaxDutyCycle() {
                return this.maxDutyCycle;
            }

            @Override
            public final java.lang.Number getMaxEirp() {
                return this.maxEirp;
            }

            @Override
            public final java.lang.Number getPingSlotDr() {
                return this.pingSlotDr;
            }

            @Override
            public final java.lang.Number getPingSlotFreq() {
                return this.pingSlotFreq;
            }

            @Override
            public final java.lang.Number getPingSlotPeriod() {
                return this.pingSlotPeriod;
            }

            @Override
            public final java.lang.String getRegParamsRevision() {
                return this.regParamsRevision;
            }

            @Override
            public final java.lang.String getRfRegion() {
                return this.rfRegion;
            }

            @Override
            public final java.lang.Number getRxDataRate2() {
                return this.rxDataRate2;
            }

            @Override
            public final java.lang.Number getRxDelay1() {
                return this.rxDelay1;
            }

            @Override
            public final java.lang.Number getRxDrOffset1() {
                return this.rxDrOffset1;
            }

            @Override
            public final java.lang.Number getRxFreq2() {
                return this.rxFreq2;
            }

            @Override
            public final java.lang.Object getSupports32BitFCnt() {
                return this.supports32BitFCnt;
            }

            @Override
            public final java.lang.Object getSupportsClassB() {
                return this.supportsClassB;
            }

            @Override
            public final java.lang.Object getSupportsClassC() {
                return this.supportsClassC;
            }

            @Override
            public final java.lang.Object getSupportsJoin() {
                return this.supportsJoin;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassBTimeout() != null) {
                    data.set("classBTimeout", om.valueToTree(this.getClassBTimeout()));
                }
                if (this.getClassCTimeout() != null) {
                    data.set("classCTimeout", om.valueToTree(this.getClassCTimeout()));
                }
                if (this.getFactoryPresetFreqsList() != null) {
                    data.set("factoryPresetFreqsList", om.valueToTree(this.getFactoryPresetFreqsList()));
                }
                if (this.getMacVersion() != null) {
                    data.set("macVersion", om.valueToTree(this.getMacVersion()));
                }
                if (this.getMaxDutyCycle() != null) {
                    data.set("maxDutyCycle", om.valueToTree(this.getMaxDutyCycle()));
                }
                if (this.getMaxEirp() != null) {
                    data.set("maxEirp", om.valueToTree(this.getMaxEirp()));
                }
                if (this.getPingSlotDr() != null) {
                    data.set("pingSlotDr", om.valueToTree(this.getPingSlotDr()));
                }
                if (this.getPingSlotFreq() != null) {
                    data.set("pingSlotFreq", om.valueToTree(this.getPingSlotFreq()));
                }
                if (this.getPingSlotPeriod() != null) {
                    data.set("pingSlotPeriod", om.valueToTree(this.getPingSlotPeriod()));
                }
                if (this.getRegParamsRevision() != null) {
                    data.set("regParamsRevision", om.valueToTree(this.getRegParamsRevision()));
                }
                if (this.getRfRegion() != null) {
                    data.set("rfRegion", om.valueToTree(this.getRfRegion()));
                }
                if (this.getRxDataRate2() != null) {
                    data.set("rxDataRate2", om.valueToTree(this.getRxDataRate2()));
                }
                if (this.getRxDelay1() != null) {
                    data.set("rxDelay1", om.valueToTree(this.getRxDelay1()));
                }
                if (this.getRxDrOffset1() != null) {
                    data.set("rxDrOffset1", om.valueToTree(this.getRxDrOffset1()));
                }
                if (this.getRxFreq2() != null) {
                    data.set("rxFreq2", om.valueToTree(this.getRxFreq2()));
                }
                if (this.getSupports32BitFCnt() != null) {
                    data.set("supports32BitFCnt", om.valueToTree(this.getSupports32BitFCnt()));
                }
                if (this.getSupportsClassB() != null) {
                    data.set("supportsClassB", om.valueToTree(this.getSupportsClassB()));
                }
                if (this.getSupportsClassC() != null) {
                    data.set("supportsClassC", om.valueToTree(this.getSupportsClassC()));
                }
                if (this.getSupportsJoin() != null) {
                    data.set("supportsJoin", om.valueToTree(this.getSupportsJoin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnDeviceProfile.LoRaWANDeviceProfileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoRaWANDeviceProfileProperty.Jsii$Proxy that = (LoRaWANDeviceProfileProperty.Jsii$Proxy) o;

                if (this.classBTimeout != null ? !this.classBTimeout.equals(that.classBTimeout) : that.classBTimeout != null) return false;
                if (this.classCTimeout != null ? !this.classCTimeout.equals(that.classCTimeout) : that.classCTimeout != null) return false;
                if (this.factoryPresetFreqsList != null ? !this.factoryPresetFreqsList.equals(that.factoryPresetFreqsList) : that.factoryPresetFreqsList != null) return false;
                if (this.macVersion != null ? !this.macVersion.equals(that.macVersion) : that.macVersion != null) return false;
                if (this.maxDutyCycle != null ? !this.maxDutyCycle.equals(that.maxDutyCycle) : that.maxDutyCycle != null) return false;
                if (this.maxEirp != null ? !this.maxEirp.equals(that.maxEirp) : that.maxEirp != null) return false;
                if (this.pingSlotDr != null ? !this.pingSlotDr.equals(that.pingSlotDr) : that.pingSlotDr != null) return false;
                if (this.pingSlotFreq != null ? !this.pingSlotFreq.equals(that.pingSlotFreq) : that.pingSlotFreq != null) return false;
                if (this.pingSlotPeriod != null ? !this.pingSlotPeriod.equals(that.pingSlotPeriod) : that.pingSlotPeriod != null) return false;
                if (this.regParamsRevision != null ? !this.regParamsRevision.equals(that.regParamsRevision) : that.regParamsRevision != null) return false;
                if (this.rfRegion != null ? !this.rfRegion.equals(that.rfRegion) : that.rfRegion != null) return false;
                if (this.rxDataRate2 != null ? !this.rxDataRate2.equals(that.rxDataRate2) : that.rxDataRate2 != null) return false;
                if (this.rxDelay1 != null ? !this.rxDelay1.equals(that.rxDelay1) : that.rxDelay1 != null) return false;
                if (this.rxDrOffset1 != null ? !this.rxDrOffset1.equals(that.rxDrOffset1) : that.rxDrOffset1 != null) return false;
                if (this.rxFreq2 != null ? !this.rxFreq2.equals(that.rxFreq2) : that.rxFreq2 != null) return false;
                if (this.supports32BitFCnt != null ? !this.supports32BitFCnt.equals(that.supports32BitFCnt) : that.supports32BitFCnt != null) return false;
                if (this.supportsClassB != null ? !this.supportsClassB.equals(that.supportsClassB) : that.supportsClassB != null) return false;
                if (this.supportsClassC != null ? !this.supportsClassC.equals(that.supportsClassC) : that.supportsClassC != null) return false;
                return this.supportsJoin != null ? this.supportsJoin.equals(that.supportsJoin) : that.supportsJoin == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classBTimeout != null ? this.classBTimeout.hashCode() : 0;
                result = 31 * result + (this.classCTimeout != null ? this.classCTimeout.hashCode() : 0);
                result = 31 * result + (this.factoryPresetFreqsList != null ? this.factoryPresetFreqsList.hashCode() : 0);
                result = 31 * result + (this.macVersion != null ? this.macVersion.hashCode() : 0);
                result = 31 * result + (this.maxDutyCycle != null ? this.maxDutyCycle.hashCode() : 0);
                result = 31 * result + (this.maxEirp != null ? this.maxEirp.hashCode() : 0);
                result = 31 * result + (this.pingSlotDr != null ? this.pingSlotDr.hashCode() : 0);
                result = 31 * result + (this.pingSlotFreq != null ? this.pingSlotFreq.hashCode() : 0);
                result = 31 * result + (this.pingSlotPeriod != null ? this.pingSlotPeriod.hashCode() : 0);
                result = 31 * result + (this.regParamsRevision != null ? this.regParamsRevision.hashCode() : 0);
                result = 31 * result + (this.rfRegion != null ? this.rfRegion.hashCode() : 0);
                result = 31 * result + (this.rxDataRate2 != null ? this.rxDataRate2.hashCode() : 0);
                result = 31 * result + (this.rxDelay1 != null ? this.rxDelay1.hashCode() : 0);
                result = 31 * result + (this.rxDrOffset1 != null ? this.rxDrOffset1.hashCode() : 0);
                result = 31 * result + (this.rxFreq2 != null ? this.rxFreq2.hashCode() : 0);
                result = 31 * result + (this.supports32BitFCnt != null ? this.supports32BitFCnt.hashCode() : 0);
                result = 31 * result + (this.supportsClassB != null ? this.supportsClassB.hashCode() : 0);
                result = 31 * result + (this.supportsClassC != null ? this.supportsClassC.hashCode() : 0);
                result = 31 * result + (this.supportsJoin != null ? this.supportsJoin.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotwireless.CfnDeviceProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotwireless.CfnDeviceProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iotwireless.CfnDeviceProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * LoRaWAN device profile object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawan</a>
         * @param loRaWan LoRaWAN device profile object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(final software.amazon.awscdk.IResolvable loRaWan) {
            this.props().loRaWan(loRaWan);
            return this;
        }
        /**
         * LoRaWAN device profile object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawan</a>
         * @param loRaWan LoRaWAN device profile object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(final software.amazon.awscdk.services.iotwireless.CfnDeviceProfile.LoRaWANDeviceProfileProperty loRaWan) {
            this.props().loRaWan(loRaWan);
            return this;
        }

        /**
         * The name of the new resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-name</a>
         * @param name The name of the new resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The tags are an array of key-value pairs to attach to the specified resource.
         * <p>
         * Tags can have a minimum of 0 and a maximum of 50 items.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-tags</a>
         * @param tags The tags are an array of key-value pairs to attach to the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotwireless.CfnDeviceProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotwireless.CfnDeviceProfile build() {
            return new software.amazon.awscdk.services.iotwireless.CfnDeviceProfile(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iotwireless.CfnDeviceProfileProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iotwireless.CfnDeviceProfileProps.Builder();
            }
            return this.props;
        }
    }
}
