package software.amazon.awscdk.services.kinesis;

/**
 * Enhanced shard-level metrics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stream stream = Stream.Builder.create(this, "MyStream")
 *         .shardLevelMetrics(List.of(ShardLevelMetrics.ALL))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html#kinesis-metrics-shard">https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html#kinesis-metrics-shard</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.109Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesis.ShardLevelMetrics")
public enum ShardLevelMetrics {
    /**
     * The number of bytes successfully put to the shard over the specified time period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INCOMING_BYTES,
    /**
     * The number of records successfully put to the shard over the specified time period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INCOMING_RECORDS,
    /**
     * The age of the last record in all GetRecords calls made against a shard, measured over the specified time period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ITERATOR_AGE_MILLISECONDS,
    /**
     * The number of bytes retrieved from the shard, measured over the specified time period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OUTGOING_BYTES,
    /**
     * The number of records retrieved from the shard, measured over the specified time period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OUTGOING_RECORDS,
    /**
     * The number of GetRecords calls throttled for the shard over the specified time period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ_PROVISIONED_THROUGHPUT_EXCEEDED,
    /**
     * The number of records rejected due to throttling for the shard over the specified time period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WRITE_PROVISIONED_THROUGHPUT_EXCEEDED,
    /**
     * All metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
}
