package software.amazon.awscdk.services.kinesisanalytics;

/**
 * Adds a reference data source to an existing application.
 * <p>
 * Amazon Kinesis Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in Amazon S3 object maps to columns in the resulting in-application table.
 * <p>
 * For conceptual information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a> . For the limits on data sources you can add to your application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a> .
 * <p>
 * This operation requires permissions to perform the <code>kinesisanalytics:AddApplicationOutput</code> action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalytics.*;
 * CfnApplicationReferenceDataSource cfnApplicationReferenceDataSource = CfnApplicationReferenceDataSource.Builder.create(this, "MyCfnApplicationReferenceDataSource")
 *         .applicationName("applicationName")
 *         .referenceDataSource(ReferenceDataSourceProperty.builder()
 *                 .referenceSchema(ReferenceSchemaProperty.builder()
 *                         .recordColumns(List.of(RecordColumnProperty.builder()
 *                                 .name("name")
 *                                 .sqlType("sqlType")
 *                                 // the properties below are optional
 *                                 .mapping("mapping")
 *                                 .build()))
 *                         .recordFormat(RecordFormatProperty.builder()
 *                                 .recordFormatType("recordFormatType")
 *                                 // the properties below are optional
 *                                 .mappingParameters(MappingParametersProperty.builder()
 *                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
 *                                                 .recordColumnDelimiter("recordColumnDelimiter")
 *                                                 .recordRowDelimiter("recordRowDelimiter")
 *                                                 .build())
 *                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
 *                                                 .recordRowPath("recordRowPath")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .recordEncoding("recordEncoding")
 *                         .build())
 *                 // the properties below are optional
 *                 .s3ReferenceDataSource(S3ReferenceDataSourceProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .fileKey("fileKey")
 *                         .referenceRoleArn("referenceRoleArn")
 *                         .build())
 *                 .tableName("tableName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.147Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource")
public class CfnApplicationReferenceDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.kinesisanalytics.IApplicationReferenceDataSourceRef {

    protected CfnApplicationReferenceDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationReferenceDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::KinesisAnalytics::ApplicationReferenceDataSource</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplicationReferenceDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Checks whether the given object is a CfnApplicationReferenceDataSource.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnApplicationReferenceDataSource(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.class, "isCfnApplicationReferenceDataSource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A reference to a ApplicationReferenceDataSource resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.kinesisanalytics.ApplicationReferenceDataSourceReference getApplicationReferenceDataSourceRef() {
        return software.amazon.jsii.Kernel.get(this, "applicationReferenceDataSourceRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.kinesisanalytics.ApplicationReferenceDataSourceReference.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Name of an existing application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of an existing application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * The reference data source can be an object in your Amazon S3 bucket.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getReferenceDataSource() {
        return software.amazon.jsii.Kernel.get(this, "referenceDataSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The reference data source can be an object in your Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReferenceDataSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "referenceDataSource", java.util.Objects.requireNonNull(value, "referenceDataSource is required"));
    }

    /**
     * The reference data source can be an object in your Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReferenceDataSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "referenceDataSource", java.util.Objects.requireNonNull(value, "referenceDataSource is required"));
    }
    /**
     * Provides additional mapping information when the record format uses delimiters, such as CSV.
     * <p>
     * For example, the following sample records use CSV format, where the records use the <em>'\n'</em> as the row delimiter and a comma (",") as the column delimiter:
     * <p>
     * <code>"name1", "address1"</code>
     * <p>
     * <code>"name2", "address2"</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * CSVMappingParametersProperty cSVMappingParametersProperty = CSVMappingParametersProperty.builder()
     *         .recordColumnDelimiter("recordColumnDelimiter")
     *         .recordRowDelimiter("recordRowDelimiter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.CSVMappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(CSVMappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Column delimiter.
         * <p>
         * For example, in a CSV format, a comma (",") is the typical column delimiter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordcolumndelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordcolumndelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordColumnDelimiter();

        /**
         * Row delimiter.
         * <p>
         * For example, in a CSV format, <em>'\n'</em> is the typical row delimiter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordrowdelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordrowdelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordRowDelimiter();

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CSVMappingParametersProperty> {
            java.lang.String recordColumnDelimiter;
            java.lang.String recordRowDelimiter;

            /**
             * Sets the value of {@link CSVMappingParametersProperty#getRecordColumnDelimiter}
             * @param recordColumnDelimiter Column delimiter. This parameter is required.
             *                              For example, in a CSV format, a comma (",") is the typical column delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumnDelimiter(java.lang.String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link CSVMappingParametersProperty#getRecordRowDelimiter}
             * @param recordRowDelimiter Row delimiter. This parameter is required.
             *                           For example, in a CSV format, <em>'\n'</em> is the typical row delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordRowDelimiter(java.lang.String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CSVMappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CSVMappingParametersProperty {
            private final java.lang.String recordColumnDelimiter;
            private final java.lang.String recordRowDelimiter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordColumnDelimiter = software.amazon.jsii.Kernel.get(this, "recordColumnDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordRowDelimiter = software.amazon.jsii.Kernel.get(this, "recordRowDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumnDelimiter = java.util.Objects.requireNonNull(builder.recordColumnDelimiter, "recordColumnDelimiter is required");
                this.recordRowDelimiter = java.util.Objects.requireNonNull(builder.recordRowDelimiter, "recordRowDelimiter is required");
            }

            @Override
            public final java.lang.String getRecordColumnDelimiter() {
                return this.recordColumnDelimiter;
            }

            @Override
            public final java.lang.String getRecordRowDelimiter() {
                return this.recordRowDelimiter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordColumnDelimiter", om.valueToTree(this.getRecordColumnDelimiter()));
                data.set("recordRowDelimiter", om.valueToTree(this.getRecordRowDelimiter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.CSVMappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CSVMappingParametersProperty.Jsii$Proxy that = (CSVMappingParametersProperty.Jsii$Proxy) o;

                if (!recordColumnDelimiter.equals(that.recordColumnDelimiter)) return false;
                return this.recordRowDelimiter.equals(that.recordRowDelimiter);
            }

            @Override
            public final int hashCode() {
                int result = this.recordColumnDelimiter.hashCode();
                result = 31 * result + (this.recordRowDelimiter.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides additional mapping information when JSON is the record format on the streaming source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * JSONMappingParametersProperty jSONMappingParametersProperty = JSONMappingParametersProperty.builder()
     *         .recordRowPath("recordRowPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.JSONMappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(JSONMappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Path to the top-level parent that contains the records.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters-recordrowpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters-recordrowpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordRowPath();

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JSONMappingParametersProperty> {
            java.lang.String recordRowPath;

            /**
             * Sets the value of {@link JSONMappingParametersProperty#getRecordRowPath}
             * @param recordRowPath Path to the top-level parent that contains the records. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordRowPath(java.lang.String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JSONMappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JSONMappingParametersProperty {
            private final java.lang.String recordRowPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordRowPath = software.amazon.jsii.Kernel.get(this, "recordRowPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordRowPath = java.util.Objects.requireNonNull(builder.recordRowPath, "recordRowPath is required");
            }

            @Override
            public final java.lang.String getRecordRowPath() {
                return this.recordRowPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordRowPath", om.valueToTree(this.getRecordRowPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.JSONMappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JSONMappingParametersProperty.Jsii$Proxy that = (JSONMappingParametersProperty.Jsii$Proxy) o;

                return this.recordRowPath.equals(that.recordRowPath);
            }

            @Override
            public final int hashCode() {
                int result = this.recordRowPath.hashCode();
                return result;
            }
        }
    }
    /**
     * When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * MappingParametersProperty mappingParametersProperty = MappingParametersProperty.builder()
     *         .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                 .recordColumnDelimiter("recordColumnDelimiter")
     *                 .recordRowDelimiter("recordRowDelimiter")
     *                 .build())
     *         .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                 .recordRowPath("recordRowPath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.MappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.CSVMappingParametersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-csvmappingparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-csvmappingparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsvMappingParameters() {
            return null;
        }

        /**
         * Provides additional mapping information when JSON is the record format on the streaming source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.JSONMappingParametersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-jsonmappingparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-jsonmappingparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonMappingParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MappingParametersProperty> {
            java.lang.Object csvMappingParameters;
            java.lang.Object jsonMappingParameters;

            /**
             * Sets the value of {@link MappingParametersProperty#getCsvMappingParameters}
             * @param csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvMappingParameters(software.amazon.awscdk.IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getCsvMappingParameters}
             * @param csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvMappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getJsonMappingParameters}
             * @param jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonMappingParameters(software.amazon.awscdk.IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getJsonMappingParameters}
             * @param jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonMappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingParametersProperty {
            private final java.lang.Object csvMappingParameters;
            private final java.lang.Object jsonMappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csvMappingParameters = software.amazon.jsii.Kernel.get(this, "csvMappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jsonMappingParameters = software.amazon.jsii.Kernel.get(this, "jsonMappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvMappingParameters = builder.csvMappingParameters;
                this.jsonMappingParameters = builder.jsonMappingParameters;
            }

            @Override
            public final java.lang.Object getCsvMappingParameters() {
                return this.csvMappingParameters;
            }

            @Override
            public final java.lang.Object getJsonMappingParameters() {
                return this.jsonMappingParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsvMappingParameters() != null) {
                    data.set("csvMappingParameters", om.valueToTree(this.getCsvMappingParameters()));
                }
                if (this.getJsonMappingParameters() != null) {
                    data.set("jsonMappingParameters", om.valueToTree(this.getJsonMappingParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.MappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingParametersProperty.Jsii$Proxy that = (MappingParametersProperty.Jsii$Proxy) o;

                if (this.csvMappingParameters != null ? !this.csvMappingParameters.equals(that.csvMappingParameters) : that.csvMappingParameters != null) return false;
                return this.jsonMappingParameters != null ? this.jsonMappingParameters.equals(that.jsonMappingParameters) : that.jsonMappingParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csvMappingParameters != null ? this.csvMappingParameters.hashCode() : 0;
                result = 31 * result + (this.jsonMappingParameters != null ? this.jsonMappingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     * <p>
     * Also used to describe the format of the reference data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * RecordColumnProperty recordColumnProperty = RecordColumnProperty.builder()
     *         .name("name")
     *         .sqlType("sqlType")
     *         // the properties below are optional
     *         .mapping("mapping")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.RecordColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the column created in the in-application input stream or reference table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Type of column created in the in-application input stream or reference table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-sqltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-sqltype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlType();

        /**
         * Reference to the data element in the streaming input or the reference data source.
         * <p>
         * This element is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-mapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-mapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMapping() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordColumnProperty> {
            java.lang.String name;
            java.lang.String sqlType;
            java.lang.String mapping;

            /**
             * Sets the value of {@link RecordColumnProperty#getName}
             * @param name Name of the column created in the in-application input stream or reference table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecordColumnProperty#getSqlType}
             * @param sqlType Type of column created in the in-application input stream or reference table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlType(java.lang.String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            /**
             * Sets the value of {@link RecordColumnProperty#getMapping}
             * @param mapping Reference to the data element in the streaming input or the reference data source.
             *                This element is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapping(java.lang.String mapping) {
                this.mapping = mapping;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordColumnProperty {
            private final java.lang.String name;
            private final java.lang.String sqlType;
            private final java.lang.String mapping;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqlType = software.amazon.jsii.Kernel.get(this, "sqlType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mapping = software.amazon.jsii.Kernel.get(this, "mapping", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.sqlType = java.util.Objects.requireNonNull(builder.sqlType, "sqlType is required");
                this.mapping = builder.mapping;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSqlType() {
                return this.sqlType;
            }

            @Override
            public final java.lang.String getMapping() {
                return this.mapping;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("sqlType", om.valueToTree(this.getSqlType()));
                if (this.getMapping() != null) {
                    data.set("mapping", om.valueToTree(this.getMapping()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.RecordColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordColumnProperty.Jsii$Proxy that = (RecordColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!sqlType.equals(that.sqlType)) return false;
                return this.mapping != null ? this.mapping.equals(that.mapping) : that.mapping == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.sqlType.hashCode());
                result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the record format and relevant mapping information that should be applied to schematize the records on the stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * RecordFormatProperty recordFormatProperty = RecordFormatProperty.builder()
     *         .recordFormatType("recordFormatType")
     *         // the properties below are optional
     *         .mappingParameters(MappingParametersProperty.builder()
     *                 .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                         .recordColumnDelimiter("recordColumnDelimiter")
     *                         .recordRowDelimiter("recordRowDelimiter")
     *                         .build())
     *                 .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                         .recordRowPath("recordRowPath")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.RecordFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of record format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-recordformattype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-recordformattype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordFormatType();

        /**
         * When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.MappingParametersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-mappingparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-mappingparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMappingParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordFormatProperty> {
            java.lang.String recordFormatType;
            java.lang.Object mappingParameters;

            /**
             * Sets the value of {@link RecordFormatProperty#getRecordFormatType}
             * @param recordFormatType The type of record format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormatType(java.lang.String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            /**
             * Sets the value of {@link RecordFormatProperty#getMappingParameters}
             * @param mappingParameters When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingParameters(software.amazon.awscdk.IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link RecordFormatProperty#getMappingParameters}
             * @param mappingParameters When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordFormatProperty {
            private final java.lang.String recordFormatType;
            private final java.lang.Object mappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordFormatType = software.amazon.jsii.Kernel.get(this, "recordFormatType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mappingParameters = software.amazon.jsii.Kernel.get(this, "mappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordFormatType = java.util.Objects.requireNonNull(builder.recordFormatType, "recordFormatType is required");
                this.mappingParameters = builder.mappingParameters;
            }

            @Override
            public final java.lang.String getRecordFormatType() {
                return this.recordFormatType;
            }

            @Override
            public final java.lang.Object getMappingParameters() {
                return this.mappingParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                if (this.getMappingParameters() != null) {
                    data.set("mappingParameters", om.valueToTree(this.getMappingParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.RecordFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordFormatProperty.Jsii$Proxy that = (RecordFormatProperty.Jsii$Proxy) o;

                if (!recordFormatType.equals(that.recordFormatType)) return false;
                return this.mappingParameters != null ? this.mappingParameters.equals(that.mappingParameters) : that.mappingParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordFormatType.hashCode();
                result = 31 * result + (this.mappingParameters != null ? this.mappingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the reference data source by providing the source information (S3 bucket name and object key name), the resulting in-application table name that is created, and the necessary schema to map the data elements in the Amazon S3 object to the in-application table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * ReferenceDataSourceProperty referenceDataSourceProperty = ReferenceDataSourceProperty.builder()
     *         .referenceSchema(ReferenceSchemaProperty.builder()
     *                 .recordColumns(List.of(RecordColumnProperty.builder()
     *                         .name("name")
     *                         .sqlType("sqlType")
     *                         // the properties below are optional
     *                         .mapping("mapping")
     *                         .build()))
     *                 .recordFormat(RecordFormatProperty.builder()
     *                         .recordFormatType("recordFormatType")
     *                         // the properties below are optional
     *                         .mappingParameters(MappingParametersProperty.builder()
     *                                 .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                         .recordColumnDelimiter("recordColumnDelimiter")
     *                                         .recordRowDelimiter("recordRowDelimiter")
     *                                         .build())
     *                                 .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                         .recordRowPath("recordRowPath")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .recordEncoding("recordEncoding")
     *                 .build())
     *         // the properties below are optional
     *         .s3ReferenceDataSource(S3ReferenceDataSourceProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .fileKey("fileKey")
     *                 .referenceRoleArn("referenceRoleArn")
     *                 .build())
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ReferenceDataSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReferenceDataSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceSchemaProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-referenceschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-referenceschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getReferenceSchema();

        /**
         * Identifies the S3 bucket and object that contains the reference data.
         * <p>
         * Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf. An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <code>UpdateApplication</code> operation to trigger reloading of data into your application.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-s3referencedatasource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-s3referencedatasource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3ReferenceDataSource() {
            return null;
        }

        /**
         * Name of the in-application table to create.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReferenceDataSourceProperty> {
            java.lang.Object referenceSchema;
            java.lang.Object s3ReferenceDataSource;
            java.lang.String tableName;

            /**
             * Sets the value of {@link ReferenceDataSourceProperty#getReferenceSchema}
             * @param referenceSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceSchema(software.amazon.awscdk.IResolvable referenceSchema) {
                this.referenceSchema = referenceSchema;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceDataSourceProperty#getReferenceSchema}
             * @param referenceSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceSchema(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceSchemaProperty referenceSchema) {
                this.referenceSchema = referenceSchema;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceDataSourceProperty#getS3ReferenceDataSource}
             * @param s3ReferenceDataSource Identifies the S3 bucket and object that contains the reference data.
             *                              Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf. An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <code>UpdateApplication</code> operation to trigger reloading of data into your application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ReferenceDataSource(software.amazon.awscdk.IResolvable s3ReferenceDataSource) {
                this.s3ReferenceDataSource = s3ReferenceDataSource;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceDataSourceProperty#getS3ReferenceDataSource}
             * @param s3ReferenceDataSource Identifies the S3 bucket and object that contains the reference data.
             *                              Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf. An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <code>UpdateApplication</code> operation to trigger reloading of data into your application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ReferenceDataSource(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty s3ReferenceDataSource) {
                this.s3ReferenceDataSource = s3ReferenceDataSource;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceDataSourceProperty#getTableName}
             * @param tableName Name of the in-application table to create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReferenceDataSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReferenceDataSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReferenceDataSourceProperty {
            private final java.lang.Object referenceSchema;
            private final java.lang.Object s3ReferenceDataSource;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.referenceSchema = software.amazon.jsii.Kernel.get(this, "referenceSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3ReferenceDataSource = software.amazon.jsii.Kernel.get(this, "s3ReferenceDataSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.referenceSchema = java.util.Objects.requireNonNull(builder.referenceSchema, "referenceSchema is required");
                this.s3ReferenceDataSource = builder.s3ReferenceDataSource;
                this.tableName = builder.tableName;
            }

            @Override
            public final java.lang.Object getReferenceSchema() {
                return this.referenceSchema;
            }

            @Override
            public final java.lang.Object getS3ReferenceDataSource() {
                return this.s3ReferenceDataSource;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("referenceSchema", om.valueToTree(this.getReferenceSchema()));
                if (this.getS3ReferenceDataSource() != null) {
                    data.set("s3ReferenceDataSource", om.valueToTree(this.getS3ReferenceDataSource()));
                }
                if (this.getTableName() != null) {
                    data.set("tableName", om.valueToTree(this.getTableName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReferenceDataSourceProperty.Jsii$Proxy that = (ReferenceDataSourceProperty.Jsii$Proxy) o;

                if (!referenceSchema.equals(that.referenceSchema)) return false;
                if (this.s3ReferenceDataSource != null ? !this.s3ReferenceDataSource.equals(that.s3ReferenceDataSource) : that.s3ReferenceDataSource != null) return false;
                return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.referenceSchema.hashCode();
                result = 31 * result + (this.s3ReferenceDataSource != null ? this.s3ReferenceDataSource.hashCode() : 0);
                result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The ReferenceSchema property type specifies the format of the data in the reference source for a SQL-based Amazon Kinesis Data Analytics application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * ReferenceSchemaProperty referenceSchemaProperty = ReferenceSchemaProperty.builder()
     *         .recordColumns(List.of(RecordColumnProperty.builder()
     *                 .name("name")
     *                 .sqlType("sqlType")
     *                 // the properties below are optional
     *                 .mapping("mapping")
     *                 .build()))
     *         .recordFormat(RecordFormatProperty.builder()
     *                 .recordFormatType("recordFormatType")
     *                 // the properties below are optional
     *                 .mappingParameters(MappingParametersProperty.builder()
     *                         .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                 .recordColumnDelimiter("recordColumnDelimiter")
     *                                 .recordRowDelimiter("recordRowDelimiter")
     *                                 .build())
     *                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                 .recordRowPath("recordRowPath")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .recordEncoding("recordEncoding")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(ReferenceSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReferenceSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of RecordColumn objects.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.RecordColumnProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRecordColumns();

        /**
         * Specifies the format of the records on the reference source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.RecordFormatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRecordFormat();

        /**
         * Specifies the encoding of the records in the reference source.
         * <p>
         * For example, UTF-8.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordencoding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordencoding</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordEncoding() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReferenceSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReferenceSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReferenceSchemaProperty> {
            java.lang.Object recordColumns;
            java.lang.Object recordFormat;
            java.lang.String recordEncoding;

            /**
             * Sets the value of {@link ReferenceSchemaProperty#getRecordColumns}
             * @param recordColumns A list of RecordColumn objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumns(software.amazon.awscdk.IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceSchemaProperty#getRecordColumns}
             * @param recordColumns A list of RecordColumn objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumns(java.util.List<? extends java.lang.Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceSchemaProperty#getRecordFormat}
             * @param recordFormat Specifies the format of the records on the reference source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormat(software.amazon.awscdk.IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceSchemaProperty#getRecordFormat}
             * @param recordFormat Specifies the format of the records on the reference source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormat(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of {@link ReferenceSchemaProperty#getRecordEncoding}
             * @param recordEncoding Specifies the encoding of the records in the reference source.
             *                       For example, UTF-8.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordEncoding(java.lang.String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReferenceSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReferenceSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReferenceSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReferenceSchemaProperty {
            private final java.lang.Object recordColumns;
            private final java.lang.Object recordFormat;
            private final java.lang.String recordEncoding;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordColumns = software.amazon.jsii.Kernel.get(this, "recordColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordFormat = software.amazon.jsii.Kernel.get(this, "recordFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordEncoding = software.amazon.jsii.Kernel.get(this, "recordEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumns = java.util.Objects.requireNonNull(builder.recordColumns, "recordColumns is required");
                this.recordFormat = java.util.Objects.requireNonNull(builder.recordFormat, "recordFormat is required");
                this.recordEncoding = builder.recordEncoding;
            }

            @Override
            public final java.lang.Object getRecordColumns() {
                return this.recordColumns;
            }

            @Override
            public final java.lang.Object getRecordFormat() {
                return this.recordFormat;
            }

            @Override
            public final java.lang.String getRecordEncoding() {
                return this.recordEncoding;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordColumns", om.valueToTree(this.getRecordColumns()));
                data.set("recordFormat", om.valueToTree(this.getRecordFormat()));
                if (this.getRecordEncoding() != null) {
                    data.set("recordEncoding", om.valueToTree(this.getRecordEncoding()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReferenceSchemaProperty.Jsii$Proxy that = (ReferenceSchemaProperty.Jsii$Proxy) o;

                if (!recordColumns.equals(that.recordColumns)) return false;
                if (!recordFormat.equals(that.recordFormat)) return false;
                return this.recordEncoding != null ? this.recordEncoding.equals(that.recordEncoding) : that.recordEncoding == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordColumns.hashCode();
                result = 31 * result + (this.recordFormat.hashCode());
                result = 31 * result + (this.recordEncoding != null ? this.recordEncoding.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifies the S3 bucket and object that contains the reference data.
     * <p>
     * Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf.
     * <p>
     * An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a> operation to trigger reloading of data into your application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * S3ReferenceDataSourceProperty s3ReferenceDataSourceProperty = S3ReferenceDataSourceProperty.builder()
     *         .bucketArn("bucketArn")
     *         .fileKey("fileKey")
     *         .referenceRoleArn("referenceRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ReferenceDataSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ReferenceDataSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amazon Resource Name (ARN) of the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * Object key name containing reference data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-filekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-filekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileKey();

        /**
         * ARN of the IAM role that the service can assume to read data on your behalf.
         * <p>
         * This role must have permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-referencerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-referencerolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReferenceRoleArn();

        /**
         * @return a {@link Builder} of {@link S3ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ReferenceDataSourceProperty> {
            java.lang.String bucketArn;
            java.lang.String fileKey;
            java.lang.String referenceRoleArn;

            /**
             * Sets the value of {@link S3ReferenceDataSourceProperty#getBucketArn}
             * @param bucketArn Amazon Resource Name (ARN) of the S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ReferenceDataSourceProperty#getFileKey}
             * @param fileKey Object key name containing reference data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileKey(java.lang.String fileKey) {
                this.fileKey = fileKey;
                return this;
            }

            /**
             * Sets the value of {@link S3ReferenceDataSourceProperty#getReferenceRoleArn}
             * @param referenceRoleArn ARN of the IAM role that the service can assume to read data on your behalf. This parameter is required.
             *                         This role must have permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceRoleArn(java.lang.String referenceRoleArn) {
                this.referenceRoleArn = referenceRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ReferenceDataSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ReferenceDataSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ReferenceDataSourceProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String fileKey;
            private final java.lang.String referenceRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileKey = software.amazon.jsii.Kernel.get(this, "fileKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.referenceRoleArn = software.amazon.jsii.Kernel.get(this, "referenceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.fileKey = java.util.Objects.requireNonNull(builder.fileKey, "fileKey is required");
                this.referenceRoleArn = java.util.Objects.requireNonNull(builder.referenceRoleArn, "referenceRoleArn is required");
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getFileKey() {
                return this.fileKey;
            }

            @Override
            public final java.lang.String getReferenceRoleArn() {
                return this.referenceRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("fileKey", om.valueToTree(this.getFileKey()));
                data.set("referenceRoleArn", om.valueToTree(this.getReferenceRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ReferenceDataSourceProperty.Jsii$Proxy that = (S3ReferenceDataSourceProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!fileKey.equals(that.fileKey)) return false;
                return this.referenceRoleArn.equals(that.referenceRoleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.fileKey.hashCode());
                result = 31 * result + (this.referenceRoleArn.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceProps.Builder();
        }

        /**
         * Name of an existing application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-applicationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-applicationname</a>
         * @param applicationName Name of an existing application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * The reference data source can be an object in your Amazon S3 bucket.
         * <p>
         * Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource</a>
         * @param referenceDataSource The reference data source can be an object in your Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceDataSource(final software.amazon.awscdk.IResolvable referenceDataSource) {
            this.props.referenceDataSource(referenceDataSource);
            return this;
        }
        /**
         * The reference data source can be an object in your Amazon S3 bucket.
         * <p>
         * Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource</a>
         * @param referenceDataSource The reference data source can be an object in your Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceDataSource(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource.ReferenceDataSourceProperty referenceDataSource) {
            this.props.referenceDataSource(referenceDataSource);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource build() {
            return new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
