package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Props for specifying data format conversion for Firehose.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * CfnTable schemaGlueTable;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .dataFormatConversion(DataFormatConversionProps.builder()
 *                 .schemaConfiguration(SchemaConfiguration.fromCfnTable(schemaGlueTable))
 *                 .inputFormat(InputFormat.OPENX_JSON)
 *                 .outputFormat(OutputFormat.PARQUET)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html">https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.351Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DataFormatConversionProps")
@software.amazon.jsii.Jsii.Proxy(DataFormatConversionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataFormatConversionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The input format to convert from for record format conversion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IInputFormat getInputFormat();

    /**
     * The output format to convert to for record format conversion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IOutputFormat getOutputFormat();

    /**
     * The schema configuration to use in converting the input format to output format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration getSchemaConfiguration();

    /**
     * Whether data format conversion is enabled or not.
     * <p>
     * Default: `true`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataFormatConversionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataFormatConversionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataFormatConversionProps> {
        software.amazon.awscdk.services.kinesisfirehose.IInputFormat inputFormat;
        software.amazon.awscdk.services.kinesisfirehose.IOutputFormat outputFormat;
        software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration schemaConfiguration;
        java.lang.Boolean enabled;

        /**
         * Sets the value of {@link DataFormatConversionProps#getInputFormat}
         * @param inputFormat The input format to convert from for record format conversion. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputFormat(software.amazon.awscdk.services.kinesisfirehose.IInputFormat inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        /**
         * Sets the value of {@link DataFormatConversionProps#getOutputFormat}
         * @param outputFormat The output format to convert to for record format conversion. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputFormat(software.amazon.awscdk.services.kinesisfirehose.IOutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        /**
         * Sets the value of {@link DataFormatConversionProps#getSchemaConfiguration}
         * @param schemaConfiguration The schema configuration to use in converting the input format to output format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaConfiguration(software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration schemaConfiguration) {
            this.schemaConfiguration = schemaConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link DataFormatConversionProps#getEnabled}
         * @param enabled Whether data format conversion is enabled or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataFormatConversionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataFormatConversionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataFormatConversionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataFormatConversionProps {
        private final software.amazon.awscdk.services.kinesisfirehose.IInputFormat inputFormat;
        private final software.amazon.awscdk.services.kinesisfirehose.IOutputFormat outputFormat;
        private final software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration schemaConfiguration;
        private final java.lang.Boolean enabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputFormat = software.amazon.jsii.Kernel.get(this, "inputFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.IInputFormat.class));
            this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.IOutputFormat.class));
            this.schemaConfiguration = software.amazon.jsii.Kernel.get(this, "schemaConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputFormat = java.util.Objects.requireNonNull(builder.inputFormat, "inputFormat is required");
            this.outputFormat = java.util.Objects.requireNonNull(builder.outputFormat, "outputFormat is required");
            this.schemaConfiguration = java.util.Objects.requireNonNull(builder.schemaConfiguration, "schemaConfiguration is required");
            this.enabled = builder.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.IInputFormat getInputFormat() {
            return this.inputFormat;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.IOutputFormat getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration getSchemaConfiguration() {
            return this.schemaConfiguration;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputFormat", om.valueToTree(this.getInputFormat()));
            data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
            data.set("schemaConfiguration", om.valueToTree(this.getSchemaConfiguration()));
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DataFormatConversionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataFormatConversionProps.Jsii$Proxy that = (DataFormatConversionProps.Jsii$Proxy) o;

            if (!inputFormat.equals(that.inputFormat)) return false;
            if (!outputFormat.equals(that.outputFormat)) return false;
            if (!schemaConfiguration.equals(that.schemaConfiguration)) return false;
            return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inputFormat.hashCode();
            result = 31 * result + (this.outputFormat.hashCode());
            result = 31 * result + (this.schemaConfiguration.hashCode());
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            return result;
        }
    }
}
