package software.amazon.awscdk.services.kinesisfirehose;

/**
 * The data processor to decompress CloudWatch Logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processors(List.of(
 *             new DecompressionProcessor(),
 *             new AppendDelimiterToRecordProcessor()))
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/writing-with-cloudwatch-logs-decompression.html">https://docs.aws.amazon.com/firehose/latest/dev/writing-with-cloudwatch-logs-decompression.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.353Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DecompressionProcessor")
public class DecompressionProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IDataProcessor {

    protected DecompressionProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DecompressionProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DecompressionProcessor(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { options });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DecompressionProcessor() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Binds this processor to a destination of a delivery stream.
     * <p>
     * Implementers should use this method to grant processor invocation permissions to the provided stream and return the
     * necessary configuration to register as a processor.
     * <p>
     * @param _scope This parameter is required.
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * The constructor props of the DataProcessor.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorOptions.Builder options;

        private Builder() {
        }

        /**
         * The input compression format.
         * <p>
         * Default: DecompressionProcessorCompressionFormat.GZIP
         * <p>
         * @return {@code this}
         * @param compressionFormat The input compression format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compressionFormat(final software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorCompressionFormat compressionFormat) {
            this.options().compressionFormat(compressionFormat);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessor build() {
            return new software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessor(
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.kinesisfirehose.DecompressionProcessorOptions.Builder();
            }
            return this.options;
        }
    }
}
