package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Collection of grant methods for a IDeliveryStreamRef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.interfaces.kinesisfirehose.*;
 * IDeliveryStreamRef deliveryStreamRef;
 * DeliveryStreamGrants deliveryStreamGrants = DeliveryStreamGrants.fromDeliveryStream(deliveryStreamRef);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.356Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DeliveryStreamGrants")
public class DeliveryStreamGrants extends software.amazon.jsii.JsiiObject {

    protected DeliveryStreamGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DeliveryStreamGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates grants for DeliveryStreamGrants.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DeliveryStreamGrants fromDeliveryStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.kinesisfirehose.IDeliveryStreamRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.DeliveryStreamGrants.class, "fromDeliveryStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DeliveryStreamGrants.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Grant the <code>grantee</code> identity permissions to perform <code>actions</code>.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant putRecords(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "putRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.kinesisfirehose.IDeliveryStreamRef getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.kinesisfirehose.IDeliveryStreamRef.class));
    }
}
