package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Props for OpenX JSON input format for data record format conversion.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OpenXJsonInputFormat inputFormat = OpenXJsonInputFormat.Builder.create()
 *         .lowercaseColumnNames(false)
 *         .columnToJsonKeyMappings(Map.of("ts", "timestamp"))
 *         .convertDotsInJsonKeysToUnderscores(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.366Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.OpenXJsonInputFormatProps")
@software.amazon.jsii.Jsii.Proxy(OpenXJsonInputFormatProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OpenXJsonInputFormatProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Maps column names to JSON keys that aren't identical to the column names.
     * <p>
     * This is useful when the JSON contains keys that are Hive keywords.
     * For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code>
     * <p>
     * Default: JSON keys are not renamed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getColumnToJsonKeyMappings() {
        return null;
    }

    /**
     * When set to <code>true</code>, specifies that the names of the keys include dots and that you want Firehose to replace them with underscores.
     * <p>
     * This is useful because Apache Hive does not allow dots in column names.
     * For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
     * <p>
     * Default: `false`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getConvertDotsInJsonKeysToUnderscores() {
        return null;
    }

    /**
     * Whether the JSON keys should be lowercased when written as column names.
     * <p>
     * Default: `true`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLowercaseColumnNames() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OpenXJsonInputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OpenXJsonInputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OpenXJsonInputFormatProps> {
        java.util.Map<java.lang.String, java.lang.String> columnToJsonKeyMappings;
        java.lang.Boolean convertDotsInJsonKeysToUnderscores;
        java.lang.Boolean lowercaseColumnNames;

        /**
         * Sets the value of {@link OpenXJsonInputFormatProps#getColumnToJsonKeyMappings}
         * @param columnToJsonKeyMappings Maps column names to JSON keys that aren't identical to the column names.
         *                                This is useful when the JSON contains keys that are Hive keywords.
         *                                For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnToJsonKeyMappings(java.util.Map<java.lang.String, java.lang.String> columnToJsonKeyMappings) {
            this.columnToJsonKeyMappings = columnToJsonKeyMappings;
            return this;
        }

        /**
         * Sets the value of {@link OpenXJsonInputFormatProps#getConvertDotsInJsonKeysToUnderscores}
         * @param convertDotsInJsonKeysToUnderscores When set to <code>true</code>, specifies that the names of the keys include dots and that you want Firehose to replace them with underscores.
         *                                           This is useful because Apache Hive does not allow dots in column names.
         *                                           For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder convertDotsInJsonKeysToUnderscores(java.lang.Boolean convertDotsInJsonKeysToUnderscores) {
            this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
            return this;
        }

        /**
         * Sets the value of {@link OpenXJsonInputFormatProps#getLowercaseColumnNames}
         * @param lowercaseColumnNames Whether the JSON keys should be lowercased when written as column names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowercaseColumnNames(java.lang.Boolean lowercaseColumnNames) {
            this.lowercaseColumnNames = lowercaseColumnNames;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OpenXJsonInputFormatProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OpenXJsonInputFormatProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OpenXJsonInputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenXJsonInputFormatProps {
        private final java.util.Map<java.lang.String, java.lang.String> columnToJsonKeyMappings;
        private final java.lang.Boolean convertDotsInJsonKeysToUnderscores;
        private final java.lang.Boolean lowercaseColumnNames;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.columnToJsonKeyMappings = software.amazon.jsii.Kernel.get(this, "columnToJsonKeyMappings", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.convertDotsInJsonKeysToUnderscores = software.amazon.jsii.Kernel.get(this, "convertDotsInJsonKeysToUnderscores", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lowercaseColumnNames = software.amazon.jsii.Kernel.get(this, "lowercaseColumnNames", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.columnToJsonKeyMappings = builder.columnToJsonKeyMappings;
            this.convertDotsInJsonKeysToUnderscores = builder.convertDotsInJsonKeysToUnderscores;
            this.lowercaseColumnNames = builder.lowercaseColumnNames;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getColumnToJsonKeyMappings() {
            return this.columnToJsonKeyMappings;
        }

        @Override
        public final java.lang.Boolean getConvertDotsInJsonKeysToUnderscores() {
            return this.convertDotsInJsonKeysToUnderscores;
        }

        @Override
        public final java.lang.Boolean getLowercaseColumnNames() {
            return this.lowercaseColumnNames;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getColumnToJsonKeyMappings() != null) {
                data.set("columnToJsonKeyMappings", om.valueToTree(this.getColumnToJsonKeyMappings()));
            }
            if (this.getConvertDotsInJsonKeysToUnderscores() != null) {
                data.set("convertDotsInJsonKeysToUnderscores", om.valueToTree(this.getConvertDotsInJsonKeysToUnderscores()));
            }
            if (this.getLowercaseColumnNames() != null) {
                data.set("lowercaseColumnNames", om.valueToTree(this.getLowercaseColumnNames()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.OpenXJsonInputFormatProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OpenXJsonInputFormatProps.Jsii$Proxy that = (OpenXJsonInputFormatProps.Jsii$Proxy) o;

            if (this.columnToJsonKeyMappings != null ? !this.columnToJsonKeyMappings.equals(that.columnToJsonKeyMappings) : that.columnToJsonKeyMappings != null) return false;
            if (this.convertDotsInJsonKeysToUnderscores != null ? !this.convertDotsInJsonKeysToUnderscores.equals(that.convertDotsInJsonKeysToUnderscores) : that.convertDotsInJsonKeysToUnderscores != null) return false;
            return this.lowercaseColumnNames != null ? this.lowercaseColumnNames.equals(that.lowercaseColumnNames) : that.lowercaseColumnNames == null;
        }

        @Override
        public final int hashCode() {
            int result = this.columnToJsonKeyMappings != null ? this.columnToJsonKeyMappings.hashCode() : 0;
            result = 31 * result + (this.convertDotsInJsonKeysToUnderscores != null ? this.convertDotsInJsonKeysToUnderscores.hashCode() : 0);
            result = 31 * result + (this.lowercaseColumnNames != null ? this.lowercaseColumnNames.hashCode() : 0);
            return result;
        }
    }
}
