package software.amazon.awscdk.services.kinesisfirehose;

/**
 * The available WriterVersions for ORC output format.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OrcOutputFormat outputFormat = OrcOutputFormat.Builder.create()
 *         .formatVersion(OrcFormatVersion.V0_11)
 *         .blockSize(Size.mebibytes(256))
 *         .compression(OrcCompression.NONE)
 *         .bloomFilterColumns(List.of("columnA"))
 *         .bloomFilterFalsePositiveProbability(0.1)
 *         .dictionaryKeyThreshold(0.7)
 *         .enablePadding(true)
 *         .paddingTolerance(0.2)
 *         .rowIndexStride(9000)
 *         .stripeSize(Size.mebibytes(32))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.367Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.OrcFormatVersion")
public enum OrcFormatVersion {
    /**
     * Use V0_11 ORC writer version when writing the output of the record transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V0_11,
    /**
     * Use V0_12 ORC writer version when writing the output of the record transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V0_12,
}
