package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Props for ORC output format for data record format conversion.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OrcOutputFormat outputFormat = OrcOutputFormat.Builder.create()
 *         .formatVersion(OrcFormatVersion.V0_11)
 *         .blockSize(Size.mebibytes(256))
 *         .compression(OrcCompression.NONE)
 *         .bloomFilterColumns(List.of("columnA"))
 *         .bloomFilterFalsePositiveProbability(0.1)
 *         .dictionaryKeyThreshold(0.7)
 *         .enablePadding(true)
 *         .paddingTolerance(0.2)
 *         .rowIndexStride(9000)
 *         .stripeSize(Size.mebibytes(32))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.368Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.OrcOutputFormatProps")
@software.amazon.jsii.Jsii.Proxy(OrcOutputFormatProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrcOutputFormatProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Hadoop Distributed File System (HDFS) block size.
     * <p>
     * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
     * Firehose uses this value for padding calculations.
     * <p>
     * Default: `Size.mebibytes(256)`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getBlockSize() {
        return null;
    }

    /**
     * The column names for which you want Firehose to create bloom filters.
     * <p>
     * Default: no bloom filters are created
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBloomFilterColumns() {
        return null;
    }

    /**
     * The Bloom filter false positive probability (FPP).
     * <p>
     * The lower the FPP, the bigger the bloom filter.
     * <p>
     * Default: `0.05`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBloomFilterFalsePositiveProbability() {
        return null;
    }

    /**
     * The compression code to use over data blocks.
     * <p>
     * The possible values are <code>NONE</code> , <code>SNAPPY</code> , and <code>ZLIB</code>.
     * Use <code>SNAPPY</code> for higher decompression speed.
     * Use <code>GZIP</code> if the compression ratio is more important than speed.
     * <p>
     * Default: `SNAPPY`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression">https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.OrcCompression getCompression() {
        return null;
    }

    /**
     * Determines whether dictionary encoding should be applied to a column.
     * <p>
     * If the number of distinct keys (unique values) in a column exceeds this fraction of the total non-null rows in that column, dictionary encoding will be turned off for that specific column.
     * <p>
     * To turn off dictionary encoding, set this threshold to 0. To always use dictionary encoding, set this threshold to 1.
     * <p>
     * Default: `0.8`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDictionaryKeyThreshold() {
        return null;
    }

    /**
     * Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries.
     * <p>
     * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
     * <p>
     * Default: `false`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnablePadding() {
        return null;
    }

    /**
     * The version of the ORC format to write.
     * <p>
     * The possible values are <code>V0_11</code> and <code>V0_12</code>.
     * <p>
     * Default: `V0_12`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.OrcFormatVersion getFormatVersion() {
        return null;
    }

    /**
     * A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size.
     * <p>
     * The default value is 0.05, which means 5 percent of stripe size.
     * <p>
     * For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block.
     * In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space.
     * This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
     * <p>
     * Kinesis Data Firehose ignores this parameter when <code>EnablePadding</code> is <code>false</code> .
     * <p>
     * Default: `0.05` if `enablePadding` is `true`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPaddingTolerance() {
        return null;
    }

    /**
     * The number of rows between index entries.
     * <p>
     * Default: 10000
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRowIndexStride() {
        return null;
    }

    /**
     * The number of bytes in each stripe.
     * <p>
     * The default is 64 MiB and the minimum is 8 MiB.
     * <p>
     * Default: `Size.mebibytes(64)`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getStripeSize() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OrcOutputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrcOutputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrcOutputFormatProps> {
        software.amazon.awscdk.Size blockSize;
        java.util.List<java.lang.String> bloomFilterColumns;
        java.lang.Number bloomFilterFalsePositiveProbability;
        software.amazon.awscdk.services.kinesisfirehose.OrcCompression compression;
        java.lang.Number dictionaryKeyThreshold;
        java.lang.Boolean enablePadding;
        software.amazon.awscdk.services.kinesisfirehose.OrcFormatVersion formatVersion;
        java.lang.Number paddingTolerance;
        java.lang.Number rowIndexStride;
        software.amazon.awscdk.Size stripeSize;

        /**
         * Sets the value of {@link OrcOutputFormatProps#getBlockSize}
         * @param blockSize The Hadoop Distributed File System (HDFS) block size.
         *                  This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         *                  Firehose uses this value for padding calculations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockSize(software.amazon.awscdk.Size blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getBloomFilterColumns}
         * @param bloomFilterColumns The column names for which you want Firehose to create bloom filters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bloomFilterColumns(java.util.List<java.lang.String> bloomFilterColumns) {
            this.bloomFilterColumns = bloomFilterColumns;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getBloomFilterFalsePositiveProbability}
         * @param bloomFilterFalsePositiveProbability The Bloom filter false positive probability (FPP).
         *                                            The lower the FPP, the bigger the bloom filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bloomFilterFalsePositiveProbability(java.lang.Number bloomFilterFalsePositiveProbability) {
            this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getCompression}
         * @param compression The compression code to use over data blocks.
         *                    The possible values are <code>NONE</code> , <code>SNAPPY</code> , and <code>ZLIB</code>.
         *                    Use <code>SNAPPY</code> for higher decompression speed.
         *                    Use <code>GZIP</code> if the compression ratio is more important than speed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(software.amazon.awscdk.services.kinesisfirehose.OrcCompression compression) {
            this.compression = compression;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getDictionaryKeyThreshold}
         * @param dictionaryKeyThreshold Determines whether dictionary encoding should be applied to a column.
         *                               If the number of distinct keys (unique values) in a column exceeds this fraction of the total non-null rows in that column, dictionary encoding will be turned off for that specific column.
         *                               <p>
         *                               To turn off dictionary encoding, set this threshold to 0. To always use dictionary encoding, set this threshold to 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dictionaryKeyThreshold(java.lang.Number dictionaryKeyThreshold) {
            this.dictionaryKeyThreshold = dictionaryKeyThreshold;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getEnablePadding}
         * @param enablePadding Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries.
         *                      This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePadding(java.lang.Boolean enablePadding) {
            this.enablePadding = enablePadding;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getFormatVersion}
         * @param formatVersion The version of the ORC format to write.
         *                      The possible values are <code>V0_11</code> and <code>V0_12</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formatVersion(software.amazon.awscdk.services.kinesisfirehose.OrcFormatVersion formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getPaddingTolerance}
         * @param paddingTolerance A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size.
         *                         The default value is 0.05, which means 5 percent of stripe size.
         *                         <p>
         *                         For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block.
         *                         In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space.
         *                         This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
         *                         <p>
         *                         Kinesis Data Firehose ignores this parameter when <code>EnablePadding</code> is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paddingTolerance(java.lang.Number paddingTolerance) {
            this.paddingTolerance = paddingTolerance;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getRowIndexStride}
         * @param rowIndexStride The number of rows between index entries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowIndexStride(java.lang.Number rowIndexStride) {
            this.rowIndexStride = rowIndexStride;
            return this;
        }

        /**
         * Sets the value of {@link OrcOutputFormatProps#getStripeSize}
         * @param stripeSize The number of bytes in each stripe.
         *                   The default is 64 MiB and the minimum is 8 MiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stripeSize(software.amazon.awscdk.Size stripeSize) {
            this.stripeSize = stripeSize;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrcOutputFormatProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrcOutputFormatProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrcOutputFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrcOutputFormatProps {
        private final software.amazon.awscdk.Size blockSize;
        private final java.util.List<java.lang.String> bloomFilterColumns;
        private final java.lang.Number bloomFilterFalsePositiveProbability;
        private final software.amazon.awscdk.services.kinesisfirehose.OrcCompression compression;
        private final java.lang.Number dictionaryKeyThreshold;
        private final java.lang.Boolean enablePadding;
        private final software.amazon.awscdk.services.kinesisfirehose.OrcFormatVersion formatVersion;
        private final java.lang.Number paddingTolerance;
        private final java.lang.Number rowIndexStride;
        private final software.amazon.awscdk.Size stripeSize;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blockSize = software.amazon.jsii.Kernel.get(this, "blockSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.bloomFilterColumns = software.amazon.jsii.Kernel.get(this, "bloomFilterColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.bloomFilterFalsePositiveProbability = software.amazon.jsii.Kernel.get(this, "bloomFilterFalsePositiveProbability", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class));
            this.dictionaryKeyThreshold = software.amazon.jsii.Kernel.get(this, "dictionaryKeyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enablePadding = software.amazon.jsii.Kernel.get(this, "enablePadding", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.formatVersion = software.amazon.jsii.Kernel.get(this, "formatVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcFormatVersion.class));
            this.paddingTolerance = software.amazon.jsii.Kernel.get(this, "paddingTolerance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.rowIndexStride = software.amazon.jsii.Kernel.get(this, "rowIndexStride", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stripeSize = software.amazon.jsii.Kernel.get(this, "stripeSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blockSize = builder.blockSize;
            this.bloomFilterColumns = builder.bloomFilterColumns;
            this.bloomFilterFalsePositiveProbability = builder.bloomFilterFalsePositiveProbability;
            this.compression = builder.compression;
            this.dictionaryKeyThreshold = builder.dictionaryKeyThreshold;
            this.enablePadding = builder.enablePadding;
            this.formatVersion = builder.formatVersion;
            this.paddingTolerance = builder.paddingTolerance;
            this.rowIndexStride = builder.rowIndexStride;
            this.stripeSize = builder.stripeSize;
        }

        @Override
        public final software.amazon.awscdk.Size getBlockSize() {
            return this.blockSize;
        }

        @Override
        public final java.util.List<java.lang.String> getBloomFilterColumns() {
            return this.bloomFilterColumns;
        }

        @Override
        public final java.lang.Number getBloomFilterFalsePositiveProbability() {
            return this.bloomFilterFalsePositiveProbability;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.OrcCompression getCompression() {
            return this.compression;
        }

        @Override
        public final java.lang.Number getDictionaryKeyThreshold() {
            return this.dictionaryKeyThreshold;
        }

        @Override
        public final java.lang.Boolean getEnablePadding() {
            return this.enablePadding;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.OrcFormatVersion getFormatVersion() {
            return this.formatVersion;
        }

        @Override
        public final java.lang.Number getPaddingTolerance() {
            return this.paddingTolerance;
        }

        @Override
        public final java.lang.Number getRowIndexStride() {
            return this.rowIndexStride;
        }

        @Override
        public final software.amazon.awscdk.Size getStripeSize() {
            return this.stripeSize;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBlockSize() != null) {
                data.set("blockSize", om.valueToTree(this.getBlockSize()));
            }
            if (this.getBloomFilterColumns() != null) {
                data.set("bloomFilterColumns", om.valueToTree(this.getBloomFilterColumns()));
            }
            if (this.getBloomFilterFalsePositiveProbability() != null) {
                data.set("bloomFilterFalsePositiveProbability", om.valueToTree(this.getBloomFilterFalsePositiveProbability()));
            }
            if (this.getCompression() != null) {
                data.set("compression", om.valueToTree(this.getCompression()));
            }
            if (this.getDictionaryKeyThreshold() != null) {
                data.set("dictionaryKeyThreshold", om.valueToTree(this.getDictionaryKeyThreshold()));
            }
            if (this.getEnablePadding() != null) {
                data.set("enablePadding", om.valueToTree(this.getEnablePadding()));
            }
            if (this.getFormatVersion() != null) {
                data.set("formatVersion", om.valueToTree(this.getFormatVersion()));
            }
            if (this.getPaddingTolerance() != null) {
                data.set("paddingTolerance", om.valueToTree(this.getPaddingTolerance()));
            }
            if (this.getRowIndexStride() != null) {
                data.set("rowIndexStride", om.valueToTree(this.getRowIndexStride()));
            }
            if (this.getStripeSize() != null) {
                data.set("stripeSize", om.valueToTree(this.getStripeSize()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.OrcOutputFormatProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrcOutputFormatProps.Jsii$Proxy that = (OrcOutputFormatProps.Jsii$Proxy) o;

            if (this.blockSize != null ? !this.blockSize.equals(that.blockSize) : that.blockSize != null) return false;
            if (this.bloomFilterColumns != null ? !this.bloomFilterColumns.equals(that.bloomFilterColumns) : that.bloomFilterColumns != null) return false;
            if (this.bloomFilterFalsePositiveProbability != null ? !this.bloomFilterFalsePositiveProbability.equals(that.bloomFilterFalsePositiveProbability) : that.bloomFilterFalsePositiveProbability != null) return false;
            if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
            if (this.dictionaryKeyThreshold != null ? !this.dictionaryKeyThreshold.equals(that.dictionaryKeyThreshold) : that.dictionaryKeyThreshold != null) return false;
            if (this.enablePadding != null ? !this.enablePadding.equals(that.enablePadding) : that.enablePadding != null) return false;
            if (this.formatVersion != null ? !this.formatVersion.equals(that.formatVersion) : that.formatVersion != null) return false;
            if (this.paddingTolerance != null ? !this.paddingTolerance.equals(that.paddingTolerance) : that.paddingTolerance != null) return false;
            if (this.rowIndexStride != null ? !this.rowIndexStride.equals(that.rowIndexStride) : that.rowIndexStride != null) return false;
            return this.stripeSize != null ? this.stripeSize.equals(that.stripeSize) : that.stripeSize == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blockSize != null ? this.blockSize.hashCode() : 0;
            result = 31 * result + (this.bloomFilterColumns != null ? this.bloomFilterColumns.hashCode() : 0);
            result = 31 * result + (this.bloomFilterFalsePositiveProbability != null ? this.bloomFilterFalsePositiveProbability.hashCode() : 0);
            result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
            result = 31 * result + (this.dictionaryKeyThreshold != null ? this.dictionaryKeyThreshold.hashCode() : 0);
            result = 31 * result + (this.enablePadding != null ? this.enablePadding.hashCode() : 0);
            result = 31 * result + (this.formatVersion != null ? this.formatVersion.hashCode() : 0);
            result = 31 * result + (this.paddingTolerance != null ? this.paddingTolerance.hashCode() : 0);
            result = 31 * result + (this.rowIndexStride != null ? this.rowIndexStride.hashCode() : 0);
            result = 31 * result + (this.stripeSize != null ? this.stripeSize.hashCode() : 0);
            return result;
        }
    }
}
