package software.amazon.awscdk.services.kinesisfirehose;

/**
 * This class specifies properties for Parquet output format for record format conversion.
 * <p>
 * You should only need to specify an instance of this class if the default configuration does not suit your needs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ParquetOutputFormat outputFormat = ParquetOutputFormat.Builder.create()
 *         .blockSize(Size.mebibytes(512))
 *         .compression(ParquetCompression.UNCOMPRESSED)
 *         .enableDictionaryCompression(true)
 *         .maxPadding(Size.bytes(10))
 *         .pageSize(Size.mebibytes(2))
 *         .writerVersion(ParquetWriterVersion.V2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.370Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.ParquetOutputFormat")
public class ParquetOutputFormat extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IOutputFormat {

    protected ParquetOutputFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ParquetOutputFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ParquetOutputFormat(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormatProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ParquetOutputFormat() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Renders the cloudformation properties for the output format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty createOutputFormatConfig() {
        return software.amazon.jsii.Kernel.call(this, "createOutputFormatConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty.class));
    }

    /**
     * Properties for the Parquet output format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormatProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormatProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormat}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormat> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormatProps.Builder props;

        private Builder() {
        }

        /**
         * The Hadoop Distributed File System (HDFS) block size.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         * Firehose uses this value for padding calculations.
         * <p>
         * Default: `Size.mebibytes(256)`
         * <p>
         * @return {@code this}
         * @param blockSize The Hadoop Distributed File System (HDFS) block size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockSize(final software.amazon.awscdk.Size blockSize) {
            this.props().blockSize(blockSize);
            return this;
        }

        /**
         * The compression code to use over data blocks.
         * <p>
         * The possible values are <code>UNCOMPRESSED</code> , <code>SNAPPY</code> , and <code>GZIP</code>.
         * Use <code>SNAPPY</code> for higher decompression speed.
         * Use <code>GZIP</code> if the compression ratio is more important than speed.
         * <p>
         * Default: `SNAPPY`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression</a>
         * @param compression The compression code to use over data blocks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(final software.amazon.awscdk.services.kinesisfirehose.ParquetCompression compression) {
            this.props().compression(compression);
            return this;
        }

        /**
         * Indicates whether to enable dictionary compression.
         * <p>
         * Default: `false`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression</a>
         * @param enableDictionaryCompression Indicates whether to enable dictionary compression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDictionaryCompression(final java.lang.Boolean enableDictionaryCompression) {
            this.props().enableDictionaryCompression(enableDictionaryCompression);
            return this;
        }

        /**
         * The maximum amount of padding to apply.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying.
         * <p>
         * Default: no padding is applied
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes</a>
         * @param maxPadding The maximum amount of padding to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxPadding(final software.amazon.awscdk.Size maxPadding) {
            this.props().maxPadding(maxPadding);
            return this;
        }

        /**
         * The Parquet page size.
         * <p>
         * Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
         * <p>
         * Default: `Size.mebibytes(1)`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes</a>
         * @param pageSize The Parquet page size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pageSize(final software.amazon.awscdk.Size pageSize) {
            this.props().pageSize(pageSize);
            return this;
        }

        /**
         * Indicates the version of Parquet to output.
         * <p>
         * The possible values are <code>V1</code> and <code>V2</code>
         * <p>
         * Default: `V1`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion</a>
         * @param writerVersion Indicates the version of Parquet to output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writerVersion(final software.amazon.awscdk.services.kinesisfirehose.ParquetWriterVersion writerVersion) {
            this.props().writerVersion(writerVersion);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormat}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormat build() {
            return new software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormat(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormatProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormatProps.Builder();
            }
            return this.props;
        }
    }
}
