package software.amazon.awscdk.services.kinesisfirehose;

/**
 * The available WriterVersions for Parquet output format.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ParquetOutputFormat outputFormat = ParquetOutputFormat.Builder.create()
 *         .blockSize(Size.mebibytes(512))
 *         .compression(ParquetCompression.UNCOMPRESSED)
 *         .enableDictionaryCompression(true)
 *         .maxPadding(Size.bytes(10))
 *         .pageSize(Size.mebibytes(2))
 *         .writerVersion(ParquetWriterVersion.V2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.371Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.ParquetWriterVersion")
public enum ParquetWriterVersion {
    /**
     * Use V1 Parquet writer version when writing the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V1,
    /**
     * Use V2 Parquet writer version when writing the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V2,
}
