package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Represents a schema configuration for Firehose S3 data record format conversion.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * CfnTable schemaGlueTable;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .dataFormatConversion(DataFormatConversionProps.builder()
 *                 .schemaConfiguration(SchemaConfiguration.fromCfnTable(schemaGlueTable))
 *                 .inputFormat(InputFormat.OPENX_JSON)
 *                 .outputFormat(OutputFormat.PARQUET)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-schemaconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-schemaconfiguration</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.374Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.SchemaConfiguration")
public class SchemaConfiguration extends software.amazon.jsii.JsiiObject {

    protected SchemaConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SchemaConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Obtain schema configuration for data record format conversion from an <code>aws_glue.CfnTable</code>.
     * <p>
     * @param table This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration fromCfnTable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnTable table, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.SchemaConfigurationFromCfnTableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration.class, "fromCfnTable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration.class), new Object[] { java.util.Objects.requireNonNull(table, "table is required"), props });
    }

    /**
     * Obtain schema configuration for data record format conversion from an <code>aws_glue.CfnTable</code>.
     * <p>
     * @param table This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration fromCfnTable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnTable table) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration.class, "fromCfnTable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.SchemaConfiguration.class), new Object[] { java.util.Objects.requireNonNull(table, "table is required") });
    }

    /**
     * Binds this Schema to the Destination, adding the necessary permissions to the Destination role.
     * <p>
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.SchemaConfigurationBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }
}
