/**
 * <h1>AWS::LakeFormation Construct Library</h1>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lakeformation.*;
 * </pre></blockquote>
 * <p>
 * <!--BEGIN CFNONLY DISCLAIMER-->
 * <p>
 * There are no official hand-written (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">L2</a>) constructs for this service yet. Here are some suggestions on how to proceed:
 * <p>
 * <ul>
 * <li>Search <a href="https://constructs.dev/search?q=lakeformation">Construct Hub for LakeFormation construct libraries</a></li>
 * <li>Use the automatically generated <a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using">L1</a> constructs, in the same way you would use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_LakeFormation.html">the CloudFormation AWS::LakeFormation resources</a> directly.</li>
 * </ul>
 * <p>
 * <!--BEGIN CFNONLY DISCLAIMER-->
 * <p>
 * There are no hand-written (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">L2</a>) constructs for this service yet.
 * However, you can still use the automatically generated <a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using">L1</a> constructs, and use this service exactly as you would using CloudFormation directly.
 * <p>
 * For more information on the resources and properties available for this service, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_LakeFormation.html">CloudFormation documentation for AWS::LakeFormation</a>.
 * <p>
 * (Read the <a href="https://github.com/aws/aws-cdk/blob/main/CONTRIBUTING.md">CDK Contributing Guide</a> and submit an RFC if you are interested in contributing to this construct library.)
 * <p>
 * <!--END CFNONLY DISCLAIMER-->
 * <p>
 * <h2>Example</h2>
 * <p>
 * Here is an example of creating a glue table and putting lakeformation tags on it. Note: this example uses deprecated constructs and overly permissive IAM roles. This example is meant to give a general idea of using the L1s; it is not production level.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.glue.alpha.S3Table;
 * import software.amazon.awscdk.services.glue.alpha.Database;
 * import software.amazon.awscdk.services.glue.alpha.DataFormat;
 * import software.amazon.awscdk.services.glue.alpha.Schema;
 * import software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings;
 * import software.amazon.awscdk.services.lakeformation.CfnTag;
 * import software.amazon.awscdk.services.lakeformation.CfnTagAssociation;
 * 
 * Stack stack;
 * String accountId;
 * 
 * 
 * String tagKey = "aws";
 * String[] tagValues = List.of("dev");
 * 
 * Database database = new Database(this, "Database");
 * 
 * S3Table table = S3Table.Builder.create(this, "Table")
 *         .database(database)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build(), Column.builder()
 *                 .name("col2")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.CSV)
 *         .build();
 * 
 * DefaultStackSynthesizer synthesizer = (DefaultStackSynthesizer)stack.getSynthesizer();
 * CfnDataLakeSettings.Builder.create(this, "DataLakeSettings")
 *         .admins(List.of(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier(stack.formatArn(ArnComponents.builder()
 *                         .service("iam")
 *                         .resource("role")
 *                         .region("")
 *                         .account(accountId)
 *                         .resourceName("Admin")
 *                         .build()))
 *                 .build(), DataLakePrincipalProperty.builder()
 *                 // The CDK cloudformation execution role.
 *                 .dataLakePrincipalIdentifier(synthesizer.cloudFormationExecutionRoleArn.replace("${AWS::Partition}", "aws"))
 *                 .build()))
 *         .build();
 * 
 * CfnTag tag = CfnTag.Builder.create(this, "Tag")
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * 
 * LFTagPairProperty lfTagPairProperty = LFTagPairProperty.builder()
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * 
 * CfnTagAssociation tagAssociation = CfnTagAssociation.Builder.create(this, "TagAssociation")
 *         .lfTags(List.of(lfTagPairProperty))
 *         .resource(ResourceProperty.builder()
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .databaseName(database.getDatabaseName())
 *                         .columnNames(List.of("col1", "col2"))
 *                         .catalogId(accountId)
 *                         .name(table.getTableName())
 *                         .build())
 *                 .build())
 *         .build();
 * 
 * tagAssociation.node.addDependency(tag);
 * tagAssociation.node.addDependency(table);
 * </pre></blockquote>
 * <p>
 * Additionally, you may need to use the lakeformation console to give permissions, particularly to give the cdk-exec-role tagging permissions.
 */
package software.amazon.awscdk.services.lakeformation;
