package software.amazon.awscdk.services.lambda;

/**
 * A Lambda capacity provider that manages compute resources for Lambda functions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * Vpc vpc = new Vpc(this, "MyVpc");
 * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build();
 * CapacityProvider capacityProvider = CapacityProvider.Builder.create(this, "MyCapacityProvider")
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(securityGroup))
 *         .scalingOptions(ScalingOptions.manual(List.of(TargetTrackingScalingPolicy.cpuUtilization(70))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.526Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CapacityProvider")
public class CapacityProvider extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.lambda.ICapacityProvider {

    protected CapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CapacityProvider.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Creates a new Lambda capacity provider.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The construct ID. This parameter is required.
     * @param props The capacity provider properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing capacity provider by ARN.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The construct ID. This parameter is required.
     * @param capacityProviderArn The ARN of the capacity provider to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ICapacityProvider fromCapacityProviderArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String capacityProviderArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.CapacityProvider.class, "fromCapacityProviderArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ICapacityProvider.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(capacityProviderArn, "capacityProviderArn is required") });
    }

    /**
     * Import an existing capacity provider using its attributes.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The construct ID. This parameter is required.
     * @param attrs The capacity provider attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ICapacityProvider fromCapacityProviderAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CapacityProviderAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.CapacityProvider.class, "fromCapacityProviderAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ICapacityProvider.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing capacity provider by name.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The construct ID. This parameter is required.
     * @param capacityProviderName The name of the capacity provider to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ICapacityProvider fromCapacityProviderName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String capacityProviderName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.CapacityProvider.class, "fromCapacityProviderName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ICapacityProvider.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(capacityProviderName, "capacityProviderName is required") });
    }

    /**
     * Configures a Lambda function to use this capacity provider.
     * <p>
     * @param func The Lambda function to configure. This parameter is required.
     * @param options Optional configuration for the function's capacity provider settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction func, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CapacityProviderFunctionOptions options) {
        software.amazon.jsii.Kernel.call(this, "addFunction", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(func, "func is required"), options });
    }

    /**
     * Configures a Lambda function to use this capacity provider.
     * <p>
     * @param func The Lambda function to configure. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction func) {
        software.amazon.jsii.Kernel.call(this, "addFunction", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(func, "func is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Amazon Resource Name (ARN) of the capacity provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCapacityProviderArn() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the capacity provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCapacityProviderName() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.CapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent construct. This parameter is required.
         * @param id The construct ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.CapacityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.CapacityProviderProps.Builder();
        }

        /**
         * A list of security group IDs to associate with EC2 instances launched by the capacity provider.
         * <p>
         * Up to 5 security groups can be specified.
         * <p>
         * @return {@code this}
         * @param securityGroups A list of security group IDs to associate with EC2 instances launched by the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * A list of subnets where the capacity provider can launch EC2 instances.
         * <p>
         * At least one subnet must be specified, and up to 16 subnets are supported.
         * <p>
         * @return {@code this}
         * @param subnets A list of subnets where the capacity provider can launch EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * The instruction set architecture required for compute instances.
         * <p>
         * Only one architecture can be specified per capacity provider.
         * <p>
         * Default: - No architecture constraints specified
         * <p>
         * @return {@code this}
         * @param architectures The instruction set architecture required for compute instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architectures(final java.util.List<? extends software.amazon.awscdk.services.lambda.Architecture> architectures) {
            this.props.architectures(architectures);
            return this;
        }

        /**
         * The name of the capacity provider.
         * <p>
         * The name must be unique within the AWS account and region.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that
         * ID for the capacity provider's name.
         * <p>
         * @return {@code this}
         * @param capacityProviderName The name of the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(final java.lang.String capacityProviderName) {
            this.props.capacityProviderName(capacityProviderName);
            return this;
        }

        /**
         * Configuration for filtering instance types that the capacity provider can use.
         * <p>
         * Default: - No instance type filtering applied
         * <p>
         * @return {@code this}
         * @param instanceTypeFilter Configuration for filtering instance types that the capacity provider can use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeFilter(final software.amazon.awscdk.services.lambda.InstanceTypeFilter instanceTypeFilter) {
            this.props.instanceTypeFilter(instanceTypeFilter);
            return this;
        }

        /**
         * The AWS Key Management Service (KMS) key used to encrypt data associated with the capacity provider.
         * <p>
         * Default: - No KMS key specified, uses an AWS-managed key instead
         * <p>
         * @return {@code this}
         * @param kmsKey The AWS Key Management Service (KMS) key used to encrypt data associated with the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * The maximum number of vCPUs that the capacity provider can scale up to.
         * <p>
         * Default: - No maximum limit specified, service default is 400
         * <p>
         * @return {@code this}
         * @param maxVCpuCount The maximum number of vCPUs that the capacity provider can scale up to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxVCpuCount(final java.lang.Number maxVCpuCount) {
            this.props.maxVCpuCount(maxVCpuCount);
            return this;
        }

        /**
         * The IAM role that the Lambda service assumes to manage the capacity provider.
         * <p>
         * Default: - A role will be generated containing the AWSLambdaManagedEC2ResourceOperator managed policy
         * <p>
         * @return {@code this}
         * @param operatorRole The IAM role that the Lambda service assumes to manage the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatorRole(final software.amazon.awscdk.services.iam.IRole operatorRole) {
            this.props.operatorRole(operatorRole);
            return this;
        }

        /**
         * The options for scaling a capacity provider, including scaling policies.
         * <p>
         * Default: - The `Auto` option is applied by default
         * <p>
         * @return {@code this}
         * @param scalingOptions The options for scaling a capacity provider, including scaling policies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingOptions(final software.amazon.awscdk.services.lambda.ScalingOptions scalingOptions) {
            this.props.scalingOptions(scalingOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.CapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.CapacityProvider build() {
            return new software.amazon.awscdk.services.lambda.CapacityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
