package software.amazon.awscdk.services.lambda;

/**
 * Options for creating a function associated with a capacity provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CapacityProvider capacityProvider;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         // Runtime must be equal to or newer than NODEJS_22_X
 *         .runtime(Runtime.NODEJS_22_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * // Associate the function with the capacity provider
 * capacityProvider.addFunction(fn, CapacityProviderFunctionOptions.builder()
 *         .perExecutionEnvironmentMaxConcurrency(10)
 *         .executionEnvironmentMemoryGiBPerVCpu(4)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.527Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CapacityProviderFunctionOptions")
@software.amazon.jsii.Jsii.Proxy(CapacityProviderFunctionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CapacityProviderFunctionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the execution environment memory per VCPU, in GiB.
     * <p>
     * Default: 2.0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getExecutionEnvironmentMemoryGiBPerVCpu() {
        return null;
    }

    /**
     * The scaling options that are applied to the $LATEST.PUBLISHED version.
     * <p>
     * Default: - No scaling limitations are applied to the $LATEST.PUBLISHED version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.LatestPublishedScalingConfig getLatestPublishedScalingConfig() {
        return null;
    }

    /**
     * Specifies the maximum number of concurrent invokes a single execution environment can handle.
     * <p>
     * Default: Maximum is set to 10
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPerExecutionEnvironmentMaxConcurrency() {
        return null;
    }

    /**
     * A boolean determining whether or not to automatically publish to the $LATEST.PUBLISHED version.
     * <p>
     * Default: - True
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublishToLatestPublished() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CapacityProviderFunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CapacityProviderFunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderFunctionOptions> {
        java.lang.Number executionEnvironmentMemoryGiBPerVCpu;
        software.amazon.awscdk.services.lambda.LatestPublishedScalingConfig latestPublishedScalingConfig;
        java.lang.Number perExecutionEnvironmentMaxConcurrency;
        java.lang.Boolean publishToLatestPublished;

        /**
         * Sets the value of {@link CapacityProviderFunctionOptions#getExecutionEnvironmentMemoryGiBPerVCpu}
         * @param executionEnvironmentMemoryGiBPerVCpu Specifies the execution environment memory per VCPU, in GiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionEnvironmentMemoryGiBPerVCpu(java.lang.Number executionEnvironmentMemoryGiBPerVCpu) {
            this.executionEnvironmentMemoryGiBPerVCpu = executionEnvironmentMemoryGiBPerVCpu;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderFunctionOptions#getLatestPublishedScalingConfig}
         * @param latestPublishedScalingConfig The scaling options that are applied to the $LATEST.PUBLISHED version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestPublishedScalingConfig(software.amazon.awscdk.services.lambda.LatestPublishedScalingConfig latestPublishedScalingConfig) {
            this.latestPublishedScalingConfig = latestPublishedScalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderFunctionOptions#getPerExecutionEnvironmentMaxConcurrency}
         * @param perExecutionEnvironmentMaxConcurrency Specifies the maximum number of concurrent invokes a single execution environment can handle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder perExecutionEnvironmentMaxConcurrency(java.lang.Number perExecutionEnvironmentMaxConcurrency) {
            this.perExecutionEnvironmentMaxConcurrency = perExecutionEnvironmentMaxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderFunctionOptions#getPublishToLatestPublished}
         * @param publishToLatestPublished A boolean determining whether or not to automatically publish to the $LATEST.PUBLISHED version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishToLatestPublished(java.lang.Boolean publishToLatestPublished) {
            this.publishToLatestPublished = publishToLatestPublished;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CapacityProviderFunctionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CapacityProviderFunctionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CapacityProviderFunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderFunctionOptions {
        private final java.lang.Number executionEnvironmentMemoryGiBPerVCpu;
        private final software.amazon.awscdk.services.lambda.LatestPublishedScalingConfig latestPublishedScalingConfig;
        private final java.lang.Number perExecutionEnvironmentMaxConcurrency;
        private final java.lang.Boolean publishToLatestPublished;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionEnvironmentMemoryGiBPerVCpu = software.amazon.jsii.Kernel.get(this, "executionEnvironmentMemoryGiBPerVCpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.latestPublishedScalingConfig = software.amazon.jsii.Kernel.get(this, "latestPublishedScalingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LatestPublishedScalingConfig.class));
            this.perExecutionEnvironmentMaxConcurrency = software.amazon.jsii.Kernel.get(this, "perExecutionEnvironmentMaxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.publishToLatestPublished = software.amazon.jsii.Kernel.get(this, "publishToLatestPublished", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionEnvironmentMemoryGiBPerVCpu = builder.executionEnvironmentMemoryGiBPerVCpu;
            this.latestPublishedScalingConfig = builder.latestPublishedScalingConfig;
            this.perExecutionEnvironmentMaxConcurrency = builder.perExecutionEnvironmentMaxConcurrency;
            this.publishToLatestPublished = builder.publishToLatestPublished;
        }

        @Override
        public final java.lang.Number getExecutionEnvironmentMemoryGiBPerVCpu() {
            return this.executionEnvironmentMemoryGiBPerVCpu;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.LatestPublishedScalingConfig getLatestPublishedScalingConfig() {
            return this.latestPublishedScalingConfig;
        }

        @Override
        public final java.lang.Number getPerExecutionEnvironmentMaxConcurrency() {
            return this.perExecutionEnvironmentMaxConcurrency;
        }

        @Override
        public final java.lang.Boolean getPublishToLatestPublished() {
            return this.publishToLatestPublished;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExecutionEnvironmentMemoryGiBPerVCpu() != null) {
                data.set("executionEnvironmentMemoryGiBPerVCpu", om.valueToTree(this.getExecutionEnvironmentMemoryGiBPerVCpu()));
            }
            if (this.getLatestPublishedScalingConfig() != null) {
                data.set("latestPublishedScalingConfig", om.valueToTree(this.getLatestPublishedScalingConfig()));
            }
            if (this.getPerExecutionEnvironmentMaxConcurrency() != null) {
                data.set("perExecutionEnvironmentMaxConcurrency", om.valueToTree(this.getPerExecutionEnvironmentMaxConcurrency()));
            }
            if (this.getPublishToLatestPublished() != null) {
                data.set("publishToLatestPublished", om.valueToTree(this.getPublishToLatestPublished()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CapacityProviderFunctionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CapacityProviderFunctionOptions.Jsii$Proxy that = (CapacityProviderFunctionOptions.Jsii$Proxy) o;

            if (this.executionEnvironmentMemoryGiBPerVCpu != null ? !this.executionEnvironmentMemoryGiBPerVCpu.equals(that.executionEnvironmentMemoryGiBPerVCpu) : that.executionEnvironmentMemoryGiBPerVCpu != null) return false;
            if (this.latestPublishedScalingConfig != null ? !this.latestPublishedScalingConfig.equals(that.latestPublishedScalingConfig) : that.latestPublishedScalingConfig != null) return false;
            if (this.perExecutionEnvironmentMaxConcurrency != null ? !this.perExecutionEnvironmentMaxConcurrency.equals(that.perExecutionEnvironmentMaxConcurrency) : that.perExecutionEnvironmentMaxConcurrency != null) return false;
            return this.publishToLatestPublished != null ? this.publishToLatestPublished.equals(that.publishToLatestPublished) : that.publishToLatestPublished == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executionEnvironmentMemoryGiBPerVCpu != null ? this.executionEnvironmentMemoryGiBPerVCpu.hashCode() : 0;
            result = 31 * result + (this.latestPublishedScalingConfig != null ? this.latestPublishedScalingConfig.hashCode() : 0);
            result = 31 * result + (this.perExecutionEnvironmentMaxConcurrency != null ? this.perExecutionEnvironmentMaxConcurrency.hashCode() : 0);
            result = 31 * result + (this.publishToLatestPublished != null ? this.publishToLatestPublished.hashCode() : 0);
            return result;
        }
    }
}
