package software.amazon.awscdk.services.lambda;

/**
 * Properties for creating a Lambda capacity provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * Vpc vpc = new Vpc(this, "MyVpc");
 * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build();
 * CapacityProvider capacityProvider = CapacityProvider.Builder.create(this, "MyCapacityProvider")
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(securityGroup))
 *         .scalingOptions(ScalingOptions.manual(List.of(TargetTrackingScalingPolicy.cpuUtilization(70))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.528Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CapacityProviderProps")
@software.amazon.jsii.Jsii.Proxy(CapacityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CapacityProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of security group IDs to associate with EC2 instances launched by the capacity provider.
     * <p>
     * Up to 5 security groups can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * A list of subnets where the capacity provider can launch EC2 instances.
     * <p>
     * At least one subnet must be specified, and up to 16 subnets are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets();

    /**
     * The instruction set architecture required for compute instances.
     * <p>
     * Only one architecture can be specified per capacity provider.
     * <p>
     * Default: - No architecture constraints specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.Architecture> getArchitectures() {
        return null;
    }

    /**
     * The name of the capacity provider.
     * <p>
     * The name must be unique within the AWS account and region.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that
     * ID for the capacity provider's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProviderName() {
        return null;
    }

    /**
     * Configuration for filtering instance types that the capacity provider can use.
     * <p>
     * Default: - No instance type filtering applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.InstanceTypeFilter getInstanceTypeFilter() {
        return null;
    }

    /**
     * The AWS Key Management Service (KMS) key used to encrypt data associated with the capacity provider.
     * <p>
     * Default: - No KMS key specified, uses an AWS-managed key instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * The maximum number of vCPUs that the capacity provider can scale up to.
     * <p>
     * Default: - No maximum limit specified, service default is 400
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxVCpuCount() {
        return null;
    }

    /**
     * The IAM role that the Lambda service assumes to manage the capacity provider.
     * <p>
     * Default: - A role will be generated containing the AWSLambdaManagedEC2ResourceOperator managed policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getOperatorRole() {
        return null;
    }

    /**
     * The options for scaling a capacity provider, including scaling policies.
     * <p>
     * Default: - The `Auto` option is applied by default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ScalingOptions getScalingOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderProps> {
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        java.util.List<software.amazon.awscdk.services.lambda.Architecture> architectures;
        java.lang.String capacityProviderName;
        software.amazon.awscdk.services.lambda.InstanceTypeFilter instanceTypeFilter;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        java.lang.Number maxVCpuCount;
        software.amazon.awscdk.services.iam.IRole operatorRole;
        software.amazon.awscdk.services.lambda.ScalingOptions scalingOptions;

        /**
         * Sets the value of {@link CapacityProviderProps#getSecurityGroups}
         * @param securityGroups A list of security group IDs to associate with EC2 instances launched by the capacity provider. This parameter is required.
         *                       Up to 5 security groups can be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getSubnets}
         * @param subnets A list of subnets where the capacity provider can launch EC2 instances. This parameter is required.
         *                At least one subnet must be specified, and up to 16 subnets are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)subnets;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getArchitectures}
         * @param architectures The instruction set architecture required for compute instances.
         *                      Only one architecture can be specified per capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder architectures(java.util.List<? extends software.amazon.awscdk.services.lambda.Architecture> architectures) {
            this.architectures = (java.util.List<software.amazon.awscdk.services.lambda.Architecture>)architectures;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getCapacityProviderName}
         * @param capacityProviderName The name of the capacity provider.
         *                             The name must be unique within the AWS account and region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(java.lang.String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getInstanceTypeFilter}
         * @param instanceTypeFilter Configuration for filtering instance types that the capacity provider can use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeFilter(software.amazon.awscdk.services.lambda.InstanceTypeFilter instanceTypeFilter) {
            this.instanceTypeFilter = instanceTypeFilter;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getKmsKey}
         * @param kmsKey The AWS Key Management Service (KMS) key used to encrypt data associated with the capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getMaxVCpuCount}
         * @param maxVCpuCount The maximum number of vCPUs that the capacity provider can scale up to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxVCpuCount(java.lang.Number maxVCpuCount) {
            this.maxVCpuCount = maxVCpuCount;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getOperatorRole}
         * @param operatorRole The IAM role that the Lambda service assumes to manage the capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatorRole(software.amazon.awscdk.services.iam.IRole operatorRole) {
            this.operatorRole = operatorRole;
            return this;
        }

        /**
         * Sets the value of {@link CapacityProviderProps#getScalingOptions}
         * @param scalingOptions The options for scaling a capacity provider, including scaling policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingOptions(software.amazon.awscdk.services.lambda.ScalingOptions scalingOptions) {
            this.scalingOptions = scalingOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CapacityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CapacityProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderProps {
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        private final java.util.List<software.amazon.awscdk.services.lambda.Architecture> architectures;
        private final java.lang.String capacityProviderName;
        private final software.amazon.awscdk.services.lambda.InstanceTypeFilter instanceTypeFilter;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final java.lang.Number maxVCpuCount;
        private final software.amazon.awscdk.services.iam.IRole operatorRole;
        private final software.amazon.awscdk.services.lambda.ScalingOptions scalingOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)));
            this.architectures = software.amazon.jsii.Kernel.get(this, "architectures", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class)));
            this.capacityProviderName = software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceTypeFilter = software.amazon.jsii.Kernel.get(this, "instanceTypeFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.InstanceTypeFilter.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.maxVCpuCount = software.amazon.jsii.Kernel.get(this, "maxVCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.operatorRole = software.amazon.jsii.Kernel.get(this, "operatorRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.scalingOptions = software.amazon.jsii.Kernel.get(this, "scalingOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ScalingOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)java.util.Objects.requireNonNull(builder.securityGroups, "securityGroups is required");
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            this.architectures = (java.util.List<software.amazon.awscdk.services.lambda.Architecture>)builder.architectures;
            this.capacityProviderName = builder.capacityProviderName;
            this.instanceTypeFilter = builder.instanceTypeFilter;
            this.kmsKey = builder.kmsKey;
            this.maxVCpuCount = builder.maxVCpuCount;
            this.operatorRole = builder.operatorRole;
            this.scalingOptions = builder.scalingOptions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.Architecture> getArchitectures() {
            return this.architectures;
        }

        @Override
        public final java.lang.String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.InstanceTypeFilter getInstanceTypeFilter() {
            return this.instanceTypeFilter;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.Number getMaxVCpuCount() {
            return this.maxVCpuCount;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getOperatorRole() {
            return this.operatorRole;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ScalingOptions getScalingOptions() {
            return this.scalingOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            data.set("subnets", om.valueToTree(this.getSubnets()));
            if (this.getArchitectures() != null) {
                data.set("architectures", om.valueToTree(this.getArchitectures()));
            }
            if (this.getCapacityProviderName() != null) {
                data.set("capacityProviderName", om.valueToTree(this.getCapacityProviderName()));
            }
            if (this.getInstanceTypeFilter() != null) {
                data.set("instanceTypeFilter", om.valueToTree(this.getInstanceTypeFilter()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getMaxVCpuCount() != null) {
                data.set("maxVCpuCount", om.valueToTree(this.getMaxVCpuCount()));
            }
            if (this.getOperatorRole() != null) {
                data.set("operatorRole", om.valueToTree(this.getOperatorRole()));
            }
            if (this.getScalingOptions() != null) {
                data.set("scalingOptions", om.valueToTree(this.getScalingOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CapacityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CapacityProviderProps.Jsii$Proxy that = (CapacityProviderProps.Jsii$Proxy) o;

            if (!securityGroups.equals(that.securityGroups)) return false;
            if (!subnets.equals(that.subnets)) return false;
            if (this.architectures != null ? !this.architectures.equals(that.architectures) : that.architectures != null) return false;
            if (this.capacityProviderName != null ? !this.capacityProviderName.equals(that.capacityProviderName) : that.capacityProviderName != null) return false;
            if (this.instanceTypeFilter != null ? !this.instanceTypeFilter.equals(that.instanceTypeFilter) : that.instanceTypeFilter != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.maxVCpuCount != null ? !this.maxVCpuCount.equals(that.maxVCpuCount) : that.maxVCpuCount != null) return false;
            if (this.operatorRole != null ? !this.operatorRole.equals(that.operatorRole) : that.operatorRole != null) return false;
            return this.scalingOptions != null ? this.scalingOptions.equals(that.scalingOptions) : that.scalingOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.securityGroups.hashCode();
            result = 31 * result + (this.subnets.hashCode());
            result = 31 * result + (this.architectures != null ? this.architectures.hashCode() : 0);
            result = 31 * result + (this.capacityProviderName != null ? this.capacityProviderName.hashCode() : 0);
            result = 31 * result + (this.instanceTypeFilter != null ? this.instanceTypeFilter.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.maxVCpuCount != null ? this.maxVCpuCount.hashCode() : 0);
            result = 31 * result + (this.operatorRole != null ? this.operatorRole.hashCode() : 0);
            result = 31 * result + (this.scalingOptions != null ? this.scalingOptions.hashCode() : 0);
            return result;
        }
    }
}
