package software.amazon.awscdk.services.lambda;

/**
 * Resource Type definition for AWS::Lambda::CapacityProvider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnCapacityProvider cfnCapacityProvider = CfnCapacityProvider.Builder.create(this, "MyCfnCapacityProvider")
 *         .permissionsConfig(CapacityProviderPermissionsConfigProperty.builder()
 *                 .capacityProviderOperatorRoleArn("capacityProviderOperatorRoleArn")
 *                 .build())
 *         .vpcConfig(CapacityProviderVpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         // the properties below are optional
 *         .capacityProviderName("capacityProviderName")
 *         .capacityProviderScalingConfig(CapacityProviderScalingConfigProperty.builder()
 *                 .maxVCpuCount(123)
 *                 .scalingMode("scalingMode")
 *                 .scalingPolicies(List.of(TargetTrackingScalingPolicyProperty.builder()
 *                         .predefinedMetricType("predefinedMetricType")
 *                         .targetValue(123)
 *                         .build()))
 *                 .build())
 *         .instanceRequirements(InstanceRequirementsProperty.builder()
 *                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
 *                 .architectures(List.of("architectures"))
 *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                 .build())
 *         .kmsKeyArn("kmsKeyArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.532Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCapacityProvider")
public class CfnCapacityProvider extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.lambda.ICapacityProviderRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CfnCapacityProvider.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Lambda::CapacityProvider</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnCapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForCapacityProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.lambda.ICapacityProviderRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.CfnCapacityProvider.class, "arnForCapacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnCapacityProvider.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnCapacityProvider(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.CfnCapacityProvider.class, "isCfnCapacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the capacity provider.
     * <p>
     * This is a read-only property that is automatically generated when the capacity provider is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current state of the capacity provider.
     * <p>
     * Indicates whether the provider is being created, is active and ready for use, has failed, or is being deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A reference to a CapacityProvider resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.lambda.CapacityProviderReference getCapacityProviderRef() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.lambda.CapacityProviderReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * IAM permissions configuration for the capacity provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderPermissionsConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPermissionsConfig() {
        return software.amazon.jsii.Kernel.get(this, "permissionsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * IAM permissions configuration for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionsConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissionsConfig", java.util.Objects.requireNonNull(value, "permissionsConfig is required"));
    }

    /**
     * IAM permissions configuration for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionsConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderPermissionsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "permissionsConfig", java.util.Objects.requireNonNull(value, "permissionsConfig is required"));
    }

    /**
     * VPC configuration for the capacity provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderVpcConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * VPC configuration for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", java.util.Objects.requireNonNull(value, "vpcConfig is required"));
    }

    /**
     * VPC configuration for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderVpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", java.util.Objects.requireNonNull(value, "vpcConfig is required"));
    }

    /**
     * The name of the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCapacityProviderName() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviderName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "capacityProviderName", value);
    }

    /**
     * The scaling configuration for the capacity provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderScalingConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCapacityProviderScalingConfig() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderScalingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scaling configuration for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviderScalingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "capacityProviderScalingConfig", value);
    }

    /**
     * The scaling configuration for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviderScalingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderScalingConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "capacityProviderScalingConfig", value);
    }

    /**
     * Specifications for the types of EC2 instances that the capacity provider can use.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.InstanceRequirementsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
        return software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifications for the types of EC2 instances that the capacity provider can use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceRequirements(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceRequirements", value);
    }

    /**
     * Specifications for the types of EC2 instances that the capacity provider can use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceRequirements(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CfnCapacityProvider.InstanceRequirementsProperty value) {
        software.amazon.jsii.Kernel.set(this, "instanceRequirements", value);
    }

    /**
     * The ARN of the AWS Key Management Service (KMS) key used by the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the AWS Key Management Service (KMS) key used by the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     * A list of tags to apply to the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tags to apply to the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * IAM permissions configuration for the capacity provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lambda.*;
     * CapacityProviderPermissionsConfigProperty capacityProviderPermissionsConfigProperty = CapacityProviderPermissionsConfigProperty.builder()
     *         .capacityProviderOperatorRoleArn("capacityProviderOperatorRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderpermissionsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderpermissionsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCapacityProvider.CapacityProviderPermissionsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderPermissionsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderPermissionsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role that Lambda assumes to manage the capacity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderpermissionsconfig.html#cfn-lambda-capacityprovider-capacityproviderpermissionsconfig-capacityprovideroperatorrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderpermissionsconfig.html#cfn-lambda-capacityprovider-capacityproviderpermissionsconfig-capacityprovideroperatorrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCapacityProviderOperatorRoleArn();

        /**
         * @return a {@link Builder} of {@link CapacityProviderPermissionsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderPermissionsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderPermissionsConfigProperty> {
            java.lang.String capacityProviderOperatorRoleArn;

            /**
             * Sets the value of {@link CapacityProviderPermissionsConfigProperty#getCapacityProviderOperatorRoleArn}
             * @param capacityProviderOperatorRoleArn The ARN of the IAM role that Lambda assumes to manage the capacity provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProviderOperatorRoleArn(java.lang.String capacityProviderOperatorRoleArn) {
                this.capacityProviderOperatorRoleArn = capacityProviderOperatorRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderPermissionsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderPermissionsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderPermissionsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderPermissionsConfigProperty {
            private final java.lang.String capacityProviderOperatorRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityProviderOperatorRoleArn = software.amazon.jsii.Kernel.get(this, "capacityProviderOperatorRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityProviderOperatorRoleArn = java.util.Objects.requireNonNull(builder.capacityProviderOperatorRoleArn, "capacityProviderOperatorRoleArn is required");
            }

            @Override
            public final java.lang.String getCapacityProviderOperatorRoleArn() {
                return this.capacityProviderOperatorRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("capacityProviderOperatorRoleArn", om.valueToTree(this.getCapacityProviderOperatorRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnCapacityProvider.CapacityProviderPermissionsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderPermissionsConfigProperty.Jsii$Proxy that = (CapacityProviderPermissionsConfigProperty.Jsii$Proxy) o;

                return this.capacityProviderOperatorRoleArn.equals(that.capacityProviderOperatorRoleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.capacityProviderOperatorRoleArn.hashCode();
                return result;
            }
        }
    }
    /**
     * The scaling configuration for the capacity provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lambda.*;
     * CapacityProviderScalingConfigProperty capacityProviderScalingConfigProperty = CapacityProviderScalingConfigProperty.builder()
     *         .maxVCpuCount(123)
     *         .scalingMode("scalingMode")
     *         .scalingPolicies(List.of(TargetTrackingScalingPolicyProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 .targetValue(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCapacityProvider.CapacityProviderScalingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderScalingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderScalingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of EC2 instances that the capacity provider can scale up to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig-maxvcpucount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig-maxvcpucount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxVCpuCount() {
            return null;
        }

        /**
         * The scaling mode for the capacity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig-scalingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig-scalingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScalingMode() {
            return null;
        }

        /**
         * A list of target tracking scaling policies for the capacity provider.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.TargetTrackingScalingPolicyProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig-scalingpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityproviderscalingconfig.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig-scalingpolicies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScalingPolicies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderScalingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderScalingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderScalingConfigProperty> {
            java.lang.Number maxVCpuCount;
            java.lang.String scalingMode;
            java.lang.Object scalingPolicies;

            /**
             * Sets the value of {@link CapacityProviderScalingConfigProperty#getMaxVCpuCount}
             * @param maxVCpuCount The maximum number of EC2 instances that the capacity provider can scale up to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxVCpuCount(java.lang.Number maxVCpuCount) {
                this.maxVCpuCount = maxVCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderScalingConfigProperty#getScalingMode}
             * @param scalingMode The scaling mode for the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingMode(java.lang.String scalingMode) {
                this.scalingMode = scalingMode;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderScalingConfigProperty#getScalingPolicies}
             * @param scalingPolicies A list of target tracking scaling policies for the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingPolicies(software.amazon.awscdk.IResolvable scalingPolicies) {
                this.scalingPolicies = scalingPolicies;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderScalingConfigProperty#getScalingPolicies}
             * @param scalingPolicies A list of target tracking scaling policies for the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingPolicies(java.util.List<? extends java.lang.Object> scalingPolicies) {
                this.scalingPolicies = scalingPolicies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderScalingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderScalingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderScalingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderScalingConfigProperty {
            private final java.lang.Number maxVCpuCount;
            private final java.lang.String scalingMode;
            private final java.lang.Object scalingPolicies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxVCpuCount = software.amazon.jsii.Kernel.get(this, "maxVCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scalingMode = software.amazon.jsii.Kernel.get(this, "scalingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scalingPolicies = software.amazon.jsii.Kernel.get(this, "scalingPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxVCpuCount = builder.maxVCpuCount;
                this.scalingMode = builder.scalingMode;
                this.scalingPolicies = builder.scalingPolicies;
            }

            @Override
            public final java.lang.Number getMaxVCpuCount() {
                return this.maxVCpuCount;
            }

            @Override
            public final java.lang.String getScalingMode() {
                return this.scalingMode;
            }

            @Override
            public final java.lang.Object getScalingPolicies() {
                return this.scalingPolicies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxVCpuCount() != null) {
                    data.set("maxVCpuCount", om.valueToTree(this.getMaxVCpuCount()));
                }
                if (this.getScalingMode() != null) {
                    data.set("scalingMode", om.valueToTree(this.getScalingMode()));
                }
                if (this.getScalingPolicies() != null) {
                    data.set("scalingPolicies", om.valueToTree(this.getScalingPolicies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnCapacityProvider.CapacityProviderScalingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderScalingConfigProperty.Jsii$Proxy that = (CapacityProviderScalingConfigProperty.Jsii$Proxy) o;

                if (this.maxVCpuCount != null ? !this.maxVCpuCount.equals(that.maxVCpuCount) : that.maxVCpuCount != null) return false;
                if (this.scalingMode != null ? !this.scalingMode.equals(that.scalingMode) : that.scalingMode != null) return false;
                return this.scalingPolicies != null ? this.scalingPolicies.equals(that.scalingPolicies) : that.scalingPolicies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxVCpuCount != null ? this.maxVCpuCount.hashCode() : 0;
                result = 31 * result + (this.scalingMode != null ? this.scalingMode.hashCode() : 0);
                result = 31 * result + (this.scalingPolicies != null ? this.scalingPolicies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * VPC configuration for the capacity provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lambda.*;
     * CapacityProviderVpcConfigProperty capacityProviderVpcConfigProperty = CapacityProviderVpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityprovidervpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityprovidervpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCapacityProvider.CapacityProviderVpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderVpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderVpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of security group IDs to associate with EC2 instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityprovidervpcconfig.html#cfn-lambda-capacityprovider-capacityprovidervpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityprovidervpcconfig.html#cfn-lambda-capacityprovider-capacityprovidervpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * A list of subnet IDs where the capacity provider can launch EC2 instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityprovidervpcconfig.html#cfn-lambda-capacityprovider-capacityprovidervpcconfig-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-capacityprovidervpcconfig.html#cfn-lambda-capacityprovider-capacityprovidervpcconfig-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link CapacityProviderVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderVpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link CapacityProviderVpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of security group IDs to associate with EC2 instances. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderVpcConfigProperty#getSubnetIds}
             * @param subnetIds A list of subnet IDs where the capacity provider can launch EC2 instances. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderVpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderVpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderVpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnCapacityProvider.CapacityProviderVpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderVpcConfigProperty.Jsii$Proxy that = (CapacityProviderVpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifications for the types of EC2 instances that the capacity provider can use.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lambda.*;
     * InstanceRequirementsProperty instanceRequirementsProperty = InstanceRequirementsProperty.builder()
     *         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *         .architectures(List.of("architectures"))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCapacityProvider.InstanceRequirementsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceRequirementsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceRequirementsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of instance types that the capacity provider can use.
         * <p>
         * Supports wildcards (for example, m5.*).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html#cfn-lambda-capacityprovider-instancerequirements-allowedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html#cfn-lambda-capacityprovider-instancerequirements-allowedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedInstanceTypes() {
            return null;
        }

        /**
         * The instruction set architecture for EC2 instances.
         * <p>
         * Specify either x86_64 or arm64.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html#cfn-lambda-capacityprovider-instancerequirements-architectures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html#cfn-lambda-capacityprovider-instancerequirements-architectures</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArchitectures() {
            return null;
        }

        /**
         * A list of instance types that the capacity provider should not use.
         * <p>
         * Takes precedence over AllowedInstanceTypes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html#cfn-lambda-capacityprovider-instancerequirements-excludedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-instancerequirements.html#cfn-lambda-capacityprovider-instancerequirements-excludedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceRequirementsProperty> {
            java.util.List<java.lang.String> allowedInstanceTypes;
            java.util.List<java.lang.String> architectures;
            java.util.List<java.lang.String> excludedInstanceTypes;

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getAllowedInstanceTypes}
             * @param allowedInstanceTypes A list of instance types that the capacity provider can use.
             *                             Supports wildcards (for example, m5.*).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedInstanceTypes(java.util.List<java.lang.String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getArchitectures}
             * @param architectures The instruction set architecture for EC2 instances.
             *                      Specify either x86_64 or arm64.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder architectures(java.util.List<java.lang.String> architectures) {
                this.architectures = architectures;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes A list of instance types that the capacity provider should not use.
             *                              Takes precedence over AllowedInstanceTypes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceRequirementsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceRequirementsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequirementsProperty {
            private final java.util.List<java.lang.String> allowedInstanceTypes;
            private final java.util.List<java.lang.String> architectures;
            private final java.util.List<java.lang.String> excludedInstanceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedInstanceTypes = software.amazon.jsii.Kernel.get(this, "allowedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.architectures = software.amazon.jsii.Kernel.get(this, "architectures", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedInstanceTypes = builder.allowedInstanceTypes;
                this.architectures = builder.architectures;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedInstanceTypes() {
                return this.allowedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getArchitectures() {
                return this.architectures;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedInstanceTypes() != null) {
                    data.set("allowedInstanceTypes", om.valueToTree(this.getAllowedInstanceTypes()));
                }
                if (this.getArchitectures() != null) {
                    data.set("architectures", om.valueToTree(this.getArchitectures()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnCapacityProvider.InstanceRequirementsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceRequirementsProperty.Jsii$Proxy that = (InstanceRequirementsProperty.Jsii$Proxy) o;

                if (this.allowedInstanceTypes != null ? !this.allowedInstanceTypes.equals(that.allowedInstanceTypes) : that.allowedInstanceTypes != null) return false;
                if (this.architectures != null ? !this.architectures.equals(that.architectures) : that.architectures != null) return false;
                return this.excludedInstanceTypes != null ? this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedInstanceTypes != null ? this.allowedInstanceTypes.hashCode() : 0;
                result = 31 * result + (this.architectures != null ? this.architectures.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A target tracking scaling policy for the capacity provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lambda.*;
     * TargetTrackingScalingPolicyProperty targetTrackingScalingPolicyProperty = TargetTrackingScalingPolicyProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         .targetValue(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-targettrackingscalingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-targettrackingscalingpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCapacityProvider.TargetTrackingScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The predefined metric for target tracking.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-targettrackingscalingpolicy.html#cfn-lambda-capacityprovider-targettrackingscalingpolicy-predefinedmetrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-targettrackingscalingpolicy.html#cfn-lambda-capacityprovider-targettrackingscalingpolicy-predefinedmetrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * The target value for the metric as a percentage (for example, 70.0 for 70%).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-targettrackingscalingpolicy.html#cfn-lambda-capacityprovider-targettrackingscalingpolicy-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-capacityprovider-targettrackingscalingpolicy.html#cfn-lambda-capacityprovider-targettrackingscalingpolicy-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * @return a {@link Builder} of {@link TargetTrackingScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingScalingPolicyProperty> {
            java.lang.String predefinedMetricType;
            java.lang.Number targetValue;

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyProperty#getPredefinedMetricType}
             * @param predefinedMetricType The predefined metric for target tracking. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyProperty#getTargetValue}
             * @param targetValue The target value for the metric as a percentage (for example, 70.0 for 70%). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingScalingPolicyProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.Number targetValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                data.set("targetValue", om.valueToTree(this.getTargetValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnCapacityProvider.TargetTrackingScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingScalingPolicyProperty.Jsii$Proxy that = (TargetTrackingScalingPolicyProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.targetValue.equals(that.targetValue);
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.targetValue.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.CfnCapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.CfnCapacityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.CfnCapacityProviderProps.Builder();
        }

        /**
         * IAM permissions configuration for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-permissionsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-permissionsconfig</a>
         * @param permissionsConfig IAM permissions configuration for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsConfig(final software.amazon.awscdk.IResolvable permissionsConfig) {
            this.props.permissionsConfig(permissionsConfig);
            return this;
        }
        /**
         * IAM permissions configuration for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-permissionsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-permissionsconfig</a>
         * @param permissionsConfig IAM permissions configuration for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsConfig(final software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderPermissionsConfigProperty permissionsConfig) {
            this.props.permissionsConfig(permissionsConfig);
            return this;
        }

        /**
         * VPC configuration for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-vpcconfig</a>
         * @param vpcConfig VPC configuration for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * VPC configuration for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-vpcconfig</a>
         * @param vpcConfig VPC configuration for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderVpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * The name of the capacity provider.
         * <p>
         * The name must be unique within your AWS account and region. If you don't specify a name, CloudFormation generates one.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityprovidername</a>
         * @param capacityProviderName The name of the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(final java.lang.String capacityProviderName) {
            this.props.capacityProviderName(capacityProviderName);
            return this;
        }

        /**
         * The scaling configuration for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig</a>
         * @param capacityProviderScalingConfig The scaling configuration for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderScalingConfig(final software.amazon.awscdk.IResolvable capacityProviderScalingConfig) {
            this.props.capacityProviderScalingConfig(capacityProviderScalingConfig);
            return this;
        }
        /**
         * The scaling configuration for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig</a>
         * @param capacityProviderScalingConfig The scaling configuration for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderScalingConfig(final software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderScalingConfigProperty capacityProviderScalingConfig) {
            this.props.capacityProviderScalingConfig(capacityProviderScalingConfig);
            return this;
        }

        /**
         * Specifications for the types of EC2 instances that the capacity provider can use.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-instancerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-instancerequirements</a>
         * @param instanceRequirements Specifications for the types of EC2 instances that the capacity provider can use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRequirements(final software.amazon.awscdk.IResolvable instanceRequirements) {
            this.props.instanceRequirements(instanceRequirements);
            return this;
        }
        /**
         * Specifications for the types of EC2 instances that the capacity provider can use.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-instancerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-instancerequirements</a>
         * @param instanceRequirements Specifications for the types of EC2 instances that the capacity provider can use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRequirements(final software.amazon.awscdk.services.lambda.CfnCapacityProvider.InstanceRequirementsProperty instanceRequirements) {
            this.props.instanceRequirements(instanceRequirements);
            return this;
        }

        /**
         * The ARN of the AWS Key Management Service (KMS) key used by the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-kmskeyarn</a>
         * @param kmsKeyArn The ARN of the AWS Key Management Service (KMS) key used by the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * A list of tags to apply to the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-tags</a>
         * @param tags A list of tags to apply to the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.CfnCapacityProvider build() {
            return new software.amazon.awscdk.services.lambda.CfnCapacityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
