package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a <code>CfnCapacityProvider</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnCapacityProviderProps cfnCapacityProviderProps = CfnCapacityProviderProps.builder()
 *         .permissionsConfig(CapacityProviderPermissionsConfigProperty.builder()
 *                 .capacityProviderOperatorRoleArn("capacityProviderOperatorRoleArn")
 *                 .build())
 *         .vpcConfig(CapacityProviderVpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         // the properties below are optional
 *         .capacityProviderName("capacityProviderName")
 *         .capacityProviderScalingConfig(CapacityProviderScalingConfigProperty.builder()
 *                 .maxVCpuCount(123)
 *                 .scalingMode("scalingMode")
 *                 .scalingPolicies(List.of(TargetTrackingScalingPolicyProperty.builder()
 *                         .predefinedMetricType("predefinedMetricType")
 *                         .targetValue(123)
 *                         .build()))
 *                 .build())
 *         .instanceRequirements(InstanceRequirementsProperty.builder()
 *                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
 *                 .architectures(List.of("architectures"))
 *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                 .build())
 *         .kmsKeyArn("kmsKeyArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.535Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCapacityProviderProps")
@software.amazon.jsii.Jsii.Proxy(CfnCapacityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCapacityProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * IAM permissions configuration for the capacity provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderPermissionsConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-permissionsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-permissionsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPermissionsConfig();

    /**
     * VPC configuration for the capacity provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderVpcConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-vpcconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVpcConfig();

    /**
     * The name of the capacity provider.
     * <p>
     * The name must be unique within your AWS account and region. If you don't specify a name, CloudFormation generates one.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityprovidername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProviderName() {
        return null;
    }

    /**
     * The scaling configuration for the capacity provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderScalingConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-capacityproviderscalingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityProviderScalingConfig() {
        return null;
    }

    /**
     * Specifications for the types of EC2 instances that the capacity provider can use.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.lambda.CfnCapacityProvider.InstanceRequirementsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-instancerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-instancerequirements</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
        return null;
    }

    /**
     * The ARN of the AWS Key Management Service (KMS) key used by the capacity provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * A list of tags to apply to the capacity provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-capacityprovider.html#cfn-lambda-capacityprovider-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCapacityProviderProps> {
        java.lang.Object permissionsConfig;
        java.lang.Object vpcConfig;
        java.lang.String capacityProviderName;
        java.lang.Object capacityProviderScalingConfig;
        java.lang.Object instanceRequirements;
        java.lang.String kmsKeyArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getPermissionsConfig}
         * @param permissionsConfig IAM permissions configuration for the capacity provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsConfig(software.amazon.awscdk.IResolvable permissionsConfig) {
            this.permissionsConfig = permissionsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getPermissionsConfig}
         * @param permissionsConfig IAM permissions configuration for the capacity provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsConfig(software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderPermissionsConfigProperty permissionsConfig) {
            this.permissionsConfig = permissionsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getVpcConfig}
         * @param vpcConfig VPC configuration for the capacity provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getVpcConfig}
         * @param vpcConfig VPC configuration for the capacity provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderVpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getCapacityProviderName}
         * @param capacityProviderName The name of the capacity provider.
         *                             The name must be unique within your AWS account and region. If you don't specify a name, CloudFormation generates one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(java.lang.String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getCapacityProviderScalingConfig}
         * @param capacityProviderScalingConfig The scaling configuration for the capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderScalingConfig(software.amazon.awscdk.IResolvable capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getCapacityProviderScalingConfig}
         * @param capacityProviderScalingConfig The scaling configuration for the capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderScalingConfig(software.amazon.awscdk.services.lambda.CfnCapacityProvider.CapacityProviderScalingConfigProperty capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getInstanceRequirements}
         * @param instanceRequirements Specifications for the types of EC2 instances that the capacity provider can use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRequirements(software.amazon.awscdk.IResolvable instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getInstanceRequirements}
         * @param instanceRequirements Specifications for the types of EC2 instances that the capacity provider can use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRequirements(software.amazon.awscdk.services.lambda.CfnCapacityProvider.InstanceRequirementsProperty instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getKmsKeyArn}
         * @param kmsKeyArn The ARN of the AWS Key Management Service (KMS) key used by the capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityProviderProps#getTags}
         * @param tags A list of tags to apply to the capacity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCapacityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCapacityProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCapacityProviderProps {
        private final java.lang.Object permissionsConfig;
        private final java.lang.Object vpcConfig;
        private final java.lang.String capacityProviderName;
        private final java.lang.Object capacityProviderScalingConfig;
        private final java.lang.Object instanceRequirements;
        private final java.lang.String kmsKeyArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.permissionsConfig = software.amazon.jsii.Kernel.get(this, "permissionsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.capacityProviderName = software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.capacityProviderScalingConfig = software.amazon.jsii.Kernel.get(this, "capacityProviderScalingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.permissionsConfig = java.util.Objects.requireNonNull(builder.permissionsConfig, "permissionsConfig is required");
            this.vpcConfig = java.util.Objects.requireNonNull(builder.vpcConfig, "vpcConfig is required");
            this.capacityProviderName = builder.capacityProviderName;
            this.capacityProviderScalingConfig = builder.capacityProviderScalingConfig;
            this.instanceRequirements = builder.instanceRequirements;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getPermissionsConfig() {
            return this.permissionsConfig;
        }

        @Override
        public final java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        public final java.lang.String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        @Override
        public final java.lang.Object getCapacityProviderScalingConfig() {
            return this.capacityProviderScalingConfig;
        }

        @Override
        public final java.lang.Object getInstanceRequirements() {
            return this.instanceRequirements;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("permissionsConfig", om.valueToTree(this.getPermissionsConfig()));
            data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            if (this.getCapacityProviderName() != null) {
                data.set("capacityProviderName", om.valueToTree(this.getCapacityProviderName()));
            }
            if (this.getCapacityProviderScalingConfig() != null) {
                data.set("capacityProviderScalingConfig", om.valueToTree(this.getCapacityProviderScalingConfig()));
            }
            if (this.getInstanceRequirements() != null) {
                data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnCapacityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCapacityProviderProps.Jsii$Proxy that = (CfnCapacityProviderProps.Jsii$Proxy) o;

            if (!permissionsConfig.equals(that.permissionsConfig)) return false;
            if (!vpcConfig.equals(that.vpcConfig)) return false;
            if (this.capacityProviderName != null ? !this.capacityProviderName.equals(that.capacityProviderName) : that.capacityProviderName != null) return false;
            if (this.capacityProviderScalingConfig != null ? !this.capacityProviderScalingConfig.equals(that.capacityProviderScalingConfig) : that.capacityProviderScalingConfig != null) return false;
            if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.permissionsConfig.hashCode();
            result = 31 * result + (this.vpcConfig.hashCode());
            result = 31 * result + (this.capacityProviderName != null ? this.capacityProviderName.hashCode() : 0);
            result = 31 * result + (this.capacityProviderScalingConfig != null ? this.capacityProviderScalingConfig.hashCode() : 0);
            result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
