package software.amazon.awscdk.services.lambda;

/**
 * The auth types for a function url.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * FunctionUrl fnUrl = fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.AWS_IAM)
 *         .build());
 * Distribution.Builder.create(this, "MyDistribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(FunctionUrlOrigin.withOriginAccessControl(fnUrl))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.695Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.FunctionUrlAuthType")
public enum FunctionUrlAuthType {
    /**
     * Restrict access to authenticated IAM users only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_IAM,
    /**
     * Bypass IAM authentication to create a public endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
