package software.amazon.awscdk.services.lambda;

/**
 * Configuration for filtering instance types that a capacity provider can use.
 * <p>
 * Instances types can either be allowed or excluded, not both.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * Vpc vpc = new Vpc(this, "MyVpc");
 * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build();
 * // Allow only specific instance families
 * CapacityProvider allowCapacityProvider = CapacityProvider.Builder.create(this, "MyCapacityProviderAllowed")
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(securityGroup))
 *         .instanceTypeFilter(InstanceTypeFilter.allow(List.of(InstanceType.of(InstanceClass.M5, InstanceSize.LARGE), InstanceType.of(InstanceClass.M5, InstanceSize.XLARGE))))
 *         .build();
 * // Or exclude specific instance types
 * CapacityProvider excludeCapacityProvider = CapacityProvider.Builder.create(this, "MyCapacityProviderExcluded")
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(securityGroup))
 *         .instanceTypeFilter(InstanceTypeFilter.exclude(List.of(InstanceType.of(InstanceClass.T2, InstanceSize.MICRO))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.711Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.InstanceTypeFilter")
public class InstanceTypeFilter extends software.amazon.jsii.JsiiObject {

    protected InstanceTypeFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceTypeFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates an instance type filter that allows only the specified instance types.
     * <p>
     * @param instanceTypes A list of instance types that the capacity provider is allowed to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.InstanceTypeFilter allow(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceType> instanceTypes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.InstanceTypeFilter.class, "allow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.InstanceTypeFilter.class), new Object[] { java.util.Objects.requireNonNull(instanceTypes, "instanceTypes is required") });
    }

    /**
     * Creates an instance type filter that excludes the specified instance types.
     * <p>
     * @param instanceTypes A list of instance types that the capacity provider should not use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.InstanceTypeFilter exclude(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceType> instanceTypes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.InstanceTypeFilter.class, "exclude", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.InstanceTypeFilter.class), new Object[] { java.util.Objects.requireNonNull(instanceTypes, "instanceTypes is required") });
    }

    /**
     * A list of instance types that the capacity provider is allowed to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getAllowedInstanceTypes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)(software.amazon.jsii.Kernel.get(this, "allowedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of instance types that the capacity provider should not use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getExcludedInstanceTypes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)(software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
