package software.amazon.awscdk.services.lambda;

/**
 * The scaling configuration that will be applied to the $LATEST.PUBLISHED version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CapacityProvider capacityProvider;
 * Function fn;
 * capacityProvider.addFunction(fn, CapacityProviderFunctionOptions.builder()
 *         .latestPublishedScalingConfig(LatestPublishedScalingConfig.builder()
 *                 .minExecutionEnvironments(5)
 *                 .maxExecutionEnvironments(25)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.715Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.LatestPublishedScalingConfig")
@software.amazon.jsii.Jsii.Proxy(LatestPublishedScalingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LatestPublishedScalingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of execution environments allowed for the $LATEST.PUBLISHED version when published into a capacity provider.
     * <p>
     * This setting limits the total number of execution environments that can be created
     * to handle concurrent invocations of this specific version.
     * <p>
     * Default: - No maximum specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxExecutionEnvironments() {
        return null;
    }

    /**
     * The minimum number of execution environments to maintain for the $LATEST.PUBLISHED version when published into a capacity provider.
     * <p>
     * This setting ensures that at least this many execution environments are always
     * available to handle function invocations for this specific version, reducing cold start latency.
     * <p>
     * Default: - 3 execution environments are set to be the minimum
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinExecutionEnvironments() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LatestPublishedScalingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LatestPublishedScalingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LatestPublishedScalingConfig> {
        java.lang.Number maxExecutionEnvironments;
        java.lang.Number minExecutionEnvironments;

        /**
         * Sets the value of {@link LatestPublishedScalingConfig#getMaxExecutionEnvironments}
         * @param maxExecutionEnvironments The maximum number of execution environments allowed for the $LATEST.PUBLISHED version when published into a capacity provider.
         *                                 This setting limits the total number of execution environments that can be created
         *                                 to handle concurrent invocations of this specific version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxExecutionEnvironments(java.lang.Number maxExecutionEnvironments) {
            this.maxExecutionEnvironments = maxExecutionEnvironments;
            return this;
        }

        /**
         * Sets the value of {@link LatestPublishedScalingConfig#getMinExecutionEnvironments}
         * @param minExecutionEnvironments The minimum number of execution environments to maintain for the $LATEST.PUBLISHED version when published into a capacity provider.
         *                                 This setting ensures that at least this many execution environments are always
         *                                 available to handle function invocations for this specific version, reducing cold start latency.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minExecutionEnvironments(java.lang.Number minExecutionEnvironments) {
            this.minExecutionEnvironments = minExecutionEnvironments;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LatestPublishedScalingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LatestPublishedScalingConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LatestPublishedScalingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LatestPublishedScalingConfig {
        private final java.lang.Number maxExecutionEnvironments;
        private final java.lang.Number minExecutionEnvironments;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxExecutionEnvironments = software.amazon.jsii.Kernel.get(this, "maxExecutionEnvironments", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minExecutionEnvironments = software.amazon.jsii.Kernel.get(this, "minExecutionEnvironments", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxExecutionEnvironments = builder.maxExecutionEnvironments;
            this.minExecutionEnvironments = builder.minExecutionEnvironments;
        }

        @Override
        public final java.lang.Number getMaxExecutionEnvironments() {
            return this.maxExecutionEnvironments;
        }

        @Override
        public final java.lang.Number getMinExecutionEnvironments() {
            return this.minExecutionEnvironments;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxExecutionEnvironments() != null) {
                data.set("maxExecutionEnvironments", om.valueToTree(this.getMaxExecutionEnvironments()));
            }
            if (this.getMinExecutionEnvironments() != null) {
                data.set("minExecutionEnvironments", om.valueToTree(this.getMinExecutionEnvironments()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.LatestPublishedScalingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LatestPublishedScalingConfig.Jsii$Proxy that = (LatestPublishedScalingConfig.Jsii$Proxy) o;

            if (this.maxExecutionEnvironments != null ? !this.maxExecutionEnvironments.equals(that.maxExecutionEnvironments) : that.maxExecutionEnvironments != null) return false;
            return this.minExecutionEnvironments != null ? this.minExecutionEnvironments.equals(that.minExecutionEnvironments) : that.minExecutionEnvironments == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxExecutionEnvironments != null ? this.maxExecutionEnvironments.hashCode() : 0;
            result = 31 * result + (this.minExecutionEnvironments != null ? this.minExecutionEnvironments.hashCode() : 0);
            return result;
        }
    }
}
