package software.amazon.awscdk.services.lambda;

/**
 * Configuration options for scaling a capacity provider, including scaling mode and policies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * Vpc vpc = new Vpc(this, "MyVpc");
 * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build();
 * CapacityProvider capacityProvider = CapacityProvider.Builder.create(this, "MyCapacityProvider")
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(securityGroup))
 *         .scalingOptions(ScalingOptions.manual(List.of(TargetTrackingScalingPolicy.cpuUtilization(70))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.741Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.ScalingOptions")
public class ScalingOptions extends software.amazon.jsii.JsiiObject {

    protected ScalingOptions(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScalingOptions(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates scaling options where the capacity provider manages scaling automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ScalingOptions auto() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.ScalingOptions.class, "auto", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ScalingOptions.class));
    }

    /**
     * Creates manual scaling options with custom target tracking scaling policies.
     * <p>
     * At least one policy is required.
     * <p>
     * @param scalingPolicies The target tracking scaling policies to use for manual scaling. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ScalingOptions manual(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.lambda.TargetTrackingScalingPolicy> scalingPolicies) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.ScalingOptions.class, "manual", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ScalingOptions.class), new Object[] { java.util.Objects.requireNonNull(scalingPolicies, "scalingPolicies is required") });
    }

    /**
     * The scaling mode for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScalingMode() {
        return software.amazon.jsii.Kernel.get(this, "scalingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The target tracking scaling policies used when scaling mode is 'Manual'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.TargetTrackingScalingPolicy> getScalingPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.lambda.TargetTrackingScalingPolicy>)(software.amazon.jsii.Kernel.get(this, "scalingPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.TargetTrackingScalingPolicy.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
