package software.amazon.awscdk.services.lambda;

/**
 * A target tracking scaling policy that automatically adjusts the capacity provider's compute resources to maintain a specified target value by tracking the required CloudWatch metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * Vpc vpc = new Vpc(this, "MyVpc");
 * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build();
 * CapacityProvider capacityProvider = CapacityProvider.Builder.create(this, "MyCapacityProvider")
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(securityGroup))
 *         .scalingOptions(ScalingOptions.manual(List.of(TargetTrackingScalingPolicy.cpuUtilization(70))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.750Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.TargetTrackingScalingPolicy")
public class TargetTrackingScalingPolicy extends software.amazon.jsii.JsiiObject {

    protected TargetTrackingScalingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TargetTrackingScalingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a target tracking scaling policy for CPU utilization.
     * <p>
     * @param targetCpuUtilization The target value for CPU utilization. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.TargetTrackingScalingPolicy cpuUtilization(final @org.jetbrains.annotations.NotNull java.lang.Number targetCpuUtilization) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.TargetTrackingScalingPolicy.class, "cpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.TargetTrackingScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(targetCpuUtilization, "targetCpuUtilization is required") });
    }

    /**
     * The predefined metric type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMetricType() {
        return software.amazon.jsii.Kernel.get(this, "metricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The predefined metric type for this scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType() {
        return software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The target value for the specified metric as a percentage.
     * <p>
     * The capacity provider will scale resources to maintain this target value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue() {
        return software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The target value for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }
}
