package software.amazon.awscdk.services.lambda;

/**
 * Specify the tenant isolation mode for Lambda functions.
 * <p>
 * This is incompatible with:
 * <p>
 * <ul>
 * <li>SnapStart</li>
 * <li>Provisioned Concurrency</li>
 * <li>Function URLs</li>
 * <li>Most Event sources (only API Gateway is supported)</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .tenancyConfig(TenancyConfig.PER_TENANT)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.751Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.TenancyConfig")
public class TenancyConfig extends software.amazon.jsii.JsiiObject {

    protected TenancyConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TenancyConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PER_TENANT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.TenancyConfig.class, "PER_TENANT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.TenancyConfig.class));
    }

    /**
     * @param mode This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TenancyConfig(final @org.jetbrains.annotations.NotNull java.lang.String mode) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(mode, "mode is required") });
    }

    /**
     * Each tenant gets a dedicated execution environment.
     * <p>
     * Execution environments are not shared between different tenants,
     * but can be reused for the same tenant to avoid cold starts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.TenancyConfig PER_TENANT;

    /**
     * The CloudFormation property for tenancy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnFunction.TenancyConfigProperty getTenancyConfigProperty() {
        return software.amazon.jsii.Kernel.get(this, "tenancyConfigProperty", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CfnFunction.TenancyConfigProperty.class));
    }
}
