package software.amazon.awscdk.services.lambda;

/**
 * Options for <code>lambda.Version</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .currentVersionOptions(VersionOptions.builder()
 *                 .removalPolicy(RemovalPolicy.RETAIN) // retain old versions
 *                 .retryAttempts(1)
 *                 .build())
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * fn.addAlias("live");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.754Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.VersionOptions")
@software.amazon.jsii.Jsii.Proxy(VersionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VersionOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.EventInvokeConfigOptions {

    /**
     * SHA256 of the version of the Lambda source code.
     * <p>
     * Specify to validate that you're deploying the right version.
     * <p>
     * Default: No validation is performed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodeSha256() {
        return null;
    }

    /**
     * Description of the version.
     * <p>
     * Default: Description of the Lambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The maximum number of execution environments allowed for this version when published into a capacity provider.
     * <p>
     * This setting limits the total number of execution environments that can be created
     * to handle concurrent invocations of this specific version.
     * <p>
     * Default: - No maximum specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxExecutionEnvironments() {
        return null;
    }

    /**
     * The minimum number of execution environments to maintain for this version when published into a capacity provider.
     * <p>
     * This setting ensures that at least this many execution environments are always
     * available to handle function invocations for this specific version, reducing cold start latency.
     * <p>
     * Default: - 3 execution environments are set to be the minimum
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinExecutionEnvironments() {
        return null;
    }

    /**
     * Specifies a provisioned concurrency configuration for a function's version.
     * <p>
     * Default: No provisioned concurrency
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedConcurrentExecutions() {
        return null;
    }

    /**
     * Whether to retain old versions of this function when a new version is created.
     * <p>
     * Default: RemovalPolicy.DESTROY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VersionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VersionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VersionOptions> {
        java.lang.String codeSha256;
        java.lang.String description;
        java.lang.Number maxExecutionEnvironments;
        java.lang.Number minExecutionEnvironments;
        java.lang.Number provisionedConcurrentExecutions;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.Duration maxEventAge;
        software.amazon.awscdk.services.lambda.IDestination onFailure;
        software.amazon.awscdk.services.lambda.IDestination onSuccess;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link VersionOptions#getCodeSha256}
         * @param codeSha256 SHA256 of the version of the Lambda source code.
         *                   Specify to validate that you're deploying the right version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSha256(java.lang.String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getDescription}
         * @param description Description of the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getMaxExecutionEnvironments}
         * @param maxExecutionEnvironments The maximum number of execution environments allowed for this version when published into a capacity provider.
         *                                 This setting limits the total number of execution environments that can be created
         *                                 to handle concurrent invocations of this specific version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxExecutionEnvironments(java.lang.Number maxExecutionEnvironments) {
            this.maxExecutionEnvironments = maxExecutionEnvironments;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getMinExecutionEnvironments}
         * @param minExecutionEnvironments The minimum number of execution environments to maintain for this version when published into a capacity provider.
         *                                 This setting ensures that at least this many execution environments are always
         *                                 available to handle function invocations for this specific version, reducing cold start latency.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minExecutionEnvironments(java.lang.Number minExecutionEnvironments) {
            this.minExecutionEnvironments = minExecutionEnvironments;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getProvisionedConcurrentExecutions}
         * @param provisionedConcurrentExecutions Specifies a provisioned concurrency configuration for a function's version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrentExecutions(java.lang.Number provisionedConcurrentExecutions) {
            this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getRemovalPolicy}
         * @param removalPolicy Whether to retain old versions of this function when a new version is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum: 60 seconds
         *                    Maximum: 6 hours
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getOnFailure}
         * @param onFailure The destination for failed invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getOnSuccess}
         * @param onSuccess The destination for successful invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link VersionOptions#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum: 0
         *                      Maximum: 2
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VersionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VersionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VersionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersionOptions {
        private final java.lang.String codeSha256;
        private final java.lang.String description;
        private final java.lang.Number maxExecutionEnvironments;
        private final java.lang.Number minExecutionEnvironments;
        private final java.lang.Number provisionedConcurrentExecutions;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final software.amazon.awscdk.services.lambda.IDestination onFailure;
        private final software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeSha256 = software.amazon.jsii.Kernel.get(this, "codeSha256", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxExecutionEnvironments = software.amazon.jsii.Kernel.get(this, "maxExecutionEnvironments", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minExecutionEnvironments = software.amazon.jsii.Kernel.get(this, "minExecutionEnvironments", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.provisionedConcurrentExecutions = software.amazon.jsii.Kernel.get(this, "provisionedConcurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IDestination.class));
            this.onSuccess = software.amazon.jsii.Kernel.get(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IDestination.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeSha256 = builder.codeSha256;
            this.description = builder.description;
            this.maxExecutionEnvironments = builder.maxExecutionEnvironments;
            this.minExecutionEnvironments = builder.minExecutionEnvironments;
            this.provisionedConcurrentExecutions = builder.provisionedConcurrentExecutions;
            this.removalPolicy = builder.removalPolicy;
            this.maxEventAge = builder.maxEventAge;
            this.onFailure = builder.onFailure;
            this.onSuccess = builder.onSuccess;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final java.lang.String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getMaxExecutionEnvironments() {
            return this.maxExecutionEnvironments;
        }

        @Override
        public final java.lang.Number getMinExecutionEnvironments() {
            return this.minExecutionEnvironments;
        }

        @Override
        public final java.lang.Number getProvisionedConcurrentExecutions() {
            return this.provisionedConcurrentExecutions;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCodeSha256() != null) {
                data.set("codeSha256", om.valueToTree(this.getCodeSha256()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMaxExecutionEnvironments() != null) {
                data.set("maxExecutionEnvironments", om.valueToTree(this.getMaxExecutionEnvironments()));
            }
            if (this.getMinExecutionEnvironments() != null) {
                data.set("minExecutionEnvironments", om.valueToTree(this.getMinExecutionEnvironments()));
            }
            if (this.getProvisionedConcurrentExecutions() != null) {
                data.set("provisionedConcurrentExecutions", om.valueToTree(this.getProvisionedConcurrentExecutions()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.VersionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VersionOptions.Jsii$Proxy that = (VersionOptions.Jsii$Proxy) o;

            if (this.codeSha256 != null ? !this.codeSha256.equals(that.codeSha256) : that.codeSha256 != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.maxExecutionEnvironments != null ? !this.maxExecutionEnvironments.equals(that.maxExecutionEnvironments) : that.maxExecutionEnvironments != null) return false;
            if (this.minExecutionEnvironments != null ? !this.minExecutionEnvironments.equals(that.minExecutionEnvironments) : that.minExecutionEnvironments != null) return false;
            if (this.provisionedConcurrentExecutions != null ? !this.provisionedConcurrentExecutions.equals(that.provisionedConcurrentExecutions) : that.provisionedConcurrentExecutions != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.codeSha256 != null ? this.codeSha256.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.maxExecutionEnvironments != null ? this.maxExecutionEnvironments.hashCode() : 0);
            result = 31 * result + (this.minExecutionEnvironments != null ? this.minExecutionEnvironments.hashCode() : 0);
            result = 31 * result + (this.provisionedConcurrentExecutions != null ? this.provisionedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
