package software.amazon.awscdk.services.lambda.eventsources;

/**
 * The authentication method to use with SelfManagedKafkaEventSource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.AuthenticationMethod;
 * import software.amazon.awscdk.services.lambda.StartingPosition;
 * import software.amazon.awscdk.services.lambda.Function;
 * import software.amazon.awscdk.services.secretsmanager.ISecret;
 * // With provisioned pollers and poller group for cost optimization
 * Function myFunction;
 * ISecret kafkaCredentials;
 * myFunction.addEventSource(SelfManagedKafkaEventSource.Builder.create()
 *         .bootstrapServers(List.of("kafka-broker1.example.com:9092", "kafka-broker2.example.com:9092"))
 *         .topic("events-topic")
 *         .secret(kafkaCredentials)
 *         .startingPosition(StartingPosition.LATEST)
 *         .authenticationMethod(AuthenticationMethod.SASL_SCRAM_512_AUTH)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(8)
 *                 .pollerGroupName("self-managed-kafka-group")
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.782Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.AuthenticationMethod")
public enum AuthenticationMethod {
    /**
     * SASL_SCRAM_512_AUTH authentication method for your Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SASL_SCRAM_512_AUTH,
    /**
     * SASL_SCRAM_256_AUTH authentication method for your Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SASL_SCRAM_256_AUTH,
    /**
     * BASIC_AUTH (SASL/PLAIN) authentication method for your Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BASIC_AUTH,
    /**
     * CLIENT_CERTIFICATE_TLS_AUTH (mTLS) authentication method for your Kafka cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLIENT_CERTIFICATE_TLS_AUTH,
}
