package software.amazon.awscdk.services.lambda.eventsources;

/**
 * A Kafka topic dead letter queue destination configuration for a Lambda event source.
 * <p>
 * This destination can only be used with Kafka-based event sources (MSK and self-managed Kafka).
 * When used with other event source types, a validation error will be thrown.
 * <p>
 * <h2>Kafka URI Format</h2>
 * <p>
 * new KafkaDlq('my-topic');
 * <p>
 * <h2>Topic Naming Requirements</h2>
 * <p>
 * Kafka topic names must follow these rules:
 * <p>
 * <ul>
 * <li>Only alphanumeric characters, dots (.), underscores (_), and hyphens (-) are allowed</li>
 * <li>Cannot be empty</li>
 * <li>Must be a valid Kafka topic name</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.KafkaDlq;
 * Function myFunction;
 * // Your MSK cluster arn
 * String clusterArn = "arn:aws:kafka:us-east-1:0123456789019:cluster/SalesCluster/abcd1234-abcd-cafe-abab-9876543210ab-4";
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * // Create a Kafka DLQ destination
 * KafkaDlq kafkaDlq = new KafkaDlq("failure-topic");
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .onFailure(kafkaDlq)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(1)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.788Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.KafkaDlq")
public class KafkaDlq extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSourceDlq {

    protected KafkaDlq(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KafkaDlq(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new Kafka DLQ destination.
     * <p>
     * @param topicName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KafkaDlq(final @org.jetbrains.annotations.NotNull java.lang.String topicName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topicName, "topicName is required") });
    }

    /**
     * Returns a destination configuration for the DLQ.
     * <p>
     * The returned configuration is used in the AWS Lambda EventSourceMapping's DestinationConfig
     * to specify where failed records should be sent.
     * <p>
     * @return The DLQ destination configuration with the properly formatted Kafka URI
     * @param _target This parameter is required.
     * @param _targetHandler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DlqDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSourceMapping _target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction _targetHandler) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DlqDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_target, "_target is required"), java.util.Objects.requireNonNull(_targetHandler, "_targetHandler is required") });
    }
}
