package software.amazon.awscdk.services.lambda.eventsources;

/**
 * (Amazon MSK and self-managed Apache Kafka only) The provisioned mode configuration for the event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.KafkaDlq;
 * Function myFunction;
 * // Your MSK cluster arn
 * String clusterArn = "arn:aws:kafka:us-east-1:0123456789019:cluster/SalesCluster/abcd1234-abcd-cafe-abab-9876543210ab-4";
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * // Create a Kafka DLQ destination
 * KafkaDlq kafkaDlq = new KafkaDlq("failure-topic");
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .onFailure(kafkaDlq)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(1)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.795Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.ProvisionedPollerConfig")
@software.amazon.jsii.Jsii.Proxy(ProvisionedPollerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProvisionedPollerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of pollers that can be provisioned.
     * <p>
     * Default: 200
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaximumPollers();

    /**
     * The minimum number of pollers that should be provisioned.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinimumPollers();

    /**
     * An optional identifier that groups multiple ESMs to share EPU capacity and reduce costs.
     * <p>
     * ESMs with the same PollerGroupName share compute
     * resources.
     * <p>
     * Default: - not set, dedicated compute resource per event source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPollerGroupName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProvisionedPollerConfig> {
        java.lang.Number maximumPollers;
        java.lang.Number minimumPollers;
        java.lang.String pollerGroupName;

        /**
         * Sets the value of {@link ProvisionedPollerConfig#getMaximumPollers}
         * @param maximumPollers The maximum number of pollers that can be provisioned. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumPollers(java.lang.Number maximumPollers) {
            this.maximumPollers = maximumPollers;
            return this;
        }

        /**
         * Sets the value of {@link ProvisionedPollerConfig#getMinimumPollers}
         * @param minimumPollers The minimum number of pollers that should be provisioned. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumPollers(java.lang.Number minimumPollers) {
            this.minimumPollers = minimumPollers;
            return this;
        }

        /**
         * Sets the value of {@link ProvisionedPollerConfig#getPollerGroupName}
         * @param pollerGroupName An optional identifier that groups multiple ESMs to share EPU capacity and reduce costs.
         *                        ESMs with the same PollerGroupName share compute
         *                        resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pollerGroupName(java.lang.String pollerGroupName) {
            this.pollerGroupName = pollerGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProvisionedPollerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProvisionedPollerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedPollerConfig {
        private final java.lang.Number maximumPollers;
        private final java.lang.Number minimumPollers;
        private final java.lang.String pollerGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maximumPollers = software.amazon.jsii.Kernel.get(this, "maximumPollers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minimumPollers = software.amazon.jsii.Kernel.get(this, "minimumPollers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pollerGroupName = software.amazon.jsii.Kernel.get(this, "pollerGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maximumPollers = java.util.Objects.requireNonNull(builder.maximumPollers, "maximumPollers is required");
            this.minimumPollers = java.util.Objects.requireNonNull(builder.minimumPollers, "minimumPollers is required");
            this.pollerGroupName = builder.pollerGroupName;
        }

        @Override
        public final java.lang.Number getMaximumPollers() {
            return this.maximumPollers;
        }

        @Override
        public final java.lang.Number getMinimumPollers() {
            return this.minimumPollers;
        }

        @Override
        public final java.lang.String getPollerGroupName() {
            return this.pollerGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maximumPollers", om.valueToTree(this.getMaximumPollers()));
            data.set("minimumPollers", om.valueToTree(this.getMinimumPollers()));
            if (this.getPollerGroupName() != null) {
                data.set("pollerGroupName", om.valueToTree(this.getPollerGroupName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda_event_sources.ProvisionedPollerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProvisionedPollerConfig.Jsii$Proxy that = (ProvisionedPollerConfig.Jsii$Proxy) o;

            if (!maximumPollers.equals(that.maximumPollers)) return false;
            if (!minimumPollers.equals(that.minimumPollers)) return false;
            return this.pollerGroupName != null ? this.pollerGroupName.equals(that.pollerGroupName) : that.pollerGroupName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maximumPollers.hashCode();
            result = 31 * result + (this.minimumPollers.hashCode());
            result = 31 * result + (this.pollerGroupName != null ? this.pollerGroupName.hashCode() : 0);
            return result;
        }
    }
}
