package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Use a self hosted Kafka installation as a streaming source for AWS Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.AuthenticationMethod;
 * import software.amazon.awscdk.services.lambda.StartingPosition;
 * import software.amazon.awscdk.services.lambda.Function;
 * import software.amazon.awscdk.services.secretsmanager.ISecret;
 * // With provisioned pollers and poller group for cost optimization
 * Function myFunction;
 * ISecret kafkaCredentials;
 * myFunction.addEventSource(SelfManagedKafkaEventSource.Builder.create()
 *         .bootstrapServers(List.of("kafka-broker1.example.com:9092", "kafka-broker2.example.com:9092"))
 *         .topic("events-topic")
 *         .secret(kafkaCredentials)
 *         .startingPosition(StartingPosition.LATEST)
 *         .authenticationMethod(AuthenticationMethod.SASL_SCRAM_512_AUTH)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(8)
 *                 .pollerGroupName("self-managed-kafka-group")
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:23.798Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.SelfManagedKafkaEventSource")
public class SelfManagedKafkaEventSource extends software.amazon.awscdk.services.lambda.eventsources.StreamEventSource {

    protected SelfManagedKafkaEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SelfManagedKafkaEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SelfManagedKafkaEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by <code>lambda.addEventSource</code> to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSourceProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSourceProps.Builder();
        }

        /**
         * Where to begin consuming the stream.
         * <p>
         * @return {@code this}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of:
         * <p>
         * <ul>
         * <li>1000 for <code>DynamoEventSource</code></li>
         * <li>10000 for <code>KinesisEventSource</code>, <code>ManagedKafkaEventSource</code> and <code>SelfManagedKafkaEventSource</code></li>
         * </ul></li>
         * </ul>
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * If the stream event source mapping should be enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled If the stream event source mapping should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The maximum amount of time to gather records before invoking the function.
         * <p>
         * Maximum of Duration.minutes(5).
         * <p>
         * Default: - Duration.seconds(0) for Kinesis, DynamoDB, and SQS event sources, Duration.millis(500) for MSK, self-managed Kafka, and Amazon MQ.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-batching">https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-batching</a>
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(final software.amazon.awscdk.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * Configuration for provisioned pollers that read from the event source.
         * <p>
         * When specified, allows control over the minimum and maximum number of pollers
         * that can be provisioned to process events from the source.
         * <p>
         * Default: - no provisioned pollers
         * <p>
         * @return {@code this}
         * @param provisionedPollerConfig Configuration for provisioned pollers that read from the event source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedPollerConfig(final software.amazon.awscdk.services.lambda.eventsources.ProvisionedPollerConfig provisionedPollerConfig) {
            this.props.provisionedPollerConfig(provisionedPollerConfig);
            return this;
        }

        /**
         * The Kafka topic to subscribe to.
         * <p>
         * @return {@code this}
         * @param topic The Kafka topic to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final java.lang.String topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * <ul><li>If the function returns an error, split the batch in two and retry.</li></ul>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param bisectBatchOnError <ul><li>If the function returns an error, split the batch in two and retry.</li></ul> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(final java.lang.Boolean bisectBatchOnError) {
            this.props.bisectBatchOnError(bisectBatchOnError);
            return this;
        }

        /**
         * The identifier for the Kafka consumer group to join.
         * <p>
         * The consumer group ID must be unique among all your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot update this value.  The value must have a length between 1 and 200 and full the pattern '[a-zA-Z0-9-/<em>:_+=.&#64;-]</em>'.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id">https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-consumer-group-id</a>
         * @param consumerGroupId The identifier for the Kafka consumer group to join. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumerGroupId(final java.lang.String consumerGroupId) {
            this.props.consumerGroupId(consumerGroupId);
            return this;
        }

        /**
         * Add Customer managed KMS key to encrypt Filter Criteria.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk</a>
         * @param filterEncryption Add Customer managed KMS key to encrypt Filter Criteria. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterEncryption(final software.amazon.awscdk.services.kms.IKey filterEncryption) {
            this.props.filterEncryption(filterEncryption);
            return this;
        }

        /**
         * Add filter criteria to Event Source.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html</a>
         * @param filters Add filter criteria to Event Source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final java.util.List<? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> filters) {
            this.props.filters(filters);
            return this;
        }

        /**
         * The maximum age of a record that Lambda sends to a function for processing.
         * <p>
         * The default value is -1, which sets the maximum age to infinite.
         * When the value is set to infinite, Lambda never discards old records.
         * Record are valid until it expires in the event source.
         * <p>
         * Default: -1
         * <p>
         * @return {@code this}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(final software.amazon.awscdk.Duration maxRecordAge) {
            this.props.maxRecordAge(maxRecordAge);
            return this;
        }

        /**
         * Add an on Failure Destination for this Kafka event.
         * <p>
         * Supported destinations:
         * * {@link KafkaDlq } - Send failed records to a Kafka topic
         * * SNS topics - Send failed records to an SNS topic
         * * SQS queues - Send failed records to an SQS queue
         * * S3 buckets - Send failed records to an S3 bucket
         * <p>
         * Default: - discarded records are ignored
         * <p>
         * @return {@code this}
         * @param onFailure Add an on Failure Destination for this Kafka event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * <ul><li>Allow functions to return partially successful responses for a batch of records.</li></ul>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param reportBatchItemFailures <ul><li>Allow functions to return partially successful responses for a batch of records.</li></ul> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBatchItemFailures(final java.lang.Boolean reportBatchItemFailures) {
            this.props.reportBatchItemFailures(reportBatchItemFailures);
            return this;
        }

        /**
         * <ul><li>Maximum number of retry attempts.</li></ul>
         * <p>
         * Set to -1 for infinite retries (until the record expires in the event source).
         * <p>
         * Default: -1 (infinite retries)
         * <p>
         * @return {@code this}
         * @param retryAttempts <ul><li>Maximum number of retry attempts.</li></ul> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Specific configuration settings for a Kafka schema registry.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param schemaRegistryConfig Specific configuration settings for a Kafka schema registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistryConfig(final software.amazon.awscdk.services.lambda.ISchemaRegistry schemaRegistryConfig) {
            this.props.schemaRegistryConfig(schemaRegistryConfig);
            return this;
        }

        /**
         * The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param secret The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * The time from which to start reading, in Unix time seconds.
         * <p>
         * Default: - no timestamp
         * <p>
         * @return {@code this}
         * @param startingPositionTimestamp The time from which to start reading, in Unix time seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPositionTimestamp(final java.lang.Number startingPositionTimestamp) {
            this.props.startingPositionTimestamp(startingPositionTimestamp);
            return this;
        }

        /**
         * The list of host and port pairs that are the addresses of the Kafka brokers in a "bootstrap" Kafka cluster that a Kafka client connects to initially to bootstrap itself.
         * <p>
         * They are in the format <code>abc.xyz.com:xxxx</code>.
         * <p>
         * @return {@code this}
         * @param bootstrapServers The list of host and port pairs that are the addresses of the Kafka brokers in a "bootstrap" Kafka cluster that a Kafka client connects to initially to bootstrap itself. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapServers(final java.util.List<java.lang.String> bootstrapServers) {
            this.props.bootstrapServers(bootstrapServers);
            return this;
        }

        /**
         * The authentication method for your Kafka cluster.
         * <p>
         * Default: AuthenticationMethod.SASL_SCRAM_512_AUTH
         * <p>
         * @return {@code this}
         * @param authenticationMethod The authentication method for your Kafka cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationMethod(final software.amazon.awscdk.services.lambda.eventsources.AuthenticationMethod authenticationMethod) {
            this.props.authenticationMethod(authenticationMethod);
            return this;
        }

        /**
         * The secret with the root CA certificate used by your Kafka brokers for TLS encryption This field is required if your Kafka brokers use certificates signed by a private CA.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param rootCaCertificate The secret with the root CA certificate used by your Kafka brokers for TLS encryption This field is required if your Kafka brokers use certificates signed by a private CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootCaCertificate(final software.amazon.awscdk.services.secretsmanager.ISecret rootCaCertificate) {
            this.props.rootCaCertificate(rootCaCertificate);
            return this;
        }

        /**
         * If your Kafka brokers are only reachable via VPC, provide the security group here.
         * <p>
         * Default: - none, required if setting vpc
         * <p>
         * @return {@code this}
         * @param securityGroup If your Kafka brokers are only reachable via VPC, provide the security group here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * If your Kafka brokers are only reachable via VPC provide the VPC here.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param vpc If your Kafka brokers are only reachable via VPC provide the VPC here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * If your Kafka brokers are only reachable via VPC, provide the subnets selection here.
         * <p>
         * Default: - none, required if setting vpc
         * <p>
         * @return {@code this}
         * @param vpcSubnets If your Kafka brokers are only reachable via VPC, provide the subnets selection here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource(
                this.props.build()
            );
        }
    }
}
