package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnLogGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * Object dataProtectionPolicy;
 * Object fieldIndexPolicies;
 * Object resourcePolicyDocument;
 * CfnLogGroupProps cfnLogGroupProps = CfnLogGroupProps.builder()
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .fieldIndexPolicies(List.of(fieldIndexPolicies))
 *         .kmsKeyId("kmsKeyId")
 *         .logGroupClass("logGroupClass")
 *         .logGroupName("logGroupName")
 *         .resourcePolicyDocument(resourcePolicyDocument)
 *         .retentionInDays(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.123Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnLogGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnLogGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLogGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Creates a data protection policy and assigns it to the log group.
     * <p>
     * A data protection policy can help safeguard sensitive data that's ingested by the log group by auditing and masking the sensitive log data. When a user who does not have permission to view masked data views a log event that includes masked data, the sensitive data is replaced by asterisks.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-dataprotectionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-dataprotectionpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataProtectionPolicy() {
        return null;
    }

    /**
     * Creates or updates a <em>field index policy</em> for the specified log group.
     * <p>
     * Only log groups in the Standard log class support field index policies. For more information about log classes, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a> .
     * <p>
     * You can use field index policies to create <em>field indexes</em> on fields found in log events in the log group. Creating field indexes lowers the costs for CloudWatch Logs Insights queries that reference those field indexes, because these queries attempt to skip the processing of log events that are known to not match the indexed field. Good fields to index are fields that you often need to query for and fields that have high cardinality of values Common examples of indexes include request ID, session ID, userID, and instance IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field indexes to improve query performance and reduce costs</a> .
     * <p>
     * Currently, this array supports only one field index policy object.
     * <p>
     * Returns union: either List<{@link java.lang.Object}> or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-fieldindexpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-fieldindexpolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFieldIndexPolicies() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS  key to use when encrypting log data.
     * <p>
     * To associate an AWS  key with the log group, specify the ARN of that KMS key here. If you do so, ingested data is encrypted using this key. This association is stored as long as the data encrypted with the KMS key is still within CloudWatch Logs . This enables CloudWatch Logs to decrypt this data whenever it is requested.
     * <p>
     * If you attempt to associate a KMS key with the log group but the KMS key doesn't exist or is deactivated, you will receive an <code>InvalidParameterException</code> error.
     * <p>
     * Log group data is always encrypted in CloudWatch Logs . If you omit this key, the encryption does not use AWS  . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/encrypt-log-data-kms.html">Encrypt log data in CloudWatch Logs using AWS Key Management Service</a>
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.kms.IKeyRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKmsKeyId() {
        return null;
    }

    /**
     * Specifies the log group class for this log group. There are two classes:.
     * <p>
     * <ul>
     * <li>The <code>Standard</code> log class supports all CloudWatch Logs features.</li>
     * <li>The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower costs.</li>
     * </ul>
     * <p>
     * For details about the features supported by each class, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
     * <p>
     * Default: - "STANDARD"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-loggroupclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-loggroupclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupClass() {
        return null;
    }

    /**
     * The name of the log group.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID for the log group.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.lambda.IFunctionRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-loggroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogGroupName() {
        return null;
    }

    /**
     * Creates or updates a resource policy for the specified log group that allows other services to put log events to this account.
     * <p>
     * A LogGroup can have 1 resource policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-resourcepolicydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-resourcepolicydocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePolicyDocument() {
        return null;
    }

    /**
     * The number of days to retain the log events in the specified log group.
     * <p>
     * Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, and 3653.
     * <p>
     * To set a log group so that its log events do not expire, do not specify this property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-retentionindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-retentionindays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionInDays() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the log group.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#cfn-logs-loggroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLogGroupProps> {
        java.lang.Object dataProtectionPolicy;
        java.lang.Object fieldIndexPolicies;
        java.lang.Object kmsKeyId;
        java.lang.String logGroupClass;
        java.lang.Object logGroupName;
        java.lang.Object resourcePolicyDocument;
        java.lang.Number retentionInDays;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLogGroupProps#getDataProtectionPolicy}
         * @param dataProtectionPolicy Creates a data protection policy and assigns it to the log group.
         *                             A data protection policy can help safeguard sensitive data that's ingested by the log group by auditing and masking the sensitive log data. When a user who does not have permission to view masked data views a log event that includes masked data, the sensitive data is replaced by asterisks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionPolicy(java.lang.Object dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getFieldIndexPolicies}
         * @param fieldIndexPolicies Creates or updates a <em>field index policy</em> for the specified log group.
         *                           Only log groups in the Standard log class support field index policies. For more information about log classes, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a> .
         *                           <p>
         *                           You can use field index policies to create <em>field indexes</em> on fields found in log events in the log group. Creating field indexes lowers the costs for CloudWatch Logs Insights queries that reference those field indexes, because these queries attempt to skip the processing of log events that are known to not match the indexed field. Good fields to index are fields that you often need to query for and fields that have high cardinality of values Common examples of indexes include request ID, session ID, userID, and instance IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field indexes to improve query performance and reduce costs</a> .
         *                           <p>
         *                           Currently, this array supports only one field index policy object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldIndexPolicies(java.util.List<? extends java.lang.Object> fieldIndexPolicies) {
            this.fieldIndexPolicies = fieldIndexPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getFieldIndexPolicies}
         * @param fieldIndexPolicies Creates or updates a <em>field index policy</em> for the specified log group.
         *                           Only log groups in the Standard log class support field index policies. For more information about log classes, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a> .
         *                           <p>
         *                           You can use field index policies to create <em>field indexes</em> on fields found in log events in the log group. Creating field indexes lowers the costs for CloudWatch Logs Insights queries that reference those field indexes, because these queries attempt to skip the processing of log events that are known to not match the indexed field. Good fields to index are fields that you often need to query for and fields that have high cardinality of values Common examples of indexes include request ID, session ID, userID, and instance IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field indexes to improve query performance and reduce costs</a> .
         *                           <p>
         *                           Currently, this array supports only one field index policy object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldIndexPolicies(software.amazon.awscdk.IResolvable fieldIndexPolicies) {
            this.fieldIndexPolicies = fieldIndexPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getKmsKeyId}
         * @param kmsKeyId The Amazon Resource Name (ARN) of the AWS  key to use when encrypting log data.
         *                 To associate an AWS  key with the log group, specify the ARN of that KMS key here. If you do so, ingested data is encrypted using this key. This association is stored as long as the data encrypted with the KMS key is still within CloudWatch Logs . This enables CloudWatch Logs to decrypt this data whenever it is requested.
         *                 <p>
         *                 If you attempt to associate a KMS key with the log group but the KMS key doesn't exist or is deactivated, you will receive an <code>InvalidParameterException</code> error.
         *                 <p>
         *                 Log group data is always encrypted in CloudWatch Logs . If you omit this key, the encryption does not use AWS  . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/encrypt-log-data-kms.html">Encrypt log data in CloudWatch Logs using AWS Key Management Service</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getKmsKeyId}
         * @param kmsKeyId The Amazon Resource Name (ARN) of the AWS  key to use when encrypting log data.
         *                 To associate an AWS  key with the log group, specify the ARN of that KMS key here. If you do so, ingested data is encrypted using this key. This association is stored as long as the data encrypted with the KMS key is still within CloudWatch Logs . This enables CloudWatch Logs to decrypt this data whenever it is requested.
         *                 <p>
         *                 If you attempt to associate a KMS key with the log group but the KMS key doesn't exist or is deactivated, you will receive an <code>InvalidParameterException</code> error.
         *                 <p>
         *                 Log group data is always encrypted in CloudWatch Logs . If you omit this key, the encryption does not use AWS  . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/encrypt-log-data-kms.html">Encrypt log data in CloudWatch Logs using AWS Key Management Service</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(software.amazon.awscdk.interfaces.kms.IKeyRef kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getLogGroupClass}
         * @param logGroupClass Specifies the log group class for this log group. There are two classes:.
         *                      <ul>
         *                      <li>The <code>Standard</code> log class supports all CloudWatch Logs features.</li>
         *                      <li>The <code>Infrequent Access</code> log class supports a subset of CloudWatch Logs features and incurs lower costs.</li>
         *                      </ul>
         *                      <p>
         *                      For details about the features supported by each class, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupClass(java.lang.String logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getLogGroupName}
         * @param logGroupName The name of the log group.
         *                     If you don't specify a name, AWS CloudFormation generates a unique ID for the log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getLogGroupName}
         * @param logGroupName The name of the log group.
         *                     If you don't specify a name, AWS CloudFormation generates a unique ID for the log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(software.amazon.awscdk.interfaces.lambda.IFunctionRef logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getResourcePolicyDocument}
         * @param resourcePolicyDocument Creates or updates a resource policy for the specified log group that allows other services to put log events to this account.
         *                               A LogGroup can have 1 resource policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicyDocument(java.lang.Object resourcePolicyDocument) {
            this.resourcePolicyDocument = resourcePolicyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getRetentionInDays}
         * @param retentionInDays The number of days to retain the log events in the specified log group.
         *                        Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, and 3653.
         *                        <p>
         *                        To set a log group so that its log events do not expire, do not specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionInDays(java.lang.Number retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogGroupProps#getTags}
         * @param tags An array of key-value pairs to apply to the log group.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLogGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLogGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLogGroupProps {
        private final java.lang.Object dataProtectionPolicy;
        private final java.lang.Object fieldIndexPolicies;
        private final java.lang.Object kmsKeyId;
        private final java.lang.String logGroupClass;
        private final java.lang.Object logGroupName;
        private final java.lang.Object resourcePolicyDocument;
        private final java.lang.Number retentionInDays;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataProtectionPolicy = software.amazon.jsii.Kernel.get(this, "dataProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fieldIndexPolicies = software.amazon.jsii.Kernel.get(this, "fieldIndexPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logGroupClass = software.amazon.jsii.Kernel.get(this, "logGroupClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourcePolicyDocument = software.amazon.jsii.Kernel.get(this, "resourcePolicyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionInDays = software.amazon.jsii.Kernel.get(this, "retentionInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataProtectionPolicy = builder.dataProtectionPolicy;
            this.fieldIndexPolicies = builder.fieldIndexPolicies;
            this.kmsKeyId = builder.kmsKeyId;
            this.logGroupClass = builder.logGroupClass;
            this.logGroupName = builder.logGroupName;
            this.resourcePolicyDocument = builder.resourcePolicyDocument;
            this.retentionInDays = builder.retentionInDays;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDataProtectionPolicy() {
            return this.dataProtectionPolicy;
        }

        @Override
        public final java.lang.Object getFieldIndexPolicies() {
            return this.fieldIndexPolicies;
        }

        @Override
        public final java.lang.Object getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getLogGroupClass() {
            return this.logGroupClass;
        }

        @Override
        public final java.lang.Object getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final java.lang.Object getResourcePolicyDocument() {
            return this.resourcePolicyDocument;
        }

        @Override
        public final java.lang.Number getRetentionInDays() {
            return this.retentionInDays;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDataProtectionPolicy() != null) {
                data.set("dataProtectionPolicy", om.valueToTree(this.getDataProtectionPolicy()));
            }
            if (this.getFieldIndexPolicies() != null) {
                data.set("fieldIndexPolicies", om.valueToTree(this.getFieldIndexPolicies()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLogGroupClass() != null) {
                data.set("logGroupClass", om.valueToTree(this.getLogGroupClass()));
            }
            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }
            if (this.getResourcePolicyDocument() != null) {
                data.set("resourcePolicyDocument", om.valueToTree(this.getResourcePolicyDocument()));
            }
            if (this.getRetentionInDays() != null) {
                data.set("retentionInDays", om.valueToTree(this.getRetentionInDays()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnLogGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLogGroupProps.Jsii$Proxy that = (CfnLogGroupProps.Jsii$Proxy) o;

            if (this.dataProtectionPolicy != null ? !this.dataProtectionPolicy.equals(that.dataProtectionPolicy) : that.dataProtectionPolicy != null) return false;
            if (this.fieldIndexPolicies != null ? !this.fieldIndexPolicies.equals(that.fieldIndexPolicies) : that.fieldIndexPolicies != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.logGroupClass != null ? !this.logGroupClass.equals(that.logGroupClass) : that.logGroupClass != null) return false;
            if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
            if (this.resourcePolicyDocument != null ? !this.resourcePolicyDocument.equals(that.resourcePolicyDocument) : that.resourcePolicyDocument != null) return false;
            if (this.retentionInDays != null ? !this.retentionInDays.equals(that.retentionInDays) : that.retentionInDays != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataProtectionPolicy != null ? this.dataProtectionPolicy.hashCode() : 0;
            result = 31 * result + (this.fieldIndexPolicies != null ? this.fieldIndexPolicies.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.logGroupClass != null ? this.logGroupClass.hashCode() : 0);
            result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
            result = 31 * result + (this.resourcePolicyDocument != null ? this.resourcePolicyDocument.hashCode() : 0);
            result = 31 * result + (this.retentionInDays != null ? this.retentionInDays.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
