package software.amazon.awscdk.services.logs;

/**
 * Copy Value processor, copies values from source to target for each entry.
 * <p>
 * This processor copies values within a log event.
 * You can also use this processor to add metadata to log events by copying values from metadata keys.
 * For more information about this processor including examples, see copyValue in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CopyValueProperty copyValueProperty = CopyValueProperty.builder()
 *         .entries(List.of(CopyValueEntryProperty.builder()
 *                 .source("source")
 *                 .target("target")
 *                 // the properties below are optional
 *                 .overwriteIfExists(false)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.179Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CopyValueProperty")
@software.amazon.jsii.Jsii.Proxy(CopyValueProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CopyValueProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of sources and target to copy.
     * <p>
     * An array of CopyValueEntry objects, where each object contains information about one field value to copy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.logs.CopyValueEntryProperty> getEntries();

    /**
     * @return a {@link Builder} of {@link CopyValueProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CopyValueProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CopyValueProperty> {
        java.util.List<software.amazon.awscdk.services.logs.CopyValueEntryProperty> entries;

        /**
         * Sets the value of {@link CopyValueProperty#getEntries}
         * @param entries List of sources and target to copy. This parameter is required.
         *                An array of CopyValueEntry objects, where each object contains information about one field value to copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder entries(java.util.List<? extends software.amazon.awscdk.services.logs.CopyValueEntryProperty> entries) {
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.CopyValueEntryProperty>)entries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CopyValueProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CopyValueProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CopyValueProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyValueProperty {
        private final java.util.List<software.amazon.awscdk.services.logs.CopyValueEntryProperty> entries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.CopyValueEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.CopyValueEntryProperty>)java.util.Objects.requireNonNull(builder.entries, "entries is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.CopyValueEntryProperty> getEntries() {
            return this.entries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entries", om.valueToTree(this.getEntries()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CopyValueProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CopyValueProperty.Jsii$Proxy that = (CopyValueProperty.Jsii$Proxy) o;

            return this.entries.equals(that.entries);
        }

        @Override
        public final int hashCode() {
            int result = this.entries.hashCode();
            return result;
        }
    }
}
